/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmc.pmts.common.util.ShowFormUtils;

public class ProjectPlanContrastRptFormPlugin
extends AbstractReportFormPlugin {
    private Stack<String> st = new Stack();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mainOrgField = (BasedataEdit)this.getControl("org");
        mainOrgField.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", this.getOrgIds())));
        BasedataEdit projectTwo = (BasedataEdit)this.getControl("projecttwo");
        projectTwo.addBeforeF7SelectListener(this::projectTwoBeforeF7Select);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(this::hyperLinkClick);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        DynamicObject obj = reportList.getReportModel().getRowData(event.getRowIndex());
        Object id = obj.get("taskid");
        this.showTaskForm(id);
    }

    private void showTaskForm(Object id) {
        BillShowParameter showParameter = ShowFormUtils.assembleShowBillParam((String)"pmts_task", (Object)id, null, null, (ShowType)ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void projectTwoBeforeF7Select(BeforeF7SelectEvent event) {
        boolean iptproject = (Boolean)this.getModel().getValue("iptproject");
        if (!iptproject) {
            Object project = this.getModel().getValue("project_id");
            event.addCustomQFilter(new QFilter("id", "!=", project));
            return;
        }
        String method = event.getSourceMethod();
        event.setCancel(true);
        if ("click".equals(method)) {
            this.showLikeProjectForm();
        }
    }

    protected Set<Object> getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            HashSet<Object> ids = new HashSet<Object>(structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
            String appNumber = reportShowParameter.getAppId();
            String entityNumber = reportShowParameter.getFormId();
            HashSet<Object> orgIds = new HashSet<Object>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)entityNumber, (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new HashSet<Object>(0);
    }

    public void beforeBindData(EventObject e) {
        Set<Object> ids = this.getOrgIds();
        long orgId = RequestContext.get().getOrgId();
        if (!ids.isEmpty()) {
            if (ids.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
            } else {
                this.getModel().setValue("org", ids.iterator().next());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"imtproject")) {
            this.showLikeProjectForm();
        }
    }

    private void showLikeProjectForm() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee\u7ec4\u7ec7\u3002", (String)"ProjectPlanContrastRptFormPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee1\u3002", (String)"ProjectPlanContrastRptFormPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        String projectId = project.getPkValue().toString();
        String orgId = org.getPkValue().toString();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmpd_calcsimilarproj");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("projectorg", (Object)orgId);
        showParameter.setCustomParam("entitynumber", (Object)"pmpd_project");
        showParameter.setCustomParam("sourceid", (Object)projectId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpd_calcsimilarproj"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)"pmpd_calcsimilarproj", (CharSequence)e.getActionId())) {
            List projects;
            Map result = (Map)e.getReturnData();
            if (result == null) {
                return;
            }
            String similarProjectData = (String)result.get("similarProject");
            Map similarProject = (Map)SerializationUtils.fromJsonString((String)similarProjectData, Map.class);
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null && !CollectionUtils.isEmpty((Collection)(projects = (List)similarProject.get(project.getString("number"))))) {
                this.getModel().setValue("projecttwo", (Object)Long.parseLong((String)projects.get(0)));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee\u7ec4\u7ec7\u3002", (String)"ProjectPlanContrastRptFormPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject projectnum = (DynamicObject)this.getModel().getValue("project");
        if (projectnum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee1\u3002", (String)"ProjectPlanContrastRptFormPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject projectTwo = (DynamicObject)this.getModel().getValue("projecttwo");
        if (projectTwo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee2\u3002", (String)"ProjectPlanContrastRptFormPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setMergeColums(List<String> columns) {
        columns.add("projectnum");
        columns.add("wbsno");
        columns.add("wbsname");
        columns.add("taskno");
        columns.add("taskname");
        columns.add("plantype");
        columns.add("planarea");
        columns.add("trade");
        columns.add("durationunit");
        columns.add("plantime");
        columns.add("planstartdate");
        columns.add("planenddate");
        columns.add("responsperson");
        columns.add("responsorg");
        super.setMergeColums(columns);
    }

    public void packageData(PackageDataEvent pe) {
        super.packageData(pe);
        DynamicObject rowData = pe.getRowData();
        ReportColumn column = (ReportColumn)pe.getSource();
        ColumnStyle columnStyle = new ColumnStyle();
        column.setStyle(columnStyle);
        ArrayList<String> ls = new ArrayList<String>(2);
        ls.add("projectnum");
        ls.add("wbsno");
        ls.add("wbsname");
        ls.add("taskno");
        ls.add("taskname");
        ls.add("plantype");
        ls.add("planarea");
        ls.add("trade");
        ls.add("durationunit");
        ls.add("plantime");
        ls.add("planstartdate");
        ls.add("planenddate");
        ls.add("responsperson");
        ls.add("responsorg");
        if (this.st.isEmpty()) {
            pe.setNoMergeKey(ls);
            this.st.push(rowData.getString("taskname"));
        } else if (!this.st.peek().equals(rowData.getString("taskname"))) {
            pe.setNoMergeKey(ls);
            this.st.push(rowData.getString("taskname"));
        }
    }
}

