/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bom;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BOMFeatureMatEntryLoadBusiness {
    private static final String BOMTYPE_PURPOSE = "purpose";
    private static final String BOMTYPE_CONFIGTYPE = "configtype";
    private static BOMFeatureMatEntryLoadBusiness bomFeatureMatEntryLoadBusiness;

    private BOMFeatureMatEntryLoadBusiness() {
    }

    public static BOMFeatureMatEntryLoadBusiness getInstance() {
        if (bomFeatureMatEntryLoadBusiness == null) {
            bomFeatureMatEntryLoadBusiness = new BOMFeatureMatEntryLoadBusiness();
        }
        return bomFeatureMatEntryLoadBusiness;
    }

    public void setFeatureEntryVisable(IFormView fv, DynamicObject typeObj) {
        if (typeObj == null) {
            return;
        }
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        String configType = typeObj.getString(BOMTYPE_CONFIGTYPE);
        if ("B".equals(purpose) && "B".equals(configType)) {
            fv.setVisible(Boolean.valueOf(true), new String[]{"featuremattab"});
        } else {
            fv.setVisible(Boolean.valueOf(false), new String[]{"featuremattab"});
        }
        fv.updateView();
    }

    public void showMatEntry(DynamicObject selectedObj) {
        Map<Object, DynamicObject> retMap = this.loadFeatureMatList(selectedObj);
        if (retMap == null) {
            return;
        }
        this.showEntryList(selectedObj, retMap);
    }

    private Map<Object, DynamicObject> loadFeatureMatList(DynamicObject selectedObj) {
        if (selectedObj == null) {
            return null;
        }
        DynamicObject featureTypeObj = selectedObj.getDynamicObject("featuretype");
        if (featureTypeObj == null) {
            return null;
        }
        long featureTypeId = featureTypeObj.getLong("id");
        QFilter filter = new QFilter("featureinfo.featuretype", "=", (Object)featureTypeId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        filter = filter.and(status);
        filter = filter.and(enable);
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_proconfigscheme", (String)"id,number,materielnum", (QFilter[])new QFilter[]{filter});
    }

    private void showEntryList(DynamicObject selectedObj, Map<Object, DynamicObject> dataMap) {
        if (dataMap == null) {
            return;
        }
        DynamicObjectCollection matEntry = selectedObj.getDynamicObjectCollection("featurematentry");
        matEntry.clear();
        Set<Map.Entry<Object, DynamicObject>> dataSet = dataMap.entrySet();
        for (Map.Entry<Object, DynamicObject> mapEntry : dataSet) {
            DynamicObject proConfigPlanObj = mapEntry.getValue();
            if (proConfigPlanObj == null) {
                return;
            }
            DynamicObject matObj = proConfigPlanObj.getDynamicObject("materielnum");
            DynamicObject matEntryObj = matEntry.addNew();
            matEntryObj.set("featuremat", (Object)matObj);
        }
    }
}

