/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bom;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.common.util.PDMAPPArgLoadUtil;

public class BomAfterAuditSyncDataBusiness {
    private static final Log log = LogFactory.getLog(BomAfterAuditSyncDataBusiness.class);

    public void syncData(Long orgId, List<Long> bomIdList, String ecnBillNo) {
        this.syncData(orgId, bomIdList, ecnBillNo, "");
    }

    public void syncData(final Long orgId, final List<Long> bomIdList, final String ecnBillNo, final String bomNumbers) {
        String tagId = String.format("MMC-BomAfterAuditSyncDataBusiness-ids-%s", bomIdList);
        ThreadPools.executeOnceIncludeRequestContext((String)tagId, (Runnable)new Runnable(){

            @Override
            public void run() {
                BomAfterAuditSyncDataBusiness.this.runSync(orgId, bomIdList, ecnBillNo, bomNumbers);
            }
        });
    }

    private void runSync(Long orgId, List<Long> bomIdList, String ecnBillNo, String srcbomNumbers) {
        if (!PDMAPPArgLoadUtil.isSyncCostBom((long)orgId)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("entity", (Object)"pdm_mftbom");
        params.put("bomIds", bomIdList);
        String bomNumbers = srcbomNumbers;
        if (StringUtils.isEmpty((String)bomNumbers)) {
            bomNumbers = this.getBomNumbers(bomIdList);
        }
        String entity = "pdm_mftbom";
        if (!StringUtils.isEmpty((String)ecnBillNo)) {
            entity = "pdm_eco";
        }
        if (StringUtils.isEmpty((String)bomNumbers)) {
            bomNumbers = bomIdList.toString();
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"syncCostBomService", (String)"syncCostBom", (Object[])new Object[]{params.toJSONString()});
            this.addlog("0", entity, "", bomNumbers, ecnBillNo);
        }
        catch (Exception ex) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672cBOM\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"BomAfterAuditSyncDataBusiness_1", (String)"mmc-fmm-business", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            this.addlog("1", entity, msg, bomNumbers, ecnBillNo);
        }
    }

    private String getBomNumbers(List<Long> bomIds) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbom", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", bomIds)});
        StringBuilder sb = new StringBuilder();
        for (DynamicObject bom : coll) {
            sb.append(bom.getString("number")).append(" ");
        }
        int size = sb.length();
        if (size > 0) {
            return sb.toString().substring(0, size - 1);
        }
        return "";
    }

    private void addlog(String status, String entity, String msg, String billNos, String ecoBillNo) {
        try {
            ORM orm = ORM.create();
            DynamicObject logObj = orm.newDynamicObject("pdm_costbomsynclog");
            logObj.set("status", (Object)status);
            logObj.set("moduler", (Object)entity);
            logObj.set("reason", (Object)msg);
            logObj.set("number", (Object)ecoBillNo);
            logObj.set("billno", (Object)billNos);
            logObj.set("creator", (Object)this.getCurrentUserId());
            logObj.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        }
        catch (Exception e) {
            log.error("\u6210\u672cBOM\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            log.error((Throwable)e);
        }
    }

    private Long getCurrentUserId() {
        return UserServiceHelper.getCurrentUserId();
    }
}

