/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.bom.ReplacePlanBusiness;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class BomReplaceUtils {
    public static String ENTITY_BOM = "pdm_mftbom";
    public static String ENTITY_MATERIAL = "bd_material";
    public static String ENTITY_BOMENTRY = "pdm_mftbomentry";
    public static String ENTITY_REPLACEPLAN = "mpdm_replaceplan";

    public static Map<String, Set<Long>> queryReplaceEntry(Long bomId, Long replacePlanId, String replaceGroup) {
        String selectFields = BomReplaceUtils.getBomEntrySelectProperties();
        QFilter qfilter = new QFilter("bomid", "=", (Object)bomId);
        qfilter.and(new QFilter("entryreplaceplan", "=", (Object)replacePlanId));
        qfilter.and(new QFilter("entryreplacegroup", "=", (Object)replaceGroup));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)ENTITY_BOMENTRY, (String)selectFields, (QFilter[])new QFilter[]{qfilter});
        HashMap<String, Set<Long>> replaceMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bomentry : coll) {
            String isReplace = bomentry.getString("entryisreplace");
            Long bomEntryId = bomentry.getLong("entryid");
            BomReplaceUtils.addMapSetData(replaceMap, isReplace, bomEntryId);
        }
        return replaceMap;
    }

    private static String getBomEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("entryid ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",entryreplaceplan");
        sb.append(",entryisreplace");
        sb.append(",entryreplacegroup");
        sb.append(",entrymaterialid");
        sb.append(",entryversion");
        sb.append(",entryqtynumerator");
        sb.append(",entryqtydenominator");
        sb.append(",bomid");
        sb.append(",entryisjumplevel");
        sb.append(",auxpropertyid");
        sb.append(",entrytype");
        sb.append(",entryseq");
        return sb.toString();
    }

    public static Map<String, Boolean> getRepConfigSet() {
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>(16);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        String fields = "createorg,entrymaterial,entryver,auxproperties,numrate,isreduction,iscalculate";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BomReplaceUtils.class.getName(), (String)"mpdm_bomrepconfig", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"modifytime desc");){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                boolean isNeedOrg = row.getBoolean("createorg");
                boolean isNeedMat = row.getBoolean("entrymaterial");
                boolean isNeedVer = row.getBoolean("entryver");
                boolean isNeedAuxp = row.getBoolean("auxproperties");
                boolean isNeedNum = row.getBoolean("numrate");
                boolean isCalculate = row.getBoolean("iscalculate");
                boolean isReduction = row.getBoolean("isreduction");
                retMap.put("isNeedOrg", isNeedOrg);
                retMap.put("isNeedMat", isNeedMat);
                retMap.put("isNeedVer", isNeedVer);
                retMap.put("isNeedAuxp", isNeedAuxp);
                retMap.put("isNeedNum", isNeedNum);
                retMap.put("isCalculate", isCalculate);
                retMap.put("isReduction", isReduction);
            }
        }
        return retMap;
    }

    public static Set<Long> convertObjToSet(Object[] pks) {
        HashSet<Long> bomentryIdSet = new HashSet<Long>(pks.length);
        for (Object pk : pks) {
            bomentryIdSet.add((Long)pk);
        }
        return bomentryIdSet;
    }

    public static boolean isNullLong(Long obj) {
        return obj == null || obj.equals(0L);
    }

    public static boolean isNullSet(Set obj) {
        return obj == null || obj.isEmpty();
    }

    public static DynamicObjectCollection queryBomEntryById(Set<Long> bomentryIdSet) {
        String selectFields = BomReplaceUtils.getBomEntrySelectProperties();
        QFilter qfilter = new QFilter("entryid", "in", bomentryIdSet);
        return QueryServiceHelper.query((String)ENTITY_BOMENTRY, (String)selectFields, (QFilter[])new QFilter[]{qfilter}, (String)"bomid,entryseq");
    }

    public static String getBomNumberFromCache(Long bomId, Map<Long, DynamicObject> bomCacheMap) {
        DynamicObject bom = bomCacheMap.get(bomId);
        if (bom == null) {
            bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)ENTITY_BOM, (String)"number,enable");
            bomCacheMap.put(bomId, bom);
        }
        return bom.getString("number");
    }

    public static boolean getBomIsEnableFromCache(Long bomId, Map<Long, DynamicObject> bomCacheMap) {
        DynamicObject bom = bomCacheMap.get(bomId);
        if (bom == null) {
            bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)ENTITY_BOM, (String)"number,enable");
            bomCacheMap.put(bomId, bom);
        }
        return "1".equals(bom.getString("enable"));
    }

    public static String getMaterialNumberFromCache(Long materialid, Map<Long, String> cacheMap) {
        if (materialid == null || materialid.equals(0L)) {
            return "";
        }
        String materialNumber = cacheMap.get(materialid);
        if (StringUtils.isEmpty((String)materialNumber)) {
            DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialid, (String)ENTITY_MATERIAL, (String)"number");
            materialNumber = material.getString("number");
            cacheMap.put(materialid, materialNumber);
        }
        return materialNumber;
    }

    public static Set<Long> getValidBomEntryByReplaceId(Set<Long> repBomentryIdSet, boolean isAll) {
        DynamicObjectCollection coll = BomReplaceUtils.queryBomEntryById(repBomentryIdSet);
        HashSet<String> repeatSet = new HashSet<String>(16);
        HashSet<Long> mmBomentryIdSet = new HashSet<Long>(16);
        for (DynamicObject bomentry : coll) {
            Map<String, Set<Long>> replaceMap;
            Set<Long> validBomEntryIdSet;
            Long replacePlanId = bomentry.getLong("entryreplaceplan");
            Long bomId = bomentry.getLong("bomid");
            String entryReplacegroup = bomentry.getString("entryreplacegroup");
            String bomIdKeys = BomReplaceUtils.getBomKeys(bomId, entryReplacegroup);
            if (!repeatSet.add(bomIdKeys = BomReplaceUtils.getBomKeys(bomIdKeys, replacePlanId)) || BomReplaceUtils.isNullSet(validBomEntryIdSet = (replaceMap = BomReplaceUtils.queryReplaceEntry(bomId, replacePlanId, entryReplacegroup)).get("false"))) continue;
            mmBomentryIdSet.addAll(validBomEntryIdSet);
            if (!isAll || BomReplaceUtils.isNullSet(validBomEntryIdSet = replaceMap.get("true"))) continue;
            mmBomentryIdSet.addAll(validBomEntryIdSet);
        }
        return mmBomentryIdSet;
    }

    public static String getBomKeys(Object bomId, Object replaceGroup) {
        return bomId + "_" + (replaceGroup == null ? "" : replaceGroup);
    }

    private static void addMapSetData(Map<String, Set<Long>> map, String keys, Long value) {
        Set<Long> set = map.get(keys);
        if (set == null) {
            set = new HashSet<Long>(16);
        }
        set.add(value);
        map.put(keys, set);
    }

    public static Set<Long> queryReplacePlanId(Long orgId, Set<Long> materialIdSet) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        QFilter materialId = new QFilter("mainmaterentry.material.masterid", "in", materialIdSet);
        qFilters.add(materialId);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_REPLACEPLAN, (Long)orgId);
        qFilters.add(orgFilter);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        qFilters.add(status);
        qFilters.add(enable);
        DynamicObjectCollection planCol = QueryServiceHelper.query((String)ENTITY_REPLACEPLAN, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        HashSet<Long> set = new HashSet<Long>(16);
        for (int i = 0; i < planCol.size(); ++i) {
            DynamicObject planObj = (DynamicObject)planCol.get(i);
            set.add(planObj.getLong("id"));
        }
        return set;
    }

    public static Set<Long> ParseStringToLongSet(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new HashSet<Long>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        HashSet<Long> set = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((String)value)) continue;
            value = value.trim();
            set.add(Long.parseLong(value));
        }
        return set;
    }

    public static Set<String> ParseStringToSet(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new HashSet<String>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        HashSet<String> set = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((String)value)) continue;
            set.add(value.trim());
        }
        return set;
    }

    public static Map<String, Set<Long>> getBomReplacePlanMap(Long orgId, Set<Long> bomentryIdSet, boolean isAdd) {
        DynamicObjectCollection coll = null;
        if (!isAdd) {
            Set<Long> mmBomEntryIdSet = BomReplaceUtils.getValidBomEntryByReplaceId(bomentryIdSet, false);
            coll = BomReplaceUtils.queryBomEntryById(mmBomEntryIdSet);
        } else {
            coll = BomReplaceUtils.queryBomEntryById(bomentryIdSet);
        }
        if (coll == null || coll.isEmpty()) {
            return new HashMap<String, Set<Long>>(16);
        }
        HashMap<String, Set<Long>> bomEntryMap = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> bomMaterialIdMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bomentry : coll) {
            if ("B".equalsIgnoreCase(bomentry.getString("entrytype")) || bomentry.getBoolean("entryisjumplevel") || bomentry.getBoolean("entryisreplace")) continue;
            Long bomEntryId = bomentry.getLong("entryid");
            Long bomId = bomentry.getLong("bomid");
            String entryReplacegroup = bomentry.getString("entryreplacegroup");
            Long materialId = bomentry.getLong("entrymaterialid");
            String bomIdKeys = BomReplaceUtils.getBomKeys(bomId, entryReplacegroup);
            BomReplaceUtils.addMapSetData(bomEntryMap, bomIdKeys, bomEntryId);
            BomReplaceUtils.addMapSetData(bomMaterialIdMap, bomIdKeys, materialId);
        }
        HashMap<String, Set<Long>> bomReplacePlanMap = new HashMap<String, Set<Long>>(16);
        ReplacePlanBusiness impl = new ReplacePlanBusiness();
        for (Map.Entry bomEntrys : bomEntryMap.entrySet()) {
            String bomIdKeys = (String)bomEntrys.getKey();
            Set newBomEntryIdSet = (Set)bomEntrys.getValue();
            Set materialIdSet = (Set)bomMaterialIdMap.get(bomIdKeys);
            Set<Long> replacePlanIdSet = BomReplaceUtils.queryReplacePlanId(orgId, materialIdSet);
            HashSet<Long> ppReplacePlanIdSet = new HashSet<Long>(16);
            if (!BomReplaceUtils.isNullSet(replacePlanIdSet)) {
                for (Long replacePlanId : replacePlanIdSet) {
                    if (!impl.checkBomEntryIdMatch(replacePlanId, newBomEntryIdSet)) continue;
                    ppReplacePlanIdSet.add(replacePlanId);
                }
            }
            bomReplacePlanMap.put(bomIdKeys, ppReplacePlanIdSet);
        }
        return bomReplacePlanMap;
    }

    public static Map<String, Set<Long>> queryBomKeyGroup(Set<Long> bomentryIdSet, String opKey, Map<String, String> replaceGroupMap) {
        DynamicObjectCollection coll = null;
        if ("btn_delreplace".equals(opKey) || "btn_resetreplace".equals(opKey)) {
            Set<Long> mmBomEntryIdSet = BomReplaceUtils.getValidBomEntryByReplaceId(bomentryIdSet, "btn_delreplace".equals(opKey));
            coll = BomReplaceUtils.queryBomEntryById(mmBomEntryIdSet);
        } else {
            coll = BomReplaceUtils.queryBomEntryById(bomentryIdSet);
        }
        if (coll == null || coll.isEmpty()) {
            return new HashMap<String, Set<Long>>(16);
        }
        HashMap<String, Set<Long>> bomEntryMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bomentry : coll) {
            Long bomEntryId = bomentry.getLong("entryid");
            Long bomId = bomentry.getLong("bomid");
            String entryReplacegroup = bomentry.getString("entryreplacegroup");
            String bomIdKeys = BomReplaceUtils.getBomKeys(bomId, entryReplacegroup);
            BomReplaceUtils.addMapSetData(bomEntryMap, bomIdKeys, bomEntryId);
            String newReplaceGroupNo = replaceGroupMap.get(bomIdKeys);
            if (!StringUtils.isEmpty((String)newReplaceGroupNo)) continue;
            newReplaceGroupNo = StringUtils.isEmpty((String)entryReplacegroup) ? BomReplaceUtils.genReplaceGroupNo(bomentry) : entryReplacegroup;
            replaceGroupMap.put(bomIdKeys, newReplaceGroupNo);
        }
        return bomEntryMap;
    }

    private static String genReplaceGroupNo(DynamicObject bomentry) {
        int seq = bomentry.getInt("entryseq");
        return ORM.create().genLongId(ENTITY_REPLACEPLAN) + "_" + seq;
    }

    public static Set<Long> getOptBomIdSet(Set<Long> bomIdSet) {
        HashSet<Long> optBomIdSet = new HashSet<Long>(16);
        QFilter qfilter = new QFilter("id", "in", bomIdSet);
        qfilter.and(new QFilter("optioncontrol", "=", (Object)"A"));
        qfilter.and(new QFilter("type.configtype", "=", (Object)"A"));
        qfilter.and(new QFilter("materialid.configproperties", "=", (Object)"3"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)ENTITY_BOM, (String)"id", (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject bom : coll) {
            optBomIdSet.add(bom.getLong("id"));
        }
        return optBomIdSet;
    }

    private static String getReplacePlanSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("number");
        sb.append(",").append("enable");
        sb.append(",").append("status");
        sb.append(",").append("createorg");
        sb.append(",").append("mainmaterentry").append(".").append("material");
        sb.append(",").append("mainmaterentry").append(".").append("isreplace");
        sb.append(",").append("repmaterentry").append(".").append("repmaterial");
        sb.append(",").append("repmaterentry").append(".").append("repauxpty");
        sb.append(",").append("repmaterentry").append(".").append("isrep");
        return sb.toString();
    }

    public static String checkReplacePlanData(Long id) {
        int i;
        if (!QueryServiceHelper.exists((String)"mpdm_replaceplan", (Object)id)) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848ID\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"BomReplaceUtils_01", (String)"mmc-fmm-business", (Object[])new Object[0]), id);
        }
        DynamicObject replacePlan = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"mpdm_replaceplan", (String)BomReplaceUtils.getReplacePlanSelectProperties());
        if (!"1".equals(replacePlan.getString("enable"))) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u4e0d\u53ef\u7528\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66ff\u4ee3\u64cd\u4f5c\u3002", (String)"BomReplaceUtils_02", (String)"mmc-fmm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        if (!"C".equals(replacePlan.getString("status"))) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BomReplaceUtils_03", (String)"mmc-fmm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        DynamicObjectCollection coll1 = replacePlan.getDynamicObjectCollection("mainmaterentry");
        if (coll1 == null || coll1.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u6ca1\u6709\u8bbe\u7f6e\u4e3b\u7269\u6599\u5206\u5f55\u6570\u636e\u3002", (String)"BomReplaceUtils_04", (String)"mmc-fmm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        DynamicObjectCollection coll2 = replacePlan.getDynamicObjectCollection("repmaterentry");
        if (coll2 == null || coll2.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u6ca1\u6709\u8bbe\u7f6e\u66ff\u4ee3\u7269\u6599\u5206\u5f55\u6570\u636e\u3002", (String)"BomReplaceUtils_05", (String)"mmc-fmm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        boolean hasReplace = false;
        for (i = 0; i < coll1.size(); ++i) {
            if (!((DynamicObject)coll1.get(i)).getBoolean("isreplace")) continue;
            hasReplace = true;
        }
        if (!hasReplace) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u7684\u4e3b\u7269\u6599\u5206\u5f55\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u201c\u66ff\u4ee3\u4e3b\u6599\u201d\u52fe\u9009\u9879\u3002", (String)"BomReplaceUtils_06", (String)"mmc-fmm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        hasReplace = false;
        for (i = 0; i < coll2.size(); ++i) {
            if (!((DynamicObject)coll2.get(i)).getBoolean("isrep")) continue;
            hasReplace = true;
        }
        if (!hasReplace) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u7684\u66ff\u4ee3\u7269\u6599\u5206\u5f55\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u201c\u66ff\u4ee3\u4e3b\u6599\u201d\u52fe\u9009\u9879\u3002", (String)"BomReplaceUtils_07", (String)"mmc-fmm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        return "";
    }
}

