/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.bom.BomAfterAuditSyncDataBusiness;

public class BomSyncCostUtils {
    public static void syncCost(DynamicObject[] objArray) {
        BomSyncCostUtils.syncCost(objArray, "");
    }

    public static void syncCost(DynamicObject[] objArray, String ecnBillNo) {
        List<Long> bomIdList;
        Long orgId;
        if (objArray == null || objArray.length <= 0) {
            return;
        }
        HashMap<Long, ArrayList<Long>> orgMap = new HashMap<Long, ArrayList<Long>>(16);
        HashMap<Long, String> orgNumberMap = new HashMap<Long, String>(16);
        for (int i = 0; i < objArray.length; ++i) {
            DynamicObject bomObj = objArray[i];
            if (!"pdm_mftbom".equals(bomObj.getDynamicObjectType().getName())) continue;
            orgId = bomObj.getDynamicObject("createorg").getLong("id");
            bomIdList = (ArrayList<Long>)orgMap.get(orgId);
            if (bomIdList == null) {
                bomIdList = new ArrayList<Long>(16);
            }
            bomIdList.add((Long)bomObj.getPkValue());
            String bomNumber = bomObj.getString("number");
            orgMap.put(orgId, (ArrayList<Long>)bomIdList);
            String bomNumbers = (String)orgNumberMap.get(orgId);
            bomNumbers = bomNumbers == null ? bomNumber : bomNumbers + " " + bomNumber;
            orgNumberMap.put(orgId, bomNumbers);
        }
        ecnBillNo = BomSyncCostUtils.getEcnBillNo(objArray, ecnBillNo);
        for (Map.Entry boms : orgMap.entrySet()) {
            orgId = (Long)boms.getKey();
            bomIdList = (List)boms.getValue();
            if (bomIdList == null || bomIdList.isEmpty()) continue;
            BomSyncCostUtils.syncCost(orgId, bomIdList, ecnBillNo, (String)orgNumberMap.get(orgId));
        }
    }

    public static void syncCost(Long orgId, List<Long> bomIdList, String ecnBillNo, String bomNumbers) {
        BomAfterAuditSyncDataBusiness business = new BomAfterAuditSyncDataBusiness();
        business.syncData(orgId, bomIdList, ecnBillNo, bomNumbers);
    }

    public static void syncCost(Long orgId, Long bomId, String ecnBillNo) {
        ArrayList<Long> bomIdList = new ArrayList<Long>(16);
        bomIdList.add(bomId);
        BomSyncCostUtils.syncCost(orgId, bomIdList, ecnBillNo, "");
    }

    private static String getEcnBillNo(DynamicObject[] objArray, String ecnBillNo) {
        if (StringUtils.isEmpty((String)ecnBillNo)) {
            for (int i = 0; i < objArray.length; ++i) {
                DynamicObject bomObj = objArray[i];
                if (!"pdm_mftbom".equals(bomObj.getDynamicObjectType().getName())) continue;
                DynamicObjectCollection coll = bomObj.getDynamicObjectCollection("entry");
                for (DynamicObject entry : coll) {
                    String entryecnno = entry.getString("entryecnno");
                    if (StringUtils.isEmpty((String)entryecnno)) continue;
                    return entryecnno;
                }
            }
        }
        return ecnBillNo;
    }
}

