/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bom;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MFTBomEditbusiness {
    private static final String BOMTYPE_PURPOSE = "purpose";
    private static final String BOMTYPE_CONFIGTYPE = "configtype";
    private static final String BOMTYPE_VALIDTIMETYPE = "validatetimetype";
    private static final String BOMTYPE_SURETIME = "suretime";

    private MFTBomEditbusiness() {
    }

    public static void setMaterialInfoByMaterial(IDataModel dm, DynamicObject createOrgObj, DynamicObject matObj) {
        if (createOrgObj == null || matObj == null) {
            return;
        }
        DynamicObject baiscObj = matObj.getDynamicObject("baseunit");
        dm.setValue("material", (Object)baiscObj);
        long orgId = createOrgObj.getLong("id");
        long matId = matObj.getLong("id");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)orgId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter matFilter = new QFilter("masterid", "=", (Object)matId);
        DynamicObject matInfo = BusinessDataServiceHelper.loadSingle((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{baseDataFilter, matFilter, status, enable});
        dm.beginInit();
        dm.setValue("material", (Object)matInfo);
        dm.endInit();
    }

    public static void setEntryMaterialInfoByMaterial(IDataModel dm, DynamicObject createOrgObj, ChangeData changeData, int rowIndex, IFormView fv) {
        Object newValue = changeData.getNewValue();
        if (createOrgObj == null || newValue == null) {
            return;
        }
        DynamicObject matObj = (DynamicObject)newValue;
        DynamicObject baiscObj = matObj.getDynamicObject("baseunit");
        String configproperties = matObj.getString("configproperties");
        dm.setValue("entryunit", (Object)baiscObj, rowIndex);
        dm.setValue("entryisjumplevel", (Object)false, rowIndex);
        dm.setValue("entryisbackflush", (Object)"A", rowIndex);
        dm.setValue("entryissuemode", (Object)"11010", rowIndex);
        dm.setValue("configproperties", (Object)configproperties, rowIndex);
        if ("3".equals(configproperties)) {
            dm.setValue("opt", (Object)Boolean.FALSE, rowIndex);
            dm.setValue("preferopt", (Object)Boolean.FALSE, rowIndex);
        }
        long orgId = createOrgObj.getLong("id");
        long matId = matObj.getLong("id");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)orgId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter matFilter = new QFilter("masterid", "=", (Object)matId);
        DynamicObject matInfo = BusinessDataServiceHelper.loadSingle((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{orgFilter, matFilter, status, enable});
        if (matInfo != null) {
            String materialattr = matInfo.getString("materialattr");
            dm.setValue("entrymaterialattr", (Object)matInfo.getString("materialattr"), rowIndex);
            if ("10020".equals(materialattr)) {
                dm.setValue("entryisjumplevel", (Object)"1", rowIndex);
            }
        }
        dm.beginInit();
        dm.setValue("entrymaterial", (Object)matInfo, rowIndex);
        dm.endInit();
    }

    public static void reSetFormDFata(IDataModel dm) {
        dm.setValue("materialid", null);
        dm.setValue("material", null);
        dm.setValue("version", null);
        DynamicObjectCollection entryCol = dm.getEntryEntity("entry");
        DynamicObjectCollection copEntryCol = dm.getEntryEntity("copentry");
        DynamicObjectCollection qtyEntryCol = dm.getEntryEntity("qtyentry");
        DynamicObjectCollection setEntryCol = dm.getEntryEntity("setupentry");
        if (entryCol != null) {
            dm.deleteEntryData("entry");
        }
        if (copEntryCol != null) {
            dm.deleteEntryData("copentry");
        }
        if (qtyEntryCol != null) {
            dm.deleteEntryData("qtyentry");
        }
        if (setEntryCol != null) {
            dm.deleteEntryData("setupentry");
        }
    }

    public static void matOrMatId(DynamicObject typeObj, IFormView view) {
        BasedataEdit matEdit = (BasedataEdit)view.getControl("material");
        BasedataEdit matIdEdit = (BasedataEdit)view.getControl("materialid");
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        if ("B".equals(purpose)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"material"});
            view.setVisible(Boolean.valueOf(false), new String[]{"materialname"});
            view.setVisible(Boolean.valueOf(false), new String[]{"materialmodel"});
            view.setVisible(Boolean.valueOf(true), new String[]{"materialid"});
            view.setVisible(Boolean.valueOf(true), new String[]{"materialidname"});
            view.setVisible(Boolean.valueOf(true), new String[]{"materialidmodel"});
            matEdit.setMustInput(false);
            matIdEdit.setMustInput(true);
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"material"});
            view.setVisible(Boolean.valueOf(true), new String[]{"materialname"});
            view.setVisible(Boolean.valueOf(true), new String[]{"materialmodel"});
            view.setVisible(Boolean.valueOf(false), new String[]{"materialid"});
            view.setVisible(Boolean.valueOf(false), new String[]{"materialidname"});
            view.setVisible(Boolean.valueOf(false), new String[]{"materialidmodel"});
            matEdit.setMustInput(true);
            matIdEdit.setMustInput(false);
        }
    }

    public static void isEntryMatInfoEnable(DynamicObject typeObj, IFormView view, IDataModel dm, boolean isResetVal) {
        DynamicObjectCollection entryCol = dm.getEntryEntity("entry");
        if (typeObj == null) {
            return;
        }
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        if ("B".equals(purpose)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"entrymaterial"});
            view.setVisible(Boolean.valueOf(false), new String[]{"entrymaterialname_r"});
            view.setVisible(Boolean.valueOf(false), new String[]{"entrymaterialmodel_r"});
            view.setVisible(Boolean.valueOf(true), new String[]{"entrymaterialid"});
            view.setVisible(Boolean.valueOf(true), new String[]{"entrymatidname"});
            view.setVisible(Boolean.valueOf(true), new String[]{"entrymatidmodel"});
            view.setVisible(Boolean.valueOf(true), new String[]{"featuretype"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"entrymaterial"});
            view.setVisible(Boolean.valueOf(true), new String[]{"entrymaterialname_r"});
            view.setVisible(Boolean.valueOf(true), new String[]{"entrymaterialmodel_r"});
            view.setVisible(Boolean.valueOf(false), new String[]{"entrymaterialid"});
            view.setVisible(Boolean.valueOf(false), new String[]{"entrymatidname"});
            view.setVisible(Boolean.valueOf(false), new String[]{"entrymatidmodel"});
            view.setVisible(Boolean.valueOf(false), new String[]{"featuretype"});
        }
        if (entryCol == null || entryCol.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            MFTBomEditbusiness.setEntryFieldInput(entryObj, purpose, view, dm, isResetVal, i);
        }
    }

    public static void setEntryFieldInput(DynamicObject entryObj, String purpose, IFormView view, IDataModel dm, boolean isResetVal, int i) {
        BasedataEdit entryMatInfoEdit = (BasedataEdit)view.getFlexControl("entrymaterial", i);
        BasedataEdit entryMatEdit = (BasedataEdit)view.getFlexControl("entrymaterialid", i);
        BasedataEdit entryfeatureEdit = (BasedataEdit)view.getFlexControl("featuretype", i);
        if ("B".equals(purpose)) {
            String entryType = entryObj.getString("entrytype");
            if ("A".equals(entryType)) {
                view.setEnable(Boolean.valueOf(true), i, new String[]{"entrymaterialid"});
                view.setEnable(Boolean.valueOf(false), i, new String[]{"featuretype"});
                view.setEnable(Boolean.valueOf(true), i, new String[]{"entryversion"});
                if (isResetVal) {
                    dm.setValue("featuretype", null, i);
                }
            } else if ("B".equals(entryType)) {
                view.setEnable(Boolean.valueOf(false), i, new String[]{"entrymaterialid"});
                view.setEnable(Boolean.valueOf(true), i, new String[]{"featuretype"});
                view.setEnable(Boolean.valueOf(false), i, new String[]{"entryversion"});
                if (isResetVal) {
                    dm.setValue("entrymaterialid", null, i);
                }
            }
        } else {
            entryMatEdit.setMustInput(false);
            entryMatInfoEdit.setMustInput(true);
            entryfeatureEdit.setMustInput(false);
        }
    }

    public static void setDefaultValueByFeatureType(IDataModel dm, ChangeData changeData, int rowIndex) {
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicObject featureTypeObj = (DynamicObject)newValue;
        DynamicObject basicUnit = featureTypeObj.getDynamicObject("basicunit");
        dm.setValue("entryunit", (Object)basicUnit);
        dm.setValue("entryisjumplevel", (Object)false, rowIndex);
        dm.setValue("entryisbackflush", (Object)"A", rowIndex);
        dm.setValue("entryissuemode", (Object)"11010", rowIndex);
    }

    public static QFilter createVerFilter(DynamicObject typeObj, DynamicObject matObj) {
        String purpose;
        DynamicObject versionRuleObj;
        if (typeObj == null || matObj == null) {
            return null;
        }
        QFilter ruleFilter = null;
        if (typeObj.getBoolean("isversion") && (versionRuleObj = typeObj.getDynamicObject("versionrule")) != null) {
            long ruleId = versionRuleObj.getLong("id");
            ruleFilter = new QFilter("bomversionrule", "=", (Object)ruleId);
        }
        if ("B".equals(purpose = typeObj.getString(BOMTYPE_PURPOSE))) {
            long matId = matObj.getLong("id");
            QFilter matFilter = new QFilter("material", "=", (Object)matId);
            if (ruleFilter != null) {
                ruleFilter.and(matFilter);
            } else {
                ruleFilter = matFilter;
            }
        }
        return ruleFilter;
    }

    public static QFilter filterEntryMaterial(DynamicObject matObj, DynamicObject bomTypeObj) {
        if (matObj == null || bomTypeObj == null) {
            return null;
        }
        long matId = matObj.getLong("id");
        QFilter filter = new QFilter("id", "!=", (Object)matId);
        String purpose = bomTypeObj.getString(BOMTYPE_PURPOSE);
        String configType = bomTypeObj.getString(BOMTYPE_CONFIGTYPE);
        if ("B".equals(purpose)) {
            String configproperties = matObj.getString("configproperties");
            ArrayList<String> list = new ArrayList<String>(10);
            list.add("");
            list.add("1");
            if (!"3".equals(configproperties)) {
                list.add("2");
                if (!"B".equals(configType)) {
                    list.add("3");
                }
            }
            filter.and(new QFilter("configproperties", "in", list));
        }
        return filter;
    }

    public static void setEntryType(DynamicObject typeObj, IFormView view, IDataModel dm) {
        DynamicObjectCollection entryCol = dm.getEntryEntity("entry");
        if (typeObj == null || entryCol == null || entryCol.isEmpty()) {
            return;
        }
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        String configType = typeObj.getString(BOMTYPE_CONFIGTYPE);
        for (int i = 0; i < entryCol.size(); ++i) {
            if ("B".equals(purpose) && "B".equals(configType)) {
                view.setEnable(Boolean.TRUE, i, new String[]{"entrytype"});
                continue;
            }
            dm.setValue("entrytype", (Object)"A");
            view.setEnable(Boolean.FALSE, i, new String[]{"entrytype"});
        }
    }

    public static void setValidateTime(DynamicObject typeObj, IDataModel dm, int index) {
        if (typeObj == null) {
            return;
        }
        String validatetimetype = typeObj.getString(BOMTYPE_VALIDTIMETYPE);
        if ("B".equals(validatetimetype)) {
            Date suretime = typeObj.getDate(BOMTYPE_SURETIME);
            dm.setValue("entryvaliddate", (Object)suretime, index);
        }
    }

    public static boolean isConfigType(IDataModel dm) {
        DynamicObject typeObj;
        DynamicObject dynamicObject = typeObj = dm.getValue("type") == null ? null : (DynamicObject)dm.getValue("type");
        if (typeObj == null) {
            return false;
        }
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        return "B".equals(purpose);
    }

    public static void setAuxpMustInput(IFormView fv, IDataModel dm, boolean isAuxpMustInput, int rowIndex, String fieldName) {
        if (!isAuxpMustInput) {
            if (rowIndex >= 0) {
                FlexEdit fieldEdit = (FlexEdit)fv.getFlexControl(fieldName, rowIndex);
                dm.setValue(fieldName, null, rowIndex);
                fv.setEnable(Boolean.FALSE, rowIndex, new String[]{fieldName});
                fieldEdit.setMustInput(false);
                fv.updateView(fieldName, rowIndex);
            } else {
                FlexEdit fieldEdit = (FlexEdit)fv.getControl(fieldName);
                dm.setValue(fieldName, null);
                fv.setEnable(Boolean.FALSE, new String[]{fieldName});
                fieldEdit.setMustInput(false);
            }
        } else if (rowIndex >= 0) {
            FlexEdit fieldEdit = (FlexEdit)fv.getFlexControl(fieldName, rowIndex);
            fv.setEnable(Boolean.TRUE, rowIndex, new String[]{fieldName});
            fieldEdit.setMustInput(true);
            fv.updateView(fieldName, rowIndex);
        } else {
            FlexEdit fieldEdit = (FlexEdit)fv.getControl(fieldName);
            fv.setEnable(Boolean.TRUE, new String[]{fieldName});
            fieldEdit.setMustInput(true);
        }
    }

    public static void setEntryColAuxpMustImput(IFormView fv, IDataModel dm, String entryName, DynamicObject typeObj, String matfieldName, String fieldName) {
        DynamicObjectCollection entryCol = dm.getEntryEntity(entryName);
        if (entryCol.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            DynamicObject entryMatObj = entryObj.getDynamicObject(matfieldName);
            DynamicObject createOrgObj = dm.getValue("createorg") == null ? null : (DynamicObject)dm.getValue("createorg");
            boolean isAuxpMustInput = MFTBomEditbusiness.isAuxpMustInput(entryMatObj, typeObj, createOrgObj);
            MFTBomEditbusiness.setAuxpMustInput(fv, dm, isAuxpMustInput, i, fieldName);
        }
    }

    public static boolean isAuxpMustInput(DynamicObject matInfoObj, DynamicObject typeObj, DynamicObject createOrgObj) {
        if (matInfoObj == null || typeObj == null) {
            return false;
        }
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        if ("B".equals(purpose)) {
            return false;
        }
        boolean isbompauxattmust = false;
        DynamicObject matObj = null;
        String entityName = matInfoObj.getDynamicObjectType().getName();
        if ("bd_materialmftinfo".equals(entityName)) {
            isbompauxattmust = matInfoObj.getBoolean("isbompauxattmust");
            matObj = matInfoObj.getDynamicObject("masterid");
        } else {
            QFilter orgfilter;
            matObj = matInfoObj;
            QFilter matfilter = new QFilter("masterid", "=", (Object)matInfoObj.getLong("id"));
            DynamicObject materialInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (String)"id,isbompauxattmust", (QFilter[])new QFilter[]{matfilter, orgfilter = new QFilter("createorg", "=", (Object)createOrgObj.getLong("id"))});
            if (materialInfo != null) {
                isbompauxattmust = materialInfo.getBoolean("isbompauxattmust");
            }
        }
        QFilter matFilter = new QFilter("id", "=", (Object)matObj.getLong("id"));
        DynamicObject loadMatObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id,isuseauxpty,auxptyentry.isaffectplan", (QFilter[])new QFilter[]{matFilter});
        boolean isuseauxpty = loadMatObj.getBoolean("isuseauxpty");
        if (!isuseauxpty) {
            return false;
        }
        DynamicObjectCollection auxpCol = loadMatObj.getDynamicObjectCollection("auxptyentry");
        boolean flag = false;
        for (DynamicObject auxpObj : auxpCol) {
            boolean isaffectplan = auxpObj.getBoolean("isaffectplan");
            if (!isaffectplan) continue;
            flag = true;
            break;
        }
        return flag && isbompauxattmust;
    }

    public static void showConfigCode(IFormView fv, IDataModel dm) {
        BasedataEdit configcodeEdit = (BasedataEdit)fv.getControl("configuredcode");
        DynamicObject typeObj = (DynamicObject)dm.getValue("type");
        if (typeObj == null) {
            return;
        }
        String purpose = typeObj.getString(BOMTYPE_PURPOSE);
        if ("C".equals(purpose)) {
            configcodeEdit.setMustInput(true);
        } else {
            configcodeEdit.setMustInput(false);
            dm.setValue("configuredcode", null);
        }
    }

    public static boolean setBOMVersionMustInput(IFormView fv, DynamicObject product, DynamicObject bomType) {
        Boolean isVersion;
        BasedataEdit verEdit = (BasedataEdit)fv.getControl("version");
        Boolean isenablematerialversion = MFTBomEditbusiness.isEnableMaterialVersion(product);
        if (bomType != null) {
            bomType = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)bomType.getDataEntityType().getName(), (String)"isversion");
        }
        if ((isVersion = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)bomType, (String)"isversion")).booleanValue() || isenablematerialversion.booleanValue()) {
            verEdit.setMustInput(true);
            return true;
        }
        verEdit.setMustInput(false);
        return false;
    }

    public static Boolean isEnableMaterialVersion(DynamicObject material) {
        DynamicObjectType type;
        if (material == null) {
            return Boolean.FALSE;
        }
        Object masterid = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)material, (String)"masterid");
        DynamicObject mater = material;
        if (masterid instanceof DynamicObject) {
            mater = (DynamicObject)masterid;
        }
        if ((type = mater.getDynamicObjectType()) == null) {
            return Boolean.FALSE;
        }
        DataEntityPropertyCollection properties = type.getProperties();
        if (properties == null || properties.isEmpty()) {
            return Boolean.FALSE;
        }
        if (!properties.toString().contains("isenablematerialversion")) {
            mater = BusinessDataServiceHelper.loadSingle((Object)mater.getPkValue(), (String)"bd_material", (String)"isenablematerialversion");
        }
        return DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)mater, (String)"isenablematerialversion");
    }

    public static void updateCopEntryMatId(IDataModel dm, DynamicObject copMatInfoObj, Integer rowIndex) {
        if (copMatInfoObj == null) {
            dm.setValue("copentrymaterialid", null);
            return;
        }
        DynamicObject copMatObj = copMatInfoObj.getDynamicObject("masterid");
        dm.setValue("copentrymaterialid", (Object)copMatObj, rowIndex.intValue());
    }

    public static void setEntryTypeDefault(int insertRowIndex, int currentRowIndex, RowDataEntity[] rowDatas, IDataModel dm) {
        int rowIndex = currentRowIndex;
        if (insertRowIndex >= 0) {
            rowIndex = insertRowIndex + 1;
        }
        String entryType = String.valueOf(dm.getValue("entrytype", rowIndex));
        if (rowDatas == null) {
            return;
        }
        for (int i = 0; i < rowDatas.length; ++i) {
            RowDataEntity rowData = rowDatas[i];
            dm.setValue("entrytype", (Object)entryType, rowData.getRowIndex());
        }
    }

    public static void setHasEntryBom(IDataModel dm) {
        DynamicObjectCollection entryCol = dm.getEntryEntity("entry");
        DynamicObject createOrgObj = (DynamicObject)dm.getValue("createorg");
        DynamicObject replaceObj = (DynamicObject)dm.getValue("replaceno");
        if (createOrgObj == null) {
            return;
        }
        HashSet<Long> entryMatSet = new HashSet<Long>(64);
        for (DynamicObject entryObj : entryCol) {
            DynamicObject entryMat = entryObj.getDynamicObject("entrymaterialid");
            if (entryMat == null) continue;
            entryMatSet.add(entryMat.getLong("id"));
        }
        if (entryMatSet.isEmpty()) {
            return;
        }
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)createOrgObj.getLong("id"));
        QFilter matFilter = new QFilter("materialid", "in", entryMatSet);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter[] filters = new QFilter[]{matFilter, ids, enable, status};
        String selectFields = "id,materialid,version,configuredcode,auxproperty";
        DynamicObjectCollection existCol = QueryServiceHelper.query((String)"pdm_mftbom", (String)selectFields, (QFilter[])filters);
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            DynamicObject entryMatObj = entryObj.getDynamicObject("entrymaterialid");
            DynamicObject entryVerObj = entryObj.getDynamicObject("entryversion");
            DynamicObject entryConfigObj = entryObj.getDynamicObject("entryconfiguredcode");
            DynamicObject entryAuxObj = entryObj.getDynamicObject("entryauxproperty");
            int seq = entryObj.getInt("seq");
            if (entryMatObj == null) continue;
            long entryMatId = entryMatObj == null ? 0L : entryMatObj.getLong("id");
            long entryVerId = entryVerObj == null ? 0L : entryVerObj.getLong("id");
            long entryConfigId = entryConfigObj == null ? 0L : entryConfigObj.getLong("id");
            long entryAuxId = entryAuxObj == null ? 0L : entryAuxObj.getLong("id");
            for (DynamicObject existObj : existCol) {
                long existMatId = existObj.getLong("materialid");
                long existVerId = existObj.getLong("version");
                long existConfigId = existObj.getLong("configuredcode");
                long existAuxId = existObj.getLong("auxproperty");
                if (entryMatId != existMatId || entryVerId != existVerId || entryConfigId != existConfigId || entryAuxId != existAuxId) continue;
                dm.setValue("hasbom", (Object)true, i);
            }
        }
    }
}

