/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bom;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.form.field.FieldEdit;
import kd.mmc.fmm.common.util.MMCUtils;

public class MFTSuperBomEditBusiness {
    public static void showTabPage(IFormView fv, IDataModel dm, int entryRowIndex, String tabPageKey) {
        String suffix = "";
        if ("tabpage_matchctlentry".equals(tabPageKey)) {
            suffix = "_optctl";
        }
        if ("tabpage_chararule".equals(tabPageKey)) {
            suffix = "_rulctl";
        }
        DynamicObject entryObj = dm.getEntryRowEntity("entry", entryRowIndex);
        dm.beginInit();
        dm.setValue("entryseq" + suffix, (Object)(entryRowIndex + 1));
        dm.setValue("entrymaterial" + suffix, entryObj.get("entrymaterialid"));
        dm.setValue("entryunit" + suffix, entryObj.get("entryunit"));
        dm.beginInit();
        if ("_optctl".equals(suffix)) {
            MFTSuperBomEditBusiness.showMatchCtlEntry(fv, dm, suffix, entryObj, entryRowIndex);
        }
        fv.updateView("tabpage_matchctlentry");
        fv.updateView("fsp_chararule");
    }

    private static void showMatchCtlEntry(IFormView fv, IDataModel dm, String suffix, DynamicObject entryObj, int entryRowIndex) {
        dm.beginInit();
        dm.setValue("opt" + suffix, entryObj.get("opt"));
        dm.setValue("preferopt" + suffix, entryObj.get("preferopt"));
        dm.setValue("mutuexcopt" + suffix, entryObj.get("mutuexcopt"));
        dm.setValue("qtyopt" + suffix, entryObj.get("qtyopt"));
        dm.setValue("maxqtyopt" + suffix, entryObj.get("maxqtyopt"));
        dm.setValue("minqtyopt" + suffix, entryObj.get("minqtyopt"));
        dm.endInit();
        DynamicObject entryMatoBJ = (DynamicObject)dm.getValue("entrymaterialid", entryRowIndex);
        if (entryMatoBJ == null) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"MFTSuperBomEditBusiness_0", (String)"mmc-fmm-business", (Object[])new Object[0]));
            return;
        }
        String configProperties = entryMatoBJ.getString("configproperties");
        if ("3".equals(configProperties)) {
            fv.setEnable(Boolean.FALSE, new String[]{"opt_optctl"});
            fv.setEnable(Boolean.FALSE, new String[]{"preferopt_optctl"});
            dm.setValue("preferopt_optctl", (Object)false);
            dm.setValue("opt_optctl", (Object)false);
            fv.updateView("fpl_opt");
        } else {
            fv.setEnable(Boolean.TRUE, new String[]{"opt_optctl"});
            fv.setEnable(Boolean.TRUE, new String[]{"preferopt_optctl"});
        }
        Object opt = entryObj.get("opt");
        if (StringUtils.isNotBlank((Object)opt) && !((Boolean)opt).booleanValue()) {
            fv.setEnable(Boolean.FALSE, new String[]{"preferopt_optctl"});
            dm.setValue("preferopt_optctl", (Object)false);
        }
        if (!((Boolean)dm.getValue("qtyopt_optctl")).booleanValue()) {
            fv.setEnable(Boolean.FALSE, new String[]{"minqtyopt_optctl"});
            fv.setEnable(Boolean.FALSE, new String[]{"maxqtyopt_optctl"});
        } else {
            fv.setEnable(Boolean.TRUE, new String[]{"minqtyopt_optctl"});
            fv.setEnable(Boolean.TRUE, new String[]{"maxqtyopt_optctl"});
        }
    }

    public static void changeOptVal(IFormView fv, IDataModel dm, String propertyName, int entryRowIndex, ChangeData changeSet) {
        String valideMessage = "";
        switch (propertyName) {
            case "opt_optctl": {
                MFTSuperBomEditBusiness.updateOptCtl(fv, dm, changeSet);
                break;
            }
            case "qtyopt_optctl": {
                MFTSuperBomEditBusiness.setQtyOptEnable(fv, changeSet);
                MFTSuperBomEditBusiness.defaultQtyOpt(fv, dm, entryRowIndex, changeSet);
                break;
            }
            case "maxqtyopt_optctl": {
                valideMessage = MFTSuperBomEditBusiness.checkOptQtyMessage(fv, entryRowIndex, changeSet, propertyName);
                break;
            }
            case "minqtyopt_optctl": {
                valideMessage = MFTSuperBomEditBusiness.checkOptQtyMessage(fv, entryRowIndex, changeSet, propertyName);
                break;
            }
            case "preferopt_optctl": {
                MFTSuperBomEditBusiness.updateFirstChoose(fv, entryRowIndex, changeSet);
                break;
            }
        }
        if (valideMessage.length() > 0) {
            fv.showTipNotification(valideMessage);
            return;
        }
        int rowNum = dm.getEntryCurrentRowIndex("entry");
        String entryFieldName = propertyName.replace("_optctl", "");
        DynamicObjectCollection col = dm.getEntryEntity("entry");
        DataEntityPropertyCollection properties = ((DynamicObject)col.get(rowNum)).getDataEntityType().getProperties();
        if (properties.containsKey((Object)entryFieldName)) {
            dm.setValue(entryFieldName, dm.getValue(propertyName), rowNum);
        }
    }

    private static void updateFirstChoose(IFormView fv, int entryRowIndex, ChangeData changeSet) {
        IDataModel dm = fv.getModel();
        boolean firstChoose = (Boolean)changeSet.getNewValue();
        if (!firstChoose) {
            return;
        }
        DynamicObjectCollection supBomEntryCol = dm.getEntryEntity("entry");
        for (DynamicObject supBomEntry : supBomEntryCol) {
            supBomEntry.set("preferopt", (Object)false);
        }
        DynamicObject entryObj = (DynamicObject)supBomEntryCol.get(entryRowIndex);
        entryObj.set("preferopt", (Object)true);
    }

    private static void updateOptCtl(IFormView fv, IDataModel dm, ChangeData changeSet) {
        Object propValueObj = changeSet.getNewValue();
        if (StringUtils.isNotBlank((Object)propValueObj) && ((Boolean)propValueObj).booleanValue()) {
            fv.setEnable(Boolean.TRUE, new String[]{"preferopt_optctl"});
        } else {
            fv.setEnable(Boolean.FALSE, new String[]{"preferopt_optctl"});
            dm.setValue("preferopt_optctl", (Object)Boolean.FALSE);
        }
    }

    private static void setQtyOptEnable(IFormView fv, ChangeData changeSet) {
        Object propValueObj = changeSet.getNewValue();
        if (StringUtils.isNotBlank((Object)propValueObj) && ((Boolean)propValueObj).booleanValue()) {
            fv.setEnable(Boolean.TRUE, new String[]{"minqtyopt_optctl"});
            fv.setEnable(Boolean.TRUE, new String[]{"maxqtyopt_optctl"});
        } else {
            fv.setEnable(Boolean.FALSE, new String[]{"minqtyopt_optctl"});
            fv.setEnable(Boolean.FALSE, new String[]{"maxqtyopt_optctl"});
        }
        fv.updateView("minqtyopt_optctl");
        fv.updateView("maxqtyopt_optctl");
    }

    private static void defaultQtyOpt(IFormView fv, IDataModel dm, int entryRowIndex, ChangeData changeSet) {
        Object propValueObj = changeSet.getNewValue();
        if (!((Boolean)propValueObj).booleanValue()) {
            dm.setValue("minqtyopt_optctl", (Object)BigDecimal.ZERO);
            dm.setValue("maxqtyopt_optctl", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal maxQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"maxqtyopt_optctl");
            BigDecimal minQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"minqtyopt_optctl");
            BigDecimal entryqty = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"entryqty", (int)entryRowIndex);
            if (maxQtyOpt.compareTo(BigDecimal.ZERO) == 0 && minQtyOpt.compareTo(BigDecimal.ZERO) == 0) {
                dm.setValue("maxqtyopt_optctl", (Object)entryqty);
                dm.setValue("minqtyopt_optctl", (Object)entryqty);
            }
        }
    }

    private static String checkOptQtyMessage(IFormView fv, int entryRowIndex, ChangeData changeSet, String propertyName) {
        String errMessage = "";
        IDataModel dm = fv.getModel();
        BigDecimal maxQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"maxqtyopt_optctl");
        BigDecimal minQtyOpt = MMCUtils.getDataModelBigDecimalData((IDataModel)dm, (String)"minqtyopt_optctl");
        if (minQtyOpt.compareTo(maxQtyOpt) > 0) {
            dm.beginInit();
            dm.setValue(propertyName, changeSet.getOldValue());
            dm.endInit();
            fv.updateView(propertyName);
            errMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7b2c%s\u884c,\u9009\u914d\u63a7\u5236\u201c\u6700\u5c0f\u6570\u91cf\u201d\u5927\u4e8e\u201c\u6700\u5927\u6570\u91cf\u201d", (String)"MFTSuperBomEditBusiness_1", (String)"mmc-fmm-business", (Object[])new Object[0]), entryRowIndex + 1);
        }
        return errMessage;
    }

    public static void fieldMustInput(IFormView fv, IDataModel dm) {
        FieldEdit optioncontrolEdit = (FieldEdit)fv.getControl("optioncontrol");
        DynamicObject matInfoObj = (DynamicObject)dm.getValue("material");
        if (matInfoObj == null) {
            return;
        }
        DynamicObject matObj = matInfoObj.getDynamicObject("masterid");
        if (matObj == null) {
            return;
        }
        String configproperties = matObj.getString("configproperties");
        if ("3".equals(configproperties)) {
            optioncontrolEdit.setMustInput(true);
            dm.setValue("optioncontrol", (Object)Character.valueOf('A'));
        } else {
            dm.setValue("optioncontrol", null);
            optioncontrolEdit.setMustInput(false);
        }
    }
}

