/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.bomSync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BOMPropertySyncbusiness {
    private static final Log logger = LogFactory.getLog(BOMPropertySyncbusiness.class);

    public void syncBom(String entityName, Set<Long> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        this.updateBom(entityName, idSet);
    }

    private void updateBom(String entityName, Set<Long> idSet) {
        if (idSet == null || idSet.isEmpty() || entityName == null || "".equals(entityName)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", idSet);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        TreeMap<String, String> fieldMap = this.getSyncField(entityName);
        Set<Long> exTypeSet = this.getExcludebomtype(entityName);
        if (fieldMap == null || fieldMap.isEmpty()) {
            logger.info("no sync bomfield set");
            return;
        }
        Set<String> fieldSet = fieldMap.keySet();
        String fieldStr = this.getSrcField(fieldSet);
        DynamicObjectCollection entityDataCol = QueryServiceHelper.query((String)entityName, (String)fieldStr, (QFilter[])new QFilter[]{filter, status, enable});
        if (entityDataCol == null || entityDataCol.isEmpty()) {
            return;
        }
        DynamicObject newBom = BusinessDataServiceHelper.newDynamicObject((String)"pdm_mftbom");
        DataEntityPropertyCollection bomPro = newBom.getDynamicObjectType().getProperties();
        DynamicObjectCollection bomEntryCol = newBom.getDynamicObjectCollection("entry");
        DataEntityPropertyCollection entryPro = bomEntryCol.getDynamicObjectType().getProperties();
        Set<String> bomHeadFiled = this.getBomField(fieldMap, bomPro, entityName);
        Set<String> bomEntryFiled = this.getBomField(fieldMap, entryPro, entityName);
        String headSql = this.getUpdateSql(bomHeadFiled, "t_pdm_mftbom", "fid", bomPro);
        String entrySql = this.getUpdateSql(bomEntryFiled, "t_pdm_mftbomentry", "fentryid", entryPro);
        Map<String, Set<Long>> bomHeadMap = this.getHeadBOM(entityDataCol, exTypeSet);
        Map<String, Set<Long>> bomEntryMap = this.getEntryBOM(entityDataCol, exTypeSet);
        List<Object[]> headParamsList = this.getParams(entityDataCol, bomHeadMap, bomHeadFiled, fieldMap, entityName);
        if (headSql != null && !"".equals(headSql) && !headParamsList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)headSql, headParamsList);
        }
        List<Object[]> entryParamsList = this.getParams(entityDataCol, bomEntryMap, bomEntryFiled, fieldMap, entityName);
        if (entrySql != null && !"".equals(entrySql) && !entryParamsList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)entrySql, entryParamsList);
        }
    }

    private Set<Long> getExcludebomtype(String entityName) {
        HashSet<Long> retSet = new HashSet<Long>(64);
        QFilter filter1 = new QFilter("businesstype", "=", (Object)entityName);
        DynamicObject tmp = BusinessDataServiceHelper.loadSingle((String)"fmm_bomsyncfieldconfig", (String)"id,excludebomtype,businesstype", (QFilter[])new QFilter[]{filter1});
        MulBasedataDynamicObjectCollection excludebomtypeCol = (MulBasedataDynamicObjectCollection)tmp.get("excludebomtype");
        for (int i = 0; i < excludebomtypeCol.size(); ++i) {
            DynamicObject excludeObj = (DynamicObject)excludebomtypeCol.get(i);
            DynamicObject bomTypeObj = excludeObj.getDynamicObject("fbasedataid");
            long bomTypeId = bomTypeObj.getLong("id");
            retSet.add(bomTypeId);
        }
        return retSet;
    }

    private List<Object[]> getParams(DynamicObjectCollection dataCol, Map<String, Set<Long>> bomMap, Set<String> fieldSet, TreeMap<String, String> fieldMap, String entityNum) {
        if (dataCol == null || dataCol.isEmpty() || bomMap == null || bomMap.isEmpty() || fieldSet == null || fieldSet.isEmpty()) {
            return new ArrayList<Object[]>(1);
        }
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(dataCol.size());
        for (int i = 0; i < dataCol.size(); ++i) {
            DynamicObject entityObj = (DynamicObject)dataCol.get(i);
            long createOrgId = entityObj.getLong("createorg");
            long matId = entityObj.getLong("masterid");
            String dataKey = createOrgId + "-" + matId;
            Set<Long> idSet = bomMap.get(dataKey);
            if (idSet == null || idSet.isEmpty()) continue;
            Object[] ObjectArray = this.createPrarams(entityObj, fieldSet, fieldMap, entityNum);
            for (long pkId : idSet) {
                Object[] newObjectArray = (Object[])ObjectArray.clone();
                newObjectArray[newObjectArray.length - 1] = pkId;
                updateList.add(newObjectArray);
            }
        }
        return updateList;
    }

    private Object[] createPrarams(DynamicObject entityObj, Set<String> fieldSet, TreeMap<String, String> fieldMap, String entityNum) {
        String matAttr;
        boolean entryisjumplevel = false;
        if ("bd_materialmftinfo".equals(entityNum) && "10020".equals(matAttr = entityObj.getString("materialattr"))) {
            entryisjumplevel = true;
        }
        int k = 0;
        Object[] ObjectArray = new Object[fieldSet.size() + 1];
        block0: for (String field : fieldSet) {
            Set<Map.Entry<String, String>> entrySet = fieldMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                Object fieldVal;
                String srcField = entry.getKey();
                String tarField = entry.getValue();
                if ("entryisjumplevel".equals(field) && "bd_materialmftinfo".equals(entityNum)) {
                    ObjectArray[k] = entryisjumplevel;
                    ++k;
                    continue block0;
                }
                if (!field.equals(tarField)) continue;
                ObjectArray[k] = fieldVal = entityObj.get(srcField);
                ++k;
                continue block0;
            }
        }
        return ObjectArray;
    }

    private Set<String> getBomField(TreeMap<String, String> fieldMap, DataEntityPropertyCollection properties, String entityNum) {
        if (fieldMap == null || fieldMap.isEmpty() || properties == null || properties.isEmpty()) {
            return new HashSet<String>(1);
        }
        HashSet<String> retSet = new HashSet<String>(fieldMap.size());
        Set<Map.Entry<String, String>> entrySet = fieldMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String field = entry.getValue();
            if (!properties.containsKey((Object)field)) continue;
            retSet.add(field);
        }
        if (properties.containsKey((Object)"entryisjumplevel") && "bd_materialmftinfo".equals(entityNum)) {
            retSet.add("entryisjumplevel");
        }
        return retSet;
    }

    private String getSrcField(Set<String> fieldSet) {
        if (fieldSet == null || fieldSet.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String field : fieldSet) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(field);
        }
        sb.append(",createorg ");
        sb.append(",masterid ");
        return sb.toString();
    }

    private String getUpdateSql(Set<String> fieldSet, String tableName, String condField, DataEntityPropertyCollection properties) {
        if (fieldSet == null || fieldSet.isEmpty()) {
            return "";
        }
        boolean isField = false;
        StringBuilder sql = new StringBuilder("update ");
        sql.append(tableName);
        sql.append(" set ");
        for (String field : fieldSet) {
            if (isField) {
                sql.append(",");
            }
            sql.append(((IDataEntityProperty)properties.get((Object)field)).getAlias());
            sql.append(" = ?");
            isField = true;
        }
        if (!isField) {
            return "";
        }
        sql.append(" where ");
        sql.append(condField);
        sql.append(" = ? ");
        return sql.toString();
    }

    private Map<String, Set<Long>> getEntryBOM(DynamicObjectCollection entityDataCol, Set<Long> exTypeSet) {
        if (entityDataCol == null || entityDataCol.isEmpty()) {
            return new HashMap<String, Set<Long>>(1);
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(entityDataCol.size());
        HashSet<Long> matIdSet = new HashSet<Long>(entityDataCol.size());
        for (int i = 0; i < entityDataCol.size(); ++i) {
            DynamicObject entityObj = (DynamicObject)entityDataCol.get(i);
            long createOrgId = entityObj.getLong("createorg");
            long matId = entityObj.getLong("masterid");
            orgIdSet.add(createOrgId);
            matIdSet.add(matId);
        }
        QFilter filter1 = new QFilter("createorg", "in", orgIdSet);
        QFilter filter2 = new QFilter("entry.entrymaterialid", "in", matIdSet);
        if (!exTypeSet.isEmpty()) {
            QFilter filter3 = new QFilter("type", "not in", exTypeSet);
            filter2.and(filter3);
        }
        HashMap<String, Set<Long>> retMap = new HashMap<String, Set<Long>>(entityDataCol.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)"createorg,entry.id entryId,entry.entrymaterialid entryMatId", (QFilter[])new QFilter[]{filter1, filter2}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long orgId = row.getLong("createorg");
                long entryId = row.getLong("entryId");
                long entryMatId = row.getLong("entryMatId");
                String dataKey = orgId + "-" + entryMatId;
                HashSet<Long> entrySet = (HashSet<Long>)retMap.get(dataKey);
                if (entrySet == null) {
                    entrySet = new HashSet<Long>(16);
                }
                entrySet.add(entryId);
                retMap.put(dataKey, entrySet);
            }
        }
        return retMap;
    }

    private Map<String, Set<Long>> getHeadBOM(DynamicObjectCollection entityDataCol, Set<Long> exTypeSet) {
        if (entityDataCol == null || entityDataCol.isEmpty()) {
            return new HashMap<String, Set<Long>>(1);
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(entityDataCol.size());
        HashSet<Long> matIdSet = new HashSet<Long>(entityDataCol.size());
        for (int i = 0; i < entityDataCol.size(); ++i) {
            DynamicObject entityObj = (DynamicObject)entityDataCol.get(i);
            long createOrgId = entityObj.getLong("createorg");
            long matId = entityObj.getLong("masterid");
            orgIdSet.add(createOrgId);
            matIdSet.add(matId);
        }
        QFilter filter1 = new QFilter("createorg", "in", orgIdSet);
        QFilter filter2 = new QFilter("materialid", "in", matIdSet);
        if (!exTypeSet.isEmpty()) {
            QFilter filter3 = new QFilter("type", "not in", exTypeSet);
            filter2.and(filter3);
        }
        HashMap<String, Set<Long>> retMap = new HashMap<String, Set<Long>>(entityDataCol.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)"id,createorg,materialid", (QFilter[])new QFilter[]{filter1, filter2}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long orgId = row.getLong("createorg");
                long bomId = row.getLong("id");
                long matId = row.getLong("materialid");
                String dataKey = orgId + "-" + matId;
                HashSet<Long> entrySet = (HashSet<Long>)retMap.get(dataKey);
                if (entrySet == null) {
                    entrySet = new HashSet<Long>(16);
                }
                entrySet.add(bomId);
                retMap.put(dataKey, entrySet);
            }
        }
        return retMap;
    }

    private TreeMap<String, String> getSyncField(String entityName) {
        TreeMap<String, String> retMap = new TreeMap<String, String>();
        QFilter filter1 = new QFilter("businesstype", "=", (Object)entityName);
        QFilter filter2 = new QFilter("entryentity.issync", "=", (Object)"1");
        DynamicObjectCollection fieldConfigCol = QueryServiceHelper.query((String)"fmm_bomsyncfieldconfig", (String)"entryentity.field field,entryentity.bomfield bomfield", (QFilter[])new QFilter[]{filter1, filter2});
        for (int i = 0; i < fieldConfigCol.size(); ++i) {
            DynamicObject obj = (DynamicObject)fieldConfigCol.get(i);
            String field = obj.getString("field");
            String bomfield = obj.getString("bomfield");
            retMap.put(field, bomfield);
        }
        return retMap;
    }
}

