/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.math.NumberUtils;

public class MaterialAuditConfigPropSynBomEvent
implements IEventServicePlugin {
    private static String SQL = "update t_pdm_mftbomentry set fconfigproperties = ? where fentryid=? and fentrymatid = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleEvent(KDBizEvent evt) {
        EntityEvent entityEvent = (EntityEvent)evt;
        List businessKeys = entityEvent.getBusinesskeys();
        if ("audit".equals(entityEvent.getOperation()) || "save".equals(entityEvent.getOperation())) {
            List ids = businessKeys.stream().map(NumberUtils::toLong).collect(Collectors.toList());
            DataSet matIDDataSet = null;
            DataSet bomDataSet = null;
            ArrayList<Object[]> updateSQL = new ArrayList<Object[]>(8);
            try {
                QFilter matQFilter = new QFilter("id", "in", ids);
                matIDDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,configproperties", (QFilter[])new QFilter[]{matQFilter}, null);
                QFilter materialQFilter = new QFilter("entry.entrymaterialid", "in", ids);
                bomDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)"entry.id entryid,entry.configproperties configproperties,entry.entrymaterialid entrymaterialid", (QFilter[])new QFilter[]{materialQFilter}, null);
                HashMap<Long, String> matInfoMap = new HashMap<Long, String>(ids.size());
                for (Row row : matIDDataSet) {
                    matInfoMap.put(row.getLong("id"), row.getString("configproperties"));
                }
                for (Row row : bomDataSet) {
                    Long entryid = row.getLong("entryid");
                    String entryConfProp = row.getString("configproperties");
                    Long entryMatPK = row.getLong("entrymaterialid");
                    String matConfProp = (String)matInfoMap.get(entryMatPK);
                    if (!this.isDiffString(matConfProp, entryConfProp)) continue;
                    updateSQL.add(new Object[]{matConfProp, entryid, entryMatPK});
                }
            }
            finally {
                if (bomDataSet != null) {
                    bomDataSet.close();
                }
                if (matIDDataSet != null) {
                    matIDDataSet.close();
                }
            }
            if (!updateSQL.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)SQL, updateSQL);
            }
            String sql = String.format("update %s set %s = ? where fentrymatid = ?", "t_pdm_mftbomentry", "fconfigproperties");
            if (!updateSQL.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, updateSQL);
            }
        }
        return businessKeys;
    }

    public boolean isDiffString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return false;
        }
        if (s1 == null || s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }
}

