/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.programe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;

public class ProgramAutoAssignUtils {
    public static String checkAutoAssignBySubmit(DynamicObjectCollection groupEntry) {
        if (groupEntry == null || groupEntry.isEmpty()) {
            return "";
        }
        int size = groupEntry.size();
        StringBuilder msg = new StringBuilder();
        boolean isExistA = false;
        boolean isExistB = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)groupEntry.get(i);
            String prodType = entry.getString("prodtype");
            BigDecimal unAssignQty = entry.getBigDecimal("assignnumerator");
            if (unAssignQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (!isExistA && ("A".equals(prodType) || "B".equals(prodType) || "C".equals(prodType))) {
                isExistA = true;
                if (msg.length() > 1) {
                    msg.append("\r\n");
                }
                msg.append(ResManager.loadKDString((String)"\u5b58\u5728\u8054\u526f\u4ea7\u54c1/\u4e2d\u95f4\u54c1\u7ec4\u4ef6\u7684\u5f85\u5206\u914d\u7528\u91cf/\u9636\u68af\u7528\u91cf/\u56fa\u5b9a\u635f\u8017\u6ca1\u6709\u5b8c\u5168\u5206\u914d\uff0c\u662f\u5426\u5c06\u81ea\u52a8\u5176\u5206\u914d\u5230\u6700\u540e\u4e00\u9053\u5de5\u5e8f\uff1f\u82e5\u4e0d\u81ea\u52a8\u5206\u914d\uff0c\u8bf7\u624b\u5de5\u5206\u914d\u540e\u518d\u63d0\u4ea4\u3002", (String)"ProgramAutoAssignUtils_01", (String)"mmc-fmm-business", (Object[])new Object[0]));
                continue;
            }
            if (isExistB || !"D".equals(prodType)) continue;
            isExistB = true;
            if (msg.length() > 1) {
                msg.append("\r\n");
            }
            msg.append(ResManager.loadKDString((String)"\u5b58\u5728\u6750\u6599\u7ec4\u4ef6\u7684\u5f85\u5206\u914d\u7528\u91cf/\u9636\u68af\u7528\u91cf/\u56fa\u5b9a\u635f\u8017\u6ca1\u6709\u5b8c\u5168\u5206\u914d\uff0c\u662f\u5426\u5c06\u81ea\u52a8\u5176\u5206\u914d\u5230\u7b2c\u4e00\u9053\u5de5\u5e8f\uff1f\u82e5\u4e0d\u81ea\u52a8\u5206\u914d\uff0c\u8bf7\u624b\u5de5\u5206\u914d\u540e\u518d\u63d0\u4ea4\u3002", (String)"ProgramAutoAssignUtils_02", (String)"mmc-fmm-business", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static String autoAssignBySubmit(DynamicObject model) {
        DynamicObjectCollection groupColl = model.getDynamicObjectCollection("groupentity");
        int size = groupColl.size();
        DynamicObject lastOp = ProgramAutoAssignUtils.getAssignOp(model, true);
        DynamicObject firstOp = ProgramAutoAssignUtils.getAssignOp(model, false);
        ORM orm = ORM.create();
        long[] pks = orm.genLongIds("fmm_programassign", size);
        ArrayList<DynamicObject> delList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < size; ++i) {
            DynamicObject sameEntry;
            DynamicObject assignOp;
            DynamicObject entry = (DynamicObject)groupColl.get(i);
            String prodType = entry.getString("prodtype");
            BigDecimal unAssignQty = entry.getBigDecimal("assignnumerator");
            String proEntryId = entry.getString("proentryid");
            boolean hasStageAssign = ProgramAutoAssignUtils.hashStageEntry(entry);
            if (unAssignQty.compareTo(BigDecimal.ZERO) <= 0 && !hasStageAssign || proEntryId != null && !"".equals(proEntryId)) continue;
            BigDecimal unAssignRate = entry.getBigDecimal("tobeassignrate");
            DynamicObject dynamicObject = assignOp = "A".equals(prodType) || "B".equals(prodType) || "C".equals(prodType) ? lastOp : firstOp;
            if (assignOp == null) continue;
            String groupEntryId = entry.getString("groupid");
            if (groupEntryId == null || "".equals(groupEntryId)) {
                groupEntryId = String.valueOf(pks[i]);
            }
            if ((sameEntry = ProgramAutoAssignUtils.getSameAssign(groupColl, assignOp, groupEntryId)) != null) {
                sameEntry.set("qtynumerator", (Object)sameEntry.getBigDecimal("qtynumerator").add(unAssignQty));
                sameEntry.set("assignrate", (Object)sameEntry.getBigDecimal("assignrate").add(unAssignRate));
                sameEntry.set("prodstage", assignOp.get("prostatge"));
                sameEntry.set("groupstatgedesc", assignOp.get("prostatgedesc"));
                sameEntry.set("stage", assignOp.get("isstage"));
                delList.add(entry);
            } else {
                entry.set("qtynumerator", (Object)entry.getBigDecimal("qtynumerator").add(unAssignQty));
                entry.set("assignrate", (Object)entry.getBigDecimal("assignrate").add(unAssignRate));
                entry.set("assignnumerator", (Object)BigDecimal.ZERO);
                entry.set("tobeassignrate", (Object)BigDecimal.ZERO);
                entry.set("proentryid", (Object)String.valueOf(assignOp.get("id")));
                entry.set("prodstage", assignOp.get("prostatge"));
                entry.set("groupstatgedesc", assignOp.get("prostatgedesc"));
                entry.set("stage", assignOp.get("isstage"));
                entry.set("groupid", (Object)groupEntryId);
                entry.set("entryprono", assignOp.get("processno"));
            }
            ProgramAutoAssignUtils.updateStageEntry(groupColl, entry, sameEntry);
        }
        if (!delList.isEmpty()) {
            for (DynamicObject delEntry : delList) {
                groupColl.remove((Object)delEntry);
            }
        }
        return "";
    }

    private static boolean hashStageEntry(DynamicObject groupEntry) {
        boolean retFlag = false;
        if (groupEntry == null) {
            return retFlag;
        }
        DynamicObjectCollection stageCol = groupEntry.getDynamicObjectCollection("stageentity");
        int size = stageCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject stageObj = (DynamicObject)stageCol.get(i);
            BigDecimal toBeAssignQty = stageObj.getBigDecimal("assignstagenumerator");
            if (toBeAssignQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            retFlag = true;
            break;
        }
        return retFlag;
    }

    private static void updateStageEntry(DynamicObjectCollection groupColl, DynamicObject groupEntryObj, DynamicObject sameGroupEntry) {
        if (groupEntryObj == null) {
            return;
        }
        DynamicObjectCollection stageEntryCol = groupEntryObj.getDynamicObjectCollection("stageentity");
        int size = stageEntryCol.size();
        ORM orm = ORM.create();
        long[] stageIds = orm.genLongIds((IDataEntityType)stageEntryCol.getDynamicObjectType(), size);
        for (int i = 0; i < size; ++i) {
            DynamicObject stageObj = (DynamicObject)stageEntryCol.get(i);
            BigDecimal toBeAssignQty = stageObj.getBigDecimal("assignstagenumerator");
            if (toBeAssignQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal toBeAssignFixRate = stageObj.getBigDecimal("assginstagefixscrap");
            DynamicObject sameStageObj = ProgramAutoAssignUtils.getSameStageEntry(sameGroupEntry, stageObj);
            if (sameStageObj != null) {
                sameStageObj.set("assignedstagenumerator", (Object)sameStageObj.getBigDecimal("assignedstagenumerator").add(toBeAssignQty));
                sameStageObj.set("assginedstagefixscrap", (Object)sameStageObj.getBigDecimal("assginedstagefixscrap").add(toBeAssignFixRate));
                sameStageObj.set("assignstagenumerator", (Object)BigDecimal.ZERO);
                sameStageObj.set("assginstagefixscrap", (Object)BigDecimal.ZERO);
                continue;
            }
            if (sameGroupEntry != null) {
                ProgramAutoAssignUtils.addStageObj(sameGroupEntry, stageObj);
                continue;
            }
            String sourceId = String.valueOf(stageIds[i]);
            stageObj.set("assignedstagenumerator", (Object)stageObj.getBigDecimal("assignstagenumerator"));
            stageObj.set("assginedstagefixscrap", (Object)stageObj.getBigDecimal("assginstagefixscrap"));
            stageObj.set("assignstagenumerator", (Object)BigDecimal.ZERO);
            stageObj.set("assginstagefixscrap", (Object)BigDecimal.ZERO);
            stageObj.set("stagesourceid", (Object)sourceId);
            stageObj.set("stagetype", (Object)"B");
            String stageEntryId = stageObj.getString("id");
            ProgramAutoAssignUtils.updateSourceId(groupColl, stageEntryId, sourceId);
        }
    }

    private static void updateSourceId(DynamicObjectCollection groupColl, String stageEntryId, String newSourceId) {
        if (groupColl == null || groupColl.isEmpty() || stageEntryId == null || "".equals(stageEntryId)) {
            return;
        }
        for (DynamicObject grouObj : groupColl) {
            DynamicObjectCollection stageCol = grouObj.getDynamicObjectCollection("stageentity");
            for (DynamicObject stageObj : stageCol) {
                String sourceId = stageObj.getString("stagesourceid");
                if (!stageEntryId.equals(sourceId)) continue;
                stageObj.set("stagesourceid", (Object)newSourceId);
            }
        }
    }

    private static void addStageObj(DynamicObject sameGroupEntry, DynamicObject stageObj) {
        DynamicObjectCollection stageCol = sameGroupEntry.getDynamicObjectCollection("stageentity");
        DynamicObject newStageObj = stageCol.addNew();
        DataEntityPropertyCollection properties = newStageObj.getDataEntityType().getProperties();
        ORM orm = ORM.create();
        long stageId = orm.genLongId(newStageObj.getDataEntityType());
        for (IDataEntityProperty property : properties) {
            String fieldName = property.getName();
            if ("id".equals(fieldName)) {
                newStageObj.set(fieldName, (Object)stageId);
                continue;
            }
            if ("assignedstagenumerator".equals(fieldName)) {
                newStageObj.set(fieldName, (Object)stageObj.getBigDecimal("assignstagenumerator"));
                continue;
            }
            if ("assginedstagefixscrap".equals(fieldName)) {
                newStageObj.set(fieldName, (Object)stageObj.getBigDecimal("assginstagefixscrap"));
                continue;
            }
            if ("assignstagenumerator".equals(fieldName) || "assginstagefixscrap".equals(fieldName)) {
                newStageObj.set(fieldName, (Object)BigDecimal.ZERO);
                continue;
            }
            if ("stagesourceid".equals(fieldName)) {
                newStageObj.set(fieldName, stageObj.get("id"));
                continue;
            }
            newStageObj.set(fieldName, stageObj.get(fieldName));
        }
    }

    private static DynamicObject getSameStageEntry(DynamicObject sameGroupEntry, DynamicObject stageObj) {
        DynamicObject retObj = null;
        if (sameGroupEntry == null || stageObj == null) {
            return retObj;
        }
        String stageEntryId = stageObj.getString("id");
        DynamicObjectCollection stageEntryCol = sameGroupEntry.getDynamicObjectCollection("stageentity");
        int size = stageEntryCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(i);
            String sourceId = stageEntry.getString("stagesourceid");
            if (stageEntryId == null || !stageEntryId.equals(sourceId)) continue;
            retObj = stageEntry;
            break;
        }
        return retObj;
    }

    private static DynamicObject getSameAssign(DynamicObjectCollection groupColl, DynamicObject lastOp, String groupId) {
        DynamicObject groupEntry = null;
        String proEntryId = lastOp.getString("id");
        for (int i = 0; i < groupColl.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)groupColl.get(i);
            String groupProEntryId = entryObj.getString("proentryid");
            String groupEntryId = entryObj.getString("groupid");
            if (groupProEntryId == null || "".equals(groupProEntryId) || groupEntryId == null || "".equals(groupEntryId) || !groupProEntryId.equals(proEntryId) || !groupEntryId.equals(groupId)) continue;
            groupEntry = entryObj;
            break;
        }
        return groupEntry;
    }

    public static DynamicObject getAssignOp(DynamicObject model, boolean isLast) {
        DynamicObjectCollection entryColl = model.getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return null;
        }
        Collections.sort(entryColl, Comparator.comparingInt(o -> o.getInt("processno")));
        return (DynamicObject)entryColl.get(isLast ? entryColl.size() - 1 : 0);
    }
}

