/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.programe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ProgramBusiness {
    public boolean validateVal(Date validate, Date invalidate) {
        boolean flag = true;
        if (validate == null || invalidate == null) {
            return flag;
        }
        if (validate.after(invalidate)) {
            flag = false;
        }
        return flag;
    }

    public int getMaxIndex(DynamicObjectCollection entryCol) {
        int index = 0;
        if (entryCol == null || entryCol.isEmpty()) {
            return index;
        }
        return entryCol.size() - 1;
    }

    public JSONArray loadBom(long orgId, long matId, long verId, long expandConfg, long auxp, BigDecimal qty) {
        JSONArray dataArray = new JSONArray();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("org", (Object)orgId);
        paramsJson.put("searchDate", (Object)new Date());
        paramsJson.put("isNeedProRoute", (Object)false);
        paramsJson.put("model", (Object)"model_fmm");
        paramsJson.put("materialid", (Object)matId);
        paramsJson.put("version", (Object)verId);
        paramsJson.put("auxproperty", (Object)auxp);
        paramsJson.put("replaceno", (Object)0L);
        paramsJson.put("showtype", (Object)"E");
        paramsJson.put("purexpand", (Object)false);
        paramsJson.put("num", (Object)(qty == null || qty.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ONE : qty));
        paramsJson.put("expandConfig", (Object)expandConfg);
        JSONArray paramArray = new JSONArray();
        paramArray.add((Object)paramsJson);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"bomExpandForMulType", (Object[])new Object[]{paramArray.toJSONString()});
        JSONArray resArray = JSONArray.parseArray((String)result);
        JSONObject resObj = (JSONObject)resArray.get(0);
        if (!resObj.getBoolean("success").booleanValue()) {
            return dataArray;
        }
        String dataKey = resObj.getString("dataKey");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        String dataStr = (String)cache.get(dataKey);
        if (dataStr != null) {
            dataArray = JSONArray.parseArray((String)dataStr);
        }
        return dataArray;
    }

    public Map<Object, DynamicObject> getMaterial(JSONArray dataArray) {
        if (dataArray == null || dataArray.isEmpty()) {
            return new HashMap<Object, DynamicObject>();
        }
        HashSet<Long> matIdSet = new HashSet<Long>(dataArray.size());
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject dataObj = (JSONObject)dataArray.get(i);
            long entryMatId = dataObj.getLong("entrymaterialId");
            matIdSet.add(entryMatId);
        }
        if (matIdSet.isEmpty()) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter filter = new QFilter("id", "in", matIdSet);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])new QFilter[]{filter, status, enable});
    }

    public int getToBeAssignedGroup(DynamicObjectCollection groupCol, String groupId) {
        int index = -1;
        if (groupCol == null || groupCol.isEmpty()) {
            return index;
        }
        for (int i = 0; i < groupCol.size(); ++i) {
            String entryGroupId;
            DynamicObject entryObj = (DynamicObject)groupCol.get(i);
            String proEntryId = entryObj.getString("proentryid");
            if (proEntryId != null && !"".equals(proEntryId) || (entryGroupId = entryObj.getString("groupid")) == null || !entryGroupId.equals(groupId)) continue;
            index = i;
            break;
        }
        return index;
    }

    public Set<Long> getAssignPro(IDataModel dm) {
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        HashSet<Long> retSet = new HashSet<Long>(groupCol.size());
        for (int i = 0; i < groupCol.size(); ++i) {
            DynamicObject groupEntry = (DynamicObject)groupCol.get(i);
            String proEntryId = groupEntry.getString("proentryid");
            if (proEntryId == null || "".equals(proEntryId) || "0".equals(proEntryId)) continue;
            retSet.add(Long.parseLong(proEntryId));
        }
        return retSet;
    }

    public int[] getSeqBySourceId(DynamicObjectCollection groupEntryCol, Set<String> groupEntryIdSet) {
        if (groupEntryCol == null || groupEntryCol.isEmpty()) {
            return new int[0];
        }
        HashSet<Integer> retSet = new HashSet<Integer>(groupEntryCol.size());
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupEntryObj = (DynamicObject)groupEntryCol.get(i);
            String sourceId = groupEntryObj.getString("sourceid");
            if (!groupEntryIdSet.contains(sourceId)) continue;
            retSet.add(i);
        }
        Integer[] retArray = retSet.toArray(new Integer[retSet.size()]);
        int[] retIntArray = Arrays.stream(retArray).mapToInt(Integer::valueOf).toArray();
        return retIntArray;
    }

    public int[] getSeqByCreateType(DynamicObjectCollection groupEntryCol, String type) {
        if (groupEntryCol == null || groupEntryCol.isEmpty()) {
            return new int[0];
        }
        HashSet<Integer> retSet = new HashSet<Integer>(groupEntryCol.size());
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupEntryObj = (DynamicObject)groupEntryCol.get(i);
            String createType = groupEntryObj.getString("createtype");
            if (type == null || !type.equals(createType)) continue;
            retSet.add(i);
        }
        Integer[] retArray = retSet.toArray(new Integer[retSet.size()]);
        int[] retIntArray = Arrays.stream(retArray).mapToInt(Integer::valueOf).toArray();
        return retIntArray;
    }

    public DynamicObject getMatInfo(DynamicObject matObj, DynamicObject orgObj) {
        long matId = matObj == null ? 0L : matObj.getLong("id");
        long orgId = orgObj == null ? 0L : orgObj.getLong("id");
        QFilter matFilter = new QFilter("masterid", "=", (Object)matId);
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{matFilter, orgFilter, status, enable});
    }

    public void syncEntryQty(IFormView fv, IDataModel dm, String fieldName, BigDecimal newVal, int index) {
        DynamicObjectCollection groupEntryCol = dm.getEntryEntity("groupentity");
        DynamicObject entryObj = (DynamicObject)groupEntryCol.get(index);
        String groupId = entryObj.getString("groupid");
        BigDecimal assignedCount = BigDecimal.ZERO;
        BigDecimal assignedRate = BigDecimal.ZERO;
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupEntryObj = (DynamicObject)groupEntryCol.get(i);
            String entryGroupId = groupEntryObj.getString("groupid");
            BigDecimal qtynumerator = groupEntryObj.getBigDecimal("qtynumerator");
            BigDecimal assignrate = groupEntryObj.getBigDecimal("assignrate");
            if (groupId == null || "".equals(groupId) || !groupId.equals(entryGroupId)) continue;
            groupEntryObj.set(fieldName, (Object)newVal);
            if ("entryqtydenominator".equals(fieldName)) {
                groupEntryObj.set("assigndenominator", (Object)newVal);
                groupEntryObj.set("qtydenominator", (Object)newVal);
            }
            assignedCount = assignedCount.add(qtynumerator);
            assignedRate = assignedRate.add(assignrate);
        }
        if ("entryqtydenominator".equals(fieldName)) {
            entryObj.set("qtydenominator", (Object)newVal);
            entryObj.set("assigndenominator", (Object)newVal);
        } else if ("fixscrap".equals(fieldName)) {
            newVal = newVal.subtract(assignedRate);
            entryObj.set("tobeassignrate", (Object)newVal);
        } else if ("entryqtynumerator".equals(fieldName)) {
            if (assignedCount.compareTo(BigDecimal.ZERO) > 0) {
                newVal = newVal.subtract(assignedCount);
            }
            entryObj.set("assignnumerator", (Object)newVal);
        }
        fv.updateView();
    }

    public void syncStageEntryQty(IFormView fv, IDataModel dm, int index, BigDecimal oldVal) {
        DynamicObject stageEntryObj = dm.getEntryRowEntity("stageentity", index);
        BigDecimal nume = stageEntryObj.getBigDecimal("stagenumerator");
        BigDecimal assinedNume = this.getAssignedStageQty(fv, dm, index, "assignedstagenumerator");
        BigDecimal toBeAssignNum = nume.subtract(assinedNume);
        BigDecimal fixscrap = stageEntryObj.getBigDecimal("stagefixscrap");
        BigDecimal assinedFixscrap = this.getAssignedStageQty(fv, dm, index, "assginedstagefixscrap");
        BigDecimal toBeAssignFixscrap = fixscrap.subtract(assinedFixscrap);
        int groupIndex = dm.getEntryCurrentRowIndex("groupentity");
        if (toBeAssignNum.compareTo(BigDecimal.ZERO) < 0) {
            dm.setValue("stagenumerator", (Object)oldVal, index);
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7ec4\u4ef6\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u884c\u9636\u68af\u4fe1\u606f\uff0c\u6807\u51c6\u7528\u91cf\uff1a\u5206\u5b50\u5fc5\u987b\u5927\u4e8e\u5df2\u5206\u914d\u7528\u91cf\uff1a\u5206\u5b50\u3002", (String)"ProgramBusiness_4", (String)"mmc-fmm-business", (Object[])new Object[0]), groupIndex + 1, index));
            fv.updateView("stageentity");
            return;
        }
        if (toBeAssignFixscrap.compareTo(BigDecimal.ZERO) < 0) {
            dm.setValue("stagefixscrap", (Object)oldVal, index);
            fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7ec4\u4ef6\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u884c\u9636\u68af\u4fe1\u606f\uff0c\u56fa\u5b9a\u635f\u8017\u7387\u5fc5\u987b\u5927\u4e8e\u5df2\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u3002", (String)"ProgramBusiness_5", (String)"mmc-fmm-business", (Object[])new Object[0]), groupIndex + 1, index));
            fv.updateView("stageentity");
            return;
        }
        dm.setValue("assignstagenumerator", (Object)toBeAssignNum, index);
        dm.setValue("assginstagefixscrap", (Object)toBeAssignFixscrap, index);
        BigDecimal deno = stageEntryObj.getBigDecimal("stagedenominator");
        dm.setValue("assginstagedenominator", (Object)deno, index);
        dm.setValue("assginedstagedenominator", (Object)deno, index);
    }

    public BigDecimal getAssignedStageQty(IFormView fv, IDataModel dm, int index, String fieldName) {
        DynamicObject stageEntryObj = dm.getEntryRowEntity("stageentity", index);
        String stageEntryId = stageEntryObj.getString("id");
        BigDecimal assignQty = stageEntryObj.getBigDecimal(fieldName);
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        for (DynamicObject groupObj : groupCol) {
            String proEntryId = groupObj.getString("proentryid");
            if (proEntryId == null || "".equals(proEntryId)) continue;
            DynamicObjectCollection stageCol = groupObj.getDynamicObjectCollection("stageentity");
            for (int i = 0; i < stageCol.size(); ++i) {
                DynamicObject stageObj = (DynamicObject)stageCol.get(i);
                String stageSourceId = stageObj.getString("stagesourceid");
                BigDecimal entryAssignQty = stageObj.getBigDecimal(fieldName);
                if (stageEntryId == null || !stageEntryId.equals(stageSourceId)) continue;
                assignQty = assignQty.add(entryAssignQty);
            }
        }
        return assignQty;
    }

    public void syncAssinedStageEntryQty(IFormView fv, IDataModel dm, int index) {
        DynamicObject stageEntryObj = dm.getEntryRowEntity("stageentity", index);
        BigDecimal startQty = stageEntryObj.getBigDecimal("batchstartqty");
        BigDecimal endQty = stageEntryObj.getBigDecimal("batchendqty");
        BigDecimal stagenumerator = stageEntryObj.getBigDecimal("stagenumerator");
        BigDecimal stagedenominator = stageEntryObj.getBigDecimal("stagedenominator");
        BigDecimal fixscrap = stageEntryObj.getBigDecimal("stagefixscrap");
        BigDecimal scraprate = stageEntryObj.getBigDecimal("stagescraprate");
        boolean isStageFix = stageEntryObj.getBoolean("isstagefix");
        String entryId = stageEntryObj.getString("id");
        DynamicObjectCollection groupEntryCol = dm.getEntryEntity("groupentity");
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupObj = (DynamicObject)groupEntryCol.get(i);
            String proEntryId = groupObj.getString("proentryid");
            if (proEntryId == null || "".equals(proEntryId)) continue;
            DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
            for (DynamicObject stageObj : stageEntryCol) {
                String sourceId = stageObj.getString("stagesourceid");
                if (entryId == null || !entryId.equals(sourceId)) continue;
                stageObj.set("batchstartqty", (Object)startQty);
                stageObj.set("batchendqty", (Object)endQty);
                stageObj.set("stagenumerator", (Object)stagenumerator);
                stageObj.set("stagedenominator", (Object)stagedenominator);
                stageObj.set("assginstagedenominator", (Object)stagedenominator);
                stageObj.set("assginedstagedenominator", (Object)stagedenominator);
                stageObj.set("stagescraprate", (Object)scraprate);
                stageObj.set("stagefixscrap", (Object)fixscrap);
                stageObj.set("isstagefix", (Object)isStageFix);
            }
        }
        dm.updateCache();
        fv.updateView("stageentity");
    }

    public void setMatInfo(IFormView fv, IDataModel dm, DynamicObject entryMatObj, int index) {
        if (entryMatObj == null) {
            dm.setValue("entrymaterialattr", null, index);
            dm.setValue("entryisjumplevel", (Object)false, index);
            dm.setValue("entryissuemode", (Object)"11040", index);
            dm.setValue("entryisbackflush", (Object)"A", index);
            dm.setValue("entrysupplyorg", null, index);
            dm.setValue("entryisstockalloc", (Object)false, index);
            dm.setValue("entrywarehouse", null, index);
            dm.setValue("entrylocation", null, index);
            dm.setValue("entryoutorg", null, index);
            dm.setValue("entryoutwarehouse", null, index);
            dm.setValue("entryoutlocation", null, index);
            return;
        }
        DynamicObject orgObj = (DynamicObject)dm.getValue("createorg");
        if (orgObj == null) {
            return;
        }
        ProgramBusiness business = new ProgramBusiness();
        DynamicObject matInfoObj = business.getMatInfo(entryMatObj, orgObj);
        if (matInfoObj == null) {
            dm.setValue("entrymaterialattr", null, index);
            dm.setValue("entryisjumplevel", (Object)false, index);
            dm.setValue("entryissuemode", (Object)"11040", index);
            dm.setValue("entryisbackflush", (Object)"A", index);
            dm.setValue("entrysupplyorg", null, index);
            dm.setValue("entryisstockalloc", (Object)false, index);
            dm.setValue("entrywarehouse", null, index);
            dm.setValue("entrylocation", null, index);
            dm.setValue("entryoutorg", null, index);
            dm.setValue("entryoutwarehouse", null, index);
            dm.setValue("entryoutlocation", null, index);
            return;
        }
        dm.beginInit();
        String materialattr = matInfoObj.getString("materialattr");
        if ("10020".equals(materialattr)) {
            dm.setValue("entryisjumplevel", (Object)true, index);
            fv.setEnable(Boolean.valueOf(false), index, new String[]{"entryisjumplevel"});
        } else if ("10040".equals(materialattr)) {
            dm.setValue("entryisjumplevel", (Object)false, index);
            fv.setEnable(Boolean.valueOf(false), index, new String[]{"entryisjumplevel"});
        } else {
            dm.setValue("entryisjumplevel", (Object)false, index);
        }
        dm.setValue("entrymaterialattr", (Object)materialattr, index);
        dm.setValue("entryissuemode", matInfoObj.get("issuemode"), index);
        dm.setValue("entryisbackflush", matInfoObj.get("isbackflush"), index);
        dm.setValue("entrysupplyorg", matInfoObj.get("supplyorgunitid"), index);
        dm.setValue("entryisstockalloc", matInfoObj.get("isstockallot"), index);
        dm.setValue("entrywarehouse", matInfoObj.get("warehouse"), index);
        dm.setValue("entrylocation", matInfoObj.get("location"), index);
        dm.setValue("entryoutorg", matInfoObj.get("outstorageunit"), index);
        dm.setValue("entryoutwarehouse", matInfoObj.get("outwarehouse"), index);
        dm.setValue("entryoutlocation", matInfoObj.get("outwarelocation"), index);
        dm.endInit();
    }

    public void syncProStage(IFormView fv, IDataModel dm, String fieldName, Object syncObj, int index) {
        DynamicObjectCollection proEntryCol = dm.getEntryEntity("entryentity");
        DynamicObject entryObj = (DynamicObject)proEntryCol.get(index);
        DynamicObjectCollection groupEntryCol = dm.getEntryEntity("groupentity");
        String proEntryId = entryObj.getString("id");
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupEntryObj = (DynamicObject)groupEntryCol.get(i);
            String groupProEntryId = groupEntryObj.getString("proentryid");
            if (groupProEntryId == null || "".equals(groupProEntryId) || !groupProEntryId.equals(proEntryId)) continue;
            groupEntryObj.set(fieldName, syncObj);
        }
        fv.updateView("groupentity");
    }

    public boolean isQtyEnableChange(IFormView fv, IDataModel dm, int index) {
        BigDecimal assignQty;
        boolean retFlag = true;
        BigDecimal entryqtynumerator = (BigDecimal)dm.getValue("entryqtynumerator");
        BigDecimal entryqtydenominator = (BigDecimal)dm.getValue("entryqtydenominator");
        DynamicObjectCollection groupEntryCol = dm.getEntryEntity("groupentity");
        DynamicObject entryObj = (DynamicObject)groupEntryCol.get(index);
        String groupId = entryObj.getString("groupid");
        BigDecimal assignCuont = BigDecimal.ZERO;
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupEntry = (DynamicObject)groupEntryCol.get(i);
            String groupProEntryId = groupEntry.getString("proentryid");
            String groupEntrygGroupId = groupEntry.getString("groupid");
            if (groupProEntryId == null || "".equals(groupProEntryId) || groupEntrygGroupId == null || "".equals(groupEntrygGroupId) || !groupEntrygGroupId.equals(groupId)) continue;
            BigDecimal qtynumerator = groupEntry.getBigDecimal("qtynumerator");
            assignCuont = assignCuont.add(qtynumerator);
        }
        BigDecimal entryQty = entryqtynumerator.divide(entryqtydenominator, 10, RoundingMode.HALF_UP);
        if (entryQty.compareTo(assignQty = assignCuont.divide(entryqtydenominator, 10, RoundingMode.HALF_UP)) < 0) {
            retFlag = false;
        }
        return retFlag;
    }

    public int getNextProNo(DynamicObjectCollection entryCol) {
        int retNo = 10;
        if (entryCol == null || entryCol.isEmpty()) {
            return retNo;
        }
        int tmp = 0;
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            int proNo = entryObj.getInt("processno");
            if (proNo <= tmp) continue;
            tmp = proNo;
        }
        if (tmp < 10) {
            return retNo;
        }
        String proNoStr = String.valueOf(tmp);
        proNoStr = proNoStr.substring(0, proNoStr.length() - 1);
        retNo = (Integer.parseInt(proNoStr) + 1) * 10;
        return retNo;
    }

    public Set<Long> getBomTypeByConfigExpand(long expandConfg) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_bomexpandconfig", (String)"entryentity.bomtype bomtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)expandConfg)});
        return coll.stream().map(p -> p.getLong("bomtype")).collect(Collectors.toSet());
    }

    public String getBomCopEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",materialid materialId");
        sb.append(",copentry.id copentryid");
        sb.append(",copentry.copentrytype copentrytype");
        sb.append(",copentry.copentrymaterial copentrymaterial");
        sb.append(",copentry.copentrymaterialid copentrymaterialid");
        sb.append(",copentry.copentryversion copentryversion");
        sb.append(",copentry.copentryunit copentryunit");
        sb.append(",copentry.copentryqty copentryqty");
        sb.append(",copentry.copentryvaliddate copentryvaliddate");
        sb.append(",copentry.copentryinvaliddate copentryinvaliddate");
        sb.append(",copentry.copentryauxproperty copentryauxproperty");
        sb.append(",copentry.copentryseq copentryseq");
        return sb.toString();
    }

    public JSONArray loadCopEntry(long orgId, long matId, long verId, long expandConfg, long auxp, BigDecimal qty) {
        QFilter status;
        QFilter enable;
        QFilter auxproperty;
        QFilter version;
        QFilter bomType;
        JSONArray dataArray = new JSONArray();
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgId);
        QFilter material = new QFilter("materialid", "=", (Object)matId);
        DynamicObjectCollection bomColl = QueryServiceHelper.query((String)"pdm_mftbom", (String)"id", (QFilter[])new QFilter[]{material, bomType = new QFilter("type", "in", this.getBomTypeByConfigExpand(expandConfg)), ids, version = new QFilter("version", "=", (Object)verId), auxproperty = new QFilter("auxproperty", "=", (Object)auxp), enable = new QFilter("enable", "=", (Object)"1"), status = new QFilter("status", "=", (Object)"C")});
        if (bomColl == null || bomColl.isEmpty()) {
            return dataArray;
        }
        Long bomId = ((DynamicObject)bomColl.get(0)).getLong("id");
        String bomSelectProerties = this.getBomCopEntrySelectProperties();
        Date newDate = new Date();
        QFilter idf = new QFilter("id", "=", (Object)bomId);
        idf.and(new QFilter("copentry.copentryvaliddate", "<=", (Object)newDate));
        idf.and(new QFilter("copentry.copentryinvaliddate", ">=", (Object)newDate));
        DynamicObjectCollection copEntrys = QueryServiceHelper.query((String)"pdm_mftbom", (String)bomSelectProerties, (QFilter[])new QFilter[]{idf});
        if (copEntrys == null || copEntrys.isEmpty()) {
            return dataArray;
        }
        ORM orm = ORM.create();
        long[] copEntryIds = orm.genLongIds(((DynamicObject)copEntrys.get(0)).getDataEntityType(), copEntrys.size());
        int index = 0;
        for (DynamicObject copEntry : copEntrys) {
            JSONObject data = new JSONObject();
            Long materialMftId = copEntry.getLong("copentrymaterial");
            DynamicObject mft = MaterialMftQueryHelper.getDataCacheByID((Object)materialMftId);
            data.put("entrymaterialId", copEntry.get("copentrymaterialid"));
            data.put("entryauxproperty", copEntry.get("copentryauxproperty"));
            data.put("entryversion", copEntry.get("copentryversion"));
            data.put("entrymaterialattr", mft.get("materialattr"));
            data.put("entryunit", copEntry.get("copentryunit"));
            data.put("entryqtytype", (Object)"A");
            data.put("entryfixscrap", (Object)BigDecimal.ZERO);
            data.put("entryscraprate", (Object)BigDecimal.ZERO);
            data.put("commonused", (Object)copEntry.getBigDecimal("copentryqty").multiply(qty));
            data.put("entryqtydenominator", copEntry.get("copentryqty"));
            data.put("entryqtydenominator", (Object)BigDecimal.ONE);
            data.put("entryvaliddate", copEntry.get("copentryvaliddate"));
            data.put("entryinvaliddate", copEntry.get("copentryinvaliddate"));
            data.put("entry_Id", copEntry.get("copentryid"));
            data.put("materialId", copEntry.get("materialId"));
            data.put("randomId", (Object)copEntryIds[index]);
            data.put("id", copEntry.get("id"));
            data.put("entryisjumplevel", (Object)("10020".equals(mft.getString("materialattr")) ? 1 : 0));
            data.put("entryownertype", (Object)"bos_org");
            data.put("entryissuemode", (Object)"11040");
            data.put("entryisbackflush", (Object)"A");
            data.put("entrysupplyorg", mft.getDynamicObject("supplyorgunitid").getPkValue());
            data.put("prodtype", (Object)("10720".equals(copEntry.getString("copentrytype")) ? "A" : "B"));
            dataArray.add((Object)data);
            ++index;
        }
        return dataArray;
    }

    public DynamicObject getProRouteProcess(DynamicObject createOrg, Object proRouteObj, DynamicObject processObj) {
        if (createOrg == null || proRouteObj == null || processObj == null) {
            return null;
        }
        long orgId = createOrg.getLong("id");
        long routeId = 0L;
        if (proRouteObj instanceof DynamicObject) {
            routeId = ((DynamicObject)proRouteObj).getLong("id");
        } else if (proRouteObj instanceof Long) {
            routeId = (Long)proRouteObj;
        }
        long processId = processObj.getLong("id");
        QFilter org = new QFilter("createorg", "=", (Object)orgId);
        QFilter proRoute = new QFilter("product_line", "=", (Object)routeId);
        QFilter process = new QFilter("proseq_entryentity.step_sequence_num", "=", (Object)processId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        String fields = "id,number,proseq_entryentity.step_sequence_num as proNoId,proseq_entryentity.step as stage,proseq_entryentity.milestone milestone";
        return QueryServiceHelper.queryOne((String)"fmm_productline_opera", (String)fields, (QFilter[])new QFilter[]{org, proRoute, process, status, enable});
    }

    public DynamicObjectCollection getProRouteProcess(long routeId, DynamicObject orgObj) {
        long orgId = orgObj == null ? 0L : orgObj.getLong("id");
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"fmm_productline_opera", (Long)orgId);
        QFilter proRoute = new QFilter("product_line", "=", (Object)routeId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        StringBuilder fields = new StringBuilder();
        fields.append("id");
        fields.append(",number");
        fields.append(",proseq_entryentity.step_sequence_seq as procNo");
        fields.append(",proseq_entryentity.step_sequence_num as proNum");
        fields.append(",proseq_entryentity.step_sequence_num.name proDesc");
        fields.append(",proseq_entryentity.step as stage");
        fields.append(",proseq_entryentity.milestone milestone");
        fields.append(",proseq_entryentity.parent_sequence_new parentProNo");
        return QueryServiceHelper.query((String)"fmm_productline_opera", (String)fields.toString(), (QFilter[])new QFilter[]{ids, proRoute, status, enable});
    }

    public Set<Integer> getJumpChildGroupindex(DynamicObjectCollection groupCol, Set<String> groupEntryIdSet, Set<Integer> childSqeSet) {
        if (groupCol == null || groupCol.isEmpty() || groupEntryIdSet == null || groupEntryIdSet.isEmpty()) {
            return childSqeSet;
        }
        HashSet<String> childEntryIdSet = new HashSet<String>(groupCol.size());
        for (int i = 0; i < groupCol.size(); ++i) {
            DynamicObject groupEntryObj = (DynamicObject)groupCol.get(i);
            String pGroupId = groupEntryObj.getString("pgroupid");
            String idStr = groupEntryObj.getString("cgroupid");
            if ("0".equals(pGroupId) || "".equals(pGroupId)) continue;
            int pEntrySeq = groupEntryObj.getInt("seq");
            if (!groupEntryIdSet.contains(pGroupId)) continue;
            childEntryIdSet.add(idStr);
            childSqeSet.add(pEntrySeq - 1);
        }
        if (childEntryIdSet.isEmpty()) {
            return childSqeSet;
        }
        childSqeSet = this.getJumpChildGroupindex(groupCol, childEntryIdSet, childSqeSet);
        return childSqeSet;
    }

    public BigDecimal getMaxEndQty(DynamicObjectCollection entryCol) {
        BigDecimal retQty = new BigDecimal("-1");
        if (entryCol == null || entryCol.isEmpty()) {
            return retQty;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            BigDecimal startQty = entryObj.getBigDecimal("batchendqty");
            if (retQty.compareTo(startQty) >= 0) continue;
            retQty = startQty;
        }
        return retQty;
    }

    public BigDecimal getAssignStageMaxEndQty(DynamicObjectCollection groupEntryCol, String groupId) {
        BigDecimal retQty = new BigDecimal("-1");
        if (groupEntryCol == null || groupEntryCol.isEmpty()) {
            return retQty;
        }
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject groupEntryObj = (DynamicObject)groupEntryCol.get(i);
            String assignGroupId = groupEntryObj.getString("groupid");
            if (!groupId.equals(assignGroupId)) continue;
            DynamicObjectCollection stageEntryCol = groupEntryObj.getDynamicObjectCollection("stageentity");
            for (DynamicObject entryObj : stageEntryCol) {
                BigDecimal endQty = entryObj.getBigDecimal("batchendqty");
                if (retQty.compareTo(endQty) >= 0) continue;
                retQty = endQty;
            }
        }
        return retQty;
    }

    public Map<Long, Set<JSONObject>> getQtyEntry(JSONArray dataArray) {
        if (dataArray == null || dataArray.isEmpty()) {
            return new HashMap<Long, Set<JSONObject>>(1);
        }
        HashSet<Long> entryIdSet = new HashSet<Long>(dataArray.size());
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject dataObj = (JSONObject)dataArray.get(i);
            long bomEntryId = dataObj.getLong("entry_Id");
            entryIdSet.add(bomEntryId);
        }
        final TreeMap<Long, Set<JSONObject>> retMap = new TreeMap<Long, Set<JSONObject>>();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbatchstartqty as qtyentrybatchstartqty ", new Object[0]);
        sql.append(",fbatchendqty as qtyentrybatchendqty", new Object[0]);
        sql.append(",fisstepfix as qtyentryisstepfix", new Object[0]);
        sql.append(",fqtynumerator as qtyentryqtynumerator", new Object[0]);
        sql.append(",fqtydenominator as qtyentryqtydenominator", new Object[0]);
        sql.append(",ffixscrap as qtyentryfixscrap", new Object[0]);
        sql.append(",fscraprate as qtyentryscraprate", new Object[0]);
        sql.append(",fentryid as entryId", new Object[0]);
        sql.append(" from t_pdm_mftbomqtyentry ", new Object[0]);
        sql.append(" where ", new Object[0]);
        sql.appendIn("fentryid", entryIdSet.toArray());
        DB.query((DBRoute)new DBRoute("scm"), (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    long entryId = rs.getLong("entryId");
                    BigDecimal qtyentrybatchstartqty = rs.getBigDecimal("qtyentrybatchstartqty");
                    BigDecimal qtyentrybatchendqty = rs.getBigDecimal("qtyentrybatchendqty");
                    boolean qtyentryisstepfix = rs.getBoolean("qtyentryisstepfix");
                    BigDecimal qtyentryqtynumerator = rs.getBigDecimal("qtyentryqtynumerator");
                    BigDecimal qtyentryqtydenominator = rs.getBigDecimal("qtyentryqtydenominator");
                    BigDecimal qtyentryfixscrap = rs.getBigDecimal("qtyentryfixscrap");
                    BigDecimal qtyentryscraprate = rs.getBigDecimal("qtyentryscraprate");
                    JSONObject json = new JSONObject();
                    json.put("qtyentrybatchstartqty", (Object)qtyentrybatchstartqty);
                    json.put("qtyentrybatchendqty", (Object)qtyentrybatchendqty);
                    json.put("qtyentryisstepfix", (Object)qtyentryisstepfix);
                    json.put("qtyentryqtynumerator", (Object)qtyentryqtynumerator);
                    json.put("qtyentryqtydenominator", (Object)qtyentryqtydenominator);
                    json.put("qtyentryfixscrap", (Object)qtyentryfixscrap);
                    json.put("qtyentryscraprate", (Object)qtyentryscraprate);
                    HashSet<JSONObject> qtySet = (HashSet<JSONObject>)retMap.get(entryId);
                    if (qtySet == null) {
                        qtySet = new HashSet<JSONObject>(32);
                    }
                    qtySet.add(json);
                    retMap.put(entryId, qtySet);
                }
                rs.close();
                return null;
            }
        });
        return retMap;
    }

    public boolean hasStageEntryData(DynamicObject entryObj) {
        boolean hasStageEntry = false;
        DynamicObjectCollection stageEntryCol = entryObj.getDynamicObjectCollection("stageentity");
        if (stageEntryCol != null && !stageEntryCol.isEmpty()) {
            hasStageEntry = true;
        }
        return hasStageEntry;
    }

    public int getSameAssign(JSONObject proData, String groupId, DynamicObjectCollection groupCol) {
        int index = -1;
        if (groupCol == null || groupCol.isEmpty() || proData == null) {
            return index;
        }
        String proEntryId = proData.getString("id");
        for (int i = 0; i < groupCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)groupCol.get(i);
            String groupProEntryId = entryObj.getString("proentryid");
            String groupEntryId = entryObj.getString("groupid");
            if (groupProEntryId == null || "".equals(groupProEntryId) || groupEntryId == null || "".equals(groupEntryId) || !groupProEntryId.equals(proEntryId) || !groupEntryId.equals(groupId)) continue;
            index = entryObj.getInt("seq");
            break;
        }
        return index;
    }

    public DynamicObject getStageEntryObj(DynamicObject groupObj, String stageEntryId, String fieldName) {
        DynamicObject retObj = null;
        if (groupObj == null) {
            return retObj;
        }
        DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
        for (int i = 0; i < stageEntryCol.size(); ++i) {
            DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(i);
            String entryId = stageEntry.getString(fieldName);
            if (stageEntryId == null || !stageEntryId.equals(entryId)) continue;
            retObj = stageEntry;
            break;
        }
        return retObj;
    }

    public Set<String> getAssginedStageEntryIds(DynamicObjectCollection groupCol) {
        if (groupCol == null || groupCol.isEmpty()) {
            return new HashSet<String>(1);
        }
        HashSet<String> retSet = new HashSet<String>(groupCol.size());
        for (DynamicObject groupObj : groupCol) {
            DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
            for (int i = 0; i < stageEntryCol.size(); ++i) {
                DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(i);
                String entryId = stageEntry.getString("stagesourceid");
                if (entryId == null || "".equals(entryId) || "0".equals(entryId)) continue;
                retSet.add(entryId);
            }
        }
        return retSet;
    }

    public boolean isAllStageEntryAssigned(DynamicObject groupObj, String fieldName) {
        boolean retFlag = true;
        if (groupObj == null) {
            return retFlag;
        }
        DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
        if (stageEntryCol.isEmpty()) {
            return retFlag;
        }
        for (int i = 0; i < stageEntryCol.size(); ++i) {
            DynamicObject stageObj = (DynamicObject)stageEntryCol.get(i);
            BigDecimal assignstagenumerator = stageObj.getBigDecimal(fieldName);
            if (assignstagenumerator.compareTo(BigDecimal.ZERO) <= 0) continue;
            retFlag = false;
            break;
        }
        return retFlag;
    }

    public String isEnbaleDeleteStageEntry(IFormView fv, IDataModel dm) {
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        Set<String> assignedStageIds = this.getAssginedStageEntryIds(groupCol);
        EntryGrid entryGrid = (EntryGrid)fv.getControl("stageentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryCol = dm.getEntryEntity("stageentity");
        HashSet<Object> assignedSeq = new HashSet<Object>(entryCol.size());
        for (int i = 0; i < selectRows.length; ++i) {
            int index = selectRows[i];
            DynamicObject entryObj = (DynamicObject)entryCol.get(index);
            String idStr = entryObj.getString("id");
            String sourceId = entryObj.getString("stagesourceid");
            int seq = entryObj.getInt("seq");
            if (assignedStageIds.contains(idStr)) {
                assignedSeq.add(seq);
                continue;
            }
            if (sourceId == null || "".equals(sourceId)) continue;
            assignedSeq.add(seq);
        }
        return this.setToString(assignedSeq);
    }

    public void deleteRelationStage(IDataModel dm, DynamicObject stageObj) {
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        DynamicObjectCollection groupDelCol = new DynamicObjectCollection();
        String idStr = stageObj.getString("id");
        for (DynamicObject groupObj : groupCol) {
            DynamicObjectCollection deleteCol = new DynamicObjectCollection();
            DynamicObjectCollection assignStageCol = groupObj.getDynamicObjectCollection("stageentity");
            for (DynamicObject assignSatge : assignStageCol) {
                String sourceId = assignSatge.getString("stagesourceid");
                if (idStr == null || !idStr.equals(sourceId)) continue;
                deleteCol.add((Object)assignSatge);
            }
            assignStageCol.removeAll((Collection)deleteCol);
            dm.updateEntryCache(assignStageCol);
            BigDecimal assignQty = groupObj.getBigDecimal("qtynumerator");
            String proEntryId = groupObj.getString("proentryid");
            if (proEntryId == null || "".equals(proEntryId) || "0".equals(proEntryId) || assignQty.compareTo(BigDecimal.ZERO) > 0 || !assignStageCol.isEmpty()) continue;
            groupDelCol.add((Object)groupObj);
        }
        groupCol.removeAll((Collection)groupDelCol);
        dm.updateEntryCache(groupCol);
    }

    public String setToString(Set<Object> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(obj.toString());
        }
        return sb.toString();
    }

    public String stageEntryVal(DynamicObject groupObj) {
        String msg = "";
        if (groupObj == null) {
            return msg;
        }
        int groupSeq = groupObj.getInt("seq");
        DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
        for (int i = 0; i < stageEntryCol.size(); ++i) {
            BigDecimal endQty1;
            DynamicObject stageObj1 = (DynamicObject)stageEntryCol.get(i);
            BigDecimal startQty1 = stageObj1.getBigDecimal("batchstartqty");
            if (startQty1.compareTo(endQty1 = stageObj1.getBigDecimal("batchendqty")) > 0) {
                msg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7ec4\u4ef6\u5bf9\u5e94\u7684\u9636\u68af\u4fe1\u606f\u7684\u201c\u6279\u91cf(\u4ece)\u201d\u5927\u4e8e\u7b49\u4e8e\u201c\u6279\u91cf(\u81f3)\u201d\u3002", (String)"ProgramBusiness_6", (String)"mmc-fmm-business", (Object[])new Object[0]), groupSeq);
                break;
            }
            boolean hasRep = false;
            for (int j = 0; j < stageEntryCol.size(); ++j) {
                DynamicObject stageObj2 = (DynamicObject)stageEntryCol.get(j);
                BigDecimal startQty2 = stageObj2.getBigDecimal("batchstartqty");
                BigDecimal endQty2 = stageObj2.getBigDecimal("batchendqty");
                if (!(startQty1.compareTo(startQty2) < 0 && endQty1.compareTo(startQty2) > 0 || startQty1.compareTo(endQty2) < 0 && endQty1.compareTo(endQty2) > 0 || startQty2.compareTo(startQty1) < 0 && endQty2.compareTo(startQty1) > 0) && (startQty2.compareTo(endQty1) >= 0 || endQty2.compareTo(endQty1) <= 0)) continue;
                hasRep = true;
                break;
            }
            if (!hasRep) continue;
            msg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7ec4\u4ef6\u5bf9\u5e94\u7684\u9636\u68af\u4fe1\u606f\u5b58\u5728\u6279\u91cf(\u4ece)\u3001\u6279\u91cf(\u81f3)\u91cd\u53e0\u3002", (String)"ProgramBusiness_0", (String)"mmc-fmm-business", (Object[])new Object[0]), groupSeq);
            break;
        }
        return msg;
    }

    public Set<Long> getEntryUnionMat(DynamicObjectCollection groupEntryCol) {
        if (groupEntryCol == null || groupEntryCol.isEmpty()) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> matSet = new HashSet<Long>(groupEntryCol.size());
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)groupEntryCol.get(i);
            String prodType = entryObj.getString("prodtype");
            DynamicObject matObj = entryObj.getDynamicObject("entrymaterial");
            if (matObj == null || !"A".equals(prodType) && !"B".equals(prodType)) continue;
            long matId = matObj.getLong("id");
            matSet.add(matId);
        }
        return matSet;
    }

    public Set<Long> getEntryStuffMat(DynamicObjectCollection groupEntryCol) {
        if (groupEntryCol == null || groupEntryCol.isEmpty()) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> matSet = new HashSet<Long>(groupEntryCol.size());
        for (int i = 0; i < groupEntryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)groupEntryCol.get(i);
            String prodType = entryObj.getString("prodtype");
            DynamicObject matObj = entryObj.getDynamicObject("entrymaterial");
            if (matObj == null || !"D".equals(prodType)) continue;
            long matId = matObj.getLong("id");
            matSet.add(matId);
        }
        return matSet;
    }

    public List<ComboItem> getComboItems(boolean isJump) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(3);
        ComboItem item1 = new ComboItem();
        item1.setValue("A");
        item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d8\u52a8", (String)"ProgramBusiness_1", (String)"mmc-fmm-business", (Object[])new Object[0])));
        list.add(item1);
        ComboItem item2 = new ComboItem();
        item2.setValue("B");
        item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u56fa\u5b9a", (String)"ProgramBusiness_2", (String)"mmc-fmm-business", (Object[])new Object[0])));
        list.add(item2);
        ComboItem item3 = new ComboItem();
        item3.setValue("C");
        item3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9636\u68af", (String)"ProgramBusiness_3", (String)"mmc-fmm-business", (Object[])new Object[0])));
        if (!isJump) {
            item3.setDisable(false);
        } else {
            item3.setDisable(true);
        }
        list.add(item3);
        return list;
    }
}

