/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.query.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.mmc.business.query.impl.MmcBizQueryImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.fmm.business.query.IBomQuery;
import org.apache.commons.collections4.CollectionUtils;

public class BomQueryImpl
extends MmcBizQueryImpl
implements IBomQuery {
    private static final DistributeSessionlessCache bomCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-bomquery-cache");
    private static final Log logger = LogFactory.getLog(BomQueryImpl.class);

    public String getSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id,");
        sf.append("number,");
        sf.append("replaceno,");
        sf.append("type,");
        sf.append("status,");
        sf.append("enable,");
        sf.append("ecn,");
        sf.append("iscoproduct,");
        sf.append("isversion,");
        sf.append("version,");
        sf.append("yieldrate,");
        sf.append("createorg,");
        sf.append("material,");
        sf.append("materialid,");
        sf.append("auxproperty,");
        sf.append("entry,");
        sf.append("entry.id,");
        sf.append("entry.seq,");
        sf.append("entry.entrymaterial,");
        sf.append("entry.entrymaterialattr,");
        sf.append("entry.entryunit,");
        sf.append("entry.entryqtytype,");
        sf.append("entry.entryqtynumerator,");
        sf.append("entry.entryqtydenominator,");
        sf.append("entry.entryfixscrap,");
        sf.append("entry.entryscraprate,");
        sf.append("entry.entryremark,");
        sf.append("entry.entryleadtime,");
        sf.append("entry.entryoutlocation,");
        sf.append("entry.entryreplaceplan,");
        sf.append("entry.reppriority,");
        sf.append("entry.entryisreplaceplanmm,");
        sf.append("entry.entryisreplace,");
        sf.append("entry.entrytimeunit,");
        sf.append("entry.entrysupplyorg,");
        sf.append("entry.entrysupplymode,");
        sf.append("entry.entrywarehouse,");
        sf.append("entry.entryiskey,");
        sf.append("entry.entrylocation,");
        sf.append("entry.entryisbackflush,");
        sf.append("entry.entryprocessseq,");
        sf.append("entry.entryoperationnumber,");
        sf.append("entry.entryissuemode,");
        sf.append("entry.entryisbulkmaterial,");
        sf.append("entry.entryisstockalloc,");
        sf.append("entry.entryversion,");
        sf.append("entry.entryauxproperty,");
        sf.append("entry.qtyentry,");
        sf.append("entry.entryisjumplevel,");
        sf.append("entry.entryownertype,");
        sf.append("entry.entryoutorg,");
        sf.append("entry.entryoutwarehouse,");
        sf.append("entry.entryvaliddate,");
        sf.append("entry.entryinvaliddate,");
        sf.append("entry.entryecn,");
        sf.append("entry.entryecn.id,");
        sf.append("entry.entryecn.number,");
        sf.append("entry.entryecn.invaliddate,");
        sf.append("entry.entryecn.validdate,");
        sf.append("entry.entryowner,");
        sf.append("entry.setupentry,");
        sf.append("entry.dateentry,");
        sf.append("entry.entryconfiguredcode,");
        sf.append("qtyentry.qtyentrymaterial,");
        sf.append("qtyentry.qtyentrybatchstartqty,");
        sf.append("qtyentry.qtyentrybatchendqty,");
        sf.append("qtyentry.qtyentryqtynumerator,");
        sf.append("qtyentry.qtyentryqtydenominator,");
        sf.append("qtyentry.qtyentryisstepfix,");
        sf.append("qtyentry.qtyentryfixscrap,");
        sf.append("qtyentry.qtyentryscraprate,");
        sf.append("copentry.copentrymaterial,");
        sf.append("copentry.copentryvaliddate,");
        sf.append("copentry.copentryinvaliddate,");
        sf.append("copentry.copentrytype,");
        sf.append("copentry.copentryauxproperty,");
        sf.append("copentry.copentryqty,");
        sf.append("copentry.copentryoperation,");
        sf.append("setupentry.setupentrysetuplocation,");
        sf.append("setupentry.setupentryremark,");
        sf.append("setupentry.setupentryqty ");
        return sf.toString();
    }

    public String getKeyEntityID() {
        return "pdm_mftbom";
    }

    @Override
    public DynamicObject getBomFromCache(DynamicObject material, Long orgID, DynamicObject manuversion, Set<Long> bomTypeIDSet, Date expendbomtime, String selectProperties, String orderByStr) {
        Map<Object, DynamicObject> boms = this.getAllBomList(material, orgID, manuversion, bomTypeIDSet, 0L, selectProperties, orderByStr);
        return this.filterBomVersionData(material, expendbomtime, boms, 0L);
    }

    private Map<Object, DynamicObject> getAllBomList(DynamicObject material, Long orgID, DynamicObject manuversion, Set<Long> bomTypeIDSet, Long configuredcodeID, String selectProperties, String orderByStr) {
        if (material == null || orgID == null || orgID.equals(0L)) {
            return Collections.emptyMap();
        }
        QFilter qfilter3 = new QFilter("materialid", "=", material.getPkValue());
        QFilter qfilter4 = BaseDataServiceHelper.getBaseDataFilter((String)this.getKeyEntityID(), (Long)orgID);
        QFilter qfilter5 = new QFilter("status", "=", (Object)"C");
        qfilter5.and(new QFilter("enable", "=", (Object)"1"));
        if (bomTypeIDSet != null && !bomTypeIDSet.isEmpty()) {
            qfilter5.and(new QFilter("type", "in", bomTypeIDSet));
        }
        if (null != manuversion && manuversion.get("bom") != null) {
            DynamicObject versionBom = (DynamicObject)manuversion.get("bom");
            qfilter5.and(new QFilter("id", "=", versionBom.get("id")));
        }
        if (configuredcodeID != null && !configuredcodeID.equals(0L)) {
            QFilter qfilterConfig = new QFilter("configuredcode.id", "=", (Object)configuredcodeID);
            qfilterConfig.or(new QFilter("type.purpose", "=", (Object)"B"));
            qfilter5.and(qfilterConfig);
        }
        return BusinessDataServiceHelper.loadFromCache((String)this.getKeyEntityID(), (String)selectProperties, (QFilter[])new QFilter[]{qfilter3, qfilter4, qfilter5}, (String)orderByStr);
    }

    private boolean isbetween(Date effectDate, Date invalidDate, Date expendbomtime) {
        if (null == effectDate || null == invalidDate || expendbomtime.after(invalidDate) || expendbomtime.before(effectDate)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private DynamicObject getBomVersionFromCache(Object id) {
        return this.loadSingleFromCache(Long.parseLong(id.toString()), "id,number,effectdate,invaliddate", "bd_bomversion");
    }

    private boolean checkBomTypeIsVersion(DynamicObject bomtype) {
        if (bomtype.containsProperty("isversion")) {
            return bomtype.getBoolean("isversion");
        }
        DynamicObject mv = this.loadSingleFromCache(bomtype.getLong("id"), "isversion", "mpdm_bomtype");
        return mv.getBoolean("isversion");
    }

    private boolean checkMaterialIsVersion(DynamicObject material) {
        if (material.containsProperty("isenablematerialversion")) {
            return material.getBoolean("isenablematerialversion");
        }
        DynamicObject mv = this.loadSingleFromCache(material.getLong("id"), "isenablematerialversion", "bd_material");
        return mv.getBoolean("isenablematerialversion");
    }

    @Override
    public Map<Long, DynamicObject> getBomEntryFromCache(Set<Long> bomentryIDSet) {
        if (bomentryIDSet == null || bomentryIDSet.isEmpty()) {
            return Collections.emptyMap();
        }
        Long startdate = System.currentTimeMillis();
        Set<Object> bomIDSet = this.getBomIDSet(bomentryIDSet);
        logger.info("BomQueryImpl.getBomEntryFromCache-getBomIDSet end: cost = " + (System.currentTimeMillis() - startdate) + ", params: bomentryIDSet = " + bomentryIDSet.toString());
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(bomentryIDSet.size());
        Map bomMap = this.getDataCacheBySet(bomIDSet);
        for (Map.Entry boms : bomMap.entrySet()) {
            DynamicObject bom = (DynamicObject)boms.getValue();
            for (DynamicObject bomentry : bom.getDynamicObjectCollection("entry")) {
                if (!bomentryIDSet.contains(bomentry.getPkValue())) continue;
                entryMap.put(bomentry.getLong("id"), bomentry);
            }
        }
        logger.info("BomQueryImpl.getBomEntryFromCache: query end,cost = " + (System.currentTimeMillis() - startdate) + ", params: bomentryIDSet = " + bomentryIDSet.toString());
        return entryMap;
    }

    @Override
    public DynamicObject getBomFromCache(DynamicObject material, Long orgID, DynamicObject manuversion, Set<Long> bomTypeIDSet, Date expendbomtime, String selectProperties, String orderByStr, DynamicObject auxproperty) {
        Map<Object, DynamicObject> boms = this.getAllBomList(material, orgID, manuversion, bomTypeIDSet, 0L, selectProperties, orderByStr);
        if (boms != null && !boms.isEmpty()) {
            boms = this.filterBomAuxPropertyData(boms, material, orgID, auxproperty);
        }
        return this.filterBomVersionData(material, expendbomtime, boms, 0L);
    }

    private boolean checkMaterialIsBompauxattmust(DynamicObject material, Long orgID) {
        QFilter qFilter = new QFilter("masterid", "=", (Object)material.getLong("id"));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)orgID));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject mv = this.loadSingleFromCache(new QFilter[]{qFilter}, "isbompauxattmust", "bd_materialmftinfo");
        return mv == null ? Boolean.FALSE.booleanValue() : mv.getBoolean("isbompauxattmust");
    }

    private Map<Object, DynamicObject> filterBomAuxPropertyData(Map<Object, DynamicObject> boms, DynamicObject material, Long orgID, DynamicObject auxproperty) {
        if (this.checkMaterialIsBompauxattmust(material, orgID)) {
            HashSet<String> compareSet = new HashSet<String>(16);
            if ((material = MaterialQueryHelper.getDataCacheByID((Object)material.getLong("id"))).getBoolean("isuseauxpty")) {
                Serializable auxptyId;
                HashSet<Long> auxptyIds = new HashSet<Long>(16);
                DynamicObjectCollection auxptyentrys = material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject auxptyentry : auxptyentrys) {
                    if (!auxptyentry.getBoolean("isaffectplan")) continue;
                    auxptyId = Long.valueOf(auxptyentry.getDynamicObject("auxpty").getLong("id"));
                    auxptyIds.add((Long)auxptyId);
                }
                if (CollectionUtils.isNotEmpty(auxptyIds)) {
                    QFilter qFilter = new QFilter("id", "in", auxptyIds);
                    DataSet ds = QueryServiceHelper.queryDataSet((String)"bd_auxproperty", (String)"bd_auxproperty", (String)"flexfield", (QFilter[])new QFilter[]{qFilter}, (String)"");
                    auxptyId = null;
                    try {
                        for (Row row : ds) {
                            String flexfield = row.getString("flexfield");
                            compareSet.add(flexfield);
                        }
                    }
                    catch (Throwable throwable) {
                        auxptyId = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds != null) {
                            if (auxptyId != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)auxptyId).addSuppressed(throwable);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
            }
            if (!compareSet.isEmpty()) {
                Map mapInOrderBillEntry = new HashMap(16);
                if (null != auxproperty) {
                    String auxValueInOrderBillEntry = auxproperty.get("value").toString();
                    mapInOrderBillEntry = (Map)JSONObject.parseObject((String)auxValueInOrderBillEntry, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                }
                HashMap<Object, DynamicObject> filterBoms = new HashMap<Object, DynamicObject>(16);
                for (Map.Entry<Object, DynamicObject> entry : boms.entrySet()) {
                    DynamicObject bomDyn = entry.getValue();
                    DynamicObject auxpropertyInBom = bomDyn.getDynamicObject("auxproperty");
                    if (null != auxpropertyInBom) {
                        String auxValueInBom = auxpropertyInBom.get("value").toString();
                        Map mapInBom = (Map)JSONObject.parseObject((String)auxValueInBom, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        boolean flag = Boolean.TRUE;
                        for (String fileds : compareSet) {
                            String valueInBom;
                            String string = valueInBom = null == mapInBom.get(fileds) ? "" : (String)mapInBom.get(fileds);
                            if (null != valueInBom && StringUtils.equals((CharSequence)valueInBom, (CharSequence)((CharSequence)mapInOrderBillEntry.get(fileds)))) continue;
                            flag = Boolean.FALSE;
                            break;
                        }
                        if (!flag) continue;
                        filterBoms.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (null != auxproperty) continue;
                    filterBoms.put(entry.getKey(), entry.getValue());
                }
                boms = filterBoms;
            }
        }
        return boms;
    }

    private DynamicObject filterBomVersionData(DynamicObject material, Date expendbomtime, Map<Object, DynamicObject> boms, Long configuredcodeID) {
        DynamicObject returnBom = null;
        if (boms != null && !boms.isEmpty()) {
            boolean isenablematerialversion = this.checkMaterialIsVersion(material);
            Date maxDate = null;
            if (configuredcodeID != null && !"0".equals(configuredcodeID.toString())) {
                DynamicObject bomType;
                DynamicObject bom;
                Long keyId = 0L;
                for (Map.Entry<Object, DynamicObject> bomEntry : boms.entrySet()) {
                    bom = bomEntry.getValue();
                    bomType = bom.getDynamicObject("type");
                    if (bomType == null || !"C".equals(bomType.getString("purpose"))) continue;
                    keyId = (Long)bom.getPkValue();
                }
                if (!"0".equals(keyId.toString())) {
                    for (Map.Entry<Object, DynamicObject> bomEntry : boms.entrySet()) {
                        bom = bomEntry.getValue();
                        bomType = bom.getDynamicObject("type");
                        if (bomType == null || "C".equals(bomType.getString("purpose"))) continue;
                        boms.put(bomEntry.getKey(), null);
                    }
                }
            }
            for (Map.Entry<Object, DynamicObject> bomEntry : boms.entrySet()) {
                DynamicObject bom = bomEntry.getValue();
                if (bom == null) continue;
                if (isenablematerialversion || this.checkBomTypeIsVersion(bom.getDynamicObject("type"))) {
                    Date invalidDate;
                    DynamicObject bomVersion;
                    Date effectDate;
                    if (bom.getDynamicObject("version") == null || !this.isbetween(effectDate = (bomVersion = this.getBomVersionFromCache(bom.getDynamicObject("version").getPkValue())).getDate("effectdate"), invalidDate = bomVersion.getDate("invaliddate"), expendbomtime)) continue;
                    if (maxDate == null) {
                        maxDate = effectDate;
                        returnBom = bom;
                    } else if (maxDate.before(effectDate)) {
                        maxDate = effectDate;
                        returnBom = bom;
                    }
                }
                if (maxDate != null) continue;
                return bom;
            }
        }
        return returnBom;
    }

    @Override
    public DynamicObject getBomFromCache(DynamicObject material, Long orgID, DynamicObject manuversion, Set<Long> bomTypeIDSet, Date expendbomtime, String selectProperties, String orderByStr, DynamicObject auxproperty, Long configuredcodeID) {
        Map<Object, DynamicObject> boms = this.getAllBomList(material, orgID, manuversion, bomTypeIDSet, configuredcodeID, selectProperties, orderByStr);
        if (boms != null && !boms.isEmpty()) {
            boms = this.filterBomAuxPropertyData(boms, material, orgID, auxproperty);
        }
        return this.filterBomVersionData(material, expendbomtime, boms, configuredcodeID);
    }

    private Set<Object> getBomIDSet(Set<Long> bomentryIDSet) {
        Long bomid;
        Long bomentryid;
        String bomentryidjson;
        HashSet<Object> bomIDSet = new HashSet<Object>(16);
        JSONArray filterArray = null;
        HashSet<Long> newBomEntryID = new HashSet<Long>(bomentryIDSet.size());
        newBomEntryID.addAll(bomentryIDSet);
        if (bomCache != null && bomCache.contains("bomentryidjson") && (filterArray = JSONArray.parseArray((String)(bomentryidjson = (String)bomCache.get("bomentryidjson")))) != null && !filterArray.isEmpty()) {
            for (int i = 0; i < filterArray.size(); ++i) {
                JSONObject resJson = (JSONObject)filterArray.get(i);
                bomentryid = resJson.getLong("bomentryid");
                bomid = resJson.getLong("bomid");
                if (!bomentryIDSet.contains(bomentryid)) continue;
                bomIDSet.add(bomid);
                newBomEntryID.remove(bomentryid);
            }
        }
        if (!newBomEntryID.isEmpty()) {
            if (filterArray == null) {
                filterArray = new JSONArray();
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MMC-BomQueryImpl-getBomIDSet", (String)this.getKeyEntityID(), (String)"id,entry.id", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", newBomEntryID)}, (String)"");){
                while (ds.hasNext()) {
                    Row arow = ds.next();
                    bomentryid = arow.getLong("entry.id");
                    bomid = arow.getLong("id");
                    bomIDSet.add(bomid);
                    JSONObject resJson = new JSONObject();
                    resJson.put("bomid", (Object)bomid);
                    resJson.put("bomentryid", (Object)bomentryid);
                    filterArray.add((Object)resJson);
                }
            }
            if (bomCache != null) {
                bomCache.put("bomentryidjson", (Object)filterArray.toJSONString(), 1800);
            }
        }
        return bomIDSet;
    }
}

