/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.query.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.IMaterialMftQuery;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.mmc.business.query.impl.MmcBizQueryImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.fmm.business.query.IProcessRouteQuery;
import org.apache.commons.collections4.MapUtils;

public class ProcessRouteQueryImpl
extends MmcBizQueryImpl
implements IProcessRouteQuery {
    private static final Log logger = LogFactory.getLog(ProcessRouteQueryImpl.class);

    public String getSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id,");
        sf.append("createorg,");
        sf.append("number,");
        sf.append("name,");
        sf.append("version,");
        sf.append("routeversion,");
        sf.append("status,");
        sf.append("enable,");
        sf.append("ismainprocess,");
        sf.append("processtype,");
        sf.append("material,");
        sf.append("routereplace,");
        sf.append("auxproperty,");
        sf.append("processentry,");
        sf.append("processentry.headunit,");
        sf.append("processentry.seq,");
        sf.append("processentry.parent,");
        sf.append("processentry.operationno,");
        sf.append("processentry.workcenter,");
        sf.append("processentry.supplier");
        return sf.toString();
    }

    public String getKeyEntityID() {
        return "pdm_route";
    }

    @Override
    public DynamicObject getRouteFromCache(DynamicObject mftmaterial, DynamicObject org) {
        if (mftmaterial == null || org == null) {
            return null;
        }
        QFilter statusFilter = new QFilter("ismainprocess", "=", (Object)"1");
        statusFilter.and(new QFilter("status", "=", (Object)"C"));
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getKeyEntityID(), (Long)((Long)org.getPkValue()));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        String selectProperties = this.selectIdProperties();
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        DynamicObject newMftmaterial = null;
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        DynamicObject processroute = this.loadSingleFromCache(new QFilter[]{orgqFilter, typeA, materialFilter, statusFilter}, selectProperties, this.getKeyEntityID());
        if (processroute != null) {
            return processroute;
        }
        newMftmaterial = IMaterialMftQuery.getImpl().getDataCacheByID(mftmaterial.getPkValue());
        DynamicObjectCollection materialgroup = newMftmaterial.getDynamicObjectCollection("mftcontrolentry");
        Set groupSet = materialgroup.stream().map(p -> (Long)p.getDynamicObject("materialcontrol").getPkValue()).collect(Collectors.toSet());
        if (!groupSet.isEmpty() && (processroute = this.loadSingleFromCache(new QFilter[]{orgqFilter, typeB, statusFilter, new QFilter("materialgroup", "in", groupSet)}, selectProperties, this.getKeyEntityID())) != null) {
            return processroute;
        }
        processroute = this.loadSingleFromCache(new QFilter[]{orgqFilter, typeC, statusFilter}, selectProperties, this.getKeyEntityID());
        return processroute;
    }

    public Map<Object, DynamicObject> filterByNewVersion(Map<Object, DynamicObject> processrouteMap) {
        HashMap<Object, DynamicObject> filterMap = new HashMap<Object, DynamicObject>(16);
        if (MapUtils.isNotEmpty(processrouteMap)) {
            HashSet<Long> routeVersionIdSet = new HashSet<Long>(16);
            for (Map.Entry<Object, DynamicObject> entrys : processrouteMap.entrySet()) {
                DynamicObject route = entrys.getValue();
                DynamicObject routeVersion = route.getDynamicObject("routeversion");
                if (routeVersion == null) continue;
                routeVersionIdSet.add((Long)routeVersion.getPkValue());
            }
            if (!routeVersionIdSet.isEmpty()) {
                Set<Long> enableVersionIdSet = this.getIsEnableVersionIdSet(routeVersionIdSet);
                for (Map.Entry<Object, DynamicObject> entrys : processrouteMap.entrySet()) {
                    Long versionId;
                    DynamicObject route = entrys.getValue();
                    DynamicObject routeVersion = route.getDynamicObject("routeversion");
                    if (routeVersion != null && !enableVersionIdSet.contains(versionId = (Long)routeVersion.getPkValue())) continue;
                    filterMap.put(entrys.getKey(), entrys.getValue());
                }
            } else {
                return processrouteMap;
            }
        }
        return filterMap;
    }

    public Set<Long> getIsEnableVersionIdSet(Set<Long> routeVersionIdSet) {
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "in", routeVersionIdSet);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_bomversion_new", (String)"id", (QFilter[])new QFilter[]{idFilter, status, enable});
        return coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
    }

    @Override
    public Map<Object, DynamicObject> queryRouteMapFromCache(DynamicObject mftmaterial, DynamicObject org, String selectProperties) {
        Map<Object, Object> processrouteMap = new HashMap<Object, DynamicObject>(16);
        if (mftmaterial == null || org == null) {
            return processrouteMap;
        }
        QFilter statusFilter = new QFilter("ismainprocess", "=", (Object)"1");
        statusFilter.and(new QFilter("status", "=", (Object)"C"));
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getKeyEntityID(), (Long)((Long)org.getPkValue()));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        DynamicObject newMftmaterial = null;
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        if (selectProperties.indexOf("routeversion") < 0) {
            selectProperties = selectProperties + ",routeversion";
        }
        processrouteMap = BusinessDataServiceHelper.loadFromCache((String)this.getKeyEntityID(), (String)selectProperties, (QFilter[])new QFilter[]{orgqFilter, typeA, materialFilter, statusFilter});
        if (MapUtils.isNotEmpty(processrouteMap = this.filterByNewVersion(processrouteMap))) {
            return processrouteMap;
        }
        newMftmaterial = IMaterialMftQuery.getImpl().getDataCacheByID(mftmaterial.getPkValue());
        DynamicObjectCollection materialgroup = newMftmaterial.getDynamicObjectCollection("mftcontrolentry");
        Set groupSet = materialgroup.stream().map(p -> (Long)p.getDynamicObject("materialcontrol").getPkValue()).collect(Collectors.toSet());
        if (!groupSet.isEmpty()) {
            processrouteMap = BusinessDataServiceHelper.loadFromCache((String)this.getKeyEntityID(), (String)selectProperties, (QFilter[])new QFilter[]{orgqFilter, typeB, statusFilter, new QFilter("materialgroup", "in", groupSet)});
            if (MapUtils.isNotEmpty(processrouteMap = this.filterByNewVersion(processrouteMap))) {
                return processrouteMap;
            }
        }
        processrouteMap = BusinessDataServiceHelper.loadFromCache((String)this.getKeyEntityID(), (String)selectProperties, (QFilter[])new QFilter[]{orgqFilter, typeC, statusFilter});
        return this.filterByNewVersion(processrouteMap);
    }

    protected String selectIdProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id");
        return sf.toString();
    }
}

