/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.route;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.common.util.PDMAPPArgLoadUtil;

public class RouteAfterAuditSyncDataBusiness {
    private static final Log log = LogFactory.getLog(RouteAfterAuditSyncDataBusiness.class);

    public void syncData(Long orgId, List<Long> routeIdList, String ecnBillNo) {
        this.syncData(orgId, routeIdList, ecnBillNo, "");
    }

    public void syncData(final Long orgId, final List<Long> routeIdList, final String ecnBillNo, final String routeNumbers) {
        String tagId = String.format("MMC-RouteAfterAuditSyncDataBusiness-ids-%s", routeIdList);
        ThreadPools.executeOnceIncludeRequestContext((String)tagId, (Runnable)new Runnable(){

            @Override
            public void run() {
                RouteAfterAuditSyncDataBusiness.this.runSyncCost(orgId, routeIdList, ecnBillNo, routeNumbers);
                RouteAfterAuditSyncDataBusiness.this.runSyncQC(orgId, routeIdList, ecnBillNo, routeNumbers);
            }
        });
    }

    private void runSyncCost(Long orgId, List<Long> routeIdList, String ecnBillNo, String srcRtNumbers) {
        if (!PDMAPPArgLoadUtil.isSyncCostRount((long)orgId)) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("entity", (Object)"pdm_route");
        params.put("routerIds", routeIdList);
        String routeNumbers = srcRtNumbers;
        if (StringUtils.isEmpty((String)routeNumbers)) {
            routeNumbers = this.getRouteNumbers(routeIdList);
        }
        String entity = "pdm_route";
        if (!StringUtils.isEmpty((String)ecnBillNo)) {
            entity = "pdm_eco";
        }
        if (StringUtils.isEmpty((String)routeNumbers)) {
            routeNumbers = routeIdList.toString();
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"syncCostRouterService", (String)"syncCostRouter", (Object[])new Object[]{params.toJSONString()});
            this.addlog("0", entity, "", routeNumbers, ecnBillNo);
        }
        catch (Exception ex) {
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u5de5\u827a\u8def\u7ebf\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"RouteAfterAuditSyncDataBusiness_1", (String)"mmc-fmm-business", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            this.addlog("1", entity, msg, routeNumbers, ecnBillNo);
        }
    }

    private void runSyncQC(Long orgId, List<Long> routeIdList, String ecnBillNo, String srcRtNumbers) {
        String entity = "pdm_route_qc";
        if (StringUtils.isEmpty((String)ecnBillNo)) {
            return;
        }
        entity = "pdm_eco_qc";
        JSONObject params = new JSONObject();
        params.put("routerIds", routeIdList);
        String routeNumbers = srcRtNumbers;
        if (StringUtils.isEmpty((String)routeNumbers)) {
            routeNumbers = this.getRouteNumbers(routeIdList);
        }
        if (StringUtils.isEmpty((String)routeNumbers)) {
            routeNumbers = routeIdList.toString();
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"ManufactureRouteSyncService", (String)"alterProcessEntry", (Object[])new Object[]{params.toJSONString()});
            this.addlog("0", entity, "", routeNumbers, ecnBillNo);
        }
        catch (Exception ex) {
            String msg = String.format(ResManager.loadKDString((String)"\u8d28\u91cf\u5de5\u827a\u8def\u7ebf\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"RouteAfterAuditSyncDataBusiness_2", (String)"mmc-fmm-business", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            this.addlog("1", entity, msg, routeNumbers, ecnBillNo);
        }
    }

    private String getRouteNumbers(List<Long> routeIds) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_route", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", routeIds)});
        StringBuilder sb = new StringBuilder();
        for (DynamicObject route : coll) {
            sb.append(route.getString("number")).append(" ");
        }
        int size = sb.length();
        if (size > 0) {
            return sb.toString().substring(0, size - 1);
        }
        return "";
    }

    private void addlog(String status, String entity, String msg, String billNos, String ecoBillNo) {
        try {
            ORM orm = ORM.create();
            DynamicObject logObj = orm.newDynamicObject("pdm_costbomsynclog");
            logObj.set("status", (Object)status);
            logObj.set("moduler", (Object)entity);
            logObj.set("reason", (Object)msg);
            logObj.set("number", (Object)ecoBillNo);
            logObj.set("billno", (Object)billNos);
            logObj.set("creator", (Object)this.getCurrentUserId());
            logObj.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        }
        catch (Exception e) {
            log.error("\u6210\u672cBOM\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            log.error((Throwable)e);
        }
    }

    private Long getCurrentUserId() {
        return UserServiceHelper.getCurrentUserId();
    }
}

