/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.route;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.route.ProcessRouteVersionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.fmm.common.util.RouteOldVsersionInitUtils;

public class RouteOldVersionInitBusiness {
    private static final Log logger = LogFactory.getLog(RouteOldVersionInitBusiness.class);
    private static final String ENTITY_RULE = "bd_bomversionrule_new";
    private static final String ENTITY_NEWVERSION = "bd_bomversion_new";
    private static final String ENTITY_ROUTE = "pdm_route";
    private static final String KEY_ISOPENRTVERSION = "isopenrouteversion";
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final DBRoute sysDBRoute = new DBRoute("sys");
    public static final int BATCHSAVE = 900;
    public static final String UPDATERTSQL = " update t_pdm_route set frouteversionid = ? where fid = ?";
    public static final String UPDATEVERSIONDATESQL = " update t_bd_bomversion set feffectdate = ? ,finvaliddate = ? where fid = ?";

    public String exec(Long orgId, String ruleid, String opKey) {
        boolean isFromSysParamOp = RouteOldVsersionInitUtils.isFromSysParamOpen((String)opKey);
        return isFromSysParamOp ? this.execByOpenSystem(orgId, ruleid) : this.execByInit(orgId, ruleid);
    }

    public String execByOpenSystem(Long orgId, String ruleid) {
        long startTime = System.currentTimeMillis();
        StringBuilder initMsg = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        if (ProcessRouteVersionUtils.isRouteVsersion((Long)orgId)) {
            try {
                Long routeversion;
                DynamicObject versionRule = ProcessRouteVersionUtils.getDefaultVersionRule((String)"B");
                Map<String, DynamicObject> versionNameMap = this.genVersionNameMap(versionRule);
                DynamicObjectCollection routes = this.getRouteData(orgId);
                ArrayList<DynamicObject> newVersionList = new ArrayList<DynamicObject>(900);
                ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(900);
                HashSet<Long> routeIdSet = new HashSet<Long>(routes.size());
                int newVersionDataSize = 0;
                int updateRtSize = 0;
                HashSet<Long> unVersionIdSet = new HashSet<Long>(128);
                HashSet<Long> nullOldVersionRtIds = new HashSet<Long>(128);
                HashMap<String, DynamicObject> cacheMap = new HashMap<String, DynamicObject>(128);
                for (DynamicObject route : routes) {
                    Long oldVersionId = route.getLong("versionid");
                    if (oldVersionId == null || oldVersionId.equals(0L)) {
                        nullOldVersionRtIds.add(route.getLong("id"));
                        continue;
                    }
                    String routeNumber = route.getString("number");
                    int oldVersionOrderSeq = route.getInt("orderseq");
                    String versionname = route.getString("versionname");
                    routeversion = route.getLong("routeversion");
                    if (routeversion != null && !routeversion.equals(0L)) {
                        unVersionIdSet.add(routeversion);
                        initMsg.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u5df2\u5b58\u5728\u65b0\u7248\u672c\u53f7\u201c%2$s\u201d\uff0c\u672c\u6b21\u4e0d\u8fdb\u884c\u5904\u7406\u3002", (String)"RouteOldVersionInitBusiness_09", (String)"mmc-fmm-business", (Object[])new Object[0]), routeNumber, route.getString("routeversionname")));
                        continue;
                    }
                    DynamicObject ruleEntry = null;
                    ruleEntry = versionNameMap.get(String.valueOf(oldVersionOrderSeq));
                    if (ruleEntry == null) {
                        initMsg.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u7684\u65e7\u7248\u672c\u540d\u79f0\u201c%2$s\u201d\u65e0\u6cd5\u5728\u7248\u672c\u89c4\u5219\u201c%3$s\u201d\u4e2d\u627e\u5230\uff08\u987a\u5e8f\u53f7\u201c%4$s\u201d\u65e0\u6cd5\u5339\u914d\uff09\u3002", (String)"RouteOldVersionInitBusiness_01", (String)"mmc-fmm-business", (Object[])new Object[0]), routeNumber, versionname, versionRule.getString("number"), oldVersionOrderSeq));
                        continue;
                    }
                    String versionNumber = this.buildVersionNumber(ruleEntry, route, versionRule);
                    DynamicObject existsVersion = (DynamicObject)cacheMap.get(versionNumber);
                    if (existsVersion == null) {
                        existsVersion = this.getVersionData(ruleEntry, route, versionRule, orgId);
                    }
                    if (existsVersion == null) {
                        DynamicObject newVersion = this.buildVersionData(ruleEntry, route, versionRule, orgId);
                        Long newVersionId = newVersion.getLong("id");
                        newVersionList.add(newVersion);
                        updateParamList.add(new Object[]{newVersionId, route.getLong("id")});
                        ++newVersionDataSize;
                        unVersionIdSet.add(newVersionId);
                        cacheMap.put(versionNumber, newVersion);
                    } else {
                        this.setRuleMaxMinDate(existsVersion, this.getValidDate(route.getDate("effectivedate")), this.getInValidDate(route.getDate("expirationdate")));
                        updateParamList.add(new Object[]{existsVersion.getLong("id"), route.getLong("id")});
                        unVersionIdSet.add(existsVersion.getLong("id"));
                    }
                    this.saveDatas(newVersionList, updateParamList, 900);
                    routeIdSet.add(route.getLong("id"));
                    ++updateRtSize;
                }
                this.saveDatas(newVersionList, updateParamList, 0);
                Map<Long, DynamicObject> routeMap = this.buildRouteDynamicObjectMap(nullOldVersionRtIds);
                ArrayList<DynamicObject> saveRouteList = new ArrayList<DynamicObject>(900);
                for (DynamicObject route : routes) {
                    String routeNumber = route.getString("number");
                    Long oldVersionId = route.getLong("versionid");
                    if (oldVersionId != null && !oldVersionId.equals(0L)) continue;
                    routeversion = route.getLong("routeversion");
                    if (routeversion != null && !routeversion.equals(0L)) {
                        unVersionIdSet.add(routeversion);
                        initMsg.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u5df2\u5b58\u5728\u65b0\u7248\u672c\u53f7\u201c%2$s\u201d\uff0c\u672c\u6b21\u4e0d\u8fdb\u884c\u5904\u7406\u3002", (String)"RouteOldVersionInitBusiness_09", (String)"mmc-fmm-business", (Object[])new Object[0]), routeNumber, route.getString("routeversionname")));
                        continue;
                    }
                    DynamicObject routeDy = routeMap.get(route.getLong("id"));
                    DynamicObject newVersion = ProcessRouteVersionUtils.createAndGetRouteVersion((DynamicObject)routeDy, (boolean)true, unVersionIdSet);
                    unVersionIdSet.add(newVersion.getLong("id"));
                    routeDy.set("routeversion", (Object)newVersion);
                    ProcessRouteVersionUtils.syncOldVersion((DynamicObject)routeDy);
                    saveRouteList.add(routeDy);
                    ++newVersionDataSize;
                    this.saveDatas(saveRouteList, null, 900);
                    routeIdSet.add(route.getLong("id"));
                    ++updateRtSize;
                }
                this.saveDatas(saveRouteList, null, 0);
                String clearMsg = this.clearNotExistsVersionRouteDatas(routeIdSet);
                if (clearMsg != null && !clearMsg.equals("")) {
                    initMsg.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u7684\u65b0\u7248\u672c\u5728\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8fdb\u884c\u4e86\u6e05\u9664\u3002", (String)"RouteOldVersionInitBusiness_02", (String)"mmc-fmm-business", (Object[])new Object[0]), clearMsg));
                }
                initMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u65b0\u7248\u672c\u53f7\u6570\u636e\u91cf\uff1a%1$s \u6761\uff0c\u66f4\u65b0\u5de5\u827a\u8def\u7ebf\u6570\u636e\u91cf\uff1a%2$s\u6761\u3002", (String)"RouteOldVersionInitBusiness_06", (String)"mmc-fmm-business", (Object[])new Object[0]), newVersionDataSize, updateRtSize));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String msg = e.getMessage();
                initMsg.append(String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"RouteOldVersionInitBusiness_03", (String)"mmc-fmm-business", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"RouteOldVersionInitBusiness_03", (String)"mmc-fmm-business", (Object[])new Object[0]), msg));
            }
        }
        long enddate = System.currentTimeMillis() - startTime;
        String costText = String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%1$s \u6beb\u79d2\u3002", (String)"RouteOldVersionInitBusiness_07", (String)"mmc-fmm-business", (Object[])new Object[0]), enddate);
        String paramValueName = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u542f\u7528\u7cfb\u7edf\u53c2\u6570\u540e\u6267\u884c\u6570\u636e\u60c5\u51b5", (String)"RouteOldVersionInitBusiness_10", (String)"mmc-fmm-business", (Object[])new Object[0]), RouteOldVsersionInitUtils.getOrgName((Long)orgId));
        RouteOldVsersionInitUtils.setParamData((Long)orgId, (String)(orgId + "_openSysParam_" + this.getCurrentDates()), (String)paramValueName, (String)costText, (String)this.getSimpleMsgStr(initMsg), (String)initMsg.toString());
        RouteOldVsersionInitUtils.addEndTag((Long)orgId);
        return errorMsg.toString();
    }

    public String execByInit(Long orgId, String ruleid) {
        long startTime = System.currentTimeMillis();
        boolean hasRtData = RouteOldVsersionInitUtils.isExistsHisRt((Long)orgId, null);
        StringBuilder initMsg = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        if (hasRtData) {
            try {
                boolean isRouteVersionSysParam = ProcessRouteVersionUtils.isRouteVsersion((Long)orgId);
                if (isRouteVersionSysParam) {
                    RouteOldVsersionInitUtils.setBizAppParamData((Long)orgId, (String)KEY_ISOPENRTVERSION, (Object)false);
                    isRouteVersionSysParam = false;
                }
                if (!isRouteVersionSysParam && (isRouteVersionSysParam = this.checkRtIsMulVersion(orgId))) {
                    RouteOldVsersionInitUtils.setBizAppParamData((Long)orgId, (String)KEY_ISOPENRTVERSION, (Object)true);
                    initMsg.append(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u7248\u672c\u7684\u5386\u53f2\u5de5\u827a\u8def\u7ebf\u6570\u636e\uff0c\u81ea\u52a8\u8bbe\u7f6e\u7cfb\u7edf\u53c2\u4e3atrue\u3002", (String)"RouteOldVersionInitBusiness_05", (String)"mmc-fmm-business", (Object[])new Object[0]));
                }
                if (isRouteVersionSysParam) {
                    DynamicObject versionRule = this.getRtVersionRule(orgId, true, ruleid);
                    Map<String, DynamicObject> versionNameMap = this.genVersionNameMap(versionRule);
                    DynamicObjectCollection routes = this.getRouteData(orgId);
                    ArrayList<DynamicObject> newVersionList = new ArrayList<DynamicObject>(900);
                    ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(900);
                    HashSet<Long> routeIdSet = new HashSet<Long>(routes.size());
                    int newVersionDataSize = 0;
                    int updateRtSize = 0;
                    HashMap<String, DynamicObject> cacheMap = new HashMap<String, DynamicObject>(128);
                    for (DynamicObject route : routes) {
                        String routeNumber = route.getString("number");
                        int oldVersionOrderSeq = route.getInt("orderseq");
                        String versionname = route.getString("versionname");
                        Long routeversion = route.getLong("routeversion");
                        if (routeversion != null && !routeversion.equals(0L)) {
                            initMsg.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u5df2\u5b58\u5728\u65b0\u7248\u672c\u53f7\u201c%2$s\u201d\uff0c\u672c\u6b21\u4e0d\u8fdb\u884c\u5904\u7406\u3002", (String)"RouteOldVersionInitBusiness_09", (String)"mmc-fmm-business", (Object[])new Object[0]), routeNumber, route.getString("routeversionname")));
                            continue;
                        }
                        DynamicObject ruleEntry = versionNameMap.get(String.valueOf(oldVersionOrderSeq));
                        if (ruleEntry == null) {
                            initMsg.append(String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u7684\u65e7\u7248\u672c\u540d\u79f0\u201c%2$s\u201d\u65e0\u6cd5\u5728\u7248\u672c\u89c4\u5219\u201c%3$s\u201d\u4e2d\u627e\u5230\uff08\u987a\u5e8f\u53f7\u201c%4$s\u201d\u65e0\u6cd5\u5339\u914d\uff09\u3002", (String)"RouteOldVersionInitBusiness_01", (String)"mmc-fmm-business", (Object[])new Object[0]), routeNumber, versionname, versionRule.getString("number"), oldVersionOrderSeq));
                            continue;
                        }
                        String versionNumber = this.buildVersionNumber(ruleEntry, route, versionRule);
                        DynamicObject existsVersion = (DynamicObject)cacheMap.get(versionNumber);
                        if (existsVersion == null) {
                            existsVersion = this.getVersionData(ruleEntry, route, versionRule, orgId);
                        }
                        if (existsVersion == null) {
                            DynamicObject newVersion = this.buildVersionData(ruleEntry, route, versionRule, orgId);
                            Long newVersionId = newVersion.getLong("id");
                            newVersionList.add(newVersion);
                            updateParamList.add(new Object[]{newVersionId, route.getLong("id")});
                            ++newVersionDataSize;
                            cacheMap.put(versionNumber, newVersion);
                        } else {
                            this.setRuleMaxMinDate(existsVersion, this.getValidDate(route.getDate("effectivedate")), this.getInValidDate(route.getDate("expirationdate")));
                            updateParamList.add(new Object[]{existsVersion.getLong("id"), route.getLong("id")});
                        }
                        this.saveDatas(newVersionList, updateParamList, 900);
                        routeIdSet.add(route.getLong("id"));
                        ++updateRtSize;
                    }
                    this.saveDatas(newVersionList, updateParamList, 0);
                    String clearMsg = this.clearNotExistsVersionRouteDatas(routeIdSet);
                    if (clearMsg != null && !clearMsg.equals("")) {
                        initMsg.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5de5\u827a\u8def\u7ebf\u53f7\u201c%1$s\u201d\u7684\u65b0\u7248\u672c\u5728\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8fdb\u884c\u4e86\u6e05\u9664\u3002", (String)"RouteOldVersionInitBusiness_02", (String)"mmc-fmm-business", (Object[])new Object[0]), clearMsg));
                    }
                    initMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u65b0\u7248\u672c\u53f7\u6570\u636e\u91cf\uff1a%1$s \u6761\uff0c\u66f4\u65b0\u5de5\u827a\u8def\u7ebf\u6570\u636e\u91cf\uff1a%2$s\u6761\u3002", (String)"RouteOldVersionInitBusiness_06", (String)"mmc-fmm-business", (Object[])new Object[0]), newVersionDataSize, updateRtSize));
                    this.clearRouteCache(orgId);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String msg = e.getMessage();
                initMsg.append(String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"RouteOldVersionInitBusiness_03", (String)"mmc-fmm-business", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"RouteOldVersionInitBusiness_03", (String)"mmc-fmm-business", (Object[])new Object[0]), msg));
            }
        } else {
            RouteOldVsersionInitUtils.setBizAppParamData((Long)orgId, (String)KEY_ISOPENRTVERSION, (Object)false);
            initMsg.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5386\u53f2\u5de5\u827a\u8def\u7ebf\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u3002", (String)"RouteOldVersionInitBusiness_04", (String)"mmc-fmm-business", (Object[])new Object[0]));
        }
        RouteOldVsersionInitUtils.setEndInit((Long)orgId);
        long enddate = System.currentTimeMillis() - startTime;
        String costText = String.format(ResManager.loadKDString((String)"\u8017\u65f6\uff1a%1$s \u6beb\u79d2\u3002", (String)"RouteOldVersionInitBusiness_07", (String)"mmc-fmm-business", (Object[])new Object[0]), enddate);
        String paramValueName = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u521d\u59cb\u5316\u60c5\u51b5", (String)"RouteOldVersionInitBusiness_08", (String)"mmc-fmm-business", (Object[])new Object[0]), RouteOldVsersionInitUtils.getOrgName((Long)orgId));
        RouteOldVsersionInitUtils.setParamData((Long)orgId, (String)(orgId + "_initdesc"), (String)paramValueName, (String)costText, (String)this.getSimpleMsgStr(initMsg), (String)initMsg.toString());
        RouteOldVsersionInitUtils.addEndTag((Long)orgId);
        return errorMsg.toString();
    }

    public void setRuleMaxMinDate(DynamicObject existsVersion, Date beginDate, Date endDate) {
        Long versionId = existsVersion.getLong("id");
        Date versionBeginDate = existsVersion.getDate("effectdate");
        Date versionEndDate = existsVersion.getDate("invaliddate");
        Date newBeginDate = null;
        Date newEndDate = null;
        if (beginDate != null && beginDate.before(versionBeginDate)) {
            newBeginDate = beginDate;
        }
        if (endDate != null && endDate.after(versionEndDate)) {
            newEndDate = endDate;
        }
        if (newBeginDate != null || newEndDate != null) {
            if (newBeginDate == null) {
                newBeginDate = versionBeginDate;
            }
            if (newEndDate == null) {
                newEndDate = versionEndDate;
            }
            DB.execute((DBRoute)sysDBRoute, (String)UPDATEVERSIONDATESQL, (Object[])new Object[]{newBeginDate, newEndDate, versionId});
        }
    }

    public void clearRouteCache(Long orgId) {
        this.refreshBaseDataCache(ENTITY_ROUTE, orgId);
    }

    public void refreshBaseDataCache(String entityname, Long orgId) {
        String cacheType = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = entityname + orgId;
        BaseDataCtrlCacheMrg.clearCache((String)cacheType, (String)key);
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entityname, orgId);
    }

    private String getSimpleMsgStr(StringBuilder errorMsg) {
        if (errorMsg.length() > 250) {
            return errorMsg.substring(0, 250);
        }
        return errorMsg.toString();
    }

    private void saveDatas(List<DynamicObject> newVersionList, List<Object[]> updateParamList, int size) {
        if (newVersionList != null && newVersionList.size() > size) {
            SaveServiceHelper.save((DynamicObject[])newVersionList.toArray(new DynamicObject[newVersionList.size()]), (OperateOption)OperateOption.create());
            newVersionList.clear();
        }
        if (updateParamList != null && updateParamList.size() > size) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)UPDATERTSQL, updateParamList);
            updateParamList.clear();
        }
    }

    private String clearNotExistsVersionRouteDatas(Set<Long> rtIdSet) {
        if (rtIdSet == null || rtIdSet.isEmpty()) {
            return "";
        }
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(64);
        StringBuilder msg = new StringBuilder();
        QFilter qfilter = new QFilter("id", "in", rtIdSet);
        qfilter.and(new QFilter("routeversion", ">", (Object)0L));
        String selectFields = "id,number,routeversion,routeversion.number routeversionnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(RouteOldVersionInitBusiness.class.getName() + "_rt04"), (String)ENTITY_ROUTE, (String)selectFields, (QFilter[])new QFilter[]{qfilter}, (String)"").filter("routeversionnumber is null");){
            for (Row arow : ds) {
                msg.append(arow.getString("number")).append(" ");
                updateParamList.add(new Object[]{0L, arow.getLong("id")});
            }
        }
        if (!updateParamList.isEmpty()) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)UPDATERTSQL, updateParamList);
            return msg.toString();
        }
        return "";
    }

    private String getNum(String materialNumber, String materialGroupNumber) {
        if (materialNumber != null && !"".equals(materialNumber)) {
            return materialNumber + "-";
        }
        if (materialGroupNumber != null && !"".equals(materialGroupNumber)) {
            return materialGroupNumber + "-";
        }
        return "";
    }

    private DynamicObject getVersionData(DynamicObject ruleEntry, DynamicObject route, DynamicObject rule, Long orgId) {
        String number = this.buildVersionNumber(ruleEntry, route, rule);
        QFilter qfilter = new QFilter("type", "=", (Object)"B");
        qfilter.and(new QFilter("bomversionrule", "=", rule.getPkValue()));
        qfilter.and(new QFilter("number", "=", (Object)number));
        Long materialId = route.getLong("material");
        Long materialgroup = route.getLong("materialgroup");
        if (materialId != null && !materialId.equals(0L)) {
            qfilter.and(new QFilter("material", "=", (Object)materialId));
        } else if (materialgroup != null && !materialgroup.equals(0L)) {
            qfilter.and(new QFilter("materialgroup", "=", (Object)materialgroup));
        } else {
            qfilter.and(new QFilter("materialgroup", "=", (Object)0L));
            qfilter.and(new QFilter("material", "=", (Object)0L));
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)ENTITY_NEWVERSION, (String)"id,effectdate,invaliddate", (QFilter[])new QFilter[]{qfilter});
        return coll.isEmpty() ? null : (DynamicObject)coll.get(0);
    }

    private String buildVersionNumber(DynamicObject ruleEntry, DynamicObject route, DynamicObject rule) {
        String ruleNum = rule.getString("number");
        ILocaleString verName = ruleEntry.getLocaleString("version");
        String verNum = verName.getLocaleValue();
        String tag = "route";
        return this.getNum(route.getString("materialnumber"), route.getString("materialgroupnumber")) + ruleNum + "-" + tag + "-" + verNum;
    }

    private DynamicObject buildVersionData(DynamicObject ruleEntry, DynamicObject route, DynamicObject rule, Long orgId) {
        String version = ruleEntry.getString("version");
        DynamicObject bomversion = ORM.create().newDynamicObject(ENTITY_NEWVERSION);
        Long newId = ORM.create().genLongId(ENTITY_NEWVERSION);
        String number = this.buildVersionNumber(ruleEntry, route, rule);
        bomversion.set("number", (Object)number);
        bomversion.set("id", (Object)newId);
        bomversion.set("masterid", (Object)newId);
        bomversion.set("name", (Object)version);
        bomversion.set("type", (Object)"B");
        bomversion.set("versionname", (Object)ruleEntry);
        bomversion.set("bomversionrule", (Object)rule);
        bomversion.set("material", (Object)route.getLong("material"));
        bomversion.set("materialgroup", (Object)route.getLong("materialgroup"));
        bomversion.set("createorg", (Object)orgId);
        bomversion.set("effectdate", (Object)this.getValidDate(route.getDate("effectivedate")));
        bomversion.set("invaliddate", (Object)this.getInValidDate(route.getDate("expirationdate")));
        bomversion.set("ctrlstrategy", (Object)"5");
        bomversion.set("enable", (Object)"1");
        bomversion.set("status", (Object)"C");
        bomversion.set("ecnbillno", (Object)"");
        bomversion.set("srcbillid", (Object)route.getLong("id"));
        return bomversion;
    }

    public Date getValidDate(Date validdate) {
        return validdate == null ? new Date() : validdate;
    }

    public String getCurrentDates() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public Date getMaxDate() {
        Date maxDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            maxDate = sdf.parse("2999-12-31");
        }
        catch (ParseException e) {
            ErrorCode ec = new ErrorCode("getMaxDate", e.getMessage());
            throw new KDBizException(ec, new Object[0]);
        }
        return maxDate;
    }

    public Date getInValidDate(Date invaliddate) {
        Date maxDate = this.getMaxDate();
        if (invaliddate == null || invaliddate.after(maxDate)) {
            invaliddate = maxDate;
        }
        return invaliddate;
    }

    public boolean checkRtIsMulVersion(Long orgId) {
        boolean isExists = false;
        StringBuilder sb = new StringBuilder();
        sb.append(" select ");
        sb.append(" a.fprocesstype, a.fmaterialid ,a.fmaterialgroupid ");
        sb.append(" from t_pdm_route a ");
        sb.append(" where a.fcreateorgid  = ? and fversionid <> 0 ");
        sb.append(" group by a.fprocesstype,a.fmaterialid,a.fmaterialgroupid ");
        sb.append(" having count(distinct a.fversionid) > 1 ");
        try (DataSet ds = DB.queryDataSet((String)(RouteOldVersionInitBusiness.class.getName() + "_rt02"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])new Object[]{orgId}).top(1);){
            for (Row arow : ds) {
                isExists = true;
            }
        }
        return isExists;
    }

    public DynamicObjectCollection getRouteData(Long orgId) {
        QFilter qf = new QFilter("createorg", "=", (Object)orgId);
        return QueryServiceHelper.query((String)ENTITY_ROUTE, (String)this.getQueryRouteFields(), (QFilter[])new QFilter[]{qf});
    }

    public String getQueryRouteFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",version versionid");
        sb.append(",version.name versionname");
        sb.append(",version.effectivedate effectivedate");
        sb.append(",version.expirationdate expirationdate");
        sb.append(",version.orderseq orderseq");
        sb.append(",processtype");
        sb.append(",materialgroup");
        sb.append(",materialgroup.number materialgroupnumber");
        sb.append(",material");
        sb.append(",material.number materialnumber");
        sb.append(",routeversion");
        sb.append(",routeversion.name routeversionname");
        return sb.toString();
    }

    public Map<String, DynamicObject> genVersionNameMap(DynamicObject versionRule) {
        HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection coll = versionRule.getDynamicObjectCollection("entryentity");
        Set entryIdSet = coll.stream().map(p -> (Long)p.getPkValue()).collect(Collectors.toSet());
        if (!entryIdSet.isEmpty()) {
            DynamicObject[] datas;
            DynamicObject f7Data = BusinessDataServiceHelper.newDynamicObject((String)"bd_bomversionruleentry_f7");
            for (DynamicObject ruleEntry : datas = BusinessDataServiceHelper.load((Object[])entryIdSet.toArray(), (DynamicObjectType)f7Data.getDynamicObjectType())) {
                dataMap.put(ruleEntry.getString("entryseq"), ruleEntry);
            }
        }
        return dataMap;
    }

    public int getMaxVersionSeq() {
        int maxSeq = 0;
        String sql = "select max(forderseq) as fmaxseq from t_mpdm_processversion where forderseq > 0";
        try (DataSet ds = DB.queryDataSet((String)(RouteOldVersionInitBusiness.class.getName() + "_maxseq"), (DBRoute)scmDBRoute, (String)sql);){
            for (Row arow : ds) {
                maxSeq = arow.getInteger("fmaxseq");
            }
        }
        return maxSeq;
    }

    public DynamicObject getRtVersionRule(Long orgId, boolean isSave, String ruleid) {
        String ruleNumber = RouteOldVsersionInitUtils.getDefRuleNumber();
        QFilter qf = new QFilter("number", "=", (Object)ruleNumber);
        if (ruleid != null && !"".equals(ruleid) && !"0".equals(ruleid)) {
            qf = new QFilter("id", "=", (Object)Long.parseLong(ruleid));
        }
        ProcessRouteVersionUtils.updateProcessVersionSeq();
        int maxVersionSeq = this.getMaxVersionSeq();
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((String)ENTITY_RULE, (QFilter[])new QFilter[]{qf});
        if (versionRule == null) {
            versionRule = this.buildNewRule(orgId, ruleNumber);
            for (int i = 1; i <= maxVersionSeq; ++i) {
                String versionName = "V" + i + ".0";
                DynamicObject ruleEntry = versionRule.getDynamicObjectCollection("entryentity").addNew();
                ruleEntry.set("version", (Object)versionName);
                ruleEntry.set("seq", (Object)i);
            }
            if (isSave) {
                versionRule = this.saveNewRule(versionRule);
            }
        } else {
            DynamicObjectCollection coll = versionRule.getDynamicObjectCollection("entryentity");
            int size = coll.size();
            if (size < maxVersionSeq) {
                for (int i = size + 1; i <= maxVersionSeq; ++i) {
                    String versionName = "V" + i + ".0";
                    DynamicObject ruleEntry = coll.addNew();
                    ruleEntry.set("version", (Object)versionName);
                    ruleEntry.set("seq", (Object)i);
                }
                if (isSave) {
                    versionRule = this.saveNewRule(versionRule);
                }
            }
        }
        return versionRule;
    }

    private DynamicObject saveNewRule(DynamicObject newRule) {
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_RULE, (DynamicObject[])new DynamicObject[]{newRule}, (OperateOption)this.getOperateOption());
        if (!operateResult.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo info : operateResult.getAllErrorOrValidateInfo()) {
                sb.append(info.getMessage()).append('\n');
            }
            if (sb.length() <= 0) {
                sb.append(operateResult.getMessage());
            }
            ErrorCode ec = new ErrorCode("save", sb.toString());
            throw new KDBizException(ec, new Object[0]);
        }
        List ids = operateResult.getSuccessPkIds();
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_RULE, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    private DynamicObject buildNewRule(Long orgId, String ruleNumber) {
        DynamicObject rule = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_RULE);
        rule.set("number", (Object)ruleNumber);
        rule.set("name", (Object)RouteOldVsersionInitUtils.getDefRuleName());
        rule.set("createorg", (Object)orgId);
        rule.set("status", (Object)"C");
        rule.set("enable", (Object)"1");
        rule.set("ctrlstrategy", (Object)"5");
        rule.set("type", (Object)"B");
        rule.set("ischeckdate", (Object)false);
        rule.set("multype", (Object)",B,");
        rule.set("isdefaultroute", (Object)true);
        rule.set("isdefault", (Object)false);
        rule.set("isdefaultprograme", (Object)false);
        rule.set("creator", (Object)RequestContext.get().getCurrUserId());
        rule.set("createtime", (Object)new Date());
        return rule;
    }

    private Map<Long, DynamicObject> buildRouteDynamicObjectMap(Set<Long> idSet) {
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(128);
        if (!idSet.isEmpty()) {
            DynamicObject[] routes;
            String selectProperties = "id,number,routeversion,version,createorg,material,material.number,materialgroup,materialgroup.number,processtype";
            for (DynamicObject route : routes = BusinessDataServiceHelper.load((String)ENTITY_ROUTE, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
                dataMap.put(route.getLong("id"), route);
            }
        }
        return dataMap;
    }
}

