/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.business.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.route.RouteAfterAuditSyncDataBusiness;

public class RouteSyncCostUtils {
    public static void syncCost(DynamicObject[] objArray) {
        RouteSyncCostUtils.syncCost(objArray, "");
    }

    public static void syncCost(DynamicObject[] objArray, String ecnBillNo) {
        Long orgId;
        if (objArray == null || objArray.length <= 0) {
            return;
        }
        HashMap<Long, ArrayList<Long>> orgMap = new HashMap<Long, ArrayList<Long>>(16);
        HashMap<Long, String> orgNumberMap = new HashMap<Long, String>(16);
        for (int i = 0; i < objArray.length; ++i) {
            DynamicObject routeObj = objArray[i];
            if (!"pdm_route".equals(routeObj.getDynamicObjectType().getName())) continue;
            orgId = routeObj.getDynamicObject("createorg").getLong("id");
            ArrayList<Long> routeIdList = (ArrayList<Long>)orgMap.get(orgId);
            if (routeIdList == null) {
                routeIdList = new ArrayList<Long>(16);
            }
            routeIdList.add((Long)routeObj.getPkValue());
            String rtNumber = routeObj.getString("number");
            orgMap.put(orgId, routeIdList);
            String routeNumbers = (String)orgNumberMap.get(orgId);
            routeNumbers = routeNumbers == null ? rtNumber : routeNumbers + " " + rtNumber;
            orgNumberMap.put(orgId, routeNumbers);
        }
        ecnBillNo = RouteSyncCostUtils.getEcnBillNo(objArray, ecnBillNo);
        for (Map.Entry rts : orgMap.entrySet()) {
            orgId = (Long)rts.getKey();
            List rtIdList = (List)rts.getValue();
            if (rtIdList == null || rtIdList.isEmpty()) continue;
            RouteAfterAuditSyncDataBusiness business = new RouteAfterAuditSyncDataBusiness();
            business.syncData(orgId, rtIdList, ecnBillNo, (String)orgNumberMap.get(orgId));
        }
    }

    private static String getEcnBillNo(DynamicObject[] objArray, String ecnBillNo) {
        if (StringUtils.isEmpty((String)ecnBillNo)) {
            for (int i = 0; i < objArray.length; ++i) {
                DynamicObject routeObj = objArray[i];
                if (!"pdm_route".equals(routeObj.getDynamicObjectType().getName())) continue;
                DynamicObjectCollection coll = routeObj.getDynamicObjectCollection("processentry");
                for (DynamicObject entry : coll) {
                    String entryecnno = entry.getString("entryecnno");
                    if (StringUtils.isEmpty((String)entryecnno)) continue;
                    return entryecnno;
                }
            }
        }
        return ecnBillNo;
    }
}

