/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.event.project.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.event.project.AbstractProjectServiceEvent;

public class CreateProjectServiceEvent
extends AbstractProjectServiceEvent {
    @Override
    public Object handleEvent(KDBizEvent evt) {
        long eventId = (Long)super.handleEvent(evt);
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(8);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)this.ids), new QFilter("isbdproject", "=", (Object)Boolean.FALSE)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pmpd_project", (QFilter[])qFilters);
        dynamicObjectMap.forEach((id, obj) -> dataEntities.add((DynamicObject)obj));
        this.createSysProject(dataEntities);
        this.updateSyncFlag(dataEntities);
        return eventId;
    }

    protected void updateSyncFlag(List<DynamicObject> dataEntities) {
        for (DynamicObject project : dataEntities) {
            project.set("ispsync", (Object)Boolean.TRUE);
            project.set("sysproject", project.getPkValue());
        }
        SaveServiceHelper.saveOperate((String)"pmpd_project", (DynamicObject[])dataEntities.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    protected void createSysProject(List<DynamicObject> dataEntities) {
        for (DynamicObject project : dataEntities) {
            long pkValue = (Long)project.getPkValue();
            boolean exists = QueryServiceHelper.exists((String)"bd_project", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkValue)});
            DynamicObject sysProject = BusinessDataServiceHelper.newDynamicObject((String)"bd_project");
            if (exists) {
                sysProject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bd_project");
            }
            if (pkValue != 0L) {
                sysProject.set("id", (Object)pkValue);
            }
            sysProject.set("createorg", project.get("createorg"));
            sysProject.set("useorg", project.get("useorg"));
            sysProject.set("org", project.get("org"));
            sysProject.set("number", project.get("number"));
            sysProject.set("name", project.get("name"));
            sysProject.set("group", project.get("pjtype"));
            sysProject.set("planbegindate", project.get("planstartdate"));
            sysProject.set("planenddate", project.get("planfinshdate"));
            sysProject.set("parent", project.get("parent"));
            sysProject.set("ctrlstrategy", (Object)Character.valueOf('5'));
            sysProject.set("enable", (Object)Character.valueOf('1'));
            sysProject.set("systemtype", (Object)"pmc");
            if (exists) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sysProject});
                String status = sysProject.getString("status");
                if (StringUtils.equals((CharSequence)"A", (CharSequence)status)) {
                    this.executeOperate(OperationServiceHelper.executeOperate((String)"submit", (String)"bd_project", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create()));
                    this.executeOperate(OperationServiceHelper.executeOperate((String)"audit", (String)"bd_project", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create()));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"B", (CharSequence)status)) continue;
                this.executeOperate(OperationServiceHelper.executeOperate((String)"audit", (String)"bd_project", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create()));
                continue;
            }
            sysProject.set("status", (Object)"A");
            this.executeOperate(OperationServiceHelper.executeOperate((String)"save", (String)"bd_project", (DynamicObject[])new DynamicObject[]{sysProject}, (OperateOption)OperateOption.create()));
            this.executeOperate(OperationServiceHelper.executeOperate((String)"submit", (String)"bd_project", (Object[])new Object[]{sysProject.getPkValue()}, (OperateOption)OperateOption.create()));
            this.executeOperate(OperationServiceHelper.executeOperate((String)"audit", (String)"bd_project", (Object[])new Object[]{sysProject.getPkValue()}, (OperateOption)OperateOption.create()));
        }
    }

    protected void executeOperate(OperationResult operationResult) {
        String errorMsg = this.getErrorMsg(operationResult);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
    }

    protected String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        return errMsg.toString();
    }
}

