/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.event.project.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CreateTaskCodeServiceEvent
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent evt) {
        long eventId = evt.getEventId();
        String evtStr = SerializationUtils.toJsonString((Object)evt);
        if (StringUtils.isEmpty((CharSequence)evtStr)) {
            return eventId;
        }
        Map evtMap = (Map)SerializationUtils.fromJsonString((String)evtStr, HashMap.class);
        if (evtMap == null) {
            return eventId;
        }
        ArrayList ids = new ArrayList(8);
        List businesskeys = (List)evtMap.get("businesskeys");
        if (businesskeys == null) {
            return eventId;
        }
        businesskeys.forEach(id -> ids.add(Long.parseLong(id)));
        String entityNumber = (String)evtMap.get("entityNumber");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (dynamicObjectMap == null || dynamicObjectMap.isEmpty()) {
            return eventId;
        }
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(8);
        dynamicObjectMap.forEach((id, obj) -> dataEntities.add((DynamicObject)obj));
        this.createTaskCodeRule(dataEntities);
        return evt.getEventId();
    }

    private void createTaskCodeRule(List<DynamicObject> dataEntities) {
        ArrayList<DynamicObject> codes = new ArrayList<DynamicObject>(8);
        QFilter[] qs = new QFilter[1];
        for (DynamicObject data : dataEntities) {
            qs[0] = new QFilter("project.id", "=", data.get("masterid"));
            if (QueryServiceHelper.exists((String)"pmts_task_code", (QFilter[])qs)) continue;
            DynamicObject taskcode = BusinessDataServiceHelper.newDynamicObject((String)"pmts_task_code");
            if (data.get("jobcodepreincre") == null || data.getInt("jobcodepreincre") <= 0 || data.getString("jobcodeprefix").equals("") || data.get("jobcodeprefix") == null) continue;
            int step = data.getInt("jobcodepreincre");
            int steplength = String.valueOf(step).length() + 3;
            taskcode.set("number", (Object)data.getString("number"));
            taskcode.set("name", (Object)(data.getString("name") + "_" + data.getString("number")));
            taskcode.set("project", (Object)data);
            taskcode.set("taskstring", (Object)data.getString("jobcodeprefix"));
            taskcode.set("taskstep", (Object)step);
            taskcode.set("initdata", (Object)step);
            taskcode.set("positionnumber", (Object)steplength);
            taskcode.set("maxvalue", (Object)0);
            taskcode.set("status", (Object)"C");
            taskcode.set("enable", (Object)"1");
            taskcode.set("creator", (Object)data.getDynamicObject("auditor"));
            taskcode.set("createtime", (Object)data.getDate("auditdate"));
            codes.add(taskcode);
        }
        SaveServiceHelper.save((DynamicObject[])codes.toArray(new DynamicObject[codes.size()]));
    }
}

