/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.event.project.changeproject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.event.project.AbstractProjectServiceEvent;
import kd.pmc.event.project.changeproject.ProjectChangeFields;

public class ChangeProjectAuditServiceEvent
extends AbstractProjectServiceEvent {
    @Override
    public Object handleEvent(KDBizEvent evt) {
        long eventId = (Long)super.handleEvent(evt);
        DynamicObjectCollection changeProjects = QueryServiceHelper.query((String)"pmpd_changeproject", (String)"id,pnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.ids)});
        ArrayList projectNumbers = new ArrayList(8);
        changeProjects.forEach(changeProject -> projectNumbers.add(changeProject.getString("pnumber")));
        String selectFields = "id,number,name,expstartdate,expfinshdate,estperiod,planstartdate,planfinshdate,planperiod";
        DynamicObjectCollection projects = QueryServiceHelper.query((String)"pmpd_project", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", projectNumbers)});
        HashMap<Long, ProjectChangeFields> changeMap = new HashMap<Long, ProjectChangeFields>(8);
        projects.forEach(project -> {
            ProjectChangeFields projectChangeFields = new ProjectChangeFields();
            projectChangeFields.setNumber(project.getString("number"));
            projectChangeFields.setName(project.getString("name"));
            projectChangeFields.setPlanBeginDate(project.getDate("planstartdate"));
            projectChangeFields.setPlanEndDate(project.getDate("planfinshdate"));
            projectChangeFields.setPlanDays(project.getInt("planperiod"));
            projectChangeFields.setExpectBeginDate(project.getDate("expstartdate"));
            projectChangeFields.setExpectEndDate(project.getDate("expfinshdate"));
            projectChangeFields.setExpectDays(project.getInt("estperiod"));
            changeMap.put(project.getLong("id"), projectChangeFields);
        });
        this.updateProject(changeMap);
        this.updateWbs(changeMap);
        return eventId;
    }

    private void updateProject(Map<Long, ProjectChangeFields> changeMap) {
        DynamicObject[] projectObjs;
        QFilter qFilter = new QFilter("id", "in", changeMap.keySet());
        for (DynamicObject project : projectObjs = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,name,planbegindate,planenddate", (QFilter[])new QFilter[]{qFilter})) {
            ProjectChangeFields projectChangeFields = changeMap.get(project.getLong("id"));
            if (projectChangeFields == null) continue;
            project.set("name", (Object)projectChangeFields.getName());
            project.set("planbegindate", (Object)projectChangeFields.getPlanBeginDate());
            project.set("planenddate", (Object)projectChangeFields.getPlanEndDate());
        }
        SaveServiceHelper.save((DynamicObject[])projectObjs);
    }

    private void updateWbs(Map<Long, ProjectChangeFields> changeMap) {
        DynamicObject[] wbsObjs;
        QFilter qFilter = new QFilter("projectnum", "in", changeMap.keySet());
        String selectProperties = "id,projectnum,number,name,estimatedstartdate,estimatedenddate,estimateddays,planstartdate,planenddate,plandays";
        for (DynamicObject wbs : wbsObjs = BusinessDataServiceHelper.load((String)"pmts_wbs", (String)selectProperties, (QFilter[])new QFilter[]{qFilter})) {
            ProjectChangeFields projectChangeFields = changeMap.get(wbs.getLong("projectnum_id"));
            if (projectChangeFields == null) continue;
            wbs.set("estimatedstartdate", (Object)projectChangeFields.getExpectBeginDate());
            wbs.set("estimatedenddate", (Object)projectChangeFields.getExpectEndDate());
            wbs.set("estimateddays", (Object)projectChangeFields.getExpectDays());
            wbs.set("planstartdate", (Object)projectChangeFields.getPlanBeginDate());
            wbs.set("planenddate", (Object)projectChangeFields.getPlanEndDate());
            wbs.set("plandays", (Object)projectChangeFields.getPlanDays());
        }
        SaveServiceHelper.save((DynamicObject[])wbsObjs);
    }
}

