/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.event.project.save;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.event.project.AbstractProjectServiceEvent;

public class BackWriteSourcePlanEvent
extends AbstractProjectServiceEvent {
    @Override
    public Object handleEvent(KDBizEvent evt) {
        long eventId = (Long)super.handleEvent(evt);
        EntityEvent event = (EntityEvent)evt;
        String operation = event.getOperation();
        Map<String, Set<Long>> relationMap = this.getRelations();
        this.backWriteReourcePlanProjects(relationMap, operation);
        return eventId;
    }

    private void backWriteReourcePlanProjects(Map<String, Set<Long>> relationMap, String operation) {
        if (relationMap.isEmpty()) {
            return;
        }
        Map<Object, DynamicObject> projectCache = this.getProjectCache();
        boolean isUnaudit = StringUtils.equals((CharSequence)"unaudit", (CharSequence)operation);
        Map<Object, Set<Object>> projectId2ContractIds = null;
        if (isUnaudit) {
            projectId2ContractIds = this.getProjectId2ContractIds(projectCache);
        }
        String selectFields = "id, billno,entry_project.seq, projcet, isreversewriting, entry_project.entry_contract.seq, contractid, contractno, contractname";
        QFilter qFilter = new QFilter("billno", "in", relationMap.keySet());
        Object[] resourcePlans = BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])resourcePlans)) {
            return;
        }
        for (Object plan : resourcePlans) {
            String billno = plan.getString("billno");
            Set<Long> projectIds = relationMap.get(billno);
            if (projectIds == null) continue;
            ArrayList deleteEntry = new ArrayList(8);
            HashSet existsProjectIds = new HashSet();
            DynamicObjectCollection entry_project = plan.getDynamicObjectCollection("entry_project");
            entry_project.forEach(entry -> {
                long projcet_id = (Long)entry.get("projcet_id");
                if (projectIds.contains(projcet_id)) {
                    existsProjectIds.add(projcet_id);
                    deleteEntry.add(entry);
                }
            });
            if (StringUtils.equals((CharSequence)"audit", (CharSequence)operation)) {
                projectIds.forEach(projectId -> {
                    if (!existsProjectIds.contains(projectId)) {
                        DynamicObject newEntry = entry_project.addNew();
                        newEntry.set("projcet_id", projectId);
                        newEntry.set("isreversewriting", (Object)Boolean.TRUE);
                    }
                });
                this.writeBackContract(projectCache, entry_project, projectIds);
                continue;
            }
            if (!isUnaudit) continue;
            entry_project.removeAll(deleteEntry);
            this.revertContract(projectId2ContractIds, entry_project);
        }
        SaveServiceHelper.save((DynamicObject[])resourcePlans);
    }

    private void revertContract(Map<Object, Set<Object>> projectId2ContractIds, DynamicObjectCollection projectCollection) {
        for (DynamicObject project : projectCollection) {
            Object projectId = project.get("projcet_id");
            Set<Object> contractIds = projectId2ContractIds.get(projectId);
            if (contractIds == null) continue;
            DynamicObjectCollection contractCollection = project.getDynamicObjectCollection("entry_contract");
            Iterator iterator = contractCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject contract = (DynamicObject)iterator.next();
                Object contractId = contract.get("contractid");
                if (!contractIds.contains(contractId)) continue;
                iterator.remove();
            }
        }
    }

    private Map<Object, Set<Object>> getProjectId2ContractIds(Map<Object, DynamicObject> projectCache) {
        HashMap<Object, Set<Object>> projectId2ContractIds = new HashMap<Object, Set<Object>>(projectCache.size());
        for (Map.Entry<Object, DynamicObject> entry : projectCache.entrySet()) {
            Object projectId = entry.getKey();
            DynamicObjectCollection collection = entry.getValue().getDynamicObjectCollection("entryentity");
            for (DynamicObject contractEntry : collection) {
                Object contractId = contractEntry.get("saleconstract");
                Set contractIds = projectId2ContractIds.computeIfAbsent(projectId, k -> new HashSet(16));
                contractIds.add(contractId);
            }
        }
        return projectId2ContractIds;
    }

    private void writeBackContract(Map<Object, DynamicObject> projectCache, DynamicObjectCollection projectCollection, Set<Long> projectIds) {
        for (DynamicObject project : projectCollection) {
            DynamicObject modifiedProject;
            Long projectId = project.getLong("projcet_id");
            if (!projectIds.contains(projectId) || (modifiedProject = projectCache.get(projectId)) == null) continue;
            DynamicObjectCollection contractCollection = project.getDynamicObjectCollection("entry_contract");
            int seq = contractCollection.size();
            DynamicObjectCollection collection = modifiedProject.getDynamicObjectCollection("entryentity");
            for (DynamicObject contractEntry : collection) {
                long contractId = contractEntry.getLong("saleconstract");
                DynamicObject contract = contractCollection.addNew();
                contract.set("seq", (Object)(++seq));
                contract.set("contractid", (Object)contractId);
                contract.set("contractno", contractEntry.get("saleconstractno"));
                contract.set("contractname", contractEntry.get("saleconstractname"));
            }
        }
    }

    private Map<Object, DynamicObject> getProjectCache() {
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add("entryentity.saleconstract");
        selectFields.add("entryentity.saleconstractno");
        selectFields.add("entryentity.saleconstractname");
        return BusinessDataServiceHelper.loadFromCache((Object[])this.ids.toArray(), (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"pmpd_project", selectFields));
    }

    private Map<String, Set<Long>> getRelations() {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)this.ids), new QFilter("entryentity1.sourcebilltype.number", "=", (Object)"pmpd_resourceplan")};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pmpd_project", (QFilter[])qFilters);
        HashMap<String, Set<Long>> relationMap = new HashMap<String, Set<Long>>(8);
        dynamicObjectMap.values().forEach(dynamicObject -> {
            DynamicObject entry;
            String soucebillno;
            long pkValue = (Long)dynamicObject.getPkValue();
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity1");
            if (entryentity != null && entryentity.size() > 0 && StringUtils.isNotBlank((CharSequence)(soucebillno = (String)(entry = (DynamicObject)entryentity.get(0)).get("sourcebillno")))) {
                HashSet<Long> projectSet = (HashSet<Long>)relationMap.get(soucebillno);
                if (projectSet == null) {
                    projectSet = new HashSet<Long>(8);
                }
                projectSet.add(pkValue);
                relationMap.put(soucebillno, projectSet);
            }
        });
        return relationMap;
    }
}

