/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.business.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.pmc.pmpd.business.project.ProjectCoderuleImplHelper;

public class ProjectCoderuleImpl {
    private static Set<Character> EXCLUDE_CODE_CHAR = new HashSet<Character>(2);
    private static Map<Integer, Character> CODE_CHAR_MAP = new HashMap<Integer, Character>(23);
    private static int CODELENGTH = 7;
    private static int CODESIZE = 10;

    public static String getCode(boolean isspecial) {
        String lastCode = ProjectCoderuleImplHelper.getLastNumber(isspecial);
        if (lastCode == null) {
            if (isspecial) {
                lastCode = ProjectCoderuleImpl.getFirstCode();
                lastCode = "S" + lastCode;
            } else {
                lastCode = ProjectCoderuleImpl.getFirstCode();
            }
        } else {
            boolean codeStandardBool = ProjectCoderuleImpl.isCodeStandard(lastCode, isspecial);
            if (codeStandardBool) {
                if (ProjectCoderuleImplHelper.isExistNumber(lastCode = ProjectCoderuleImpl.getNextCode(lastCode))) {
                    lastCode = ProjectCoderuleImpl.getAvailableCode();
                }
            } else {
                lastCode = ProjectCoderuleImpl.getAvailableCode();
            }
        }
        return lastCode;
    }

    public static String getAvailableCode() {
        ArrayList<String> codes = new ArrayList<String>(CODESIZE);
        codes.add(ProjectCoderuleImpl.getFirstCode());
        for (int i = 0; i < CODESIZE - 1; ++i) {
            codes.add(ProjectCoderuleImpl.getNextCode((String)codes.get(i)));
        }
        Set<String> numberSet = ProjectCoderuleImplHelper.getExistNumber(codes);
        for (int i = 0; i < codes.size(); ++i) {
            if (numberSet.contains(codes.get(i))) continue;
            return (String)codes.get(i);
        }
        return ProjectCoderuleImpl.getAvailableCode((String)codes.get(codes.size() - 1));
    }

    public static String getAvailableCode(String code) {
        ArrayList<String> codes = new ArrayList<String>(code.length());
        codes.add(ProjectCoderuleImpl.getNextCode(code));
        for (int i = 0; i < code.length(); ++i) {
            codes.add(ProjectCoderuleImpl.getNextCode((String)codes.get(i)));
        }
        Set<String> numberSet = ProjectCoderuleImplHelper.getExistNumber(codes);
        for (int i = 0; i < codes.size(); ++i) {
            if (numberSet.contains(codes.get(i))) continue;
            return (String)codes.get(i);
        }
        return ProjectCoderuleImpl.getAvailableCode((String)codes.get(codes.size() - 1));
    }

    public static String getNextCode(String lastCode) {
        StringBuilder sb = new StringBuilder();
        char lastChar = lastCode.substring(lastCode.length() - 1).charAt(0);
        Character nextChar = ProjectCoderuleImpl.getNextChar(lastChar);
        if (nextChar == null) {
            lastChar = lastCode.substring(lastCode.length() - 2, lastCode.length() - 1).charAt(0);
            nextChar = ProjectCoderuleImpl.getNextChar(lastChar);
            if (nextChar == null) {
                lastChar = lastCode.substring(lastCode.length() - 3, lastCode.length() - 2).charAt(0);
                nextChar = ProjectCoderuleImpl.getNextChar(lastChar);
                if (nextChar == null) {
                    return null;
                }
                sb.append(lastCode.substring(0, lastCode.length() - 3));
                sb.append(nextChar);
                sb.append(CODE_CHAR_MAP.get(0));
                sb.append(CODE_CHAR_MAP.get(0));
            } else {
                sb.append(lastCode.substring(0, lastCode.length() - 2));
                sb.append(nextChar);
                sb.append(CODE_CHAR_MAP.get(0));
            }
        } else {
            sb.append(lastCode.substring(0, lastCode.length() - 1));
            sb.append(nextChar);
        }
        return sb.toString();
    }

    public static Character getNextChar(char lastChar) {
        int index = ProjectCoderuleImpl.getCodeCharIndex(lastChar);
        if (index - EXCLUDE_CODE_CHAR.size() != CODE_CHAR_MAP.size() - 1) {
            try {
                char nextChar = CODE_CHAR_MAP.get(index + 1).charValue();
                return Character.valueOf(nextChar);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static int getCodeCharIndex(char lastChar) {
        for (Map.Entry<Integer, Character> codeCharEntry : CODE_CHAR_MAP.entrySet()) {
            if (!codeCharEntry.getValue().equals(Character.valueOf(lastChar))) continue;
            return codeCharEntry.getKey();
        }
        return 0;
    }

    public static String getFirstCode() {
        StringBuilder sb = new StringBuilder();
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        sb.append(year);
        sb.append(CODE_CHAR_MAP.get(0));
        sb.append(CODE_CHAR_MAP.get(0));
        sb.append(CODE_CHAR_MAP.get(0));
        return sb.toString();
    }

    public static boolean isCodeStandard(String code, boolean bool) {
        if (code.length() != CODELENGTH && !bool || code.length() != CODELENGTH + 1 && bool) {
            return false;
        }
        if (!code.matches("^\\d{4}[A-Z]{3}$") && !bool) {
            return false;
        }
        if (!code.matches("^S\\d{4}[A-Z]{3}$") && bool) {
            return false;
        }
        for (Character excludeCode : EXCLUDE_CODE_CHAR) {
            if (!code.contains(excludeCode.toString())) continue;
            return false;
        }
        return true;
    }

    static {
        EXCLUDE_CODE_CHAR.add(Character.valueOf('I'));
        EXCLUDE_CODE_CHAR.add(Character.valueOf('O'));
        char firstNumber = 'A';
        int size = 0;
        for (int i = 0; i < 26; ++i) {
            if (!EXCLUDE_CODE_CHAR.contains(Character.valueOf(firstNumber))) {
                CODE_CHAR_MAP.put(size, Character.valueOf(firstNumber));
                ++size;
            }
            firstNumber = (char)(firstNumber + '\u0001');
        }
    }
}

