/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLogModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.DragPmtsTaskHelper;
import kd.pmc.pmts.common.util.DateUtil;

public class AdjustPmtsTaskHelper {
    public static String updateData(GanttCommandContext ctx, GanttLogModel ganttLogModel) {
        long oldendTime;
        String args = ctx.geteArgs();
        JSONObject jsonobj = JSON.parseObject((String)args);
        GanttTaskModel taskModel = (GanttTaskModel)JSON.parseObject((String)jsonobj.getString("item"), GanttTaskModel.class);
        String taskId = taskModel.getObjId();
        String starttimeToField = taskModel.getStarttimeToField();
        String endtimeToField = taskModel.getEndtimeToField();
        Long startTime = taskModel.getStartDate();
        Long endTime = taskModel.getEndDate();
        ListView view = (ListView)ctx.getView();
        String metaKey = view.getListModel().getEntityId();
        long mainId = Long.parseLong(taskId);
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)mainId, (String)metaKey);
        String number = GanttCommandUtils.getBillNo((DynamicObject)dynObj);
        ganttLogModel.setBusinessObj(taskModel.getMetaKey());
        ganttLogModel.setBillNo(number);
        ganttLogModel.setName(ResManager.loadKDString((String)"\u5de6\u53f3\u62c9\u52a8", (String)"AdjustPmtsTaskHelper_0", (String)"mmc-fmm-business", (Object[])new Object[0]));
        String verifyResult = GanttCommandUtils.verifyTime((GanttCommandContext)ctx, (long)startTime, (long)endTime);
        if (StringUtils.isNotBlank((CharSequence)verifyResult)) {
            return verifyResult;
        }
        StringBuilder beforeContent = new StringBuilder(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"AdjustPmtsTaskHelper_1", (String)"mmc-fmm-business", (Object[])new Object[0]));
        StringBuilder afterContent = new StringBuilder(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"AdjustPmtsTaskHelper_1", (String)"mmc-fmm-business", (Object[])new Object[0]));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        Date beforeStartTime = dynObj.getDate(starttimeToField);
        beforeContent.append(Objects.isNull(beforeStartTime) ? "_" : sdf.format(beforeStartTime));
        beforeContent.append(String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"AdjustPmtsTaskHelper_2", (String)"mmc-fmm-business", (Object[])new Object[0]), ", "));
        Date beforeEndTime = dynObj.getDate(endtimeToField);
        beforeContent.append(Objects.isNull(beforeEndTime) ? "_" : sdf.format(beforeEndTime));
        long oldstartTime = dynObj.getDate("planstartdate") == null ? 0L : dynObj.getDate("planstartdate").getTime();
        long l = oldendTime = dynObj.getDate("planenddate") == null ? 0L : dynObj.getDate("planenddate").getTime();
        if (GanttCrossObjectEnum.TASK.getValue().equals(taskModel.getCrossObj()) && GanttCrossTypeEnum.PERCENT.getValue().equals(taskModel.getCrossType())) {
            AdjustPmtsTaskHelper.setPercentValueByAdjust(dynObj, taskModel);
            return null;
        }
        if (!taskModel.isSubcross()) {
            dynObj.set(starttimeToField, (Object)new Timestamp(startTime));
            dynObj.set(endtimeToField, (Object)new Timestamp(endTime));
        } else {
            DynamicObjectCollection subsectionentry = dynObj.getDynamicObjectCollection("subsectionentry");
            for (DynamicObject object : subsectionentry) {
                if (StringUtils.equals((CharSequence)object.getString("id"), (CharSequence)taskModel.getTaskSubEntryId()) || !taskModel.isRightLine() || taskModel.isLeftLine() || object.getDate("subsubplanenddate").getTime() <= taskModel.getStartDate()) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e24\u4e2a\u5206\u6bb5\u6a2a\u9053\u4e0d\u53ef\u91cd\u53e0\u3002", (String)"AdjustPmtsTaskHelper_3", (String)"mmc-fmm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection dynamicObjects = dynObj.getDynamicObjectCollection("subsectionentry");
            if (!dynamicObjects.isEmpty()) {
                DynamicObject lastSubCross = (DynamicObject)subsectionentry.get(subsectionentry.size() - 1);
                lastSubCross.set("subplanstartdate", (Object)new Timestamp(startTime));
                lastSubCross.set("subsubplanenddate", (Object)new Timestamp(endTime));
            }
        }
        afterContent.append(sdf.format(new Date(startTime)));
        afterContent.append(String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"AdjustPmtsTaskHelper_2", (String)"mmc-fmm-business", (Object[])new Object[0]), ", "));
        afterContent.append(sdf.format(new Date(endTime)));
        ganttLogModel.setBeforeContent(beforeContent.toString());
        ganttLogModel.setAfterContent(afterContent.toString());
        DragPmtsTaskHelper.toUpdateDelayed(dynObj, taskModel, ctx, oldstartTime, oldendTime);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
        return null;
    }

    private static void setPercentValueByAdjust(DynamicObject dynObj, GanttTaskModel taskModel) {
        BigDecimal actual = new BigDecimal(taskModel.getEndDate() - taskModel.getStartDate());
        Double seconds = 0.0;
        BigDecimal plantime = dynObj.getBigDecimal("plantime");
        DynamicObject timeunit = dynObj.getDynamicObject("durationunit");
        if (StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"40") && plantime != null) {
            seconds = plantime.doubleValue() * 60.0 * 60.0 * 1000.0;
        } else if (StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"30") && plantime != null) {
            seconds = plantime.doubleValue() * 24.0 * 60.0 * 60.0 * 1000.0;
        }
        BigDecimal plan = BigDecimal.valueOf(seconds);
        seconds = seconds / 1000.0;
        BigDecimal result = actual.divide(plan, 4, 4);
        if (result.compareTo(BigDecimal.ONE) < 0) {
            dynObj.set("finishpercent", (Object)result.multiply(new BigDecimal(100)));
            dynObj.set("actualdate", (Object)DateUtil.addSecond((Date)dynObj.getDate("actualstartdate"), (long)((long)(seconds * result.doubleValue()))));
        } else {
            Long timestamp = seconds.longValue() * 99L / 100L;
            dynObj.set("finishpercent", (Object)99);
            dynObj.set("actualdate", (Object)DateUtil.addSecond((Date)dynObj.getDate("actualstartdate"), (long)timestamp));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }
}

