/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLogModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttCommandUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.business.helper.TaskSaveStageServiceHelper;
import kd.pmc.pmts.common.util.DateUtil;
import kd.pmc.pmts.common.util.FiledSetUtil;

public class DragPmtsTaskHelper {
    private static String ITEM = "item";
    private static String TARGETGANTTTYPE = "targetGanttType";
    private static String TARGETGROUPID = "targetGroupId";
    public static final Integer MAX_ORDERNO = 0;

    private static String getTaskUpEntityNumber(DynamicObject mGanttSourceObj, String taskEntityIds, String dataModeType) {
        DynamicObjectCollection col = mGanttSourceObj.getDynamicObjectCollection("entityselect");
        for (DynamicObject dynamicObject : col) {
            String viewStr = Long.toString(dynamicObject.getLong("id"));
            if (!StringUtils.equals((CharSequence)dataModeType, (CharSequence)viewStr)) continue;
            DynamicObjectCollection relationColl = dynamicObject.getDynamicObjectCollection("entityrelation");
            for (DynamicObject relation : relationColl) {
                String relationNumber = relation.getString("rentity.number");
                if (!StringUtils.equals((CharSequence)relationNumber, (CharSequence)taskEntityIds)) continue;
                return relation.getString("ruplevelentity.number");
            }
        }
        return null;
    }

    public static String updateTaskData(GanttCommandContext ctx, GanttLogModel ganttLogModel) {
        DynamicObject up;
        String args = ctx.geteArgs();
        JSONObject jsonObj = JSON.parseObject((String)args);
        GanttTaskModel taskModel = (GanttTaskModel)JSON.parseObject((String)jsonObj.getString(ITEM), GanttTaskModel.class);
        String targetGroupId = jsonObj.getString(TARGETGROUPID);
        String targetEntityFlag = jsonObj.getString("targetEntityFlag");
        String groupToField = null;
        String starttimeToField = taskModel.getStarttimeToField();
        String endtimeToField = taskModel.getEndtimeToField();
        ListView view = (ListView)ctx.getView();
        String metaKey = view.getListModel().getEntityId();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(taskModel.getObjId()), (String)metaKey);
        if (taskModel.isSubcross()) {
            DynamicObjectCollection subsectionentry = dynObj.getDynamicObjectCollection("subsectionentry");
            for (DynamicObject object : subsectionentry) {
                if (StringUtils.equals((CharSequence)object.getString("id"), (CharSequence)taskModel.getTaskSubEntryId()) || !taskModel.isRightLine() || taskModel.isLeftLine() || object.getDate("subsubplanenddate").getTime() <= taskModel.getStartDate()) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e24\u4e2a\u5206\u6bb5\u6a2a\u9053\u4e0d\u53ef\u91cd\u53e0\u3002", (String)"DragPmtsTaskHelper_1", (String)"mmc-fmm-business", (Object[])new Object[0]));
            }
        }
        String number = GanttCommandUtils.getBillNo((DynamicObject)dynObj);
        ganttLogModel.setBusinessObj(taskModel.getMetaKey());
        ganttLogModel.setBillNo(number);
        List planDataList = (List)GanttBigObjectCache.get((String)ctx.getView().getPageId(), (String)"dataList");
        String requestId = ctx.getPageCache().get("requestId");
        String taskEntityIds = ctx.getPageCache().get("taskEntityIds");
        String groupId = targetGroupId;
        String taskObjId = groupId.substring(requestId.length());
        DynamicObject targetDynObj = null;
        groupId = taskObjId;
        if (jsonObj.getString(TARGETGANTTTYPE).equals("pageData")) {
            groupId = GanttCommandUtils.getFirstResourceId((List)planDataList, (String)taskEntityIds, (String)groupId);
            if (StringUtils.equals((CharSequence)targetEntityFlag, (CharSequence)"pmts_task")) {
                targetDynObj = BusinessDataServiceHelper.loadSingle((Object)taskObjId, (String)metaKey);
            }
        }
        DynamicObject groupObj = null;
        if (StringUtils.equals((CharSequence)targetEntityFlag, (CharSequence)"pmts_task")) {
            DynamicObject mGanttSourceObj = (DynamicObject)GanttBigObjectCache.get((String)ctx.getView().getPageId(), (String)"datasource");
            String currentEntity = ctx.getPageCache().get("viewSchemEntity");
            String taskUpEntityNumber = DragPmtsTaskHelper.getTaskUpEntityNumber(mGanttSourceObj, taskEntityIds, currentEntity);
            if (targetDynObj != null) {
                if (targetDynObj.get("wbs") == null) {
                    taskUpEntityNumber = "pmpd_project";
                    groupToField = "projectnum";
                } else {
                    groupToField = "wbs";
                }
            }
            String queryField = GanttCommandUtils.getQueryField((String)taskUpEntityNumber);
            if (StringUtils.isNotBlank((CharSequence)groupId) && !StringUtils.equals((CharSequence)groupId, (CharSequence)"0")) {
                groupObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(groupId), (String)taskUpEntityNumber, (String)queryField);
            }
        } else if (StringUtils.isNotBlank((CharSequence)targetEntityFlag)) {
            String queryField = GanttCommandUtils.getQueryField((String)targetEntityFlag);
            groupObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(groupId), (String)targetEntityFlag, (String)queryField);
            groupToField = StringUtils.equals((CharSequence)targetEntityFlag, (CharSequence)"pmts_wbs") ? "wbs" : "projectnum";
        }
        StringBuilder beforeContent = new StringBuilder(ResManager.loadKDString((String)"\u6240\u5c5e\u8d44\u6e90\u540d\u79f0\uff1a", (String)"DragPmtsTaskHelper_2", (String)"mmc-fmm-business", (Object[])new Object[0]));
        StringBuilder afterContent = new StringBuilder(ResManager.loadKDString((String)"\u6240\u5c5e\u8d44\u6e90\u540d\u79f0\uff1a", (String)"DragPmtsTaskHelper_2", (String)"mmc-fmm-business", (Object[])new Object[0]));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        String cammandName = "";
        DynamicObject dynamicObject = up = StringUtils.isNotBlank((CharSequence)groupToField) ? dynObj.getDynamicObject(groupToField) : null;
        if (up == null || DragPmtsTaskHelper.getIdJundeNull(groupObj) == DragPmtsTaskHelper.getIdJundeNull(up)) {
            beforeContent.setLength(0);
            beforeContent.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragPmtsTaskHelper_3", (String)"mmc-fmm-business", (Object[])new Object[0]));
            afterContent.setLength(0);
            afterContent.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragPmtsTaskHelper_3", (String)"mmc-fmm-business", (Object[])new Object[0]));
            cammandName = ResManager.loadKDString((String)"\u5de6\u53f3\u79fb\u52a8", (String)"DragPmtsTaskHelper_4", (String)"mmc-fmm-business", (Object[])new Object[0]);
        } else {
            beforeContent.append(up == null ? " " : GanttCommandUtils.getBillName((DynamicObject)up));
            beforeContent.append(String.format(ResManager.loadKDString((String)"%s\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragPmtsTaskHelper_5", (String)"mmc-fmm-business", (Object[])new Object[0]), ", "));
            afterContent.append(groupObj == null ? " " : GanttCommandUtils.getBillName((DynamicObject)groupObj));
            afterContent.append(String.format(ResManager.loadKDString((String)"%s\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DragPmtsTaskHelper_5", (String)"mmc-fmm-business", (Object[])new Object[0]), ", "));
            cammandName = ResManager.loadKDString((String)"\u4e0a\u4e0b\u79fb\u52a8", (String)"DragPmtsTaskHelper_6", (String)"mmc-fmm-business", (Object[])new Object[0]);
        }
        Date beforeStartTime = dynObj.getDate(starttimeToField);
        beforeContent.append(Objects.isNull(beforeStartTime) ? "_" : sdf.format(beforeStartTime));
        beforeContent.append(String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"DragPmtsTaskHelper_7", (String)"mmc-fmm-business", (Object[])new Object[0]), ", "));
        Date beforeEndTime = dynObj.getDate(endtimeToField);
        beforeContent.append(Objects.isNull(beforeEndTime) ? "_" : sdf.format(beforeEndTime));
        DynamicObject dynObjWbs = dynObj.getDynamicObject("wbs");
        if (StringUtils.equals((CharSequence)groupToField, (CharSequence)"projectnum")) {
            dynObj.set("wbs", null);
        } else if (StringUtils.isNotBlank((CharSequence)groupToField)) {
            dynObj.set(groupToField, (Object)groupId);
        }
        DynamicObject[] saveObjects = null;
        if (StringUtils.isNotBlank((CharSequence)groupToField)) {
            if (targetDynObj != null) {
                int targetOrderno = targetDynObj.getInt("orderno");
                int orderno = dynObj.getInt("orderno");
                DynamicObject targetDynObjWbs = targetDynObj.getDynamicObject("wbs");
                if (dynObjWbs != null && targetDynObjWbs != null) {
                    if (dynObjWbs.getString("id").equals(targetDynObjWbs.getString("id"))) {
                        DragPmtsTaskHelper.setOrdrNo(targetOrderno, orderno, dynObjWbs, targetDynObj, dynObj, ctx);
                    } else {
                        DragPmtsTaskHelper.updateOrderNoByGroup(targetOrderno, DragPmtsTaskHelper.getProjectId(ctx), targetDynObjWbs.getLong("id"), targetDynObj.getLong("id"), dynObj);
                    }
                } else if (dynObjWbs != null && targetDynObjWbs == null) {
                    DragPmtsTaskHelper.updateOrderNoByGroup(targetOrderno, DragPmtsTaskHelper.getProjectId(ctx), null, targetDynObj.getLong("id"), dynObj);
                } else if (dynObjWbs == null && targetDynObjWbs != null) {
                    DragPmtsTaskHelper.updateOrderNoByGroup(targetOrderno, DragPmtsTaskHelper.getProjectId(ctx), targetDynObjWbs.getLong("id"), targetDynObj.getLong("id"), dynObj);
                } else if (dynObjWbs == null && targetDynObjWbs == null) {
                    DragPmtsTaskHelper.setOrdrNo(targetOrderno, orderno, null, targetDynObj, dynObj, ctx);
                }
                saveObjects = new DynamicObject[]{dynObj, targetDynObj};
            } else {
                List<QFilter> qFilterList = null;
                if (StringUtils.equals((CharSequence)groupToField, (CharSequence)"projectnum")) {
                    qFilterList = DragPmtsTaskHelper.getQFilters(DragPmtsTaskHelper.getProjectId(ctx), null);
                } else if (StringUtils.equals((CharSequence)groupToField, (CharSequence)"wbs") && groupObj != null) {
                    qFilterList = DragPmtsTaskHelper.getQFilters(DragPmtsTaskHelper.getProjectId(ctx), groupObj.getLong("id"));
                }
                if (qFilterList == null) {
                    return null;
                }
                DynamicObject[] taskObjets = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"orderno");
                if (taskObjets != null && taskObjets.length > 0) {
                    for (int i = 0; i < taskObjets.length; ++i) {
                        DynamicObject taskObjet = taskObjets[i];
                        taskObjet.set("orderno", (Object)(i + 2));
                    }
                    SaveServiceHelper.update((DynamicObject[])taskObjets);
                }
                dynObj.set("orderno", (Object)1);
                saveObjects = new DynamicObject[]{dynObj};
            }
        } else {
            List plist;
            GanttRowDataModel lastrow = (GanttRowDataModel)planDataList.get(planDataList.size() - 1);
            if (StringUtils.equals((CharSequence)lastrow.getEntityFlag(), (CharSequence)"pmts_wbs")) {
                dynObj.set("orderno", (Object)1);
                dynObj.set("wbs", (Object)lastrow.getObjId());
            } else if (StringUtils.equals((CharSequence)lastrow.getEntityFlag(), (CharSequence)"pmts_task") && !StringUtils.equals((CharSequence)lastrow.getObjId(), (CharSequence)dynObj.getString("id")) && !CollectionUtils.isEmpty(plist = planDataList.stream().filter(x -> StringUtils.equals((CharSequence)lastrow.getParentObjId(), (CharSequence)x.getObjId())).collect(Collectors.toList()))) {
                GanttRowDataModel parentData = (GanttRowDataModel)plist.get(0);
                if (StringUtils.equals((CharSequence)parentData.getEntityFlag(), (CharSequence)"pmpd_project")) {
                    dynObj.set("projectnum", (Object)parentData.getObjId());
                } else {
                    dynObj.set("wbs", (Object)parentData.getObjId());
                }
                DynamicObject lastObject = QueryServiceHelper.queryOne((String)"pmts_task", (String)"orderno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(lastrow.getObjId()))});
                dynObj.set("orderno", (Object)(lastObject.getInt("orderno") + 1));
            }
            saveObjects = new DynamicObject[]{dynObj};
        }
        if (!taskModel.isSubcross() || DragPmtsTaskHelper.isLastSubCross(taskModel, dynObj)) {
            if (!taskModel.isSubcross()) {
                dynObj.set(starttimeToField, (Object)new Timestamp(taskModel.getStartDate()));
                dynObj.set(endtimeToField, (Object)new Timestamp(taskModel.getEndDate()));
            }
            DragPmtsTaskHelper.toUpdateDelayed(dynObj, taskModel, ctx, 0L, 0L);
        }
        afterContent.append(sdf.format(new Date(taskModel.getStartDate())));
        afterContent.append(String.format(ResManager.loadKDString((String)"%s\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"DragPmtsTaskHelper_7", (String)"mmc-fmm-business", (Object[])new Object[0]), ", "));
        afterContent.append(sdf.format(new Date(taskModel.getEndDate())));
        SaveServiceHelper.save((DynamicObject[])saveObjects);
        ganttLogModel.setBeforeContent(beforeContent.toString());
        ganttLogModel.setAfterContent(afterContent.toString());
        ganttLogModel.setName(cammandName);
        return null;
    }

    private static boolean isLastSubCross(GanttTaskModel taskModel, DynamicObject dynObj) {
        if (taskModel.isSubcross()) {
            DynamicObjectCollection dynamicObjects = dynObj.getDynamicObjectCollection("subsectionentry");
            String[] ids = taskModel.getTaskId().split("_");
            if (ids != null && ids.length == 4) {
                int size = dynamicObjects.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                    if (!StringUtils.equals((CharSequence)dynamicObject.getString("id"), (CharSequence)ids[3]) || i != size - 1) continue;
                    dynamicObject.set("subplanstartdate", (Object)new Timestamp(taskModel.getStartDate()));
                    dynamicObject.set("subsubplanenddate", (Object)new Timestamp(taskModel.getEndDate()));
                    return true;
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a2a\u9053\u6570\u636e\u5b58\u5728\u95ee\u9898\u3002", (String)"DragPmtsTaskHelper_8", (String)"mmc-fmm-business", (Object[])new Object[0]));
            }
        }
        return false;
    }

    public static void toUpdateDelayed(DynamicObject dynObj, GanttTaskModel taskModel, GanttCommandContext ctx, long startTimestamp, long endTimestamp) {
        if (GanttCrossObjectEnum.TASK.getValue().equals(taskModel.getCrossObj()) && GanttCrossTypeEnum.PLAN.getValue().equals(taskModel.getCrossType()) || StringUtils.equals((CharSequence)taskModel.getCrossObj(), (CharSequence)GanttCrossObjectEnum.LANDMARKS.getValue())) {
            Map<Long, String> map;
            BigDecimal plan = new BigDecimal(taskModel.getEndDate() - taskModel.getStartDate());
            BigDecimal btimeunit = PmtsTaskValueHelper.getUnit(null);
            if (!taskModel.isSubcross()) {
                dynObj.set("plantime", (Object)plan.divide(btimeunit, 2, 4));
            }
            dynObj.set("abnormal", (Object)(!CollectionUtils.isEmpty(map = DragPmtsTaskHelper.getTaskProjectStageMsg(dynObj, ctx)) ? 1 : 0));
            DynamicObjectCollection postpositiontaskentry = dynObj.getDynamicObjectCollection("postpositiontaskentry");
            DynamicObjectCollection prepositiontaskentry = dynObj.getDynamicObjectCollection("prepositiontaskentry");
            if (prepositiontaskentry != null && prepositiontaskentry.size() > 0) {
                PmtsTaskValueHelper.setTaskCollection(prepositiontaskentry, dynObj);
            }
            if (postpositiontaskentry != null && postpositiontaskentry.size() > 0) {
                if (startTimestamp == 0L) {
                    PmtsTaskValueHelper.startCalTaskDateDalayed(dynObj, ctx.getView().getPageId());
                } else {
                    Map<String, BigDecimal> returnMap = PmtsTaskValueHelper.calDelayedChangeByAdjustTask(startTimestamp, endTimestamp, dynObj, btimeunit);
                    if (!returnMap.isEmpty()) {
                        PmtsTaskValueHelper.calNextTaskDateByAdjustTask(dynObj, returnMap, ctx.getView().getPageId());
                    }
                }
            }
        } else if (GanttCrossObjectEnum.TASK.getValue().equals(taskModel.getCrossObj()) && GanttCrossTypeEnum.ACTUAL.getValue().equals(taskModel.getCrossType())) {
            if (startTimestamp == 0L) {
                return;
            }
            Date planstartdate = dynObj.getDate("planstartdate");
            Date planenddate = dynObj.getDate("planenddate");
            BigDecimal actual = new BigDecimal(taskModel.getEndDate() - taskModel.getStartDate());
            BigDecimal plan = null;
            Double seconds = 0.0;
            if (planstartdate == null || planenddate == null) {
                BigDecimal plantime = dynObj.getBigDecimal("plantime");
                DynamicObject timeunit = dynObj.getDynamicObject("durationunit");
                if (StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"40") && plantime != null) {
                    seconds = plantime.doubleValue() * 60.0 * 60.0 * 1000.0;
                } else if (StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"30") && plantime != null) {
                    seconds = plantime.doubleValue() * 24.0 * 60.0 * 60.0 * 1000.0;
                }
                plan = BigDecimal.valueOf(seconds);
                seconds = seconds / 1000.0;
            } else if (planstartdate != null && planenddate != null) {
                plan = new BigDecimal(planenddate.getTime() - planstartdate.getTime());
                Long plantimestamp = (planenddate.getTime() - planstartdate.getTime()) / 1000L;
                seconds = plantimestamp.doubleValue();
            }
            BigDecimal result = actual.divide(plan, 4, 4);
            if (result.compareTo(BigDecimal.ONE) < 0) {
                dynObj.set("finishpercent", (Object)result.multiply(new BigDecimal(100)));
            } else {
                Long timestamp = seconds.longValue() * 99L / 100L;
                dynObj.set("finishpercent", (Object)99);
                dynObj.set("actualdate", (Object)DateUtil.addSecond((Date)dynObj.getDate("actualstartdate"), (long)timestamp));
            }
        }
    }

    private static Map<Long, String> getTaskProjectStageMsg(DynamicObject dynObj, GanttCommandContext ctx) {
        ArrayList<Map<String, Object>> taskList = new ArrayList<Map<String, Object>>(1);
        HashMap<String, Serializable> task = new HashMap<String, Serializable>(3);
        HashSet projectStageIds = new HashSet(8);
        DynamicObjectCollection col = dynObj.getDynamicObjectCollection("projectstage");
        col.forEach(obj -> projectStageIds.add(obj.getLong("fbasedataid_id")));
        task.put("id", Long.valueOf(dynObj.getLong("id")));
        task.put("projectstage", projectStageIds);
        task.put("planstartdate", dynObj.getDate("planstartdate"));
        task.put("planenddate", dynObj.getDate("planenddate"));
        taskList.add(task);
        Object projectObject = GanttUtils.getFilterValue((String)"projectnum.id", (String)ctx.getView().getPageId());
        if (projectObject != null) {
            Long projectnumId = Long.parseLong(projectObject.toString());
            return TaskSaveStageServiceHelper.getTaskProjectStageMsg(projectnumId, taskList);
        }
        return null;
    }

    private static void setOrdrNo(int targetOrderno, int orderno, DynamicObject dynObjWbs, DynamicObject targetDynObj, DynamicObject dynObj, GanttCommandContext ctx) {
        List<QFilter> qFilterList = DragPmtsTaskHelper.getQFilters(DragPmtsTaskHelper.getProjectId(ctx), dynObjWbs == null ? null : Long.valueOf(dynObjWbs.getLong("id")));
        if (targetOrderno == MAX_ORDERNO || orderno == MAX_ORDERNO) {
            DynamicObject[] taskObjets = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"orderno");
            for (int i = 0; i < taskObjets.length; ++i) {
                DynamicObject taskObjet = taskObjets[i];
                int num = i + 1;
                taskObjet.set("orderno", (Object)num);
                if (taskObjet.getString("id").equals(targetDynObj.getString("id"))) {
                    targetOrderno = num;
                }
                if (!taskObjet.getString("id").equals(dynObj.getString("id"))) continue;
                orderno = num;
            }
            SaveServiceHelper.update((DynamicObject[])taskObjets);
            dynObj.set("orderno", (Object)targetOrderno);
            targetDynObj.set("orderno", (Object)orderno);
        } else {
            if (Math.abs(targetOrderno - orderno) > 1) {
                if (targetOrderno > orderno) {
                    QFilter orderNoFilter = new QFilter("orderno", ">", (Object)orderno);
                    orderNoFilter.and("orderno", "<=", (Object)targetOrderno);
                    qFilterList.add(orderNoFilter);
                    DragPmtsTaskHelper.setOrderNoByGroup(qFilterList, -1);
                } else if (targetOrderno < orderno) {
                    QFilter orderNoFilter = new QFilter("orderno", ">=", (Object)targetOrderno);
                    orderNoFilter.and("orderno", "<", (Object)orderno);
                    qFilterList.add(orderNoFilter);
                    DragPmtsTaskHelper.setOrderNoByGroup(qFilterList, 1);
                }
            } else {
                targetDynObj.set("orderno", (Object)orderno);
            }
            dynObj.set("orderno", (Object)targetOrderno);
        }
    }

    private static void setOrderNoByGroup(List<QFilter> qFilterList, int num) {
        DynamicObject[] taskObjets;
        for (DynamicObject taskObjet : taskObjets = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"orderno")) {
            taskObjet.set("orderno", (Object)(taskObjet.getInt("orderno") + num));
        }
        SaveServiceHelper.update((DynamicObject[])taskObjets);
    }

    private static Long getProjectId(GanttCommandContext ctx) {
        Long projectId = null;
        Object projectObject = GanttUtils.getFilterValue((String)"projectnum.id", (String)ctx.getView().getPageId());
        if (projectObject != null) {
            projectId = Long.parseLong(projectObject.toString());
        }
        return projectId;
    }

    public static List<QFilter> getQFilters(Long projectId, Long wbsId) {
        QFilter projectFilter = new QFilter("projectnum.id", "=", (Object)projectId);
        QFilter wbsFilter = null;
        wbsFilter = wbsId == null ? new QFilter("wbs.id", "is null", null).or("wbs.id", "=", (Object)0) : new QFilter("wbs.id", "=", (Object)wbsId);
        QFilter filter = new QFilter("version.id", "is null", null);
        filter.or("version.id", "=", (Object)0);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(projectFilter);
        qFilterList.add(wbsFilter);
        qFilterList.add(filter);
        return qFilterList;
    }

    private static void updateOrderNoByGroup(int orderno, Long projectId, Long wbsId, Long targetTaskId, DynamicObject dynObj) {
        List<QFilter> qFilterList = DragPmtsTaskHelper.getQFilters(projectId, wbsId);
        if (orderno != 0) {
            QFilter orderNoFilter = new QFilter("orderno", ">=", (Object)orderno);
            qFilterList.add(orderNoFilter);
            dynObj.set("orderno", (Object)orderno);
        }
        int num = 0;
        DynamicObject[] taskObjets = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"orderno");
        for (int i = 0; i < taskObjets.length; ++i) {
            DynamicObject taskObjet = taskObjets[i];
            int k = i + 1;
            if (orderno == MAX_ORDERNO) {
                taskObjet.set("orderno", (Object)(num > 0 ? ++num : k));
                if (targetTaskId.longValue() != taskObjet.getLong("id")) continue;
                num = k + 1;
                dynObj.set("orderno", (Object)num);
                continue;
            }
            taskObjet.set("orderno", (Object)(taskObjet.getInt("orderno") + 1));
        }
        SaveServiceHelper.update((DynamicObject[])taskObjets);
    }

    private static long getIdJundeNull(DynamicObject groupObj) {
        if (Objects.isNull(groupObj)) {
            return 0L;
        }
        return groupObj.getLong("id");
    }
}

