/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.util.MileStoneTplUtils;
import kd.pmc.pmpd.common.util.TimeResult;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;
import kd.pmc.pmts.common.util.BindOrderUtils;

public class MileStoneTplHelper {
    public static boolean isImport(long tplId, long projectId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("projectnum", "=", (Object)projectId), new QFilter("tplid", "=", (Object)tplId)};
        boolean existsWbs = QueryServiceHelper.exists((String)"pmts_wbs", (QFilter[])qFilters);
        boolean existsTask = QueryServiceHelper.exists((String)"pmts_task", (QFilter[])qFilters);
        return existsWbs || existsTask;
    }

    public static void importTplDatas(IFormView view, long tplId, long projectId) {
        DynamicObject mileStoneTpl = BusinessDataServiceHelper.loadSingleFromCache((Object)tplId, (String)"pmpd_milestonetpl");
        DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectId, (String)"pmpd_project");
        DynamicObjectCollection entryCol = mileStoneTpl.getDynamicObjectCollection("treeentryentity");
        ArrayList<DynamicObject> wbsList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> mileStoneList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(8);
        long createOrg = Long.parseLong(view.getPageCache().get("createOrg"));
        String wbsCtrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"pmts_wbs", (String)view.getPageCache().get("createOrg"));
        String taskCtrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"pmts_task", (String)view.getPageCache().get("createOrg"));
        HashMap<Long, Integer> wbsLevelMap = new HashMap<Long, Integer>(8);
        HashMap<Long, Long> newIdMap = new HashMap<Long, Long>(8);
        long[] ids = ID.genLongIds((int)entryCol.size());
        int taskNumCounts = 0;
        int wbsNumCounts = 0;
        for (int i = 0; i < entryCol.size(); ++i) {
            if (!StringUtils.equals((CharSequence)"B", (CharSequence)((DynamicObject)entryCol.get(i)).getString("biztype"))) {
                ++taskNumCounts;
            } else {
                ++wbsNumCounts;
            }
            newIdMap.put(((DynamicObject)entryCol.get(i)).getLong("id"), ids[i]);
        }
        String[] wbsNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pmts_wbs", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_wbs")), (String)String.valueOf(RequestContext.get().getOrgId()), (int)wbsNumCounts);
        String[] taskNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pmts_task", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_task")), (String)String.valueOf(RequestContext.get().getOrgId()), (int)taskNumCounts);
        int taskIndex = 0;
        int wbsIndex = 0;
        ArrayList<DynamicObject> taskNoList = new ArrayList<DynamicObject>(8);
        Map resultMap = MileStoneTplUtils.calTplTime((DynamicObject)mileStoneTpl, (Date)project.getDate("planstartdate"), (BigDecimal)project.getBigDecimal("planperiod"));
        for (DynamicObject entry : entryCol) {
            String bizType = entry.getString("biztype");
            TimeResult result = resultMap.getOrDefault((Long)entry.getPkValue(), new TimeResult());
            if (StringUtils.equals((CharSequence)"A", (CharSequence)bizType)) {
                DynamicObject mileStone = MileStoneTplHelper.createMileStone(view, mileStoneTpl, entry, project, newIdMap);
                if (taskIndex < taskNumbers.length) {
                    mileStone.set("number", (Object)taskNumbers[taskIndex]);
                    ++taskIndex;
                } else {
                    mileStone.set("number", (Object)ID.genStringId());
                }
                mileStone.set("planstartdate", (Object)result.getBeginDate());
                mileStone.set("planenddate", (Object)result.getBeginDate());
                mileStone.set("plantime", (Object)BigDecimal.ZERO);
                mileStone.set("ctrlstrategy", (Object)taskCtrlStrgy);
                mileStone.set("createorg", (Object)createOrg);
                mileStoneList.add(mileStone);
                taskNoList.add(mileStone);
                continue;
            }
            if (StringUtils.equals((CharSequence)"B", (CharSequence)bizType)) {
                DynamicObject wbs = MileStoneTplHelper.createWbs(view, mileStoneTpl, entry, project, newIdMap);
                long pid = (Long)entry.get("pid");
                long id = (Long)entry.getPkValue();
                int level = 1;
                if (pid == 0L) {
                    wbsLevelMap.put(id, 1);
                } else {
                    level = (Integer)wbsLevelMap.get(pid) + 1;
                    wbsLevelMap.put(id, level);
                }
                wbs.set("number", (Object)wbsNumbers[wbsIndex]);
                wbs.set("longnumber", (Object)wbsNumbers[wbsIndex]);
                wbs.set("level", (Object)level);
                wbs.set("planstartdate", (Object)result.getBeginDate());
                wbs.set("planenddate", (Object)result.getFinishDate());
                wbs.set("plandays", (Object)result.getDays());
                wbs.set("ctrlstrategy", (Object)wbsCtrlStrgy);
                wbs.set("createorg", (Object)createOrg);
                wbsList.add(wbs);
                ++wbsIndex;
                continue;
            }
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)bizType)) continue;
            DynamicObject task = MileStoneTplHelper.createTask(view, mileStoneTpl, entry, project, newIdMap);
            if (taskIndex < taskNumbers.length) {
                task.set("number", (Object)taskNumbers[taskIndex]);
                ++taskIndex;
            } else {
                task.set("number", (Object)ID.genStringId());
            }
            task.set("planstartdate", (Object)result.getBeginDate());
            task.set("planenddate", (Object)result.getFinishDate());
            task.set("plantime", (Object)result.getDays());
            task.set("ctrlstrategy", (Object)taskCtrlStrgy);
            task.set("createorg", (Object)createOrg);
            taskList.add(task);
            taskNoList.add(task);
        }
        if (!mileStoneList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])mileStoneList.toArray(new DynamicObject[0]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])mileStoneList.toArray(new DynamicObject[0]));
        }
        if (!wbsList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])wbsList.toArray(new DynamicObject[0]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])wbsList.toArray(new DynamicObject[0]));
        }
        if (!taskList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[0]));
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])taskList.toArray(new DynamicObject[0]));
        }
        if (!taskNoList.isEmpty()) {
            PmtsTaskValueHelper.setTaskOrderNo(taskNoList);
        }
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskAdd(new ArrayList<Object>(newIdMap.keySet()), new ArrayList<Object>(newIdMap.keySet()));
    }

    public static DynamicObject createWbs(IFormView view, DynamicObject head, DynamicObject entry, DynamicObject project, Map<Long, Long> newIdMap) {
        DynamicObject wbs = BusinessDataServiceHelper.newDynamicObject((String)"pmts_wbs");
        wbs.set("id", (Object)newIdMap.get(entry.getPkValue()));
        wbs.set("masterid", (Object)newIdMap.get(entry.getPkValue()));
        wbs.set("projectnum", (Object)project);
        wbs.set("name", (Object)entry.getString("wbsname"));
        wbs.set("fullname", (Object)entry.getString("wbsname"));
        wbs.set("wbstype", entry.get("wbstype"));
        wbs.set("status", (Object)"A");
        wbs.set("enable", (Object)"1");
        wbs.set("businessstate", (Object)"A");
        wbs.set("parent", (Object)newIdMap.get(entry.getLong("pid")));
        wbs.set("creator", (Object)RequestContext.get().getCurrUserId());
        wbs.set("createtime", (Object)new Date());
        wbs.set("durationunit", entry.get("timeunit"));
        wbs.set("tplid", head.getPkValue());
        wbs.set("tplentryid", entry.getPkValue());
        wbs.set("plantype", (Object)BindOrderUtils.getPlanTypeId((IFormView)view));
        return wbs;
    }

    public static DynamicObject createTask(IFormView view, DynamicObject head, DynamicObject entry, DynamicObject project, Map<Long, Long> newIdMap) {
        DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"pmts_task");
        task.set("id", (Object)newIdMap.get(entry.getPkValue()));
        task.set("masterid", (Object)newIdMap.get(entry.getPkValue()));
        task.set("projectnum", project.getPkValue());
        task.set("name", (Object)entry.getString("taskname"));
        task.set("status", (Object)"A");
        task.set("enable", (Object)"1");
        task.set("wbs", (Object)newIdMap.get(entry.getLong("pid")));
        task.set("creator", (Object)RequestContext.get().getCurrUserId());
        task.set("createtime", (Object)new Date());
        task.set("durationunit", entry.get("timeunit"));
        task.set("tasktype", entry.get("tasktype"));
        task.set("executestatus", (Object)"1");
        task.set("workloadunit", (Object)"1");
        task.set("scheduletype", (Object)"1");
        task.set("timetype", (Object)"1");
        task.set("percenttype", (Object)"1");
        task.set("taskstatus", (Object)"1");
        task.set("tplid", head.getPkValue());
        task.set("tplentryid", entry.getPkValue());
        task.set("plantype", (Object)BindOrderUtils.getPlanTypeId((IFormView)view));
        task.set("standardtask", entry.get("standardtask"));
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("fronttask"))) {
            DynamicObjectCollection prepositiontaskentry = task.getDynamicObjectCollection("prepositiontaskentry");
            DynamicObject frontEntry = prepositiontaskentry.addNew();
            frontEntry.set("prepositiontask", (Object)newIdMap.get(entry.get("fronttaskid")));
            frontEntry.set("taskrelation", entry.get("frontrelation"));
            frontEntry.set("predelayed", entry.get("frontdelay"));
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString("posttask"))) {
            DynamicObjectCollection postpositiontaskentry = task.getDynamicObjectCollection("postpositiontaskentry");
            DynamicObject postEntry = postpositiontaskentry.addNew();
            postEntry.set("postpositiontask", (Object)newIdMap.get(entry.get("posttaskid")));
            postEntry.set("taskrelationtwo", entry.get("postrelation"));
            postEntry.set("postdelayed", entry.get("postdelay"));
        }
        PmtsTaskValueHelper.setFilterValueToGanttTask(task, view);
        return task;
    }

    public static DynamicObject createMileStone(IFormView view, DynamicObject head, DynamicObject entry, DynamicObject project, Map<Long, Long> newIdMap) {
        DynamicObject mileStone = MileStoneTplHelper.createTask(view, head, entry, project, newIdMap);
        mileStone.set("scheduletype", (Object)"3");
        mileStone.set("name", entry.get("milestonename"));
        mileStone.set("standardtask", entry.get("standardmile"));
        return mileStone;
    }
}

