/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class PmtsTaskDelayHelper {
    public static Map<String, Date> calDateByPreTask(DynamicObjectCollection prepositiontaskentry, BigDecimal plantime, DynamicObject selfObject) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        BigDecimal unit = PmtsTaskValueHelper.getUnit(null);
        int size = prepositiontaskentry.size();
        int index = -1;
        Long maxTime = 0L;
        for (int i = 0; i < size; ++i) {
            DynamicObject object = (DynamicObject)prepositiontaskentry.get(i);
            Long time = PmtsTaskDelayHelper.getCalTime(object, unit, selfObject);
            if (time > maxTime) {
                maxTime = time;
                index = i;
            }
            for (int j = i + 1; j < size; ++j) {
                DynamicObject jobject = (DynamicObject)prepositiontaskentry.get(j);
                Long jtime = PmtsTaskDelayHelper.getCalTime(jobject, unit, selfObject);
                if (jtime <= maxTime) continue;
                index = j;
                maxTime = jtime;
            }
        }
        if ((index != -1 || size == 1) && maxTime > 0L) {
            long start = 0L;
            long end = 0L;
            DynamicObject object = (DynamicObject)prepositiontaskentry.get(size == 1 ? 0 : index);
            if (object != null) {
                String relation = object.getString("taskrelation");
                if (StringUtils.isBlank((String)relation)) {
                    return map;
                }
                switch (relation) {
                    case "1": {
                        start = maxTime;
                        end = start + plantime.multiply(unit).longValue();
                        break;
                    }
                    case "2": {
                        end = maxTime;
                        start = end - plantime.multiply(unit).longValue();
                        break;
                    }
                    case "3": {
                        start = maxTime;
                        end = start + plantime.multiply(unit).longValue();
                        break;
                    }
                    case "4": {
                        end = maxTime;
                        start = end - plantime.multiply(unit).longValue();
                        break;
                    }
                }
                Date planstartdate = new Date(start);
                Date planenddate = new Date(end);
                map.put("planstartdate", planstartdate);
                map.put("planenddate", planenddate);
            }
        }
        return map;
    }

    public static Long getCalTime(DynamicObject object, BigDecimal unit, DynamicObject selfObject) {
        DynamicObject preobject = object.getDynamicObject("prepositiontask");
        if (preobject == null) {
            return 0L;
        }
        boolean ishave = false;
        DataEntityPropertyCollection dataEntityProperties = preobject.getDynamicObjectType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            if (!dataEntityProperty.getName().contains("plantime")) continue;
            ishave = true;
            break;
        }
        if (!ishave) {
            preobject = PmtsTaskValueHelper.getDynamicObject(preobject);
        }
        if (selfObject != null && preobject.getLong("id") == selfObject.getLong("id")) {
            preobject = selfObject;
        }
        if (preobject.getBigDecimal("plantime") == null) {
            return 0L;
        }
        long seconds = preobject.getBigDecimal("plantime").multiply(unit).divide(new BigDecimal(1000)).longValue();
        DynamicObjectCollection subsectionentry = preobject.getDynamicObjectCollection("subsectionentry");
        Date startDate = preobject.getDate("planstartdate");
        Date endDate = preobject.getDate("planenddate");
        String prerelation = object.getString("taskrelation");
        BigDecimal predelayed = object.getBigDecimal("predelayed");
        Map<String, Date> dateMap = PmtsTaskValueHelper.getStartEndDate(startDate, endDate, seconds);
        if (!subsectionentry.isEmpty()) {
            DynamicObject firstSubTask = (DynamicObject)subsectionentry.get(0);
            DynamicObject lastSubTask = (DynamicObject)subsectionentry.get(subsectionentry.size() - 1);
            dateMap.put("planstartdate", firstSubTask.getDate("subplanstartdate"));
            dateMap.put("planenddate", lastSubTask.getDate("subsubplanenddate"));
        }
        if (StringUtils.isBlank((String)prerelation) || dateMap.isEmpty()) {
            return 0L;
        }
        Long time = 0L;
        switch (prerelation) {
            case "1": {
                time = dateMap.get("planenddate").getTime() + predelayed.multiply(unit).longValue();
                break;
            }
            case "2": {
                time = dateMap.get("planenddate").getTime() + predelayed.multiply(unit).longValue();
                break;
            }
            case "3": {
                time = dateMap.get("planstartdate").getTime() + predelayed.multiply(unit).longValue();
                break;
            }
            case "4": {
                time = dateMap.get("planstartdate").getTime() + predelayed.multiply(unit).longValue();
                break;
            }
        }
        return time;
    }

    public static void setSubTaskData(DynamicObject dynamicObject, Map<String, Date> dateMap) {
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("subsectionentry");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        Date newplanstartdate = null;
        Date newplanenddate = null;
        Long intervalTime = 0L;
        BigDecimal unit = PmtsTaskValueHelper.getUnit(null);
        int size = dynamicObjects.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject subObject = (DynamicObject)dynamicObjects.get(i);
            if (i == 0) {
                if (!dateMap.isEmpty()) {
                    newplanstartdate = dateMap.get("planstartdate");
                    newplanenddate = DateUtils.addMilliseconds((Date)newplanstartdate, (int)subObject.getBigDecimal("subplantime").multiply(unit).intValue());
                    intervalTime = newplanstartdate.getTime() - subObject.getDate("subplanstartdate").getTime();
                }
            } else {
                newplanstartdate = DateUtils.addMilliseconds((Date)subObject.getDate("subplanstartdate"), (int)intervalTime.intValue());
                newplanenddate = DateUtils.addMilliseconds((Date)subObject.getDate("subsubplanenddate"), (int)intervalTime.intValue());
            }
            subObject.set("subplanstartdate", newplanstartdate);
            subObject.set("subsubplanenddate", newplanenddate);
        }
    }
}

