/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskDelayHelper;
import kd.pmc.pmts.common.util.DateUtil;
import org.apache.commons.lang3.time.DateUtils;

public class PmtsTaskValueHelper {
    public static void setFilterValueToGanttTask(DynamicObject task, IFormView formView) {
        DynamicObject mGanttSourceObj = (DynamicObject)GanttBigObjectCache.get((String)formView.getPageId(), (String)"datasource");
        DynamicObjectCollection col = mGanttSourceObj.getDynamicObjectCollection("entityfilter");
        for (DynamicObject object : col) {
            String number = object.getString("entitycondalign");
            String key = number + ".id";
            Object fobject = GanttUtils.getFilterValue((String)key, (String)formView.getPageId());
            if (!Objects.nonNull(fobject)) continue;
            Long value = 0L;
            value = fobject instanceof List ? (Long)((List)fobject).get(0) : Long.valueOf(Long.parseLong(fobject.toString()));
            task.set(number, (Object)value);
        }
    }

    public static void setFilterValueToGanttTask(IDataModel dataModel, IFormView formView) {
        DynamicObject mGanttSourceObj = (DynamicObject)GanttBigObjectCache.get((String)formView.getPageId(), (String)"datasource");
        DynamicObjectCollection col = mGanttSourceObj.getDynamicObjectCollection("entityfilter");
        for (DynamicObject object : col) {
            String number = object.getString("entitycondalign");
            String key = number + ".id";
            Object fobject = GanttUtils.getFilterValue((String)key, (String)formView.getPageId());
            if (!Objects.nonNull(fobject)) continue;
            Long value = 0L;
            value = fobject instanceof List ? (Long)((List)fobject).get(0) : Long.valueOf(Long.parseLong(fobject.toString()));
            dataModel.setItemValueByID(number, (Object)value);
        }
    }

    public static BigDecimal getUnit(DynamicObject durationunit) {
        return new BigDecimal(86400000);
    }

    public static void calDateByDelayed(DynamicObject dynamicObject, DynamicObject postpositiontask, Set<DynamicObject> objectSet, DynamicObject selfObject) {
        String relation = dynamicObject.getString("taskrelationtwo");
        if (StringUtils.isBlank((CharSequence)relation)) {
            return;
        }
        if (postpositiontask != null) {
            DynamicObjectCollection prepositiontaskentry = postpositiontask.getDynamicObjectCollection("prepositiontaskentry");
            Map<String, Date> dateMap = PmtsTaskDelayHelper.calDateByPreTask(prepositiontaskentry, postpositiontask.getBigDecimal("plantime"), selfObject);
            if (dateMap.isEmpty()) {
                return;
            }
            postpositiontask.set("planstartdate", (Object)dateMap.get("planstartdate"));
            postpositiontask.set("planenddate", (Object)dateMap.get("planenddate"));
            objectSet.add(postpositiontask);
        }
    }

    public static Long getTimestamp(String taskrelation, Date endDate, Date startDate, DynamicObject currentObject) {
        Long timestamp = 0L;
        DynamicObjectCollection subsectionentry = currentObject.getDynamicObjectCollection("subsectionentry");
        Date selfStartDate = currentObject.getDate("planstartdate");
        Date selfEndDate = currentObject.getDate("planenddate");
        if (!subsectionentry.isEmpty()) {
            selfStartDate = ((DynamicObject)subsectionentry.get(0)).getDate("subplanstartdate");
            selfEndDate = ((DynamicObject)subsectionentry.get(subsectionentry.size() - 1)).getDate("subsubplanenddate");
        }
        if (taskrelation.equals("1") && selfStartDate != null && endDate != null) {
            timestamp = selfStartDate.getTime() - endDate.getTime();
        } else if (taskrelation.equals("2") && selfEndDate != null && endDate != null) {
            timestamp = selfEndDate.getTime() - endDate.getTime();
        } else if (taskrelation.equals("3") && selfStartDate != null && startDate != null) {
            timestamp = selfStartDate.getTime() - startDate.getTime();
        } else if (taskrelation.equals("4") && selfEndDate != null && startDate != null) {
            timestamp = selfEndDate.getTime() - startDate.getTime();
        }
        return timestamp;
    }

    public static Map<String, Date> getStartEndDate(Date planstartdate, Date planenddate, long seconds) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (Objects.nonNull(planstartdate) && Objects.isNull(planenddate)) {
            planenddate = DateUtil.addSecond((Date)planstartdate, (long)seconds);
        } else if (Objects.isNull(planstartdate) && Objects.nonNull(planenddate)) {
            planstartdate = DateUtil.reduceSecond((Date)planenddate, (long)seconds);
        } else if (Objects.isNull(planstartdate) && Objects.isNull(planenddate)) {
            return map;
        }
        map.put("planstartdate", planstartdate);
        map.put("planenddate", planenddate);
        return map;
    }

    public static Map<String, BigDecimal> calDelayedChangeByAdjustTask(long startTimestamp, long endTimestamp, DynamicObject dynObj, BigDecimal unit) {
        long changeTimestamp = 0L;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (startTimestamp != 0L && endTimestamp != 0L) {
            long startChangeTime = 0L;
            long endChangeTime = 0L;
            DynamicObjectCollection postTaskentry = dynObj.getDynamicObjectCollection("subsectionentry");
            if (postTaskentry.isEmpty()) {
                startChangeTime = dynObj.getDate("planstartdate").getTime() - startTimestamp;
                endChangeTime = dynObj.getDate("planenddate").getTime() - endTimestamp;
            } else {
                DynamicObject object = (DynamicObject)postTaskentry.get(postTaskentry.size() - 1);
                startChangeTime = object.getDate("subplanstartdate").getTime() - startTimestamp;
                endChangeTime = object.getDate("subsubplanenddate").getTime() - endTimestamp;
            }
            String key = "";
            if (Math.abs(startChangeTime) > Math.abs(endChangeTime)) {
                changeTimestamp = startChangeTime;
                key = "left";
            } else if (Math.abs(startChangeTime) < Math.abs(endChangeTime)) {
                changeTimestamp = endChangeTime;
                key = "right";
            }
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                map.put(key, new BigDecimal(changeTimestamp).divide(unit, 2, 4));
            }
        }
        return map;
    }

    public static void calNextTaskDateByAdjustTask(DynamicObject selfObject, Map<String, BigDecimal> map, String pageId) {
        List dataModels = (List)GanttCacheUtils.getCacheBigObject((String)pageId, (String)"dataList");
        List ids = dataModels.stream().filter(ganttRowDataModel -> StringUtils.equals((CharSequence)ganttRowDataModel.getEntityFlag(), (CharSequence)"pmts_task")).map(p -> Long.parseLong(p.getObjId())).collect(Collectors.toList());
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"pmts_task");
        HashSet<DynamicObject> objectSet = new HashSet<DynamicObject>(100);
        String flag = map.keySet().iterator().next();
        DynamicObjectCollection postTaskentry = selfObject.getDynamicObjectCollection("postpositiontaskentry");
        if (!CollectionUtils.isEmpty((Collection)postTaskentry)) {
            for (DynamicObject dynamicObject : postTaskentry) {
                boolean leftChange;
                String relation = dynamicObject.getString("taskrelationtwo");
                boolean rightChange = (StringUtils.equals((CharSequence)relation, (CharSequence)"1") || StringUtils.equals((CharSequence)relation, (CharSequence)"2")) && flag.equals("right");
                boolean bl = leftChange = (StringUtils.equals((CharSequence)relation, (CharSequence)"3") || StringUtils.equals((CharSequence)relation, (CharSequence)"4")) && flag.equals("left");
                if (!leftChange && !rightChange) continue;
                DynamicObject postpositiontask = dynamicObject.getDynamicObject("postpositiontask");
                if ((postpositiontask = PmtsTaskValueHelper.getDynamicObject(postpositiontask, dynamicObjectMap)) == null) {
                    return;
                }
                DynamicObjectCollection dynamicObjects = postpositiontask.getDynamicObjectCollection("subsectionentry");
                if (!dynamicObjects.isEmpty()) {
                    PmtsTaskValueHelper.setSplitTaskDate(dynamicObjects, selfObject, postpositiontask);
                }
                PmtsTaskValueHelper.calDateByDelayed(dynamicObject, postpositiontask, objectSet, selfObject);
                PmtsTaskValueHelper.calNextTaskDate(selfObject, postpositiontask, objectSet, dynamicObjectMap);
            }
        }
        if (!objectSet.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])objectSet.toArray(new DynamicObject[objectSet.size()]));
        }
    }

    private static void setSplitTaskDate(DynamicObjectCollection dynamicObjects, DynamicObject selfObject, DynamicObject postpositiontask) {
        int size = dynamicObjects.size();
        Date newplanstartdate = null;
        Date newplanenddate = null;
        Long intervalTime = 0L;
        Map<String, Date> preDateMap = PmtsTaskDelayHelper.calDateByPreTask(postpositiontask.getDynamicObjectCollection("prepositiontaskentry"), postpositiontask.getBigDecimal("plantime"), selfObject);
        BigDecimal unit = PmtsTaskValueHelper.getUnit(null);
        for (int i = 0; i < size; ++i) {
            DynamicObject subObject = (DynamicObject)dynamicObjects.get(i);
            if (i == 0) {
                if (preDateMap != null) {
                    newplanstartdate = preDateMap.get("planstartdate");
                    newplanenddate = DateUtils.addMilliseconds((Date)newplanstartdate, (int)subObject.getBigDecimal("subplantime").multiply(unit).intValue());
                    intervalTime = newplanstartdate.getTime() - subObject.getDate("subplanstartdate").getTime();
                }
            } else {
                newplanstartdate = DateUtils.addMilliseconds((Date)subObject.getDate("subplanstartdate"), (int)intervalTime.intValue());
                newplanenddate = DateUtils.addMilliseconds((Date)subObject.getDate("subsubplanenddate"), (int)intervalTime.intValue());
            }
            subObject.set("subplanstartdate", newplanstartdate);
            subObject.set("subsubplanenddate", newplanenddate);
        }
    }

    public static void startCalTaskDateDalayed(DynamicObject selfObject, String pageId) {
        HashSet<DynamicObject> objectSet = new HashSet<DynamicObject>(100);
        List dataModels = (List)GanttCacheUtils.getCacheBigObject((String)pageId, (String)"dataList");
        if (dataModels == null) {
            return;
        }
        List ids = dataModels.stream().filter(ganttRowDataModel -> StringUtils.equals((CharSequence)ganttRowDataModel.getEntityFlag(), (CharSequence)"pmts_task")).map(p -> Long.parseLong(p.getObjId())).collect(Collectors.toList());
        Map taskMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"pmts_task");
        PmtsTaskValueHelper.calNextTaskDate(selfObject, selfObject, objectSet, taskMap);
        if (!objectSet.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])objectSet.toArray(new DynamicObject[objectSet.size()]));
        }
    }

    private static void calNextTaskDate(DynamicObject updateObject, DynamicObject selfObject, Set<DynamicObject> objectSet, Map<Object, DynamicObject> dynamicObjectMap) {
        DynamicObjectCollection postTaskentry;
        if (updateObject.getLong("id") != selfObject.getLong("id")) {
            selfObject = dynamicObjectMap.get(selfObject.getLong("id"));
        }
        if (!CollectionUtils.isEmpty((Collection)(postTaskentry = selfObject.getDynamicObjectCollection("postpositiontaskentry")))) {
            for (DynamicObject dynamicObject : postTaskentry) {
                DynamicObject postpositiontask = PmtsTaskValueHelper.getDynamicObject(dynamicObject.getDynamicObject("postpositiontask"), dynamicObjectMap);
                if (postpositiontask == null) continue;
                DynamicObjectCollection dynamicObjects = postpositiontask.getDynamicObjectCollection("subsectionentry");
                if (!dynamicObjects.isEmpty()) {
                    PmtsTaskValueHelper.setSplitTaskDate(dynamicObjects, selfObject, postpositiontask);
                }
                PmtsTaskValueHelper.calDateByDelayed(dynamicObject, postpositiontask, objectSet, selfObject);
                PmtsTaskValueHelper.calNextTaskDate(updateObject, dynamicObject.getDynamicObject("postpositiontask"), objectSet, dynamicObjectMap);
            }
        }
    }

    public static void setTaskCollection(DynamicObjectCollection positiontaskentry, DynamicObject dynObj) {
        if (positiontaskentry != null) {
            for (DynamicObject object : positiontaskentry) {
                String taskrelation = object.getString("taskrelation");
                DynamicObject positiontask = object.getDynamicObject("prepositiontask");
                if (positiontask == null) continue;
                DynamicObjectCollection subsectionentry = positiontask.getDynamicObjectCollection("subsectionentry");
                Long timestamp = 0L;
                BigDecimal unit = PmtsTaskValueHelper.getUnit(null);
                if (subsectionentry.isEmpty()) {
                    timestamp = PmtsTaskValueHelper.getTimestamp(taskrelation, positiontask.getDate("planenddate"), positiontask.getDate("planstartdate"), dynObj);
                } else {
                    DynamicObject firstSubTask = (DynamicObject)subsectionentry.get(0);
                    DynamicObject lastSubTask = (DynamicObject)subsectionentry.get(subsectionentry.size() - 1);
                    timestamp = PmtsTaskValueHelper.getTimestamp(taskrelation, lastSubTask.getDate("subsubplanenddate"), firstSubTask.getDate("subplanstartdate"), dynObj);
                }
                BigDecimal delayed = new BigDecimal(timestamp).divide(unit, 2, 4);
                PmtsTaskValueHelper.updateDelayedTwo(delayed, positiontaskentry, positiontask.getLong("id"), dynObj);
            }
        }
    }

    private static void updateDelayedTwo(BigDecimal delayed, DynamicObjectCollection positiontaskentry, Long postTaskId, DynamicObject dynObj) {
        for (DynamicObject object : positiontaskentry) {
            DynamicObject postpositiontask = object.getDynamicObject("prepositiontask");
            if (postpositiontask.getLong("id") != postTaskId.longValue()) continue;
            object.set("predelayed", (Object)delayed);
            break;
        }
        dynObj.set("prepositiontaskentry", (Object)positiontaskentry);
        DynamicObject postObject = BusinessDataServiceHelper.loadSingleFromCache((Object)postTaskId, (String)"pmts_task");
        DynamicObjectCollection postpositiontaskentry = postObject.getDynamicObjectCollection("postpositiontaskentry");
        for (DynamicObject object : postpositiontaskentry) {
            if (!object.getDynamicObject("postpositiontask").getString("id").equals(dynObj.getString("id"))) continue;
            object.set("postdelayed", (Object)delayed);
            break;
        }
        postObject.set("postpositiontaskentry", (Object)postpositiontaskentry);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{postObject});
    }

    public static DynamicObject getDynamicObject(DynamicObject object) {
        if (object == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)object.getLong("id"), (String)"pmts_task");
    }

    public static DynamicObject getDynamicObject(DynamicObject object, Map<Object, DynamicObject> dynamicObjectMap) {
        if (object == null) {
            return null;
        }
        return dynamicObjectMap.get(object.getLong("id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTaskOrderNo(List<DynamicObject> tasks) {
        try (DLock dl = DLock.create((String)"task/orderno/multiple");){
            dl.lock();
            try {
                HashSet<Long> projectIdSet = new HashSet<Long>(100);
                for (DynamicObject task : tasks) {
                    if (task.get("projectnum") instanceof Long) {
                        projectIdSet.add(task.getLong("projectnum"));
                        continue;
                    }
                    projectIdSet.add(task.getDynamicObject("projectnum").getLong("id"));
                }
                QFilter projectFilter = new QFilter("projectnum.id", "in", new ArrayList(projectIdSet));
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                try (DataSet maxData = QueryServiceHelper.queryDataSet((String)"", (String)"pmts_task", (String)"orderno,projectnum.id", (QFilter[])projectFilter.toArray(), null).groupBy(new String[]{"projectnum.id"}).max("orderno").finish();){
                    for (Row row : maxData) {
                        Integer maxOrderNo = row.getInteger("orderno");
                        Long projectId = row.getLong("projectnum.id");
                        map.put(projectId, maxOrderNo);
                    }
                }
                if (map.isEmpty()) {
                    return;
                }
                for (DynamicObject task : tasks) {
                    Long projectid = null;
                    projectid = task.get("projectnum") instanceof Long ? Long.valueOf(task.getLong("projectnum")) : Long.valueOf(task.getDynamicObject("projectnum").getLong("id"));
                    int maxOrderNo = (Integer)map.get(projectid);
                    task.set("orderno", (Object)(++maxOrderNo));
                    map.put(projectid, maxOrderNo);
                }
                SaveServiceHelper.update((DynamicObject[])tasks.toArray(new DynamicObject[0]));
            }
            finally {
                dl.unlock();
            }
        }
    }

    public static Date queryDayOneDate(Long projectnumId, Long versionId) {
        QFilter qFilter = new QFilter("isdayone", "=", (Object)"1");
        qFilter.and(new QFilter("projectnum", "=", (Object)projectnumId));
        QFilter version = new QFilter("version", "=", (Object)versionId);
        if (versionId == 0L) {
            qFilter.and(version.or(new QFilter("releasestatus", "=", (Object)true)));
        } else {
            qFilter.and(version);
        }
        DynamicObject taskObj = QueryServiceHelper.queryOne((String)"pmts_task", (String)"planstartdate", (QFilter[])qFilter.toArray());
        if (taskObj != null && taskObj.getDate("planstartdate") != null) {
            return taskObj.getDate("planstartdate");
        }
        return null;
    }
}

