/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.CopyHelper;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;

public class ProjectPlanAction {
    protected List<Object> pks;
    protected String entityName;
    protected MainEntityType entityType;
    protected static final List<String> CAN_NOTCOPY_PROP = Arrays.asList("sourceid", "sourceplantype", "plantype");
    protected List<Object> opPks;
    protected List<String> excProp;

    public ProjectPlanAction(List<Object> pks, String entityName) {
        this.pks = pks;
        this.entityName = entityName;
        this.entityType = EntityMetadataCache.getDataEntityType((String)entityName);
    }

    public List<DynamicObject> copy(ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])this.pks.toArray(new Object[0]), (DynamicObjectType)this.entityType);
        this.getOpPks().addAll(this.pks);
        List<DynamicObject> copyObjs = this.copy(Arrays.asList(objs), sourcePlanType, targetPlanType);
        this.save(copyObjs);
        if ("pmts_task".equals(this.entityName) && !CollectionUtils.isEmpty(copyObjs)) {
            PmtsTaskValueHelper.setTaskOrderNo(copyObjs);
        }
        return copyObjs;
    }

    public void save(List<DynamicObject> copyObjs) {
        if (copyObjs != null) {
            DynamicObject[] copyObjsList = copyObjs.toArray(new DynamicObject[0]);
            this.save(copyObjsList);
        }
    }

    public void save(DynamicObject[] objs) {
        if (objs != null) {
            SaveServiceHelper.save((DynamicObject[])objs);
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])objs);
        }
    }

    public List<DynamicObject> copy(List<DynamicObject> objs, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
        if (objs == null || sourcePlanType == null || targetPlanType == null) {
            return null;
        }
        String[] numbers = this.getNumbers(objs.size());
        long[] ids = ID.genLongIds((int)objs.size());
        ArrayList<DynamicObject> copyObjs = new ArrayList<DynamicObject>(objs.size());
        this.copy(objs, copyObjs, numbers, ids, sourcePlanType, targetPlanType);
        return copyObjs;
    }

    public void copy(List<DynamicObject> objs, List<DynamicObject> copyObjs, String[] numbers, long[] ids, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
    }

    public void resetField(DynamicObject copyObj, DynamicObject obj, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType, long id, String number) {
        CopyHelper.clearFieldCantCopy((IDataEntityType)this.entityType, copyObj, this.excProp);
        copyObj.set("plantype_id", (Object)targetPlanType.getId());
        copyObj.set("name", obj.get("name"));
        copyObj.set("org_id", obj.get("org_id"));
        copyObj.set("createorg_id", obj.get("createorg_id"));
        this.restField(copyObj);
        copyObj.set("sourceid", obj.getPkValue());
        copyObj.set("sourceplantype_id", (Object)sourcePlanType.getId());
        copyObj.set("number", (Object)number);
        copyObj.set("id", (Object)id);
        copyObj.set("masterid", (Object)id);
    }

    public void restField(DynamicObject object) {
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        Date date = new Date();
        object.set("creator_id", (Object)userId);
        object.set("modifier_id", (Object)userId);
        object.set("createtime", (Object)date);
        object.set("modifytime", (Object)date);
    }

    public DynamicObject[] preSet() {
        return null;
    }

    public String[] getNumbers(int size) {
        return CodeRuleServiceHelper.getBatchNumber((String)this.entityName, (DynamicObject)new DynamicObject((DynamicObjectType)this.entityType), null, (int)size);
    }

    public Map<Object, DynamicObject> queryCopyWbsPks(List<Object> parentWbsPks, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType) {
        if (CollectionUtils.isEmpty(parentWbsPks)) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashMap<Object, DynamicObject> copyParentWbsPks = new HashMap<Object, DynamicObject>(parentWbsPks.size());
        QFilter qFilter = new QFilter("sourceid", "in", parentWbsPks);
        qFilter.and("plantype", "=", (Object)sourcePlanType.getId());
        DynamicObjectCollection wbsColl = QueryServiceHelper.query((String)"pmts_wbs", (String)"id,sourceid,longnumber", (QFilter[])qFilter.toArray(), (String)"createtime");
        for (DynamicObject row : wbsColl) {
            copyParentWbsPks.put(row.get(1), row);
        }
        return copyParentWbsPks;
    }

    public static DynamicObject queryDefaultConf() {
        QFilter qFilter = new QFilter("defconf", "=", (Object)Boolean.TRUE);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_projectplan_conf", (String)"projectnum,syncobj,entryentity.sourceplantype,entryentity.targetplantype,entryentity.enew,entryentity.eedit,entryentity.edelete,entryentity.updatestatus", (QFilter[])qFilter.toArray());
    }

    public void add() {
        List<DynamicObject> data = this.doAdd();
        this.save(data);
        if ("pmts_task".equals(this.entityName) && !CollectionUtils.isEmpty(data)) {
            PmtsTaskValueHelper.setTaskOrderNo(data);
        }
    }

    public List<DynamicObject> doAdd() {
        if (CollectionUtils.isEmpty(this.pks)) {
            return null;
        }
        DynamicObject planTypeConf = ProjectPlanAction.queryDefaultConf();
        if (planTypeConf == null) {
            return null;
        }
        String syncObj = planTypeConf.getString("syncobj");
        if (this.hasSyncObj(syncObj)) {
            return null;
        }
        DynamicObject[] sourceObjs = BusinessDataServiceHelper.load((Object[])this.pks.toArray(new Object[0]), (DynamicObjectType)this.entityType);
        if (sourceObjs == null) {
            return null;
        }
        Set planTypes = Stream.of(sourceObjs).map(i -> i.getLong("plantype_id")).collect(Collectors.toSet());
        HashMap<Long, List<Long>> typeCanDoOperate = new HashMap<Long, List<Long>>(planTypes.size());
        HashMap<Object, Boolean> typedoStatus = new HashMap<Object, Boolean>(planTypes.size());
        for (Long planType : planTypes) {
            typeCanDoOperate.put(planType, this.getTargetPlanType(planTypeConf, planType, "enew"));
            typedoStatus.put(planType, this.canDoByStatus(planTypeConf, planType));
        }
        Set projectIds = Stream.of(sourceObjs).map(wbs -> wbs.get("projectnum_id")).collect(Collectors.toSet());
        ArrayList<Object> li = new ArrayList<Object>();
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.MASTER.getId());
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.REGION.getId());
        Map<Object, Set<Object>> baseVersionCount = this.getBaseVersionCount(li, new ArrayList<Object>(projectIds), this.entityType);
        ArrayList<DynamicObject> allCopyObjs = new ArrayList<DynamicObject>(this.pks.size());
        HashMap<Long, List<DynamicObject>> sourceDyObjs = new HashMap<Long, List<DynamicObject>>(4);
        for (DynamicObject sourceObj2 : sourceObjs) {
            long sourcePlanTypeId = sourceObj2.getLong("plantype_id");
            if (!this.planTypeHasRight(syncObj, sourceObj2, typedoStatus, baseVersionCount)) continue;
            sourceDyObjs.computeIfAbsent(sourcePlanTypeId, i -> new ArrayList(10)).add(sourceObj2);
            this.getOpPks().add(sourceObj2.get("id"));
        }
        this.beforeDoAdd(sourceDyObjs);
        sourceDyObjs.forEach((soureType, sourceObj) -> {
            List targetTypes = (List)typeCanDoOperate.get(soureType);
            for (Long planType : targetTypes) {
                List<DynamicObject> objs = this.copy((List<DynamicObject>)sourceObj, ProjectPlanTypeHelper.PlanTypeEnum.getPlanTypeById(soureType), ProjectPlanTypeHelper.PlanTypeEnum.getPlanTypeById(planType));
                if (objs == null) continue;
                allCopyObjs.addAll(objs);
            }
        });
        return allCopyObjs;
    }

    public void beforeDoAdd(Map<Long, List<DynamicObject>> sourceDyObjs) {
    }

    public boolean planTypeHasRight(String syncObj, DynamicObject sourceObj, Map<Object, Boolean> typedoStatus, Map<Object, Set<Object>> baseVersionCount) {
        if (this.isSyncObj(syncObj, sourceObj)) {
            return false;
        }
        if (sourceObj.get("plantype") == null) {
            return false;
        }
        Object project = sourceObj.get("projectnum_id");
        long sourcePlanTypeId = sourceObj.getLong("plantype_id");
        Boolean doStatus = typedoStatus.get(sourcePlanTypeId);
        Set<Object> projectBaseVersion = baseVersionCount.get(project);
        return doStatus == false || projectBaseVersion == null || !projectBaseVersion.contains(sourcePlanTypeId);
    }

    public void edit() {
        DynamicObject[] allCopyObjs = this.doEdit();
        if (allCopyObjs != null) {
            SaveServiceHelper.save((DynamicObject[])allCopyObjs);
        }
    }

    public DynamicObject[] doEdit() {
        if (CollectionUtils.isEmpty(this.pks)) {
            return null;
        }
        DynamicObject planTypeConf = ProjectPlanAction.queryDefaultConf();
        if (planTypeConf == null) {
            return null;
        }
        String syncObj = planTypeConf.getString("syncobj");
        if (this.hasSyncObj(syncObj)) {
            return null;
        }
        DynamicObject[] sourceObjs = BusinessDataServiceHelper.load((Object[])this.pks.toArray(new Object[0]), (DynamicObjectType)this.entityType);
        if (sourceObjs == null) {
            return null;
        }
        Set planTypes = Stream.of(sourceObjs).map(i -> i.getLong("plantype_id")).collect(Collectors.toSet());
        HashMap<Long, List<Long>> typeCanDoOperate = new HashMap<Long, List<Long>>(planTypes.size());
        HashMap<Object, Boolean> typedoStatus = new HashMap<Object, Boolean>(planTypes.size());
        for (Long planType : planTypes) {
            typeCanDoOperate.put(planType, this.getTargetPlanType(planTypeConf, planType, "eedit"));
            typedoStatus.put(planType, this.canDoByStatus(planTypeConf, planType));
        }
        Set projectIds = Stream.of(sourceObjs).map(i -> i.get("projectnum_id")).collect(Collectors.toSet());
        ArrayList<Object> li = new ArrayList<Object>();
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.MASTER.getId());
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.REGION.getId());
        Map<Object, Set<Object>> baseVersionCount = this.getBaseVersionCount(li, new ArrayList<Object>(projectIds), this.entityType);
        HashMap<Object, DynamicObject> sourceDyObjs = new HashMap<Object, DynamicObject>(sourceObjs.length);
        for (DynamicObject sourceObj : sourceObjs) {
            if (!this.planTypeHasRight(syncObj, sourceObj, typedoStatus, baseVersionCount)) continue;
            sourceDyObjs.put(sourceObj.getPkValue(), sourceObj);
            this.getOpPks().add(sourceObj.getPkValue());
        }
        if (sourceDyObjs.size() == 0) {
            return null;
        }
        this.beforeDoEdit(sourceDyObjs);
        List<Object> copyPks = this.queryCopyPks(sourceDyObjs.keySet());
        DynamicObject[] allCopyObjs = BusinessDataServiceHelper.load((Object[])copyPks.toArray(new Object[0]), (DynamicObjectType)this.entityType);
        List<DynamicObject> copyObjs = Arrays.asList(allCopyObjs);
        for (Long sourceType : planTypes) {
            List targetTypes = (List)typeCanDoOperate.get(sourceType);
            for (Long planType : targetTypes) {
                this.copyEdit(sourceDyObjs, copyObjs, ProjectPlanTypeHelper.PlanTypeEnum.getPlanTypeById(sourceType), planType);
            }
        }
        return allCopyObjs;
    }

    public void beforeDoEdit(Map<Object, DynamicObject> sourceDyObjs) {
    }

    public List<Object> queryCopyPks(Set<Object> keySet) {
        QFilter qFilter = new QFilter("sourceid", "in", keySet);
        ArrayList<Object> cppyPks = new ArrayList<Object>(5);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCopyPks", (String)this.entityName, (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                cppyPks.add(row.get(0));
            }
        }
        return cppyPks;
    }

    public void copyEdit(Map<Object, DynamicObject> sourceObjsMap, List<DynamicObject> copyObjs, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, long targetPlanType) {
    }

    public List<Long> getTargetPlanType(DynamicObject planTypeConf, long sourcePlanTypeId, String operate) {
        DynamicObjectCollection entries = planTypeConf.getDynamicObjectCollection("entryentity");
        ArrayList<Long> planTypes = new ArrayList<Long>(2);
        for (DynamicObject entry : entries) {
            long sPlanTypeId = entry.getLong("sourceplantype_id");
            long targetPlanTypeId = entry.getLong("targetplantype_id");
            boolean type = entry.getBoolean(operate);
            if (sPlanTypeId != sourcePlanTypeId || !type) continue;
            planTypes.add(targetPlanTypeId);
        }
        return planTypes;
    }

    public boolean canDoByStatus(DynamicObject planTypeConf, long sourcePlanTypeId) {
        DynamicObjectCollection entries = planTypeConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            long sPlanTypeId = entry.getLong("sourceplantype_id");
            String updatestatus = entry.getString("updatestatus");
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)updatestatus) || sPlanTypeId != sourcePlanTypeId) continue;
            return true;
        }
        return false;
    }

    public boolean hasSyncObj(String syncObj) {
        return true;
    }

    public void delete() {
        List<Object> deletePks = this.doDelete();
        if (!CollectionUtils.isEmpty(deletePks)) {
            DeleteServiceHelper.delete((String)this.entityName, (QFilter[])new QFilter[]{new QFilter("id", "in", deletePks)});
        }
    }

    public List<Object> doDelete() {
        if (CollectionUtils.isEmpty(this.pks)) {
            return null;
        }
        DynamicObject planTypeConf = ProjectPlanAction.queryDefaultConf();
        if (planTypeConf == null) {
            return null;
        }
        String syncObj = planTypeConf.getString("syncobj");
        if (this.hasSyncObj(syncObj)) {
            return null;
        }
        DynamicObjectCollection targetObjs = QueryServiceHelper.query((String)this.entityType.getName(), (String)this.getSelectProp(), (QFilter[])new QFilter("sourceid", "in", this.pks).toArray());
        if (CollectionUtils.isEmpty((Collection)targetObjs)) {
            return null;
        }
        Set planTypes = targetObjs.stream().map(i -> i.getLong("sourceplantype")).collect(Collectors.toSet());
        HashMap<Long, List<Long>> typeCanDoOperate = new HashMap<Long, List<Long>>(planTypes.size());
        HashMap<Long, Boolean> typedoStatus = new HashMap<Long, Boolean>(planTypes.size());
        for (Long planType : planTypes) {
            typeCanDoOperate.put(planType, this.getTargetPlanType(planTypeConf, planType, "edelete"));
            typedoStatus.put(planType, this.canDoByStatus(planTypeConf, planType));
        }
        Set projectIds = targetObjs.stream().map(wbs -> wbs.get("projectnum")).collect(Collectors.toSet());
        HashMap<Long, Set> deletePks = new HashMap<Long, Set>(2);
        ArrayList<Object> li = new ArrayList<Object>();
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.MASTER.getId());
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.REGION.getId());
        Map<Object, Set<Object>> baseVersionCount = this.getBaseVersionCount(li, new ArrayList<Object>(projectIds), this.entityType);
        Iterator it = targetObjs.iterator();
        while (it.hasNext()) {
            DynamicObject obj = (DynamicObject)it.next();
            if (this.isSyncObj(syncObj, obj)) {
                it.remove();
                continue;
            }
            Object project = obj.get("projectnum");
            long sourcePlanType = obj.getLong("sourceplantype");
            Boolean doStatus = (Boolean)typedoStatus.get(sourcePlanType);
            Set<Object> projectBaseVersion = baseVersionCount.get(project);
            if (doStatus.booleanValue() && projectBaseVersion != null && projectBaseVersion.contains(sourcePlanType)) {
                it.remove();
                continue;
            }
            List targetPlanType = (List)typeCanDoOperate.get(sourcePlanType);
            for (Long planType : targetPlanType) {
                Set pks = deletePks.computeIfAbsent(planType, val -> new HashSet());
                pks.add(obj.get("sourceid"));
            }
        }
        ArrayList<Object> deleteObjPks = new ArrayList<Object>(4);
        for (Map.Entry delEntry : deletePks.entrySet()) {
            this.getDeletePks(delEntry.getKey(), (Set)delEntry.getValue(), deleteObjPks);
        }
        return deleteObjPks;
    }

    public void getDeletePks(Object planType, Set<Object> sourceId, List<Object> deletePks) {
        QFilter qFilter = new QFilter("plantype", "=", planType);
        qFilter.and("sourceid", "in", sourceId);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)this.entityName, (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject obj : objs) {
            deletePks.add(obj.get(0));
        }
    }

    public boolean isSyncObj(String syncObj, DynamicObject obj) {
        return false;
    }

    public String getSelectProp() {
        return "id,projectnum,plantype,sourceplantype,sourceid";
    }

    public Map<Object, Set<Object>> getBaseVersionCount(List<Object> sourcePlanTypeIds, List<Object> projectPks, MainEntityType entityType) {
        QFilter qFilter = new QFilter("projectnum", "in", projectPks);
        qFilter.and("plantype", "in", sourcePlanTypeIds);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        List<Object> baseVersionTypePk = this.getBaseVersionTypePk();
        if (!CollectionUtils.isEmpty(baseVersionTypePk)) {
            qFilter.and("versiontype", "in", baseVersionTypePk);
        }
        DynamicObjectCollection baseVersion = QueryServiceHelper.query((String)"mpdm_gantt_version_tbase", (String)"projectnum,plantype", (QFilter[])qFilter.toArray());
        HashMap<Object, Set<Object>> versionCount = new HashMap<Object, Set<Object>>(projectPks.size());
        for (DynamicObject version : baseVersion) {
            Object projectd = version.get(0);
            Object plantyped = version.get(1);
            Set protype = versionCount.computeIfAbsent(projectd, val -> new HashSet(2));
            protype.add(plantyped);
        }
        return versionCount;
    }

    public List<Object> getBaseVersionTypePk() {
        QFilter typeQFilter = new QFilter("number", "in", Arrays.asList("masterplan_baseline", "regionplan_baseline", "industryplan_baseline"));
        DynamicObjectCollection ganttVersionTypes = QueryServiceHelper.query((String)"mpdm_gantt_versiontype", (String)"id", (QFilter[])new QFilter[]{typeQFilter});
        return ganttVersionTypes.stream().map(i -> i.get(0)).collect(Collectors.toList());
    }

    public List<Object> getPks() {
        return this.pks;
    }

    public void setPks(List<Object> pks) {
        this.pks = pks;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public List<Object> getOpPks() {
        if (this.opPks == null) {
            this.opPks = new ArrayList<Object>(this.pks == null ? 2 : this.pks.size());
        }
        return this.opPks;
    }

    public void setOpPks(List<Object> opPks) {
        this.opPks = opPks;
    }
}

