/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.gantt.util.GanttVersionUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.util.BindOrderUtils;

public class ProjectPlanReleaseHelper {
    public static final String MPDM_GANTT_VERSION_TASK = "mpdm_gantt_version_task";
    public static final Set<String> TASK_EXCLUDEFIELDS = new HashSet<String>();
    public static final Set<String> WBS_EXCLUDEFIELDS = new HashSet<String>();
    public static final Map<Long, Long> PLANTYPE_VERSIONTYPE = new LinkedHashMap<Long, Long>(4);

    public static void release(Map<String, Object> param, Object projectId, Object planTypeId, Set<Long> dataIds, String filterStr) {
        DynamicObject[] taskDatas = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task"));
        DynamicObject[] wbsDatas = BusinessDataServiceHelper.load((Object[])dataIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_wbs"));
        DynamicObject version = ProjectPlanReleaseHelper.createVersion(param, projectId, planTypeId, filterStr);
        LinkedHashMap<Object, Object> relations = new LinkedHashMap<Object, Object>();
        ProjectPlanReleaseHelper.createVersionWBSDatas(version, wbsDatas, relations);
        ProjectPlanReleaseHelper.createVersionTaskDatas(version, taskDatas, relations);
    }

    public static void unRelease(Object versionId) {
        DynamicObject[] taskVersionDatas = ProjectPlanReleaseHelper.loadDatas("pmts_task", new QFilter("version", "=", versionId).toArray());
        DynamicObject[] wbsVersionDatas = ProjectPlanReleaseHelper.loadDatas("pmts_wbs", new QFilter("version", "=", versionId).toArray());
        LinkedHashMap<Object, Object> relations = new LinkedHashMap<Object, Object>();
        ProjectPlanReleaseHelper.rollBackWBSDatas(wbsVersionDatas, relations);
        ProjectPlanReleaseHelper.rollBackTaskDatas(taskVersionDatas, relations);
    }

    public static DynamicObject createVersion(Map<String, Object> param, Object projectId, Object planTypeId, String filterStr) {
        String versionName = (String)param.get("name");
        DynamicObject version = QueryServiceHelper.queryOne((String)MPDM_GANTT_VERSION_TASK, (String)"id", (QFilter[])new QFilter("name", "=", (Object)versionName).toArray());
        if (version != null) {
            version = BusinessDataServiceHelper.loadSingle((Object)version.get("id"), (String)MPDM_GANTT_VERSION_TASK);
            DeleteServiceHelper.delete((String)"pmts_task", (QFilter[])new QFilter("version", "=", version.getPkValue()).toArray());
            DeleteServiceHelper.delete((String)"pmts_wbs", (QFilter[])new QFilter("version", "=", version.getPkValue()).toArray());
        } else {
            version = BusinessDataServiceHelper.newDynamicObject((String)MPDM_GANTT_VERSION_TASK);
            version.set("id", (Object)ID.genLongId());
        }
        version.set("projectnum", projectId);
        version.set("plantype", planTypeId);
        version.set("filterstr_tag", (Object)filterStr);
        version.set("sourcetype", (Object)"1");
        version.set("versiontype", (Object)PLANTYPE_VERSIONTYPE.get(planTypeId));
        version.set("createorg", (Object)RequestContext.get().getOrgId());
        version.set("number", (Object)GanttVersionUtils.getVersionNumber((DynamicObject)version));
        version.set("name", (Object)versionName);
        version.set("status", (Object)"C");
        version.set("enable", (Object)"1");
        version.set("ctrlstrategy", (Object)"5");
        version.set("creator", (Object)RequestContext.get().getCurrUserId());
        version.set("createtime", (Object)System.currentTimeMillis());
        version.set("modifier", (Object)RequestContext.get().getCurrUserId());
        version.set("modifytime", (Object)System.currentTimeMillis());
        version.set("auditor", (Object)RequestContext.get().getCurrUserId());
        version.set("audittime", (Object)System.currentTimeMillis());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{version});
        return version;
    }

    public static void createVersionWBSDatas(DynamicObject version, DynamicObject[] datas, Map<Object, Object> relationMap) {
        OperationServiceHelper.executeOperate((String)"submit", (String)"pmts_wbs", (DynamicObject[])datas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"audit", (String)"pmts_wbs", (DynamicObject[])datas, (OperateOption)OperateOption.create());
        long[] ids = ID.genLongIds((int)datas.length);
        ArrayList<DynamicObject> newDatas = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject data = datas[i];
            DynamicObject newData = ProjectPlanReleaseHelper.createWbsObj(data, version, ids[i]);
            relationMap.put(data.getPkValue(), newData.getPkValue());
            newDatas.add(newData);
        }
        SaveServiceHelper.save((DynamicObject[])newDatas.toArray(new DynamicObject[0]));
        ProjectPlanReleaseHelper.replaceWbsDatas(newDatas.toArray(new DynamicObject[0]), relationMap);
        ProjectPlanReleaseHelper.updateReleaseWbsDatas(datas, relationMap);
    }

    public static void createVersionTaskDatas(DynamicObject version, DynamicObject[] datas, Map<Object, Object> relationMap) {
        OperationServiceHelper.executeOperate((String)"submit", (String)"pmts_task", (DynamicObject[])datas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"audit", (String)"pmts_task", (DynamicObject[])datas, (OperateOption)OperateOption.create());
        long[] ids = ID.genLongIds((int)datas.length);
        ArrayList<DynamicObject> newDatas = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject data = datas[i];
            DynamicObject newData = ProjectPlanReleaseHelper.createTaskObj(data, version, ids[i]);
            relationMap.put(data.getPkValue(), newData.getPkValue());
            newDatas.add(newData);
        }
        SaveServiceHelper.save((DynamicObject[])newDatas.toArray(new DynamicObject[0]));
        ProjectPlanReleaseHelper.replaceTaskDatas(newDatas.toArray(new DynamicObject[0]), relationMap);
        ProjectPlanReleaseHelper.updateReleaseTaskDatas(datas, relationMap);
    }

    public static void updateReleaseTaskDatas(DynamicObject[] datas, Map<Object, Object> relations) {
        for (DynamicObject data : datas) {
            data.set("releasestatus", (Object)"1");
            data.set("deletestatus", (Object)"A");
            data.set("releasetask_id", relations.get(data.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    public static void updateReleaseWbsDatas(DynamicObject[] datas, Map<Object, Object> relations) {
        for (DynamicObject data : datas) {
            data.set("releasestatus", (Object)"1");
            data.set("deletestatus", (Object)"A");
            data.set("releasewbs_id", relations.get(data.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    public static void updateUnReleaseTaskDatas(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            data.set("releasestatus", (Object)"0");
            data.set("deletestatus", (Object)"A");
            data.set("version", null);
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    public static void updateUnReleaseWbsDatas(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            data.set("releasestatus", (Object)"0");
            data.set("deletestatus", (Object)"A");
            data.set("version", null);
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    public static void rollBackWBSDatas(DynamicObject[] versionDatas, Map<Object, Object> relations) {
        DynamicObject[] initDatas;
        Map<Object, DynamicObject> versionDataMap = ProjectPlanReleaseHelper.getDynamicObjectMap(versionDatas);
        Map<Object, Object> initToVersion = ProjectPlanReleaseHelper.initToVersion(versionDatas);
        for (DynamicObject initWbs : initDatas = ProjectPlanReleaseHelper.loadDatas("pmts_wbs", new QFilter("id", "in", initToVersion.keySet()).toArray())) {
            Object versionWbsId = initToVersion.get(initWbs.getPkValue());
            relations.put(versionWbsId, initWbs.getPkValue());
            DynamicObject versionWbs = versionDataMap.get(versionWbsId);
            ProjectPlanReleaseHelper.copyDynamicObject(WBS_EXCLUDEFIELDS, versionWbs, initWbs);
        }
        SaveServiceHelper.save((DynamicObject[])initDatas);
        ProjectPlanReleaseHelper.replaceWbsDatas(initDatas, relations);
        ProjectPlanReleaseHelper.updateUnReleaseWbsDatas(initDatas);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"pmts_wbs", (DynamicObject[])initDatas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pmts_wbs", (DynamicObject[])initDatas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"pmts_wbs", (DynamicObject[])versionDatas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pmts_wbs", (DynamicObject[])versionDatas, (OperateOption)OperateOption.create());
    }

    public static void rollBackTaskDatas(DynamicObject[] versionDatas, Map<Object, Object> relations) {
        DynamicObject[] initDatas;
        Map<Object, DynamicObject> versionDataMap = ProjectPlanReleaseHelper.getDynamicObjectMap(versionDatas);
        Map<Object, Object> initToVersion = ProjectPlanReleaseHelper.initToVersion(versionDatas);
        for (DynamicObject initTask : initDatas = ProjectPlanReleaseHelper.loadDatas("pmts_task", new QFilter("id", "in", initToVersion.keySet()).toArray())) {
            Object versionTaskId = initToVersion.get(initTask.getPkValue());
            relations.put(versionTaskId, initTask.getPkValue());
            DynamicObject versionTask = versionDataMap.get(versionTaskId);
            ProjectPlanReleaseHelper.copyDynamicObject(TASK_EXCLUDEFIELDS, versionTask, initTask);
        }
        SaveServiceHelper.save((DynamicObject[])initDatas);
        ProjectPlanReleaseHelper.replaceTaskDatas(initDatas, relations);
        ProjectPlanReleaseHelper.updateUnReleaseTaskDatas(initDatas);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"pmts_task", (DynamicObject[])initDatas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pmts_task", (DynamicObject[])initDatas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"pmts_task", (DynamicObject[])versionDatas, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pmts_task", (DynamicObject[])versionDatas, (OperateOption)OperateOption.create());
    }

    private static Map<Object, DynamicObject> getDynamicObjectMap(DynamicObject[] datas) {
        LinkedHashMap<Object, DynamicObject> dynamicObjectMap = new LinkedHashMap<Object, DynamicObject>(16);
        for (DynamicObject data : datas) {
            dynamicObjectMap.put(data.getPkValue(), data);
        }
        return dynamicObjectMap;
    }

    private static Map<Object, Object> initToVersion(DynamicObject[] versionDatas) {
        LinkedHashMap<Object, Object> relationMap = new LinkedHashMap<Object, Object>(16);
        for (DynamicObject versionData : versionDatas) {
            relationMap.put(versionData.getLong("initid"), versionData.getPkValue());
        }
        return relationMap;
    }

    public static DynamicObject[] loadDatas(String entity, QFilter[] qFilters) {
        LinkedHashSet pkValues = new LinkedHashSet(16);
        DynamicObjectCollection col = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])qFilters);
        col.forEach(obj -> pkValues.add(obj.getLong("id")));
        return BusinessDataServiceHelper.load((Object[])pkValues.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entity));
    }

    public static DynamicObject[] replaceTaskDatas(DynamicObject[] tasks, Map<Object, Object> relationMap) {
        for (DynamicObject task : tasks) {
            DynamicObject wbs = task.getDynamicObject("wbs");
            if (wbs != null) {
                task.set("wbs_id", relationMap.get(wbs.getPkValue()));
            }
            DynamicObjectCollection frontEntrys = task.getDynamicObjectCollection("prepositiontaskentry");
            for (DynamicObject entry : frontEntrys) {
                DynamicObject frontTask = entry.getDynamicObject("prepositiontask");
                if (frontTask == null || relationMap.get(frontTask.getPkValue()) == null) continue;
                entry.set("prepositiontask_id", relationMap.get(frontTask.getPkValue()));
            }
            DynamicObjectCollection postEntrys = task.getDynamicObjectCollection("postpositiontaskentry");
            for (DynamicObject entry : postEntrys) {
                DynamicObject postTask = entry.getDynamicObject("postpositiontask");
                if (postTask == null || relationMap.get(postTask.getPkValue()) == null) continue;
                entry.set("postpositiontask_id", relationMap.get(postTask.getPkValue()));
            }
        }
        SaveServiceHelper.update((DynamicObject[])tasks);
        ProjectPlanReleaseHelper.copyCardRelations(relationMap);
        return tasks;
    }

    public static DynamicObject[] replaceWbsDatas(DynamicObject[] wbses, Map<Object, Object> relationMap) {
        for (DynamicObject wbs : wbses) {
            DynamicObject parent = wbs.getDynamicObject("parent");
            if (parent == null || relationMap.get(parent.getPkValue()) == null) continue;
            wbs.set("parent_id", relationMap.get(parent.getPkValue()));
        }
        SaveServiceHelper.update((DynamicObject[])wbses);
        return wbses;
    }

    public static DynamicObject createTaskObj(DynamicObject data, DynamicObject version, Object id) {
        CloneUtils cloneUtils = new CloneUtils(false, true);
        DynamicObject newData = (DynamicObject)cloneUtils.clone((IDataEntityBase)data);
        newData.set("id", id);
        newData.set("masterid", id);
        newData.set("version", (Object)version);
        newData.set("createtime", (Object)new Date());
        newData.set("modifytime", (Object)new Date());
        newData.set("creator", (Object)RequestContext.get().getCurrUserId());
        newData.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newData.set("number", (Object)(data.getString("number") + "&" + version.getString("name")));
        newData.set("initid", data.getPkValue());
        newData.set("releasestatus", (Object)"1");
        return newData;
    }

    public static DynamicObject createWbsObj(DynamicObject data, DynamicObject version, Object id) {
        CloneUtils cloneUtils = new CloneUtils(false, true);
        DynamicObject newData = (DynamicObject)cloneUtils.clone((IDataEntityBase)data);
        newData.set("id", id);
        newData.set("masterid", id);
        newData.set("version", (Object)version);
        newData.set("createtime", (Object)new Date());
        newData.set("modifytime", (Object)new Date());
        newData.set("creator", (Object)RequestContext.get().getCurrUserId());
        newData.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newData.set("number", (Object)(data.getString("number") + "&" + version.getString("name")));
        newData.set("initid", data.getPkValue());
        newData.set("releasestatus", (Object)"1");
        return newData;
    }

    public static void copyCardRelations(Map<Object, Object> relationMap) {
        List<String> targetBillIds = ProjectPlanReleaseHelper.objectToString(relationMap.values());
        BindOrderUtils.deleteTargetBillRelations(targetBillIds, (String)"sfc_mromanuftech");
        QFilter qFilter = new QFilter("targetbillid", "in", ProjectPlanReleaseHelper.objectToString(relationMap.keySet()));
        qFilter = qFilter.and(new QFilter("targetbilltype", "=", (Object)"pmts_task"));
        DynamicObjectCollection cardRelations = QueryServiceHelper.query((String)"fmm_task_relations", (String)"id", (QFilter[])qFilter.toArray());
        LinkedHashSet releationIds = new LinkedHashSet();
        cardRelations.forEach(relation -> releationIds.add(relation.getLong("id")));
        DynamicObject[] relations = BusinessDataServiceHelper.load((Object[])releationIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fmm_task_relations"));
        ArrayList<DynamicObject> newRelations = new ArrayList<DynamicObject>(16);
        CloneUtils cloneUtils = new CloneUtils(false, true);
        for (DynamicObject relation2 : relations) {
            DynamicObject newRelation = (DynamicObject)cloneUtils.clone((IDataEntityBase)relation2);
            long oldTaskId = Long.parseLong(relation2.getString("targetbillid"));
            Object newTaskId = relationMap.get(oldTaskId);
            newRelation.set("targetbillid", newTaskId);
            newRelations.add(newRelation);
        }
        SaveServiceHelper.save((DynamicObject[])newRelations.toArray(new DynamicObject[0]));
    }

    public static void copyDynamicObject(Set<String> excludeKeys, DynamicObject fromObj, DynamicObject toObj) {
        DynamicObjectType dynamicObjectType = toObj.getDynamicObjectType();
        ISimpleProperty primaryKey = dynamicObjectType.getPrimaryKey();
        String primaryKeyName = primaryKey.getName();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (excludeKeys.contains(name) || StringUtils.equals((CharSequence)primaryKeyName, (CharSequence)name) || property instanceof DynamicLocaleProperty) continue;
            if (property instanceof EntryProp || property instanceof MulBasedataProp) {
                DynamicObjectCollection toObjCol = toObj.getDynamicObjectCollection(name);
                toObjCol.clear();
                DynamicObjectCollection fromObjCol = fromObj.getDynamicObjectCollection(name);
                for (DynamicObject fromEntry : fromObjCol) {
                    DynamicObject toEntry = toObjCol.addNew();
                    ProjectPlanReleaseHelper.copyDynamicObject(excludeKeys, fromEntry, toEntry);
                }
                continue;
            }
            toObj.set(name, fromObj.get(name));
        }
    }

    private static List<String> objectToString(Collection collection) {
        ArrayList objects = new ArrayList(collection);
        ArrayList<String> stringList = new ArrayList<String>(objects.size());
        objects.forEach(object -> stringList.add(object.toString()));
        return stringList;
    }

    static {
        TASK_EXCLUDEFIELDS.add("version");
        TASK_EXCLUDEFIELDS.add("version_id");
        TASK_EXCLUDEFIELDS.add("number");
        TASK_EXCLUDEFIELDS.add("name");
        TASK_EXCLUDEFIELDS.add("initid");
        TASK_EXCLUDEFIELDS.add("releasetask");
        TASK_EXCLUDEFIELDS.add("releasetask_id");
        TASK_EXCLUDEFIELDS.add("masterid");
        TASK_EXCLUDEFIELDS.add("status");
        WBS_EXCLUDEFIELDS.add("version");
        WBS_EXCLUDEFIELDS.add("version_id");
        WBS_EXCLUDEFIELDS.add("number");
        WBS_EXCLUDEFIELDS.add("name");
        WBS_EXCLUDEFIELDS.add("initid");
        WBS_EXCLUDEFIELDS.add("releasewbs");
        WBS_EXCLUDEFIELDS.add("releasewbs_id");
        WBS_EXCLUDEFIELDS.add("masterid");
        WBS_EXCLUDEFIELDS.add("status");
        PLANTYPE_VERSIONTYPE.put(1437660575319473152L, 1566037799071759360L);
        PLANTYPE_VERSIONTYPE.put(1437660676930681856L, 1569102666401852416L);
        PLANTYPE_VERSIONTYPE.put(1437660742504453120L, 1569102224406096896L);
        PLANTYPE_VERSIONTYPE.put(0L, 1565962687752550400L);
    }
}

