/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.CopyHelper;
import kd.pmc.pmts.business.helper.ProjectPlanAction;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;

public class ProjectPlanTaskAction
extends ProjectPlanAction {
    protected List<DynamicObject> cardRelation;
    private List<Object> cardTargetPks;
    private Map<Object, Map<Object, Object>> copyPlanTypeData;
    private static final String[] copyProp = new String[]{"name", "projectstage", "scheduletype", "planarea", "trade", "workshift", "responsorg", "responsperson", "planner", "workspace", "importanttask", "durationunit", "plantime", "actualtime", "needtime", "finishtime", "taskcalendar", "tasktype", "tasklevel", "priority", "timetype", "percenttype", "limitone", "limitonedate", "limittwo", "limittwodate", "planstartdate", "planenddate"};
    protected Map<Object, List<DynamicObject>> sourceCardRelation;

    public ProjectPlanTaskAction(List<Object> pks) {
        super(pks, "pmts_task");
    }

    @Override
    public List<DynamicObject> copy(ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
        List<DynamicObject> copyObjs = super.copy(sourcePlanType, targetPlanType);
        this.saveOrUpdateCardRelation(false);
        return copyObjs;
    }

    @Override
    public void copy(List<DynamicObject> objs, List<DynamicObject> copyObjs, String[] numbers, long[] ids, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
        List<Object> wbsPks = objs.stream().filter(i -> i.getDynamicObject("wbs") != null).map(i -> i.getDynamicObject("wbs").getPkValue()).collect(Collectors.toList());
        Map<Object, DynamicObject> copyWbsPks = this.queryCopyWbsPks(wbsPks, targetPlanType);
        Map<Object, List<DynamicObject>> taskBindCard = this.getSourceCardRelation();
        for (int i2 = 0; i2 < objs.size(); ++i2) {
            DynamicObject obj = objs.get(i2);
            DynamicObject plantype = obj.getDynamicObject("plantype");
            if (plantype == null) continue;
            DynamicObject copyObj = (DynamicObject)OrmUtils.clone((Object)obj, (IDataEntityType)this.getEntityType(), (boolean)true, (boolean)true);
            long id = 0L;
            String number = null;
            if (numbers != null && i2 < numbers.length) {
                number = numbers[i2];
            }
            if (ids != null && i2 < ids.length) {
                id = ids[i2];
            }
            this.resetField(copyObj, obj, sourcePlanType, targetPlanType, id, number);
            DynamicObject wbs = copyObj.getDynamicObject("wbs");
            if (wbs != null) {
                DynamicObject copyWbs = copyWbsPks.get(wbs.getPkValue());
                copyObj.set("wbs_id", copyWbs == null ? null : copyWbs.get("id"));
            }
            this.addCardRelation(obj.getPkValue(), taskBindCard, id);
            this.copyPositionTask(obj, copyObj, targetPlanType.getId());
            copyObjs.add(copyObj);
        }
    }

    public void copyPositionTask(DynamicObject sourceObj, DynamicObject copyObj, long targetPlanType) {
        this.copyPositionEntry(sourceObj, copyObj, targetPlanType, "prepositiontaskentry", "prepositiontask_id", "taskrelation", "predelayed");
        this.copyPositionEntry(sourceObj, copyObj, targetPlanType, "postpositiontaskentry", "postpositiontask_id", "taskrelationtwo", "postdelayed");
    }

    public void copyPositionEntry(DynamicObject sourceObj, DynamicObject copyObj, long targetPlanType, String entryName, String taskField, String taskrelationField, String predelayedField) {
        DynamicObjectCollection sourceEntry = sourceObj.getDynamicObjectCollection(entryName);
        DynamicObjectCollection copyEntry = copyObj.getDynamicObjectCollection(entryName);
        copyEntry.clear();
        for (DynamicObject entry : sourceEntry) {
            Object id;
            Object tasPk = entry.get(taskField);
            Map<Object, Object> obj = this.copyPlanTypeData.get(tasPk);
            if (obj == null || (id = obj.get(targetPlanType)) == null) continue;
            DynamicObject copy = copyEntry.addNew();
            copy.set(taskField, id);
            copy.set(taskrelationField, entry.get(taskrelationField));
            copy.set(predelayedField, entry.get(predelayedField));
        }
    }

    public void addCardRelation(Object pkValue, Map<Object, List<DynamicObject>> taskBindCard, long copyPk) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fmm_task_relations");
        if (taskBindCard == null) {
            return;
        }
        String targetPk = String.valueOf(copyPk);
        this.getCardTargetPks().add(targetPk);
        List<DynamicObject> list = taskBindCard.get(String.valueOf(pkValue));
        if (list == null) {
            return;
        }
        List<DynamicObject> cardRelation = this.getCardRelation();
        for (DynamicObject dynamicObject : list) {
            DynamicObject obj = (DynamicObject)OrmUtils.clone((Object)dynamicObject, (IDataEntityType)entityType, (boolean)true, (boolean)true);
            obj.set("targetbillid", (Object)targetPk);
            cardRelation.add(obj);
        }
    }

    public Map<Object, List<DynamicObject>> queryTaskBindCard(List<Object> targetIds, String sourceBillType) {
        if (CollectionUtils.isEmpty(targetIds)) {
            return new HashMap<Object, List<DynamicObject>>(0);
        }
        List ids = targetIds.stream().map(String::valueOf).collect(Collectors.toList());
        QFilter qFilter = new QFilter("targetbillid", "in", ids);
        qFilter = qFilter.and(new QFilter("sourcebilltype", "=", (Object)sourceBillType));
        DynamicObjectCollection taskRelations = QueryServiceHelper.query((String)"fmm_task_relations", (String)"sourcebilltype,sourcebillid,sourcebillentryid,targetbilltype,targetbillid,targetbillentryid", (QFilter[])qFilter.toArray());
        return taskRelations.stream().collect(Collectors.groupingBy(i -> i.get("targetbillid")));
    }

    @Override
    public void add() {
        super.add();
        this.saveOrUpdateCardRelation(false);
    }

    @Override
    public boolean hasSyncObj(String syncObj) {
        if (syncObj == null) {
            return true;
        }
        boolean hasTask = syncObj.contains("C");
        boolean hasMilestone = syncObj.contains("B");
        if (hasTask || hasMilestone) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isSyncObj(String syncObj, DynamicObject obj) {
        if (syncObj == null) {
            return true;
        }
        boolean hasTask = syncObj.contains("C");
        boolean hasMilestone = syncObj.contains("B");
        if (!hasTask && !hasMilestone) {
            return true;
        }
        String type = obj.getString("scheduletype");
        if (!hasTask && StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
            return true;
        }
        return !hasMilestone && StringUtils.equals((CharSequence)"3", (CharSequence)type);
    }

    @Override
    public void copyEdit(Map<Object, DynamicObject> sourceObjsMap, List<DynamicObject> copyObjs, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, long targetPlanType) {
        List<Object> wbsPks = sourceObjsMap.values().stream().filter(i -> i.getDynamicObject("wbs") != null).map(i -> i.getDynamicObject("wbs").getPkValue()).collect(Collectors.toList());
        Map<Object, DynamicObject> copyWbsPks = this.queryCopyWbsPks(wbsPks, ProjectPlanTypeHelper.PlanTypeEnum.getPlanTypeById(targetPlanType));
        DataEntityPropertyCollection properties = this.getEntityType().getProperties();
        Map<Object, List<DynamicObject>> taskBindCard = this.getSourceCardRelation();
        for (DynamicObject copyObj : copyObjs) {
            long plantypeId = copyObj.getLong("plantype_id");
            if (plantypeId != targetPlanType) continue;
            Object sourcePk = copyObj.get("sourceid");
            DynamicObject sourceObj = sourceObjsMap.get(sourcePk);
            for (String prop : copyProp) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)prop);
                if (property instanceof BasedataProp) {
                    IDataEntityProperty refProp = ((BasedataProp)property).getRefIdProp();
                    String refName = refProp.getName();
                    copyObj.set(refName, sourceObj.get(refName));
                    continue;
                }
                copyObj.set(prop, sourceObj.get(prop));
            }
            DynamicObject wbs = sourceObj.getDynamicObject("wbs");
            if (wbs != null) {
                DynamicObject copyWbs = copyWbsPks.get(wbs.getPkValue());
                copyObj.set("wbs_id", copyWbs == null ? null : copyWbs.get("id"));
            }
            copyObj.set("name", sourceObj.get("name"));
            CopyHelper.copyCollection((IDataEntityProperty)this.getEntityType().getProperty("multilanguagetext"), sourceObj, copyObj, true, null);
            this.copyPositionTask(sourceObj, copyObj, targetPlanType);
            this.addCardRelation(copyObj.get("sourceid"), taskBindCard, copyObj.getLong("id"));
        }
    }

    @Override
    public void edit() {
        super.edit();
        this.saveOrUpdateCardRelation(true);
    }

    public void saveOrUpdateCardRelation(boolean update) {
        if (update) {
            this.deleteCardRelation(this.getCardTargetPks());
        }
        if (this.cardRelation == null) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])this.cardRelation.toArray(new DynamicObject[0]));
    }

    public void deleteCardRelation(Collection<Object> targetbillids) {
        if (CollectionUtils.isEmpty(targetbillids)) {
            return;
        }
        List pks = targetbillids.stream().map(i -> String.valueOf(i)).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"fmm_task_relations", (QFilter[])new QFilter[]{new QFilter("targetbillid", "in", pks)});
    }

    @Override
    public void delete() {
        List<Object> deletePks = this.doDelete();
        if (!CollectionUtils.isEmpty(deletePks)) {
            DeleteServiceHelper.delete((String)this.getEntityName(), (QFilter[])new QFilter[]{new QFilter("id", "in", deletePks)});
        }
        if (!CollectionUtils.isEmpty(deletePks)) {
            this.deleteCardRelation(deletePks);
        }
    }

    public void editCardRelation() {
        if (CollectionUtils.isEmpty((Collection)this.pks)) {
            return;
        }
        this.getOpPks().addAll(this.pks);
        DynamicObject planTypeConf = ProjectPlanTaskAction.queryDefaultConf();
        if (planTypeConf == null) {
            return;
        }
        String syncObj = planTypeConf.getString("syncobj");
        if (this.hasSyncObj(syncObj)) {
            return;
        }
        DynamicObject[] sourceObjs = BusinessDataServiceHelper.load((String)this.entityName, (String)this.getSelectProp(), (QFilter[])new QFilter("id", "in", (Object)this.pks).toArray());
        if (sourceObjs == null) {
            return;
        }
        Set planTypes = Stream.of(sourceObjs).map(i -> i.getLong("plantype_id")).collect(Collectors.toSet());
        HashMap<Long, List<Long>> typeCanDoOperate = new HashMap<Long, List<Long>>(planTypes.size());
        HashMap<Object, Boolean> typedoStatus = new HashMap<Object, Boolean>(planTypes.size());
        for (Long planType : planTypes) {
            typeCanDoOperate.put(planType, this.getTargetPlanType(planTypeConf, planType, "eedit"));
            typedoStatus.put(planType, this.canDoByStatus(planTypeConf, planType));
        }
        Set projectIds = Stream.of(sourceObjs).map(i -> i.get("projectnum_id")).collect(Collectors.toSet());
        ArrayList<Object> li = new ArrayList<Object>();
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.MASTER.getId());
        li.add(ProjectPlanTypeHelper.PlanTypeEnum.REGION.getId());
        Map<Object, Set<Object>> baseVersionCount = this.getBaseVersionCount(li, new ArrayList<Object>(projectIds), this.entityType);
        HashMap<Object, DynamicObject> sourceDyObjs = new HashMap<Object, DynamicObject>(sourceObjs.length);
        for (DynamicObject sourceObj : sourceObjs) {
            if (!this.planTypeHasRight(syncObj, sourceObj, typedoStatus, baseVersionCount)) continue;
            sourceDyObjs.put(sourceObj.getPkValue(), sourceObj);
            this.getOpPks().add(sourceObj.getPkValue());
        }
        List<Object> copyPks = this.queryCopyPks(sourceDyObjs.keySet());
        DynamicObject[] allCopyObjs = BusinessDataServiceHelper.load((Object[])copyPks.toArray(new Object[0]), (DynamicObjectType)this.entityType);
        List<DynamicObject> copyObjs = Arrays.asList(allCopyObjs);
        for (Long sourceType : planTypes) {
            List targetTypes = (List)typeCanDoOperate.get(sourceType);
            for (Long planType : targetTypes) {
                this.getCardRelation(copyObjs, planType);
            }
        }
        this.saveOrUpdateCardRelation(true);
    }

    public void getCardRelation(List<DynamicObject> copyObjs, long targetPlanType) {
        Map<Object, List<DynamicObject>> taskBindCard = this.getSourceCardRelation();
        for (DynamicObject copyObj : copyObjs) {
            long plantypeId = copyObj.getLong("plantype_id");
            if (plantypeId != targetPlanType) continue;
            this.addCardRelation(copyObj.get("sourceid"), taskBindCard, copyObj.getLong("id"));
        }
    }

    @Override
    public String getSelectProp() {
        return "id,projectnum,plantype,scheduletype,sourceplantype,sourceid";
    }

    public List<Object> getCardTargetPks() {
        if (this.cardTargetPks == null) {
            this.cardTargetPks = new ArrayList<Object>(2);
        }
        return this.cardTargetPks;
    }

    public List<DynamicObject> getCardRelation() {
        if (this.cardRelation == null) {
            this.cardRelation = new ArrayList<DynamicObject>(2);
        }
        return this.cardRelation;
    }

    public Map<Object, List<DynamicObject>> getSourceCardRelation() {
        if (this.sourceCardRelation == null) {
            this.sourceCardRelation = this.queryTaskBindCard(this.getOpPks(), "sfc_mromanuftech");
        }
        return this.sourceCardRelation;
    }

    @Override
    public void beforeDoAdd(Map<Long, List<DynamicObject>> sourceDyObjs) {
        HashSet<Object> taskPks = new HashSet<Object>(sourceDyObjs.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : sourceDyObjs.entrySet()) {
            for (DynamicObject dynamicObject : entry.getValue()) {
                this.addRelationTaskPk(dynamicObject.getDynamicObjectCollection("prepositiontaskentry"), "prepositiontask_id", taskPks);
                this.addRelationTaskPk(dynamicObject.getDynamicObjectCollection("postpositiontaskentry"), "postpositiontask_id", taskPks);
            }
        }
        this.queryCopyPlanTypeData(taskPks);
    }

    @Override
    public void beforeDoEdit(Map<Object, DynamicObject> sourceDyObjs) {
        HashSet<Object> taskPks = new HashSet<Object>(sourceDyObjs.size());
        for (Map.Entry<Object, DynamicObject> entry : sourceDyObjs.entrySet()) {
            DynamicObject obj = entry.getValue();
            this.addRelationTaskPk(obj.getDynamicObjectCollection("prepositiontaskentry"), "prepositiontask_id", taskPks);
            this.addRelationTaskPk(obj.getDynamicObjectCollection("postpositiontaskentry"), "postpositiontask_id", taskPks);
        }
        this.queryCopyPlanTypeData(taskPks);
    }

    private void addRelationTaskPk(DynamicObjectCollection prepositiontaskentry, String taskPk, Set<Object> taskPks) {
        for (DynamicObject dynamicObject : prepositiontaskentry) {
            taskPks.add(dynamicObject.get(taskPk));
        }
    }

    private void queryCopyPlanTypeData(Set<Object> taskPks) {
        QFilter qFilter = new QFilter("sourceid", "in", taskPks);
        DynamicObjectCollection data = QueryServiceHelper.query((String)this.entityName, (String)"plantype,id,sourceid", (QFilter[])qFilter.toArray(), (String)"createtime desc");
        this.copyPlanTypeData = new HashMap<Object, Map<Object, Object>>(taskPks.size());
        for (DynamicObject obj : data) {
            Object id = obj.get("id");
            Object souceid = obj.get("sourceid");
            Object sourceplantype = obj.get("plantype");
            Map copyType = this.copyPlanTypeData.computeIfAbsent(souceid, val -> new HashMap(2));
            copyType.put(sourceplantype, id);
        }
    }
}

