/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTaskAction;
import kd.pmc.pmts.business.helper.ProjectPlanWbsAction;

public class ProjectPlanTypeHelper {
    public static void copyMasterPlan(Map<String, List<Object>> masterPlan, PlanTypeEnum sourcePlanType, PlanTypeEnum targetPlanType, Long projectId) {
        List<Object> wbsPks = masterPlan.get("wbs");
        new ProjectPlanWbsAction(wbsPks).copy(sourcePlanType, targetPlanType);
        List<Object> taskPks = masterPlan.get("task");
        new ProjectPlanTaskAction(taskPks).copy(sourcePlanType, targetPlanType);
    }

    public static void projectPlanTypeTaskAdd(List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskAdd(null, taskPks);
    }

    public static void projectPlanTypeTaskEdit(List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskEdit(null, taskPks);
    }

    public static void projectPlanTypeTaskDelete(List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskDelete(null, taskPks);
    }

    public static void projectPlanTypeWbsAdd(List<Object> wbsPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskAdd(wbsPks, null);
    }

    public static void projectPlanTypeWbsEdit(List<Object> wbsPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskEdit(wbsPks, null);
    }

    public static void projectPlanTypeWbsDelete(List<Object> wbsPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskDelete(wbsPks, null);
    }

    public static void projectPlanTypeWbsTaskAdd(List<Object> wbsPks, List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskTrigger(wbsPks, taskPks, "add");
    }

    public static void projectPlanTypeWbsTaskEdit(List<Object> wbsPks, List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskTrigger(wbsPks, taskPks, "edit");
    }

    public static void projectPlanTypeWbsTaskDelete(List<Object> wbsPks, List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskTrigger(wbsPks, taskPks, "delete");
    }

    public static void projectPlanTypeTaskBindCard(List<Object> taskPks) {
        ProjectPlanTypeHelper.projectPlanTypeWbsTaskTrigger(null, taskPks, "bindcard");
    }

    public static void projectPlanTypeWbsTaskTrigger(List<Object> wbsPks, List<Object> taskPks, String operate) {
        if (CollectionUtils.isEmpty(wbsPks) && CollectionUtils.isEmpty(taskPks)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("wbs", wbsPks);
        params.put("task", taskPks);
        params.put("operate", operate);
        ProjectPlanTypeHelper.projectPlanTypeTriggerEvent(params);
    }

    public static void projectPlanTypeTriggerEvent(Map<String, Object> params) {
        EventServiceHelper.triggerEventSubscribe((String)"fmm_projectplantype_sync", (String)SerializationUtils.toJsonString(params));
    }

    public static void executeWbsTsakSync(Map<String, Object> params) {
        String operate = (String)params.get("operate");
        if (operate == null) {
            return;
        }
        List wbsPks = (List)params.get("wbs");
        List taskPks = (List)params.get("task");
        ProjectPlanWbsAction wbsAction = new ProjectPlanWbsAction(wbsPks);
        ProjectPlanTaskAction taskAction = new ProjectPlanTaskAction(taskPks);
        if (StringUtils.equals((CharSequence)operate, (CharSequence)"add")) {
            wbsAction.add();
            taskAction.add();
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"delete")) {
            wbsAction.delete();
            taskAction.delete();
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"edit")) {
            wbsAction.edit();
            taskAction.edit();
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"bindcard")) {
            taskAction.editCardRelation();
        }
    }

    public static enum PlanTypeEnum {
        MASTER("master", 1437660575319473152L),
        REGION("region", 1437660676930681856L),
        TRADE("trade", 1437660742504453120L);

        private String code;
        private long id;

        private PlanTypeEnum(String code, long id) {
            this.code = code;
            this.id = id;
        }

        public String getCode() {
            return this.code;
        }

        public long getId() {
            return this.id;
        }

        public static PlanTypeEnum getPlanTypeById(long id) {
            PlanTypeEnum[] types;
            for (PlanTypeEnum type : types = PlanTypeEnum.values()) {
                if (type.getId() != id) continue;
                return type;
            }
            return null;
        }
    }
}

