/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.pmc.pmts.business.helper.CopyHelper;
import kd.pmc.pmts.business.helper.ProjectPlanAction;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;

public class ProjectPlanWbsAction
extends ProjectPlanAction {
    public ProjectPlanWbsAction(List<Object> pks) {
        super(pks, "pmts_wbs");
    }

    @Override
    public void copy(List<DynamicObject> objs, List<DynamicObject> copyObjs, String[] numbers, long[] ids, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
        List wbss = objs.stream().sorted(Comparator.comparing(i -> i.getInt("level"))).collect(Collectors.toList());
        for (int i2 = 0; i2 < wbss.size(); ++i2) {
            DynamicObject obj = (DynamicObject)wbss.get(i2);
            DynamicObject plantype = obj.getDynamicObject("plantype");
            if (plantype == null) continue;
            DynamicObject copyObj = (DynamicObject)OrmUtils.clone((Object)obj, (IDataEntityType)this.getEntityType(), (boolean)true, (boolean)true);
            long id = 0L;
            String number = null;
            if (numbers != null && i2 < numbers.length) {
                number = numbers[i2];
            }
            if (ids != null && i2 < ids.length) {
                id = ids[i2];
            }
            this.resetField(copyObj, obj, sourcePlanType, targetPlanType, id, number);
            copyObjs.add(copyObj);
        }
        this.resetParentWbs(copyObjs, targetPlanType);
    }

    public void resetParentWbs(List<DynamicObject> copyObjs, ProjectPlanTypeHelper.PlanTypeEnum targetPlanType) {
        if (copyObjs == null) {
            return;
        }
        List<Object> parentWbsPks = copyObjs.stream().filter(i -> i.getDynamicObject("parent") != null).map(i -> i.getDynamicObject("parent").getPkValue()).collect(Collectors.toList());
        Map<Object, DynamicObject> copyParentWbsPks = this.queryCopyWbsPks(parentWbsPks, targetPlanType);
        Map<Object, DynamicObject> resourceParentWbsPks = this.queryResourceWbsPsk(copyObjs);
        for (DynamicObject copyObj : copyObjs) {
            DynamicObject parent = copyObj.getDynamicObject("parent");
            if (parent != null) {
                Object parentId = parent.getPkValue();
                DynamicObject copyparent = resourceParentWbsPks.get(parentId);
                copyparent = copyparent == null ? copyParentWbsPks.get(parentId) : copyparent;
                Object copyparentId = copyparent == null ? null : copyparent.get("id");
                String longNumber = copyparent == null ? "" : copyparent.getString("longnumber") + ".";
                copyObj.set("parent_id", copyparentId);
                copyObj.set("longnumber", (Object)(longNumber + copyObj.getString("number")));
                if (copyparent != null) continue;
                copyObj.set("level", (Object)0);
                continue;
            }
            copyObj.set("longnumber", (Object)copyObj.getString("number"));
        }
    }

    @Override
    public boolean hasSyncObj(String syncObj) {
        return syncObj == null || !syncObj.contains("A");
    }

    @Override
    public void copyEdit(Map<Object, DynamicObject> sourceObjsMap, List<DynamicObject> copyObjs, ProjectPlanTypeHelper.PlanTypeEnum sourcePlanType, long targetPlanType) {
        for (DynamicObject copyObj : copyObjs) {
            long plantypeId = copyObj.getLong("plantype_id");
            if (plantypeId != targetPlanType) continue;
            Object sourcePk = copyObj.get("sourceid");
            DynamicObject sourceObj = sourceObjsMap.get(sourcePk);
            CopyHelper.copyDynamicObj((DynamicObjectType)this.getEntityType(), sourceObj, copyObj, false, CAN_NOTCOPY_PROP);
            copyObj.set("name", sourceObj.get("name"));
            CopyHelper.copyCollection((IDataEntityProperty)this.getEntityType().getProperty("multilanguagetext"), sourceObj, copyObj, true, null);
        }
        this.resetParentWbs(copyObjs, ProjectPlanTypeHelper.PlanTypeEnum.getPlanTypeById(targetPlanType));
    }

    public Map<Object, DynamicObject> queryResourceWbsPsk(List<DynamicObject> wbss) {
        HashMap<Object, DynamicObject> pks = new HashMap<Object, DynamicObject>(8);
        for (DynamicObject obj : wbss) {
            pks.put(obj.get("sourceid"), obj);
        }
        return pks;
    }
}

