/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskDelayHelper;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;

public class SimpleTaskCaculateHelper {
    public static void caculateTask(DynamicObject[] dyos, String pageId) {
        boolean hascircle;
        if (ArrayUtils.isNotEmpty((Object[])dyos) && !(hascircle = SimpleTaskCaculateHelper.checkCircle(dyos))) {
            DynamicObject object = dyos[0];
            DynamicObjectCollection prePositiontaskentry = object.getDynamicObjectCollection("prepositiontaskentry");
            Map<String, Date> dateMap = PmtsTaskDelayHelper.calDateByPreTask(prePositiontaskentry, object.getBigDecimal("plantime"), null);
            if (!dateMap.isEmpty()) {
                object.set("planstartdate", (Object)dateMap.get("planstartdate"));
                object.set("planenddate", (Object)dateMap.get("planenddate"));
                PmtsTaskDelayHelper.setSubTaskData(object, dateMap);
                SaveServiceHelper.update((DynamicObject)object);
            }
            PmtsTaskValueHelper.startCalTaskDateDalayed(object, pageId);
        }
    }

    public static boolean checkCircle(DynamicObject[] dyos) {
        try (AlgoContext context = Algo.newContext();){
            Set<Long> topids = Arrays.stream(dyos).map(t -> t.getLong("id")).collect(Collectors.toSet());
            QFilter topfilter = new QFilter("id", "in", topids);
            DataSet kkset = QueryServiceHelper.queryDataSet((String)"PMTS_TASK_KK", (String)"pmts_task", (String)"prepositiontaskentry.prepositiontask.id as parentid,id,prepositiontaskentry.prepositiontask.name as parentname,name,plantime,needtime,wbs.id as wbsid", (QFilter[])topfilter.toArray(), (String)"number desc");
            kkset = kkset.select("parentid,id,wbsid,concat(parentname,'_',name) as path,plantime,needtime");
            boolean bl = SimpleTaskCaculateHelper.doCheck(topids, kkset);
            return bl;
        }
    }

    private static boolean doCheck(Set<Long> topids, DataSet totalset) {
        boolean hasCircle = false;
        QFilter normalqf = new QFilter("prepositiontaskentry.prepositiontask.id", "in", (Object)topids.toArray());
        DataSet taskset = QueryServiceHelper.queryDataSet((String)"PMTS_TASK_KK", (String)"pmts_task", (String)"prepositiontaskentry.prepositiontask.name as parentname,name,prepositiontaskentry.prepositiontask.id as parentid,plantime,needtime,id,wbs.id as wbsid", (QFilter[])normalqf.toArray(), (String)"number desc");
        DataSet newset = taskset.copy();
        DataSet newtotalset = totalset.copy();
        if (taskset.isEmpty()) {
            return hasCircle;
        }
        taskset = taskset.select("wbsid as cwbsid,parentid,id,name as path,plantime as cplantime,needtime as cneedtime");
        taskset = taskset.leftJoin(totalset).on("parentid", "id").select(new String[]{"parentid", "cwbsid", "id", "path cpath", "cplantime", "cneedtime"}, new String[]{"path", "plantime", "needtime", "wbsid"}).finish();
        HashSet<Long> currids = new HashSet<Long>();
        for (Row row : taskset) {
            String path = row.getString("path");
            String cpath = row.getString("cpath");
            String[] pathArr = path.split("_");
            for (int i = 0; i < pathArr.length; ++i) {
                if (!pathArr[i].equals(cpath)) continue;
                hasCircle = true;
                StringBuilder msg = new StringBuilder();
                msg.append(String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u5f15\u7528\u8def\u5f84\u4e3a%2$s", (String)"SimpleTaskCaculateHelper_0", (String)"mmc-fmm-business", (Object[])new Object[0]), cpath, path));
                throw new KDBizException(msg.toString());
            }
            currids.add(row.getLong("id"));
        }
        if (!currids.isEmpty()) {
            newset = newset.select("parentid,id,wbsid,name as path,plantime as cplantime,needtime as cneedtime");
            DataSet s1 = newset.leftJoin(newtotalset).on("parentid", "id").select(new String[]{"parentid", "id", "path cpath", "cplantime", "cneedtime"}, new String[]{"path", "plantime", "needtime", "wbsid"}).finish().copy();
            DataSet s2 = s1.select(new String[]{"parentid", "wbsid", "id", "concat(path,'_',cpath) as path", "cplantime+plantime as plantime", "cneedtime+needtime as needtime"}).copy();
            hasCircle = SimpleTaskCaculateHelper.doCheck(currids, s2);
        }
        return hasCircle;
    }
}

