/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.business.helper.BillFieldEntityHelper;
import kd.pmc.pmts.common.consts.TaskInvokeOperationConst;

public class TaskInvokeOperationHelper {
    public static final Set<String> RELEASE_BIZSTATUS = new HashSet<String>();
    private static Log logger = LogFactory.getLog(TaskInvokeOperationHelper.class);

    public static OperationResult InvokeOperation(String opKey, String entityid, AbstractFormPlugin plugin, DynamicObjectCollection taskColl) {
        OperationResult result;
        FilterContainer filterContainer;
        IFormView view = plugin.getView();
        if (CollectionUtils.isEmpty((Collection)taskColl)) {
            view.showTipNotification(TaskInvokeOperationConst.getMsgContainTask());
            return null;
        }
        ListSelectedRowCollection listdatas = new ListSelectedRowCollection();
        int i = 0;
        ArrayList<DynamicObject> updateDeleteStatus = new ArrayList<DynamicObject>();
        for (DynamicObject task : taskColl) {
            if (TaskInvokeOperationHelper.isUpdateDeleteStatus(task, opKey)) {
                updateDeleteStatus.add(task);
                continue;
            }
            ListSelectedRow initRow = TaskInvokeOperationHelper.createInitDataRow(task, opKey, i);
            if (initRow != null) {
                listdatas.add((Object)initRow);
                continue;
            }
            ListSelectedRow row = new ListSelectedRow(task.getPkValue());
            row.setBillStatus(task.getString("status"));
            row.setEntryPkLongType(false);
            row.setPkLongType(true);
            row.setSubEntryPkLongType(false);
            row.setMainOrgId(task.getLong("useorg.id"));
            row.setName(task.getString("name"));
            row.setNumber(task.getString("number"));
            row.setRowKey(i);
            row.setSelected(true);
            ++i;
            listdatas.add((Object)row);
        }
        TaskInvokeOperationHelper.updateDeleteStatus(updateDeleteStatus.toArray(new DynamicObject[0]));
        FormOperate operate = (FormOperate)FormMetadataCache.getFormOperation((String)entityid, (String)opKey);
        operate.setListSelectedData(listdatas);
        operate.setListFocusRow(listdatas.isEmpty() ? new ListSelectedRow() : listdatas.get(0));
        operate.setPermissionEntityId(null);
        operate.setEntityId(entityid);
        OperateOption operateOption = OperateOption.create();
        if (view instanceof ListView && (filterContainer = (FilterContainer)view.getControl("filtercontainerap")) != null) {
            operateOption.setVariableValue("filterSelectedValues", SerializationUtils.serializeToBase64((Object)filterContainer.getSelectedValues()));
        }
        operateOption.setVariableValue("isListViewOp4Mutex", "true");
        operateOption.setVariableValue("bos_support_bigdata_aysn", String.valueOf(true));
        operateOption.setVariableValue("SpecialDataPerm_CurrentAppId", view.getFormShowParameter().getAppId());
        operateOption.setVariableValue("bos_bigdata_aysn", String.valueOf(true));
        operate.setOption(operateOption);
        operate.setView(view);
        if (operate instanceof IEntityOperate) {
            IEntityOperate entityOperate = (IEntityOperate)operate;
            entityOperate.setRemoteInvoke(true);
        }
        OperationResult operationResult = result = listdatas.isEmpty() ? new OperationResult() : operate.execute();
        if (operate.getOperateKey().equals("stoptask") && result.getSuccessPkIds().size() > 0) {
            TaskInvokeOperationHelper.showTaskStopForm(plugin, result);
        }
        if (operate.getType().equals("donothing") && result.isShowMessage() && result.isSuccess()) {
            view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s\u6210\u529f\u3002", (String)"TaskInvokeOperationHelper_0", (String)"mmc-fmm-business", (Object[])new Object[0]), operate.getOperateName().getLocaleValue()));
            view.invokeOperation("refresh");
        }
        if (operate.getOperateKey().equals("delete")) {
            view.invokeOperation("refresh");
            String orderPageId = view.getPageCache().get("orderPageId");
            if (StringUtils.isNotEmpty((CharSequence)orderPageId)) {
                IListView orderView = (IListView)view.getView(orderPageId);
                orderView.refresh();
                view.sendFormAction((IFormView)orderView);
            }
        }
        return result;
    }

    public static void InvokeCopyOperation(AbstractFormPlugin plugin, DynamicObjectCollection taskColl) {
        IFormView view = plugin.getView();
        if (taskColl.size() <= 0) {
            view.showTipNotification(TaskInvokeOperationConst.getMsgContainTask());
            return;
        }
        TaskInvokeOperationHelper.showCopyDataForm(view, ((DynamicObject)taskColl.get(0)).getPkValue(), plugin);
    }

    public static void InvokeFastdefinedCopyOperation(AbstractFormPlugin plugin, DynamicObject dyn, Map<String, Object> para) {
        IFormView view = plugin.getView();
        if ("pmts_task".equals(dyn.getDataEntityType().getName())) {
            TaskInvokeOperationHelper.showCopyDataForm(view, dyn.getPkValue(), plugin, "pmts_task_insert", para);
        } else if ("pmts_wbs".equals(dyn.getDataEntityType().getName())) {
            TaskInvokeOperationHelper.showCopyDataForm(view, dyn.getPkValue(), plugin, "pmts_wbs_insert", para);
        }
    }

    public static void InvokeDeleteOperation(AbstractFormPlugin plugin, DynamicObjectCollection taskColl) {
        IFormView view = plugin.getView();
        if (taskColl.size() <= 0) {
            view.showTipNotification(TaskInvokeOperationConst.getMsgContainTask());
            return;
        }
        TaskInvokeOperationHelper.showDeleteConfirmForm(plugin);
    }

    public static String addErrorInfo(String opKey, DynamicObject task, String propName, String status) {
        String entityid = task.getDataEntityType().getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        ComboProp props = (ComboProp)BillFieldEntityHelper.findPropertys((EntityType)mainEntityType, propName).get(propName);
        FormOperate operate = (FormOperate)FormMetadataCache.getFormOperation((String)entityid, (String)opKey);
        String opName = operate.getOperateName().getLocaleValue();
        List items = props.getComboItems();
        String errorMsg = "";
        for (ValueMapItem valueMapItem : items) {
            if (!valueMapItem.getValue().equals(status)) continue;
            StringBuilder sbbler = new StringBuilder();
            sbbler.append(String.format(ResManager.loadKDString((String)"%1$s\u5fc5\u987b\u4e3a%2$s", (String)"TaskInvokeOperationHelper_2", (String)"mmc-fmm-business", (Object[])new Object[0]), props.getDisplayName().getLocaleValue(), valueMapItem.getName()));
            errorMsg = sbbler.toString();
        }
        return errorMsg;
    }

    public static String propIsNull(DynamicObject task, String propName) {
        String entityid = task.getDataEntityType().getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        String propCNName = BillFieldEntityHelper.findPropertys((EntityType)mainEntityType, propName).get(propName).getDisplayName().getLocaleValue();
        StringBuilder sbbler = new StringBuilder();
        sbbler.append(propCNName);
        sbbler.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskInvokeOperationHelper_3", (String)"mmc-fmm-business", (Object[])new Object[0]));
        String errorMsg = sbbler.toString();
        return errorMsg;
    }

    private static void showTaskStopForm(AbstractFormPlugin plugin, OperationResult result) {
        IFormView view = plugin.getView();
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "pmts_task_stop");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack callback = new CloseCallBack((IFormPlugin)plugin, "StopReason");
        showParameter.setCloseCallBack(callback);
        showParameter.setCustomParam("opresult", (Object)result);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private static void showCopyDataForm(IFormView view, Object id, AbstractFormPlugin plugin) {
        ListView listview = (ListView)view;
        String entityTypeId = listview.getEntityTypeId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPermissionEntityId(null);
        baseShowParameter.setFormId(entityTypeId);
        baseShowParameter.getOpenStyle().setTargetKey("tabap");
        baseShowParameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.getCustomParams().put("iscopy", Boolean.TRUE);
        baseShowParameter.getCustomParams().put("isCopyRelateEntity", Boolean.FALSE);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "close"));
        baseShowParameter.setPkId(id);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    private static void showCopyDataForm(IFormView view, Object id, AbstractFormPlugin plugin, String entityTpye, Map<String, Object> para) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPermissionEntityId(null);
        baseShowParameter.setFormId(entityTpye);
        baseShowParameter.getOpenStyle().setTargetKey("tabap");
        baseShowParameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        para.put("iscopy", Boolean.TRUE);
        para.put("isCopyRelateEntity", Boolean.FALSE);
        if ("pmts_task_insert".equals(entityTpye) && "1".equals(para.get("scheduletype"))) {
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u52a1", (String)"TaskInvokeOperationHelper_4", (String)"mmc-fmm-business", (Object[])new Object[0]));
        } else if ("pmts_task_insert".equals(entityTpye) && "3".equals(para.get("scheduletype"))) {
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891", (String)"TaskInvokeOperationHelper_5", (String)"mmc-fmm-business", (Object[])new Object[0]));
        }
        if ("pmts_wbs_insert".equals(entityTpye)) {
            baseShowParameter.setCaption("WBS");
        }
        baseShowParameter.getCustomParams().putAll(para);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "close"));
        baseShowParameter.setPkId(id);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    private static void showDeleteConfirmForm(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        String message = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002", (String)"TaskInvokeOperationHelper_6", (String)"mmc-fmm-business", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\uff1f", (String)"TaskInvokeOperationHelper_7", (String)"mmc-fmm-business", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("selfdelete", (IFormPlugin)plugin);
        view.showConfirm(message, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public static void InvokeAlterTaskNumber(AbstractFormPlugin plugin, DynamicObjectCollection taskColl) {
    }

    public static void InvokePositionEdit(AbstractFormPlugin plugin, DynamicObjectCollection taskColl) {
        IFormView view = plugin.getView();
        if (taskColl.size() <= 0) {
            view.showErrorNotification(TaskInvokeOperationConst.getMsgSelectOne());
            return;
        }
        DynamicObject task = (DynamicObject)taskColl.get(0);
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "pmts_resetrelation");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack callback = new CloseCallBack((IFormPlugin)plugin, "ResetRelation");
        showParameter.setCloseCallBack(callback);
        showParameter.setCustomParam("taskId", task.getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void InvokeDocumentEdit(AbstractFormPlugin plugin, DynamicObjectCollection taskcoll) {
        IFormView view = plugin.getView();
        if (taskcoll.size() <= 0) {
            view.showErrorNotification(TaskInvokeOperationConst.getMsgSelectOne());
            return;
        }
        String curid = ((DynamicObject)taskcoll.get(0)).get("id").toString();
        String projectid = ((DynamicObject)taskcoll.get(0)).get("projectnum.id").toString();
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "pmts_task_document");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack callback = new CloseCallBack((IFormPlugin)plugin, "DocumentEdit");
        showParameter.setCloseCallBack(callback);
        showParameter.setCustomParam("taskId", (Object)curid);
        showParameter.setCustomParam("projectid", (Object)projectid);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void invokeNewTaskSchedule(AbstractFormPlugin plugin, DynamicObjectCollection wbss) {
        IFormView view = plugin.getView();
        long orgid = Long.parseLong(plugin.getPageCache().get("verifyOrg"));
        String filtersStr = (String)GanttBigObjectCache.get((String)plugin.getView().getPageId(), (String)"filterStr");
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)filtersStr, Map.class);
        QFilter orgfilter = new QFilter("createorg", "=", (Object)orgid);
        QFilter deffilter = new QFilter("isdefault", "=", (Object)"1");
        QFilter stfilter = new QFilter("status", "=", (Object)"C");
        QFilter ebfilter = new QFilter("enable", "=", (Object)"1");
        Map dyMap = BusinessDataServiceHelper.loadFromCache((String)"pmts_taskscheme", (QFilter[])new QFilter[]{orgfilter, deffilter, stfilter, ebfilter});
        long scmId = 0L;
        long plantype = 0L;
        Set<Long> wbsSet = new HashSet<Long>();
        if (!dyMap.isEmpty()) {
            scmId = dyMap.entrySet().stream().mapToLong(e -> (Long)e.getKey()).findFirst().getAsLong();
            DynamicObject dyObj = dyMap.entrySet().stream().map(e -> (DynamicObject)e.getValue()).findFirst().get();
            if (dyObj.getBoolean("isbytype")) {
                for (Map.Entry m : filterMap.entrySet()) {
                    if (!((String)m.getKey()).contains("plantype")) continue;
                    Map map = (Map)m.getValue();
                    String value = map.get("value").toString();
                    plantype = Long.parseLong(value);
                }
                if (plantype == 0L) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u7c7b\u578b\u4e0d\u7b26\uff0c\u65e0\u6cd5\u8fdb\u884c\u5173\u952e\u8def\u5f84\u8ba1\u7b97\uff0c\u8bf7\u6309\u7167\u8ba1\u5212\u7c7b\u578b\u8fdb\u884c\u533a\u5206\u3002", (String)"TaskInvokeOperationHelper_8", (String)"mmc-fmm-business", (Object[])new Object[0]));
                    return;
                }
            }
            if (dyObj.getBoolean("isbywbs")) {
                String msg;
                if (wbss.isEmpty()) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u4e2aWBS\u8282\u70b9\uff0c\u6309\u7167WBS\u8ba1\u7b97\u5173\u952e\u8def\u5f84\u3002", (String)"TaskInvokeOperationHelper_9", (String)"mmc-fmm-business", (Object[])new Object[0]);
                    view.showErrorNotification(msg);
                    return;
                }
                if (wbss.size() > 1) {
                    msg = ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2aWBS\u8282\u70b9\u6765\u8ba1\u7b97\u5173\u952e\u8def\u5f84\u3002", (String)"TaskInvokeOperationHelper_10", (String)"mmc-fmm-business", (Object[])new Object[0]);
                    view.showErrorNotification(msg);
                    return;
                }
                long projectid = ((DynamicObject)wbss.get(0)).getDynamicObject("projectnum").getLong("id");
                long l = ((DynamicObject)wbss.get(0)).getLong("id");
                wbsSet = TaskInvokeOperationHelper.getWbsNodes(projectid, l);
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u8ba1\u7b97\u9ed8\u8ba4\u5173\u952e\u8def\u5f84\u8ba1\u7b97\u65b9\u6848\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"TaskInvokeOperationHelper_11", (String)"mmc-fmm-business", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            return;
        }
        long projectid = 0L;
        for (Map.Entry entry : filterMap.entrySet()) {
            if (!((String)entry.getKey()).contains("projectnum")) continue;
            Map mm = (Map)entry.getValue();
            String value = mm.get("value").toString();
            projectid = Long.parseLong(value);
        }
        if (projectid == 0L) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u8ba1\u7b97\u5f53\u524d\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u4fe1\u606f\u3002", (String)"TaskInvokeOperationHelper_12", (String)"mmc-fmm-business", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            return;
        }
        TaskInvokeOperationHelper.showJobForm(plugin, orgid, scmId, projectid, wbsSet, plantype);
    }

    private static void showJobForm(AbstractFormPlugin plugin, long orgid, long scmId, long projectid, Set<Long> wbsSet, long plantype) {
        JobFormInfo jobFormInfo = new JobFormInfo(null);
        logger.info("----------pggeid" + plugin.getView().getPageId());
        IFormView view = plugin.getView();
        logger.info("----------\u7236\u754c\u9762" + view.getEntityId());
        jobFormInfo.setParentPageId(plugin.getView().getPageId());
        FormViewPluginProxy service = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        IFormPlugin workTaskList = service.getPlugIns().stream().filter(p -> p.getPluginName().contains("WorkTaskList")).findFirst().get();
        if (Objects.isNull(workTaskList)) {
            logger.info("---------\u63d2\u4ef6\u4e3a\u7a7a" + view.getEntityId());
        }
        CloseCallBack closeCallBack = new CloseCallBack(workTaskList, "taskcloseback");
        String capstr = ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u7b97", (String)"TaskInvokeOperationHelper_15", (String)"mmc-fmm-business", (Object[])new Object[0]);
        jobFormInfo.setCaption(capstr);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.pmc.pmts.formplugin.base.TaskScheduleClickPlugin");
        TaskInvokeOperationHelper.dispatch(jobFormInfo, view, orgid, scmId, projectid, wbsSet, plantype);
    }

    public static void dispatch(JobFormInfo jobFormInfo, IFormView view, long orgid, long scmId, long projectid, Set<Long> wbsSet, long plantype) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmts_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(jobFormInfo.getCaption());
        logger.info("----------ServiceAppId" + view.getFormShowParameter().getServiceAppId());
        showParameter.getCustomParams().put("ServiceAppId", "pmts");
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        logger.info("----------jobInfoStr" + jobInfoStr);
        showParameter.getCustomParams().put("pmts_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("orgid", orgid);
        showParameter.getCustomParams().put("scmId", scmId);
        showParameter.getCustomParams().put("projectid", projectid);
        showParameter.getCustomParams().put("wbsSet", wbsSet);
        showParameter.getCustomParams().put("plantype", plantype);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    private static Set<Long> getWbsNodes(long projectid, long cwbsid) {
        DynamicObjectCollection pmts_wbs = QueryServiceHelper.query((String)"pmts_wbs", (String)"id,parent.id as parentid", (QFilter[])new QFilter("projectnum.id", "=", (Object)projectid).toArray());
        ArrayList<Long> childids = new ArrayList<Long>(2);
        ArrayList<Long> cids = new ArrayList<Long>(1);
        cids.add(cwbsid);
        TaskInvokeOperationHelper.findChildIds(cids, pmts_wbs, childids);
        childids.add(cwbsid);
        childids.remove(0L);
        Set<Long> collect = childids.stream().collect(Collectors.toSet());
        return collect;
    }

    private static void findChildIds(List<Long> pids, DynamicObjectCollection pmts_wbs, List<Long> childids) {
        List<Long> childs = pmts_wbs.stream().filter(w1 -> pids.contains(w1.getLong("parentid"))).map(w2 -> w2.getLong("id")).collect(Collectors.toList());
        childids.addAll(childs);
        if (!childs.isEmpty()) {
            TaskInvokeOperationHelper.findChildIds(childs, pmts_wbs, childids);
        }
    }

    public static void InvokeTaskSchedule(AbstractFormPlugin plugin) {
    }

    public static void InvokeHsRsAllocation(AbstractFormPlugin plugin, DynamicObjectCollection taskColl) {
        IFormView view = plugin.getView();
        if (taskColl.size() <= 0) {
            view.showErrorNotification(TaskInvokeOperationConst.getMsgSelectOne());
            return;
        }
        String curid = ((DynamicObject)taskColl.get(0)).get("id").toString();
        Object projectid = ((DynamicObject)taskColl.get(0)).get("projectnum.id");
        if ("0".equals(curid)) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u4e00\u884c\u4efb\u52a1\u3002", (String)"TaskInvokeOperationHelper_14", (String)"mmc-fmm-business", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "pmts_task_rsallocation");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack callback = new CloseCallBack((IFormPlugin)plugin, "Rsallocation");
        showParameter.setCloseCallBack(callback);
        showParameter.setCustomParam("curtaskid", (Object)curid);
        if (projectid != null) {
            showParameter.setCustomParam("projectid", (Object)Long.parseLong(projectid.toString()));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private static boolean isUpdateDeleteStatus(DynamicObject task, String opKey) {
        Object releasetask = task.get("releasetask");
        return releasetask != null && StringUtils.equals((CharSequence)"delete", (CharSequence)opKey);
    }

    private static void updateDeleteStatus(DynamicObject[] tasks) {
        for (DynamicObject task : tasks) {
            task.set("deletestatus", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    private static ListSelectedRow createInitDataRow(DynamicObject task, String opKey, int rowKey) {
        long initid = task.getLong("initid");
        if (initid != 0L && RELEASE_BIZSTATUS.contains(opKey)) {
            ListSelectedRow row = new ListSelectedRow((Object)initid);
            row.setBillStatus(task.getString("status"));
            row.setEntryPkLongType(false);
            row.setPkLongType(true);
            row.setSubEntryPkLongType(false);
            row.setMainOrgId(task.getLong("useorg.id"));
            row.setName(task.getString("name"));
            row.setNumber(task.getString("number"));
            row.setRowKey(rowKey);
            row.setSelected(true);
            return row;
        }
        return null;
    }

    static {
        RELEASE_BIZSTATUS.add("confirm");
        RELEASE_BIZSTATUS.add("unconfirm");
        RELEASE_BIZSTATUS.add("release");
        RELEASE_BIZSTATUS.add("unrelease");
        RELEASE_BIZSTATUS.add("start");
        RELEASE_BIZSTATUS.add("unstart");
        RELEASE_BIZSTATUS.add("stoptask");
        RELEASE_BIZSTATUS.add("restarttask");
        RELEASE_BIZSTATUS.add("done");
        RELEASE_BIZSTATUS.add("undone");
    }
}

