/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.business.task.CrossSetSerive;
import kd.pmc.pmts.common.util.DateUtil;

public class CrossSetServiceFactroy {
    private static Map<String, CrossSetSerive> crossSetSeriveHashMap = new HashMap<String, CrossSetSerive>();

    public static CrossSetSerive getCrossDataStrategy(String crossType) {
        return crossSetSeriveHashMap.get(crossType);
    }

    private static void setPlanCross(DynamicObject work, GanttTaskModel ganttTaskModel, GanttBuildContext context) {
        Double ptime;
        String taskIdStr = ganttTaskModel.getObjId();
        if (!StringUtils.equals((CharSequence)taskIdStr, (CharSequence)work.getString("id"))) {
            return;
        }
        BigDecimal plantime = work.getBigDecimal("plantime");
        DynamicObject timeunit = work.getDynamicObject("durationunit");
        Double seconds = 0.0;
        if (timeunit != null && StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"40") && plantime != null) {
            ptime = plantime.doubleValue();
            seconds = ptime * 60.0 * 60.0;
        } else if (timeunit != null && StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"30") && plantime != null) {
            ptime = plantime.doubleValue();
            seconds = ptime * 24.0 * 60.0 * 60.0;
        }
        Date planstartdate = work.getDate("planstartdate");
        Date planenddate = work.getDate("planenddate");
        if (planstartdate != null && planenddate == null) {
            planenddate = DateUtil.addSecond((Date)planstartdate, (long)seconds.longValue());
        } else if (planstartdate == null && planenddate != null) {
            planstartdate = DateUtil.reduceSecond((Date)planenddate, (long)seconds.longValue());
        } else if (planstartdate == null && planenddate == null) {
            DynamicObject project = work.getDynamicObject("projectnum");
            Date dayOne = CrossSetServiceFactroy.queryDayOneDate(context, project, work.getLong("version_id"));
            Date planstarttime = project.getDate("expstartdate");
            if (dayOne != null) {
                planstarttime = dayOne;
            }
            if (planstarttime != null) {
                planstartdate = new Date(planstarttime.getTime());
                planenddate = DateUtil.addSecond((Date)planstartdate, (long)seconds.longValue());
            }
        }
        if (planstartdate != null) {
            ganttTaskModel.setStartDate(Long.valueOf(planstartdate.getTime()));
        }
        if (planenddate != null) {
            ganttTaskModel.setEndDate(Long.valueOf(planenddate.getTime()));
        }
    }

    public static Date queryDayOneDate(GanttBuildContext context, DynamicObject project, Long versionId) {
        Date planDate;
        IFormView view = SessionManager.getCurrent().getView(context.getPageId());
        if (view == null) {
            return null;
        }
        IPageCache pageCache = view.getPageCache();
        if (pageCache == null) {
            return null;
        }
        String firDay = pageCache.get("firday");
        if (StringUtils.isNotEmpty((CharSequence)firDay)) {
            if (firDay.equals("null")) {
                return null;
            }
            return DateUtil.parseStrDate((String)firDay);
        }
        ListShowParameter formShowParameter = (ListShowParameter)view.getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        if (billFormId.contains("release")) {
            versionId = 0L;
        }
        firDay = (planDate = PmtsTaskValueHelper.queryDayOneDate(project.getLong("id"), versionId)) == null ? "null" : DateUtil.formatDate((Date)planDate);
        pageCache.put("firday", firDay);
        return planDate;
    }

    private static void setActualCross(DynamicObject work, GanttTaskModel ganttTaskModel) {
        String executestatus = work.getString("executestatus");
        Long actualstartdate = CrossSetServiceFactroy.getLongTime(work, "actualstartdate");
        Long actualenddate = CrossSetServiceFactroy.getLongTime(work, "actualenddate");
        Long actualdate = CrossSetServiceFactroy.getLongTime(work, "actualdate");
        if (StringUtils.equals((CharSequence)"2", (CharSequence)executestatus)) {
            ganttTaskModel.setStartDate(actualstartdate);
            Long currentTime = System.currentTimeMillis();
            ganttTaskModel.setEndDate(actualdate == null ? currentTime : actualdate);
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)executestatus)) {
            ganttTaskModel.setStartDate(actualstartdate);
            ganttTaskModel.setEndDate(actualenddate);
            ganttTaskModel.setAdjustable(false);
        }
    }

    private static void setStillNeedCross(DynamicObject work, GanttTaskModel ganttTaskModel) {
        if (work.getDate("nfirststartdate") != null) {
            ganttTaskModel.setStartDate(CrossSetServiceFactroy.getLongTime(work, "nfirststartdate"));
            ganttTaskModel.setEndDate(CrossSetServiceFactroy.getLongTime(work, "nfirstenddate"));
        } else if (work.getDate("nlaststartdate") != null) {
            ganttTaskModel.setStartDate(CrossSetServiceFactroy.getLongTime(work, "nlaststartdate"));
            ganttTaskModel.setEndDate(CrossSetServiceFactroy.getLongTime(work, "nlastenddate"));
        }
    }

    private static void setPercentCross(DynamicObject work, GanttTaskModel ganttTaskModel, GanttBuildContext context) {
        Boolean showPercentValue;
        Double ptime;
        String taskIdStr = ganttTaskModel.getObjId();
        if (!StringUtils.equals((CharSequence)taskIdStr, (CharSequence)work.getString("id"))) {
            return;
        }
        BigDecimal plantime = work.getBigDecimal("plantime");
        DynamicObject timeunit = work.getDynamicObject("durationunit");
        Double seconds = 0.0;
        if (timeunit != null && StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"40") && plantime != null) {
            ptime = plantime.doubleValue();
            seconds = ptime * 60.0 * 60.0;
        } else if (timeunit != null && StringUtils.equals((CharSequence)timeunit.getString("number"), (CharSequence)"30") && plantime != null) {
            ptime = plantime.doubleValue();
            seconds = ptime * 24.0 * 60.0 * 60.0;
        }
        ganttTaskModel.setShowPercent(true);
        ganttTaskModel.setLeftDrag(false);
        String executestatus = work.getString("executestatus");
        BigDecimal finishpercent = work.getBigDecimal("finishpercent");
        Date planstartdate = work.getDate("planstartdate");
        Date planenddate = work.getDate("planenddate");
        if (planstartdate == null || planenddate == null || finishpercent.compareTo(BigDecimal.ZERO) == 0) {
            ganttTaskModel.setStartDate(Long.valueOf(0L));
            ganttTaskModel.setEndDate(Long.valueOf(0L));
        } else {
            ganttTaskModel.setStartDate(Long.valueOf(planstartdate.getTime()));
            if (StringUtils.equals((CharSequence)"4", (CharSequence)executestatus)) {
                ganttTaskModel.setEndDate(Long.valueOf(planenddate.getTime()));
                ganttTaskModel.setAdjustable(false);
            } else {
                finishpercent = finishpercent.divide(new BigDecimal(100));
                Date endDate = DateUtil.addSecond((Date)planstartdate, (long)((long)(seconds * finishpercent.doubleValue())));
                ganttTaskModel.setEndDate(Long.valueOf(endDate.getTime()));
            }
            ganttTaskModel.setPlanDateTimeStamp(Long.valueOf(planenddate.getTime() - planstartdate.getTime()));
        }
        if (finishpercent.compareTo(new BigDecimal(1)) == 0) {
            ganttTaskModel.setAdjustable(false);
            ganttTaskModel.setDraggable(false);
        }
        if (!(showPercentValue = context.getSchemModel().getShowPercentValue()).booleanValue()) {
            ganttTaskModel.setInnerDesc(null);
        }
    }

    private static Long getLongTime(DynamicObject object, String name) {
        Date date = object.getDate(name);
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    static {
        crossSetSeriveHashMap.put(GanttCrossTypeEnum.PLAN.getValue(), (work, ganttTaskModel, context) -> CrossSetServiceFactroy.setPlanCross(work, ganttTaskModel, context));
        crossSetSeriveHashMap.put(GanttCrossTypeEnum.ACTUAL.getValue(), (work, ganttTaskModel, context) -> CrossSetServiceFactroy.setActualCross(work, ganttTaskModel));
        crossSetSeriveHashMap.put(GanttCrossTypeEnum.NEED.getValue(), (work, ganttTaskModel, context) -> CrossSetServiceFactroy.setStillNeedCross(work, ganttTaskModel));
        crossSetSeriveHashMap.put(GanttCrossTypeEnum.PERCENT.getValue(), (work, ganttTaskModel, context) -> CrossSetServiceFactroy.setPercentCross(work, ganttTaskModel, context));
    }
}

