/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.service.GanttVersionCreateService;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.util.FiledSetUtil;
import org.apache.commons.lang.StringUtils;

public class TaskCreateVersionServiceImpl
implements GanttVersionCreateService {
    public static final String MPDM_GANTT_VERSION_TASK = "mpdm_gantt_version_task";
    public static final String BASELINE = "baseline";

    public void createVersion(DynamicObject version, IFormView formView) {
        Map<String, DynamicObject[]> resourcePlanMap = null;
        boolean isExist = (Boolean)GanttBigObjectCache.get((String)formView.getPageId(), (String)"isExist");
        ArrayList<Long> deleteWbsId = new ArrayList<Long>(16);
        if (StringUtils.isNotBlank((String)formView.getPageCache().get("versionflag"))) {
            List ganttRowDataModelList = (List)GanttBigObjectCache.get((String)formView.getPageId(), (String)"dataList");
            resourcePlanMap = this.getResourcePlanListBySelect(ganttRowDataModelList);
            if (isExist) {
                for (Map.Entry<String, DynamicObject[]> resourcePlanEntry : resourcePlanMap.entrySet()) {
                    DynamicObject[] resourcePlans = resourcePlanEntry.getValue();
                    ArrayList<String> numberList = new ArrayList<String>(resourcePlans.length);
                    for (DynamicObject dynamicObject : resourcePlans) {
                        numberList.add(dynamicObject.getString("number") + "&" + version.getString("number"));
                    }
                    QFilter numberQFilter = new QFilter("number", "in", numberList);
                    if (resourcePlanEntry.getKey().equals("pmts_wbs")) {
                        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryWbsId", (String)"pmts_wbs", (String)"id", (QFilter[])numberQFilter.toArray(), null);
                        Throwable throwable = null;
                        try {
                            for (Row row : dataSet) {
                                deleteWbsId.add(row.getLong("id"));
                            }
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (dataSet == null) continue;
                            if (throwable != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            dataSet.close();
                            continue;
                        }
                    }
                    if (!resourcePlanEntry.getKey().equals("pmts_task")) continue;
                    DeleteServiceHelper.delete((String)resourcePlanEntry.getKey(), (QFilter[])numberQFilter.toArray());
                }
            }
            this.setHistoryData(resourcePlanMap, formView, version, deleteWbsId);
        } else {
            resourcePlanMap = this.getResourcePlanList(formView);
            if (isExist) {
                DynamicObject[] wbsDatas;
                DynamicObject[] taskkDatas;
                QFilter qFilter = new QFilter("projectnum.id", "=", (Object)version.getDynamicObject("projectnum").getLong("id"));
                DynamicObject qversiontype = version.getDynamicObject("versiontype");
                QFilter versiontypeFilter = new QFilter("versiontype.id", "=", (Object)qversiontype.getLong("id"));
                DynamicObject mpdmGanttVersion = BusinessDataServiceHelper.loadSingle((String)MPDM_GANTT_VERSION_TASK, (String)FiledSetUtil.queryAllFileds((String)MPDM_GANTT_VERSION_TASK, null), (QFilter[])new QFilter[]{qFilter, versiontypeFilter});
                String value = "";
                String ganttVersionNumber = "";
                String versionTypeNumber = qversiontype.getString("number");
                if (StringUtils.equals((String)qversiontype.getString("number"), (String)BASELINE)) {
                    ganttVersionNumber = value = "task_history_version";
                } else {
                    value = versionTypeNumber.replace(BASELINE, "history");
                    ganttVersionNumber = "history";
                }
                QFilter numberQFilter = new QFilter("number", "=", (Object)value);
                qversiontype = QueryServiceHelper.queryOne((String)"mpdm_gantt_versiontype", (String)"id", (QFilter[])numberQFilter.toArray());
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)qversiontype.getLong("id"), (String)"mpdm_gantt_versiontype");
                QFilter qfilter = new QFilter("version.id", "=", (Object)mpdmGanttVersion.getLong("id"));
                for (DynamicObject taskkData : taskkDatas = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])new QFilter[]{qfilter})) {
                    this.reverseBaseLinePlanToNull(taskkData);
                }
                SaveServiceHelper.update((DynamicObject[])taskkDatas);
                for (DynamicObject wbsData : wbsDatas = BusinessDataServiceHelper.load((String)"pmts_wbs", (String)FiledSetUtil.queryAllFileds((String)"pmts_wbs", null), (QFilter[])new QFilter[]{qfilter})) {
                    this.reverseWbsBaseLinePlanToNull(wbsData);
                }
                SaveServiceHelper.update((DynamicObject[])wbsDatas);
                mpdmGanttVersion.set("versiontype", (Object)dynamicObject);
                String number = mpdmGanttVersion.getString("number").replace(BASELINE, ganttVersionNumber);
                mpdmGanttVersion.set("number", (Object)number);
                mpdmGanttVersion.set("name", (Object)number);
                mpdmGanttVersion.set("sourcetype", (Object)"2");
                SaveServiceHelper.update((DynamicObject)mpdmGanttVersion);
            }
            this.setHistoryData(resourcePlanMap, formView, version, deleteWbsId);
        }
    }

    public void setVersionPlans(Map<String, DynamicObject[]> resourcePlanMap, IFormView formView, DynamicObject version) {
        this.setHistoryData(resourcePlanMap, formView, version, null);
    }

    private void setHistoryData(Map<String, DynamicObject[]> resourcePlanMap, IFormView formView, DynamicObject version, List<Long> deleteWbsId) {
        Date date = new Date();
        if (!CollectionUtils.isEmpty(resourcePlanMap)) {
            DynamicObject[] taskVersionPlans = null;
            DynamicObject[] wbsVersionPlans = null;
            Map entityVersionMap = (Map)GanttBigObjectCache.get((String)formView.getPageId(), (String)"entityVersionMap");
            CloneUtils cloneUtils = new CloneUtils(false, true);
            HashMap<Long, DynamicObject> taskObjectMap = new HashMap<Long, DynamicObject>(8);
            HashMap<Long, DynamicObject> wbsObjectMap = new HashMap<Long, DynamicObject>(8);
            for (Map.Entry<String, DynamicObject[]> resourcePlanEntry : resourcePlanMap.entrySet()) {
                String entity = resourcePlanEntry.getKey();
                DynamicObject[] resourcePlans = resourcePlanEntry.getValue();
                DynamicObject[] versionPlans = new DynamicObject[resourcePlans.length];
                DynamicObject[] objects = new DynamicObject[resourcePlans.length];
                String versiontype = version.getDynamicObject("versiontype").getString("number");
                long[] ids = ID.genLongIds((int)resourcePlans.length);
                for (int i = 0; i < resourcePlans.length; ++i) {
                    DynamicObject object = resourcePlans[i];
                    DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)object);
                    clone.set("id", (Object)ids[i]);
                    clone.set("masterid", (Object)ids[i]);
                    clone.set((String)entityVersionMap.get(entity), (Object)version);
                    clone.set("createtime", (Object)date);
                    clone.set("modifytime", (Object)date);
                    clone.set("creator", (Object)RequestContext.get().getCurrUserId());
                    clone.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    if (deleteWbsId == null) {
                        clone.set("releasestatus", (Object)"1");
                    }
                    if (versiontype.contains(BASELINE)) {
                        if (entity.equals("pmts_task")) {
                            this.reverseBaseLinePlan(object, version);
                            this.reverseBaseLinePlan(clone, version);
                            this.setBasePlanTime(object);
                            this.setBasePlanTime(clone);
                        } else if (entity.equals("pmts_wbs")) {
                            this.reverseWbsBaseLinePlan(object, version);
                            this.reverseWbsBaseLinePlan(clone, version);
                        }
                        object.set("modifytime", (Object)date);
                        object.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        objects[i] = object;
                    }
                    if (entity.equals("pmts_task")) {
                        taskObjectMap.put(object.getLong("id"), clone);
                    }
                    clone.set("number", (Object)(clone.getString("number") + "&" + version.getString("number")));
                    if (entity.equals("pmts_wbs")) {
                        clone.set("longnumber", (Object)(version.getString("number") + "&" + clone.getString("longnumber")));
                        wbsObjectMap.put(object.getLong("id"), clone);
                    } else if (entity.equals("pmts_task")) {
                        taskObjectMap.put(object.getLong("id"), clone);
                    }
                    versionPlans[i] = clone;
                }
                SaveServiceHelper.save((DynamicObject[])versionPlans);
                if (entity.equals("pmts_task")) {
                    taskVersionPlans = versionPlans;
                } else if (entity.equals("pmts_wbs")) {
                    wbsVersionPlans = versionPlans;
                    this.changeTaskWbsId(wbsVersionPlans, deleteWbsId);
                }
                if (!versiontype.contains(BASELINE)) continue;
                SaveServiceHelper.update((DynamicObject[])objects);
            }
            if (taskVersionPlans != null) {
                this.setHistoryDataIntoTask(taskVersionPlans, wbsObjectMap, taskObjectMap);
            }
            if (wbsVersionPlans != null) {
                this.setHistoryDataIntoWbs(wbsVersionPlans, wbsObjectMap);
            }
        }
    }

    private void changeTaskWbsId(DynamicObject[] versionPlans, List<Long> deleteWbsId) {
        DynamicObject[] tasks;
        if (CollectionUtils.isEmpty(deleteWbsId)) {
            return;
        }
        QFilter qfilter = new QFilter("wbs.id", "in", deleteWbsId);
        QFilter vfilter = new QFilter("version.id", "is not null", null);
        vfilter.or("version.id", "!=", (Object)0);
        for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])new QFilter[]{qfilter, vfilter})) {
            String number = task.getDynamicObject("wbs").getString("number");
            for (DynamicObject versionPlan : versionPlans) {
                String wbsnumber = versionPlan.getString("number");
                if (!StringUtils.equals((String)wbsnumber, (String)number)) continue;
                task.set("wbs", (Object)versionPlan);
            }
        }
        SaveServiceHelper.update((DynamicObject[])tasks);
        QFilter wqfilter = new QFilter("id", "in", deleteWbsId);
        DeleteServiceHelper.delete((String)"pmts_wbs", (QFilter[])wqfilter.toArray());
    }

    private void setHistoryDataIntoTask(DynamicObject[] taskVersionPlans, Map<Long, DynamicObject> wbsObjectMap, Map<Long, DynamicObject> taskObjectMap) {
        for (DynamicObject task : taskVersionPlans) {
            DynamicObjectCollection preEntrys = task.getDynamicObjectCollection("prepositiontaskentry");
            this.setPositiontask(preEntrys, taskObjectMap, "prepositiontask");
            DynamicObjectCollection postEntrys = task.getDynamicObjectCollection("postpositiontaskentry");
            this.setPositiontask(postEntrys, taskObjectMap, "postpositiontask");
            DynamicObject wbs = task.getDynamicObject("wbs");
            if (wbs == null) continue;
            task.set("wbs", (Object)wbsObjectMap.get(wbs.getLong("id")));
        }
        SaveServiceHelper.update((DynamicObject[])taskVersionPlans);
    }

    private void setHistoryDataIntoWbs(DynamicObject[] wbsVersionPlans, Map<Long, DynamicObject> wbsObjectMap) {
        for (DynamicObject wbsVersionPlan : wbsVersionPlans) {
            DynamicObject oldParentWbs = wbsVersionPlan.getDynamicObject("parent");
            if (oldParentWbs == null) continue;
            wbsVersionPlan.set("parent", (Object)wbsObjectMap.get(oldParentWbs.getLong("id")));
        }
        SaveServiceHelper.update((DynamicObject[])wbsVersionPlans);
    }

    private void setPositiontask(DynamicObjectCollection entrys, Map<Long, DynamicObject> taskObjectMap, String name) {
        for (DynamicObject entry : entrys) {
            if (entry.getDynamicObject(name) == null) continue;
            entry.set(name, (Object)taskObjectMap.get(entry.getDynamicObject(name).getLong("id")));
        }
    }

    private void reverseBaseLinePlan(DynamicObject taskObject, DynamicObject version) {
        taskObject.set("baselinename", (Object)version.getString("number"));
        taskObject.set("baselinetype", (Object)version.getDynamicObject("versiontype").getString("name"));
        taskObject.set("bsplanerhour", taskObject.get("planhours"));
        taskObject.set("bsplaneqhour", taskObject.get("pfacilityhours"));
        taskObject.set("bsplandate", taskObject.get("plantime"));
        taskObject.set("bsstartdate", taskObject.get("planstartdate"));
        taskObject.set("bsenddate", taskObject.get("planenddate"));
        taskObject.set("bsearlydate", taskObject.get("firststartdate"));
        taskObject.set("bslaterdate", taskObject.get("firstenddate"));
    }

    protected void setBasePlanTime(DynamicObject clone) {
        DynamicObjectCollection subsectionentry = clone.getDynamicObjectCollection("subsectionentry");
        if (CollectionUtils.isEmpty((Collection)subsectionentry)) {
            return;
        }
        for (DynamicObject entry : subsectionentry) {
            entry.set("baseplanstartdate", entry.get("subplanstartdate"));
            entry.set("baseplanenddate", entry.get("subsubplanenddate"));
        }
    }

    private void reverseBaseLinePlanToNull(DynamicObject taskObject) {
        taskObject.set("baselinename", (Object)"");
        taskObject.set("baselinetype", (Object)"");
        taskObject.set("bsplanerhour", null);
        taskObject.set("bsplaneqhour", null);
        taskObject.set("bsplandate", null);
        taskObject.set("bsstartdate", null);
        taskObject.set("bsenddate", null);
        taskObject.set("bsearlydate", null);
        taskObject.set("bslaterdate", null);
    }

    private void reverseWbsBaseLinePlan(DynamicObject wbsObject, DynamicObject version) {
        wbsObject.set("baselinename", (Object)version.getString("number"));
        wbsObject.set("baselinetype", (Object)version.getDynamicObject("versiontype").getString("name"));
        wbsObject.set("bsplandate", wbsObject.get("plandays"));
        wbsObject.set("bsstartdate", wbsObject.get("planstartdate"));
        wbsObject.set("bsenddate", wbsObject.get("planenddate"));
    }

    private void reverseWbsBaseLinePlanToNull(DynamicObject wbsObject) {
        wbsObject.set("baselinename", (Object)"");
        wbsObject.set("baselinetype", (Object)"");
        wbsObject.set("bsplandate", null);
        wbsObject.set("bsstartdate", null);
        wbsObject.set("bsenddate", null);
    }

    private Map<String, DynamicObject[]> getChangeTasks(DynamicObjectCollection idCollection, DynamicObjectCollection baseLines) {
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> wbsList = new ArrayList<DynamicObject>();
        for (DynamicObject object : idCollection) {
            String number = object.getString("number");
            boolean isChange = false;
            int num = 0;
            for (DynamicObject baseLine : baseLines) {
                String baseLineNumber = baseLine.getString("number");
                if (StringUtils.equals((String)number, (String)baseLineNumber)) {
                    object.set("number", null);
                    object.set("id", null);
                    baseLine.set("number", null);
                    baseLine.set("id", null);
                    if (object.toString().equals(baseLine.toString())) continue;
                    isChange = true;
                    break;
                }
                ++num;
            }
            if (!isChange && baseLines.size() != num) continue;
            taskList.add(object);
            wbsList.add(object.getDynamicObject("wbs"));
        }
        HashMap<String, DynamicObject[]> dynamicObjectMap = new HashMap<String, DynamicObject[]>(16);
        dynamicObjectMap.put("pmts_task", taskList.toArray(new DynamicObject[0]));
        dynamicObjectMap.put("pmts_wbs", wbsList.toArray(new DynamicObject[0]));
        return dynamicObjectMap;
    }

    private Map<String, DynamicObject[]> getResourcePlanListBySelect(List<GanttRowDataModel> ganttRowDataModelList) {
        HashSet taskIds = new HashSet(ganttRowDataModelList.size());
        HashSet wbsIds = new HashSet(ganttRowDataModelList.size());
        ganttRowDataModelList.stream().forEach(ganttRowDataModel -> {
            if (ganttRowDataModel.getIsSealf().booleanValue() && ganttRowDataModel.getIsSelect().booleanValue()) {
                taskIds.add(Long.parseLong(ganttRowDataModel.getObjId()));
                wbsIds.add(Long.parseLong(ganttRowDataModel.getParentObjId()));
            }
            if (ganttRowDataModel.getEntityFlag().equals("pmts_wbs") && ganttRowDataModel.getIsSelect().booleanValue()) {
                wbsIds.add(Long.parseLong(ganttRowDataModel.getObjId()));
            }
        });
        HashMap entityToIdMap = new HashMap(16);
        entityToIdMap.put("pmts_task", taskIds);
        entityToIdMap.put("pmts_wbs", wbsIds);
        HashMap<String, DynamicObject[]> dynamicObjectMap = new HashMap<String, DynamicObject[]>(entityToIdMap.size());
        for (Map.Entry entityToIdEntry : entityToIdMap.entrySet()) {
            String entityNumber = (String)entityToIdEntry.getKey();
            Set ids = (Set)entityToIdEntry.getValue();
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)type);
            dynamicObjectMap.put(entityNumber, dynamicObjects);
        }
        return dynamicObjectMap;
    }
}

