/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ForecastByEqHandlerCoGroupFunction
extends CoGroupFunction {
    private static final Log logger = LogFactory.getLog(ForecastByEqHandlerCoGroupFunction.class);
    private static final long serialVersionUID = 640177612772637306L;
    private final RowMeta leftRowMeta;
    private final int shelflifeIndex;
    private final int useprobabilityIndex;
    private final int averageqtyIndex;
    private final int eqcountIndex;
    private final int forecastqtyIndex;
    private final int stockfactorIndex;
    private final int rightAcStockFactorIndex;
    private final DynamicObject defaultParams;

    public ForecastByEqHandlerCoGroupFunction(RowMeta leftRowMeta, RowMeta rightRowMeta, DynamicObject defaultParams) {
        this.leftRowMeta = leftRowMeta;
        this.shelflifeIndex = this.leftRowMeta.getFieldIndex("shelflife");
        this.useprobabilityIndex = this.leftRowMeta.getFieldIndex("useprobability");
        this.averageqtyIndex = this.leftRowMeta.getFieldIndex("averageqty");
        this.eqcountIndex = this.leftRowMeta.getFieldIndex("eqcount");
        this.forecastqtyIndex = this.leftRowMeta.getFieldIndex("forecastqty");
        this.stockfactorIndex = this.leftRowMeta.getFieldIndex("stockfactor");
        this.rightAcStockFactorIndex = rightRowMeta.getFieldIndex("acstockfactor");
        this.defaultParams = defaultParams;
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector out) {
        String acstockfactor = "";
        if (this.defaultParams != null) {
            acstockfactor = this.defaultParams.getString("acstockfactor");
        }
        for (RowX row : iterable1) {
            acstockfactor = row.getString(this.rightAcStockFactorIndex);
        }
        List stockList = null;
        if (StringUtils.isNotEmpty((String)acstockfactor)) {
            try {
                stockList = (List)JSONUtils.cast((String)acstockfactor, List.class, (Class[])new Class[]{Map.class});
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        for (RowX row : iterable) {
            RowX newRow = this.copyRow(row);
            Boolean shelflife = row.getBoolean(this.shelflifeIndex);
            shelflife = shelflife == null ? Boolean.FALSE : shelflife;
            BigDecimal useprobability = row.getBigDecimal(this.useprobabilityIndex);
            useprobability = useprobability == null ? BigDecimal.ZERO : useprobability;
            BigDecimal stockfactor = BigDecimal.ZERO;
            if (stockList != null) {
                BigDecimal curStock = BigDecimal.ONE;
                for (Map item : stockList) {
                    if (useprobability.compareTo(curStock) >= 0) {
                        if (shelflife.booleanValue()) {
                            stockfactor = new BigDecimal(String.valueOf(item.get("shelfLifeItem")));
                            break;
                        }
                        stockfactor = new BigDecimal(String.valueOf(item.get("noShelfLifeItem")));
                        break;
                    }
                    curStock = curStock.subtract(new BigDecimal("0.1"));
                }
            }
            newRow.set(this.stockfactorIndex, (Object)stockfactor);
            BigDecimal averageqty = newRow.getBigDecimal(this.averageqtyIndex);
            averageqty = averageqty == null ? BigDecimal.ZERO : averageqty;
            BigDecimal eqcount = newRow.getBigDecimal(this.eqcountIndex);
            eqcount = eqcount == null ? BigDecimal.ZERO : eqcount;
            BigDecimal forecastqty = averageqty.multiply(eqcount).multiply(stockfactor);
            newRow.set(this.forecastqtyIndex, (Object)forecastqty);
            out.collect(newRow);
        }
    }

    private RowX copyRow(RowX row) {
        RowX newRow = new RowX(this.leftRowMeta.getFieldCount());
        for (int i = 0; i < this.leftRowMeta.getFieldCount(); ++i) {
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

