/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ForecastByTimeHandlerCoGroupFunction
extends CoGroupFunction {
    private static final Log logger = LogFactory.getLog(ForecastByTimeHandlerCoGroupFunction.class);
    private static final long serialVersionUID = 640177612772637306L;
    private RowMeta leftRowMeta;
    private Map<String, Integer> leftNameRelIndex = new HashMap<String, Integer>(16);
    private Map<String, Integer> rightNameRelIndex = new HashMap<String, Integer>(16);
    private DynamicObject defaultParams;

    public ForecastByTimeHandlerCoGroupFunction(RowMeta leftRowMeta, RowMeta rightRowMeta, DynamicObject defaultParams) {
        Field[] fields2;
        Field[] fields;
        this.leftRowMeta = leftRowMeta;
        for (Field field : fields = leftRowMeta.getFields()) {
            this.leftNameRelIndex.put(field.getName(), leftRowMeta.getFieldIndex(field.getName()));
        }
        for (Field field : fields2 = rightRowMeta.getFields()) {
            this.rightNameRelIndex.put(field.getName(), rightRowMeta.getFieldIndex(field.getName()));
        }
        this.defaultParams = defaultParams;
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector out) {
        String quarterfactorStr = "";
        String stockfactorStr = "";
        String servicefactorStr = "";
        BigDecimal deliveryfactorParams = BigDecimal.ZERO;
        BigDecimal deliveryfactornoParams = BigDecimal.ZERO;
        BigDecimal avgdeliveryParams = BigDecimal.ZERO;
        BigDecimal delstandadevParams = BigDecimal.ZERO;
        if (this.defaultParams != null) {
            quarterfactorStr = this.defaultParams.getString("quarterfactor");
            stockfactorStr = this.defaultParams.getString("stockfactor");
            servicefactorStr = this.defaultParams.getString("servicefactor");
            deliveryfactorParams = this.defaultParams.getBigDecimal("deliveryfactor");
            deliveryfactornoParams = this.defaultParams.getBigDecimal("deliveryfactorno");
            avgdeliveryParams = this.defaultParams.getBigDecimal("avgdelivery");
            delstandadevParams = this.defaultParams.getBigDecimal("delstandadev");
        }
        for (RowX row : iterable1) {
            quarterfactorStr = row.getString(this.rightNameRelIndex.get("quarterfactor").intValue());
            stockfactorStr = row.getString(this.rightNameRelIndex.get("stockfactor").intValue());
            servicefactorStr = row.getString(this.rightNameRelIndex.get("servicefactor").intValue());
            deliveryfactorParams = row.getBigDecimal(this.rightNameRelIndex.get("deliveryfactor").intValue());
            deliveryfactornoParams = row.getBigDecimal(this.rightNameRelIndex.get("deliveryfactorno").intValue());
            avgdeliveryParams = row.getBigDecimal(this.rightNameRelIndex.get("avgdelivery").intValue());
            delstandadevParams = row.getBigDecimal(this.rightNameRelIndex.get("delstandadev").intValue());
        }
        List quarterfactorList = null;
        List stockfactorList = null;
        List servicefactorList = null;
        try {
            if (StringUtils.isNotEmpty((String)quarterfactorStr)) {
                quarterfactorList = (List)JSONUtils.cast((String)quarterfactorStr, List.class, (Class[])new Class[]{Map.class});
            }
            if (StringUtils.isNotEmpty((String)stockfactorStr)) {
                stockfactorList = (List)JSONUtils.cast((String)stockfactorStr, List.class, (Class[])new Class[]{Map.class});
            }
            if (StringUtils.isNotEmpty((String)servicefactorStr)) {
                servicefactorList = (List)JSONUtils.cast((String)servicefactorStr, List.class, (Class[])new Class[]{Map.class});
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        for (RowX row : iterable) {
            RowX newRow = this.copyRow(row);
            BigDecimal delstandadev = newRow.getBigDecimal(this.leftNameRelIndex.get("delstandadev").intValue());
            delstandadev = delstandadev == null ? delstandadevParams : delstandadev;
            BigDecimal avgdelivery = newRow.getBigDecimal(this.leftNameRelIndex.get("avgdelivery").intValue());
            avgdelivery = avgdelivery == null ? avgdeliveryParams : avgdelivery;
            BigDecimal daystandadev = newRow.getBigDecimal(this.leftNameRelIndex.get("daystandadev").intValue());
            daystandadev = daystandadev == null ? BigDecimal.ZERO : daystandadev;
            newRow.set(this.leftNameRelIndex.get("delstandadev").intValue(), (Object)delstandadev);
            newRow.set(this.leftNameRelIndex.get("avgdelivery").intValue(), (Object)avgdelivery);
            Boolean shelflife = row.getBoolean(this.leftNameRelIndex.get("shelflife").intValue());
            shelflife = shelflife == null ? Boolean.FALSE : shelflife;
            Integer usemonthcount = newRow.getInteger(this.leftNameRelIndex.get("usemonthcount").intValue());
            usemonthcount = usemonthcount == null ? Integer.valueOf(0) : usemonthcount;
            BigDecimal averagedayqty = newRow.getBigDecimal(this.leftNameRelIndex.get("averagedayqty").intValue());
            averagedayqty = averagedayqty == null ? BigDecimal.ZERO : averagedayqty;
            BigDecimal averageqty = newRow.getBigDecimal(this.leftNameRelIndex.get("averageqty").intValue());
            averageqty = averageqty == null ? BigDecimal.ZERO : averageqty;
            String qcode = newRow.getString(this.leftNameRelIndex.get("qcode").intValue());
            BigDecimal quarterfactor = BigDecimal.ZERO;
            if (StringUtils.isNotEmpty((String)qcode) && quarterfactorList != null) {
                for (Map item : quarterfactorList) {
                    String itemQCode = String.valueOf(item.get("quarterCode"));
                    if (!qcode.equalsIgnoreCase(itemQCode)) continue;
                    quarterfactor = new BigDecimal(String.valueOf(item.get("quarterFactor")));
                    break;
                }
            }
            newRow.set(this.leftNameRelIndex.get("quarterfactor").intValue(), (Object)quarterfactor);
            BigDecimal stockfactor = BigDecimal.ZERO;
            if (stockfactorList != null) {
                for (int i = 0; i < stockfactorList.size(); ++i) {
                    if (usemonthcount != i) continue;
                    if (shelflife.booleanValue()) {
                        stockfactor = new BigDecimal(String.valueOf(((Map)stockfactorList.get(i)).get("shelfLifeItem")));
                        break;
                    }
                    stockfactor = new BigDecimal(String.valueOf(((Map)stockfactorList.get(i)).get("noShelfLifeItem")));
                    break;
                }
            }
            newRow.set(this.leftNameRelIndex.get("stockfactor").intValue(), (Object)stockfactor);
            BigDecimal serviceFactor = BigDecimal.ZERO;
            if (servicefactorList != null) {
                for (int i = 0; i < servicefactorList.size(); ++i) {
                    if (usemonthcount != i) continue;
                    serviceFactor = new BigDecimal(String.valueOf(((Map)servicefactorList.get(i)).get("serviceFactor")));
                    break;
                }
                newRow.set(this.leftNameRelIndex.get("servicefactor").intValue(), (Object)serviceFactor);
            }
            BigDecimal deliveryfactor = shelflife != false ? deliveryfactorParams : deliveryfactornoParams;
            newRow.set(this.leftNameRelIndex.get("deliveryfactor").intValue(), (Object)deliveryfactor);
            BigDecimal a = avgdelivery.multiply(daystandadev.multiply(daystandadev));
            BigDecimal b = averagedayqty.multiply(averagedayqty).multiply(delstandadev.multiply(delstandadev));
            BigDecimal c = a.add(b);
            double result = Math.sqrt(c.doubleValue());
            BigDecimal d = BigDecimal.valueOf(result).setScale(10, 4);
            BigDecimal safestock = serviceFactor.multiply(d);
            BigDecimal rop = averagedayqty.multiply(avgdelivery.add(deliveryfactor)).add(safestock);
            BigDecimal roq = averageqty.multiply(stockfactor);
            BigDecimal targetstock = rop.add(roq).multiply(quarterfactor);
            newRow.set(this.leftNameRelIndex.get("safestock").intValue(), (Object)safestock);
            newRow.set(this.leftNameRelIndex.get("rop").intValue(), (Object)rop);
            newRow.set(this.leftNameRelIndex.get("roq").intValue(), (Object)roq);
            newRow.set(this.leftNameRelIndex.get("targetstock").intValue(), (Object)targetstock);
            out.collect(newRow);
        }
    }

    private RowX copyRow(RowX row) {
        RowX newRow = new RowX(this.leftRowMeta.getFieldCount());
        for (int i = 0; i < this.leftRowMeta.getFieldCount(); ++i) {
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

