/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;

public class GeneralSuggestHandlerCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 640177612772637306L;
    private RowMeta leftRowMeta;
    private Map<String, Integer> leftNameRelIndex = new HashMap<String, Integer>(16);
    private Map<String, Integer> rightNameRelIndex = new HashMap<String, Integer>(16);
    private DynamicObject defaultParams;
    private boolean isSpecial;

    public GeneralSuggestHandlerCoGroupFunction(RowMeta leftRowMeta, RowMeta rightRowMeta, DynamicObject defaultParams, boolean isSpecial) {
        Field[] fields2;
        Field[] fields;
        this.leftRowMeta = leftRowMeta;
        for (Field field : fields = leftRowMeta.getFields()) {
            this.leftNameRelIndex.put(field.getName(), leftRowMeta.getFieldIndex(field.getName()));
        }
        for (Field field : fields2 = rightRowMeta.getFields()) {
            this.rightNameRelIndex.put(field.getName(), rightRowMeta.getFieldIndex(field.getName()));
        }
        this.defaultParams = defaultParams;
        this.isSpecial = isSpecial;
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector out) {
        String inventorylevelhigh = "";
        String inventorylevellow = "";
        if (this.defaultParams != null) {
            inventorylevelhigh = this.defaultParams.getString("inventorylevelhigh");
            inventorylevellow = this.defaultParams.getString("inventorylevellow");
        }
        for (RowX row : iterable1) {
            inventorylevelhigh = row.getString(this.rightNameRelIndex.get("inventorylevelhigh").intValue());
            inventorylevellow = row.getString(this.rightNameRelIndex.get("inventorylevellow").intValue());
        }
        for (RowX row : iterable) {
            BigDecimal calstocklevel;
            RowX newRow = this.copyRow(row);
            BigDecimal targetstock = row.getBigDecimal(this.leftNameRelIndex.get("targetstock").intValue());
            targetstock = targetstock == null ? BigDecimal.ZERO : targetstock;
            BigDecimal forecastqty = row.getBigDecimal(this.leftNameRelIndex.get("forecastqty").intValue());
            forecastqty = forecastqty == null ? BigDecimal.ZERO : forecastqty;
            String calmethod = row.getString(this.leftNameRelIndex.get("calstocklevel").intValue());
            calmethod = StringUtils.isEmpty((String)calmethod) ? "5" : calmethod;
            BigDecimal specialreq = row.getBigDecimal(this.leftNameRelIndex.get("specialreq").intValue());
            BigDecimal bigDecimal = specialreq = specialreq == null ? BigDecimal.ZERO : specialreq;
            if (this.isSpecial) {
                calstocklevel = targetstock;
            } else {
                String inventorylevel = "";
                inventorylevel = targetstock.compareTo(forecastqty) >= 0 ? inventorylevelhigh : inventorylevellow;
                calstocklevel = "1".equalsIgnoreCase(inventorylevel) ? targetstock : ("2".equalsIgnoreCase(inventorylevel) ? forecastqty : targetstock.add(forecastqty).divide(new BigDecimal(2), 10, 4));
            }
            newRow.set(this.leftNameRelIndex.get("calstocklevel").intValue(), (Object)calstocklevel);
            BigDecimal suggestqty = "1".equals(calmethod) ? (calstocklevel.compareTo(specialreq) > 0 ? calstocklevel : specialreq) : ("2".equals(calmethod) ? (calstocklevel.compareTo(specialreq) < 0 ? calstocklevel : specialreq) : ("3".equals(calmethod) ? calstocklevel.add(specialreq) : ("4".equals(calmethod) ? calstocklevel.add(specialreq).divide(new BigDecimal(2), 10, 4) : calstocklevel)));
            newRow.set(this.leftNameRelIndex.get("suggestqty").intValue(), (Object)suggestqty);
            out.collect(newRow);
        }
    }

    private RowX copyRow(RowX row) {
        RowX newRow = new RowX(this.leftRowMeta.getFieldCount());
        for (int i = 0; i < this.leftRowMeta.getFieldCount(); ++i) {
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

