/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class HisUseResultLate12MonthReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 640177612772637302L;
    private RowMeta rowMeta;
    private RowMeta oldRowMeta;
    private int qtyIndex;
    private int customerIndex;
    private int actypeIndex;
    private int checktypeIndex;
    private int materialtypeIndex;
    private int materialIndex;
    private int unitIndex;
    private int materialchangeIndex;
    private int usedateIndex;
    private int supplyrespIndex;
    private int beforematerialnumberIndex;
    private int beforematerialnameIndex;
    private int beforeunitnameIndex;
    private Map<Integer, Integer> offSetRelMonthDays = new HashMap<Integer, Integer>(16);
    private Calendar curDate = Calendar.getInstance();

    public HisUseResultLate12MonthReduceGroupFunction(RowMeta rowMeta) {
        this.rowMeta = this.buildResultRowMeta();
        this.oldRowMeta = rowMeta;
        this.qtyIndex = this.oldRowMeta.getFieldIndex("qty");
        this.customerIndex = this.oldRowMeta.getFieldIndex("customer");
        this.actypeIndex = this.oldRowMeta.getFieldIndex("actype");
        this.checktypeIndex = this.oldRowMeta.getFieldIndex("checktype");
        this.materialtypeIndex = this.oldRowMeta.getFieldIndex("materialtype");
        this.materialIndex = this.oldRowMeta.getFieldIndex("material");
        this.unitIndex = this.oldRowMeta.getFieldIndex("unit");
        this.materialchangeIndex = this.oldRowMeta.getFieldIndex("materialchange");
        this.usedateIndex = this.oldRowMeta.getFieldIndex("usedate");
        this.supplyrespIndex = this.oldRowMeta.getFieldIndex("supplyresp");
        this.beforematerialnumberIndex = this.oldRowMeta.getFieldIndex("beforematerial.number");
        this.beforematerialnameIndex = this.oldRowMeta.getFieldIndex("beforematerial.name");
        this.beforeunitnameIndex = this.oldRowMeta.getFieldIndex("beforeunit.name");
        this.initOffSetRelMonthDays();
    }

    private void initOffSetRelMonthDays() {
        Calendar calendar = Calendar.getInstance();
        for (int i = 1; i < 13; ++i) {
            calendar.setTime(this.curDate.getTime());
            calendar.set(5, 1);
            calendar.add(2, -i + 1);
            calendar.add(5, -1);
            this.offSetRelMonthDays.put(i, calendar.get(5));
        }
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        BigDecimal qty12m = BigDecimal.ZERO;
        BigDecimal insupplyqty = BigDecimal.ZERO;
        BigDecimal custosupplyqty = BigDecimal.ZERO;
        int usemonthcount = 0;
        Integer ordercountall = 0;
        boolean materialchange = false;
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>(16);
        HashMap<Integer, BigDecimal> qtyMap = new HashMap<Integer, BigDecimal>(16);
        HashMap<String, CharSequence[]> beforeMaterialMap = new HashMap<String, CharSequence[]>(16);
        RowX newRow = null;
        for (RowX row : rows) {
            String beforematerialnumber;
            if (newRow == null) {
                newRow = this.buildRow(row);
            }
            if (row.getBoolean(this.materialchangeIndex).booleanValue()) {
                materialchange = true;
            }
            beforematerialnumber = (beforematerialnumber = row.getString(this.beforematerialnumberIndex)) == null ? "" : beforematerialnumber;
            String beforematerialname = row.getString(this.beforematerialnameIndex);
            beforematerialname = beforematerialname == null ? "" : beforematerialname;
            String beforeunitname = row.getString(this.beforeunitnameIndex);
            beforeunitname = beforeunitname == null ? "" : beforeunitname;
            CharSequence[] beforeMaterial = new String[]{beforematerialnumber, beforematerialname, beforeunitname};
            beforeMaterialMap.put(String.join((CharSequence)"_", beforeMaterial), beforeMaterial);
            Date useDate = row.getDate(this.usedateIndex);
            if (!this.inLate12Month(useDate)) continue;
            Integer n = ordercountall;
            Integer n2 = ordercountall = Integer.valueOf(ordercountall + 1);
            int offset = this.getMonthOffset(useDate);
            Integer ordercount = (Integer)countMap.get(offset);
            if (ordercount == null) {
                ordercount = 1;
            } else {
                Integer n3 = ordercount;
                Integer n4 = ordercount = Integer.valueOf(ordercount + 1);
            }
            countMap.put(offset, ordercount);
            BigDecimal curQty = row.getBigDecimal(this.qtyIndex);
            if (curQty == null) continue;
            String supplyresp = row.getString(this.supplyrespIndex);
            if ("0".equals(supplyresp)) {
                insupplyqty = insupplyqty.add(curQty);
            } else if ("1".equals(supplyresp)) {
                custosupplyqty = custosupplyqty.add(curQty);
            }
            qty12m = qty12m.add(curQty);
            BigDecimal mQty = (BigDecimal)qtyMap.get(offset);
            mQty = mQty == null ? BigDecimal.ZERO.add(curQty) : mQty.add(curQty);
            qtyMap.put(offset, mQty);
        }
        if (newRow != null) {
            newRow.set(6, (Object)qty12m);
            usemonthcount = countMap.size();
            newRow.set(9, (Object)usemonthcount);
            newRow.set(18, (Object)ordercountall);
            newRow.set(48, (Object)materialchange);
            LinkedList<BigDecimal> monthstandadevList = new LinkedList<BigDecimal>();
            LinkedList<BigDecimal> standadev12mList = new LinkedList<BigDecimal>();
            LinkedList<BigDecimal> daystandadevList = new LinkedList<BigDecimal>();
            LinkedList<BigDecimal> daystandadev12mList = new LinkedList<BigDecimal>();
            for (int i = 1; i < 13; ++i) {
                Integer ordercount = (Integer)countMap.get(i);
                BigDecimal mqty = (BigDecimal)qtyMap.get(i);
                if (ordercount != null) {
                    newRow.set(18 + i, (Object)ordercount);
                } else {
                    newRow.set(18 + i, (Object)0);
                }
                if (mqty != null) {
                    newRow.set(35 + i, (Object)mqty);
                    monthstandadevList.add(mqty);
                    standadev12mList.add(mqty);
                    BigDecimal daystandadevAvg = mqty.divide(new BigDecimal(this.offSetRelMonthDays.getOrDefault(i, 30)), 10, 4);
                    daystandadevList.add(daystandadevAvg);
                    daystandadev12mList.add(daystandadevAvg);
                    continue;
                }
                newRow.set(35 + i, (Object)BigDecimal.ZERO);
                standadev12mList.add(BigDecimal.ZERO);
                daystandadev12mList.add(BigDecimal.ZERO);
            }
            newRow.set(7, (Object)insupplyqty);
            newRow.set(8, (Object)custosupplyqty);
            if (usemonthcount > 0) {
                newRow.set(10, (Object)qty12m.divide(new BigDecimal(usemonthcount), 10, 4));
            }
            newRow.set(11, (Object)qty12m.divide(new BigDecimal(12), 10, 4));
            if (usemonthcount > 0) {
                newRow.set(12, (Object)qty12m.divide(new BigDecimal(365).multiply(new BigDecimal(usemonthcount)).divide(new BigDecimal(12), 10, 4), 10, 4));
            }
            newRow.set(13, (Object)qty12m.divide(new BigDecimal(365), 10, 4));
            BigDecimal monthstandadev = this.variance(monthstandadevList);
            newRow.set(14, (Object)monthstandadev);
            BigDecimal standadev12m = this.variance(standadev12mList);
            newRow.set(15, (Object)standadev12m);
            BigDecimal daystandadev = this.variance(daystandadevList);
            newRow.set(16, (Object)daystandadev);
            BigDecimal daystandadev12m = this.variance(daystandadev12mList);
            newRow.set(17, (Object)daystandadev12m);
            String quarter1 = countMap.keySet().stream().anyMatch(o -> o >= 1 && o <= 3) ? "1" : "0";
            String quarter2 = countMap.keySet().stream().anyMatch(o -> o >= 4 && o <= 6) ? "1" : "0";
            String quarter3 = countMap.keySet().stream().anyMatch(o -> o >= 7 && o <= 9) ? "1" : "0";
            String quarter4 = countMap.keySet().stream().anyMatch(o -> o >= 10 && o <= 12) ? "1" : "0";
            String qcode = quarter1 + quarter2 + quarter3 + quarter4;
            newRow.set(31, (Object)qcode);
            newRow.set(32, (Object)quarter1);
            newRow.set(33, (Object)quarter2);
            newRow.set(34, (Object)quarter3);
            newRow.set(35, (Object)quarter4);
            Collection values = beforeMaterialMap.values();
            newRow.set(49, (Object)values.stream().map(o -> o[0]).collect(Collectors.joining("/")));
            newRow.set(50, (Object)values.stream().map(o -> o[1]).collect(Collectors.joining("/")));
            newRow.set(51, (Object)values.stream().map(o -> o[2]).collect(Collectors.joining("/")));
            out.collect(newRow);
        }
    }

    private int getMonthOffset(Date useDate) {
        int curYear = this.curDate.get(1);
        int curMonth = this.curDate.get(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(useDate);
        int useYear = calendar.get(1);
        int useMonth = calendar.get(2);
        return curMonth - useMonth + 12 * (curYear - useYear);
    }

    private RowX buildRow(RowX oldRow) {
        RowX row = new RowX(this.rowMeta.getFieldCount());
        row.set(0, oldRow.get(this.customerIndex));
        row.set(1, oldRow.get(this.actypeIndex));
        row.set(2, oldRow.get(this.checktypeIndex));
        row.set(3, oldRow.get(this.materialtypeIndex));
        row.set(4, oldRow.get(this.materialIndex));
        row.set(5, oldRow.get(this.unitIndex));
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowMeta buildResultRowMeta() {
        String[] fieldNames = new String[52];
        DataType[] dataTypes = new DataType[52];
        fieldNames[0] = "customer";
        dataTypes[0] = DataType.LongType;
        fieldNames[1] = "actype";
        dataTypes[1] = DataType.LongType;
        fieldNames[2] = "checktype";
        dataTypes[2] = DataType.LongType;
        fieldNames[3] = "materialtype";
        dataTypes[3] = DataType.LongType;
        fieldNames[4] = "material";
        dataTypes[4] = DataType.LongType;
        fieldNames[5] = "unit";
        dataTypes[5] = DataType.LongType;
        fieldNames[6] = "qty12m";
        dataTypes[6] = DataType.BigDecimalType;
        fieldNames[7] = "insupplyqty";
        dataTypes[7] = DataType.BigDecimalType;
        fieldNames[8] = "custosupplyqty";
        dataTypes[8] = DataType.BigDecimalType;
        fieldNames[9] = "usemonthcount";
        dataTypes[9] = DataType.IntegerType;
        fieldNames[10] = "averageqty";
        dataTypes[10] = DataType.BigDecimalType;
        fieldNames[11] = "averageqty12m";
        dataTypes[11] = DataType.BigDecimalType;
        fieldNames[12] = "averagedayqty";
        dataTypes[12] = DataType.BigDecimalType;
        fieldNames[13] = "averageyearqty";
        dataTypes[13] = DataType.BigDecimalType;
        fieldNames[14] = "monthstandadev";
        dataTypes[14] = DataType.BigDecimalType;
        fieldNames[15] = "standadev12m";
        dataTypes[15] = DataType.BigDecimalType;
        fieldNames[16] = "daystandadev";
        dataTypes[16] = DataType.BigDecimalType;
        fieldNames[17] = "daystandadev12m";
        dataTypes[17] = DataType.BigDecimalType;
        fieldNames[18] = "ordercountall";
        dataTypes[18] = DataType.IntegerType;
        fieldNames[19] = "ordercount1";
        dataTypes[19] = DataType.IntegerType;
        fieldNames[20] = "ordercount2";
        dataTypes[20] = DataType.IntegerType;
        fieldNames[21] = "ordercount3";
        dataTypes[21] = DataType.IntegerType;
        fieldNames[22] = "ordercount4";
        dataTypes[22] = DataType.IntegerType;
        fieldNames[23] = "ordercount5";
        dataTypes[23] = DataType.IntegerType;
        fieldNames[24] = "ordercount6";
        dataTypes[24] = DataType.IntegerType;
        fieldNames[25] = "ordercount7";
        dataTypes[25] = DataType.IntegerType;
        fieldNames[26] = "ordercount8";
        dataTypes[26] = DataType.IntegerType;
        fieldNames[27] = "ordercount9";
        dataTypes[27] = DataType.IntegerType;
        fieldNames[28] = "ordercount10";
        dataTypes[28] = DataType.IntegerType;
        fieldNames[29] = "ordercount11";
        dataTypes[29] = DataType.IntegerType;
        fieldNames[30] = "ordercount12";
        dataTypes[30] = DataType.IntegerType;
        fieldNames[31] = "qcode";
        dataTypes[31] = DataType.StringType;
        fieldNames[32] = "quarter1";
        dataTypes[32] = DataType.StringType;
        fieldNames[33] = "quarter2";
        dataTypes[33] = DataType.StringType;
        fieldNames[34] = "quarter3";
        dataTypes[34] = DataType.StringType;
        fieldNames[35] = "quarter4";
        dataTypes[35] = DataType.StringType;
        fieldNames[36] = "mqty1";
        dataTypes[36] = DataType.BigDecimalType;
        fieldNames[37] = "mqty2";
        dataTypes[37] = DataType.BigDecimalType;
        fieldNames[38] = "mqty3";
        dataTypes[38] = DataType.BigDecimalType;
        fieldNames[39] = "mqty4";
        dataTypes[39] = DataType.BigDecimalType;
        fieldNames[40] = "mqty5";
        dataTypes[40] = DataType.BigDecimalType;
        fieldNames[41] = "mqty6";
        dataTypes[41] = DataType.BigDecimalType;
        fieldNames[42] = "mqty7";
        dataTypes[42] = DataType.BigDecimalType;
        fieldNames[43] = "mqty8";
        dataTypes[43] = DataType.BigDecimalType;
        fieldNames[44] = "mqty9";
        dataTypes[44] = DataType.BigDecimalType;
        fieldNames[45] = "mqty10";
        dataTypes[45] = DataType.BigDecimalType;
        fieldNames[46] = "mqty11";
        dataTypes[46] = DataType.BigDecimalType;
        fieldNames[47] = "mqty12";
        dataTypes[47] = DataType.BigDecimalType;
        fieldNames[48] = "materialchange";
        dataTypes[48] = DataType.BooleanType;
        fieldNames[49] = "beforematerialnumber";
        dataTypes[49] = DataType.StringType;
        fieldNames[50] = "beforematerialname";
        dataTypes[50] = DataType.StringType;
        fieldNames[51] = "beforeunitname";
        dataTypes[51] = DataType.StringType;
        return new RowMeta(fieldNames, dataTypes);
    }

    private BigDecimal variance(List<BigDecimal> values) {
        int m = values.size();
        if (m < 2) {
            return null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            sum = sum.add(value);
        }
        BigDecimal dAve = sum.divide(new BigDecimal(m), 10, 4);
        BigDecimal dVar = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            dVar = dVar.add(value.subtract(dAve).multiply(value.subtract(dAve)));
        }
        BigDecimal resultBig = dVar.divide(new BigDecimal(m - 1), 10, 4);
        double result = resultBig.doubleValue();
        result = Math.sqrt(result);
        return BigDecimal.valueOf(result).setScale(10, 4);
    }

    public Map<String, Date> getLate12Month() {
        HashMap<String, Date> params = new HashMap<String, Date>(16);
        Calendar c = Calendar.getInstance();
        c.setTime(this.curDate.getTime());
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date endDate = c.getTime();
        c.add(2, -12);
        Date startDate = c.getTime();
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        return params;
    }

    private boolean inLate12Month(Date useDate) {
        Map<String, Date> params = this.getLate12Month();
        Date startDate = params.get("startDate");
        Date endDate = params.get("endDate");
        return useDate.compareTo(startDate) >= 0 && useDate.compareTo(endDate) < 0;
    }
}

