/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.util.HashSet;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;

public class HisUseResultMaterialGeneralCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 640177612772637306L;
    private RowMeta leftRowMeta;
    private RowMeta rightRowMeta;
    private int isgeneralIndex;
    private int leftCustomerIndex;
    private int leftActypeIndex;
    private int rightCustomerIndex;
    private int rightActypeIndex;

    public HisUseResultMaterialGeneralCoGroupFunction(RowMeta leftRowMeta, RowMeta rightRowMeta) {
        this.leftRowMeta = leftRowMeta;
        this.rightRowMeta = rightRowMeta;
        this.isgeneralIndex = this.leftRowMeta.getFieldIndex("isgeneral");
        this.leftCustomerIndex = this.leftRowMeta.getFieldIndex("customer");
        this.leftActypeIndex = this.leftRowMeta.getFieldIndex("actype");
        this.rightCustomerIndex = this.rightRowMeta.getFieldIndex("customer");
        this.rightActypeIndex = this.rightRowMeta.getFieldIndex("actype");
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector out) {
        boolean allMatch = false;
        HashSet<String> rightSet = new HashSet<String>(16);
        for (RowX row : iterable1) {
            Long rightCustomer = row.getLong(this.rightCustomerIndex);
            Long rightActype = row.getLong(this.rightActypeIndex);
            if (rightCustomer == null) {
                rightCustomer = 0L;
            }
            if (rightActype == null) {
                rightActype = 0L;
            }
            if (rightCustomer == 0L && rightActype == 0L) {
                allMatch = true;
                break;
            }
            rightSet.add(rightCustomer + "_" + rightActype);
        }
        for (RowX row : iterable) {
            RowX newRow = this.copyRow(row);
            if (allMatch) {
                newRow.set(this.isgeneralIndex, (Object)true);
            } else if (rightSet.size() > 0) {
                Long leftCustomer = row.getLong(this.leftCustomerIndex);
                Long leftActype = row.getLong(this.leftActypeIndex);
                if (leftCustomer == null) {
                    leftCustomer = 0L;
                }
                if (leftActype == null) {
                    leftActype = 0L;
                }
                String match1 = leftCustomer + "_" + leftActype;
                String match2 = "0_" + leftActype;
                String match3 = leftCustomer + "_0";
                if (rightSet.contains(match1) || rightSet.contains(match2) || rightSet.contains(match3)) {
                    newRow.set(this.isgeneralIndex, (Object)true);
                }
            }
            out.collect(newRow);
        }
    }

    private RowX copyRow(RowX row) {
        RowX newRow = new RowX(this.leftRowMeta.getFieldCount());
        for (int i = 0; i < this.leftRowMeta.getFieldCount(); ++i) {
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

