/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class HisUseResultReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 640177612772637306L;
    private RowMeta rowMeta = this.buildResultRowMeta();
    private RowMeta oldRowMeta;
    private int qtyIndex;
    private int atachapternoIndex;
    private int customerIndex;
    private int actypeIndex;
    private int checktypeIndex;
    private int materialtypeIndex;
    private int materialIndex;
    private int unitIndex;

    public HisUseResultReduceGroupFunction(RowMeta rowMeta) {
        this.oldRowMeta = rowMeta;
        this.qtyIndex = this.oldRowMeta.getFieldIndex("qty");
        this.atachapternoIndex = this.oldRowMeta.getFieldIndex("atachapterno");
        this.customerIndex = this.oldRowMeta.getFieldIndex("customer");
        this.actypeIndex = this.oldRowMeta.getFieldIndex("actype");
        this.checktypeIndex = this.oldRowMeta.getFieldIndex("checktype");
        this.materialtypeIndex = this.oldRowMeta.getFieldIndex("materialtype");
        this.materialIndex = this.oldRowMeta.getFieldIndex("material");
        this.unitIndex = this.oldRowMeta.getFieldIndex("unit");
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        RowX newRow = null;
        BigDecimal total = BigDecimal.ZERO;
        HashSet<Long> atachapternoIds = new HashSet<Long>(16);
        for (RowX row : rows) {
            Long curatachapterno;
            BigDecimal curQty;
            if (newRow == null) {
                newRow = this.buildRow(row);
            }
            if ((curQty = row.getBigDecimal(this.qtyIndex)) != null) {
                total = total.add(curQty);
            }
            if ((curatachapterno = row.getLong(this.atachapternoIndex)) == null) continue;
            atachapternoIds.add(curatachapterno);
        }
        if (newRow != null) {
            newRow.set(6, (Object)total);
            newRow.set(7, (Object)atachapternoIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            out.collect(newRow);
        }
    }

    private RowX buildRow(RowX oldRow) {
        RowX row = new RowX(this.rowMeta.getFieldCount());
        row.set(0, oldRow.get(this.customerIndex));
        row.set(1, oldRow.get(this.actypeIndex));
        row.set(2, oldRow.get(this.checktypeIndex));
        row.set(3, oldRow.get(this.materialtypeIndex));
        row.set(4, oldRow.get(this.materialIndex));
        row.set(5, oldRow.get(this.unitIndex));
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowMeta buildResultRowMeta() {
        String[] fieldNames = new String[8];
        DataType[] dataTypes = new DataType[8];
        fieldNames[0] = "customer";
        dataTypes[0] = DataType.LongType;
        fieldNames[1] = "actype";
        dataTypes[1] = DataType.LongType;
        fieldNames[2] = "checktype";
        dataTypes[2] = DataType.LongType;
        fieldNames[3] = "materialtype";
        dataTypes[3] = DataType.LongType;
        fieldNames[4] = "material";
        dataTypes[4] = DataType.LongType;
        fieldNames[5] = "unit";
        dataTypes[5] = DataType.LongType;
        fieldNames[6] = "qty";
        dataTypes[6] = DataType.BigDecimalType;
        fieldNames[7] = "atachapterno";
        dataTypes[7] = DataType.StringType;
        return new RowMeta(fieldNames, dataTypes);
    }
}

