/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class MaterialTransformMapFunction
extends MapFunction {
    private static final long serialVersionUID = 3691049377965116848L;
    private RowMeta rowMeta;
    private RowMeta oldRowMeta;
    private int materialIndex;
    private int unitIndex;
    private int qtyIndex;
    private int beforeMaterialIndex;
    private int beforeUnitIndex;
    private int beforeQtyIndex;
    private int coefficientIndex;
    private int aftermaterielIndex;
    private int afterunitIndex;
    private int materialchangeIndex;

    public MaterialTransformMapFunction(RowMeta rowMeta) {
        this.rowMeta = this.buildResultRowMeta(rowMeta);
        this.materialIndex = this.rowMeta.getFieldIndex("material");
        this.unitIndex = this.rowMeta.getFieldIndex("unit");
        this.qtyIndex = this.rowMeta.getFieldIndex("qty");
        this.beforeMaterialIndex = this.rowMeta.getFieldIndex("beforematerial");
        this.beforeUnitIndex = this.rowMeta.getFieldIndex("beforeunit");
        this.beforeQtyIndex = this.rowMeta.getFieldIndex("billqty");
        this.coefficientIndex = this.rowMeta.getFieldIndex("coefficient");
        this.aftermaterielIndex = this.rowMeta.getFieldIndex("aftermateriel");
        this.afterunitIndex = this.rowMeta.getFieldIndex("afterunit");
        this.materialchangeIndex = this.rowMeta.getFieldIndex("materialchange");
        this.oldRowMeta = rowMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        for (int i = 0; i < this.oldRowMeta.getFieldCount(); ++i) {
            newRow.set(i, row.get(i));
        }
        BigDecimal coefficient = newRow.getBigDecimal(this.coefficientIndex);
        BigDecimal beforeQty = newRow.getBigDecimal(this.beforeQtyIndex);
        newRow.set(this.beforeMaterialIndex, newRow.get(this.materialIndex));
        newRow.set(this.beforeUnitIndex, newRow.get(this.unitIndex));
        newRow.set(this.qtyIndex, (Object)beforeQty);
        newRow.set(this.materialchangeIndex, (Object)false);
        if (coefficient != null) {
            newRow.set(this.materialIndex, newRow.get(this.aftermaterielIndex));
            newRow.set(this.unitIndex, newRow.get(this.afterunitIndex));
            if (beforeQty != null) {
                newRow.set(this.qtyIndex, (Object)coefficient.multiply(newRow.getBigDecimal(this.beforeQtyIndex)));
            }
            newRow.set(this.materialchangeIndex, (Object)true);
        }
        return newRow;
    }

    private RowMeta buildResultRowMeta(RowMeta rowMeta) {
        LinkedList<String> mainFieldList = new LinkedList<String>();
        mainFieldList.add("material");
        mainFieldList.add("unit");
        mainFieldList.add("qty");
        mainFieldList.add("billqty");
        mainFieldList.add("beforematerial");
        mainFieldList.add("beforeunit");
        mainFieldList.add("coefficient");
        mainFieldList.add("aftermateriel");
        mainFieldList.add("afterunit");
        mainFieldList.add("materialchange");
        LinkedList<Field> addField = new LinkedList<Field>(Arrays.asList(rowMeta.getFields()));
        for (String fieldStr : mainFieldList) {
            Field field = rowMeta.getField(fieldStr, false);
            if (field != null) continue;
            LongType dataType = DataType.LongType;
            if (fieldStr.contains("qty") || fieldStr.contains("coefficient")) {
                dataType = DataType.BigDecimalType;
            } else if (fieldStr.contains("materialchange")) {
                dataType = DataType.BooleanType;
            }
            field = new Field(fieldStr, (DataType)dataType);
            addField.add(field);
        }
        return new RowMeta(addField.toArray(new Field[0]));
    }
}

