/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class MonthTransformMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private int transformFieldIndex;
    private String dayofweek;

    public MonthTransformMapFunction(RowMeta rowMeta, String transformField, String dayofweek) {
        this.rowMeta = rowMeta;
        this.transformFieldIndex = rowMeta.getFieldIndex(transformField);
        this.dayofweek = dayofweek;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            if (this.transformFieldIndex == i) {
                Date d = row.getDate(i);
                Date monday = MonthTransformMapFunction.getTheWeekStart(d);
                monday = this.getMonthOffset(monday, this.dayofweek);
                newRow.set(i, (Object)monday);
                continue;
            }
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public static Date getTheWeekStart(Date baseDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    public Date getMonthOffset(Date day, String dayOfWeek) {
        Calendar c = Calendar.getInstance();
        c.setTime(day);
        if ("Mbeg".equalsIgnoreCase(dayOfWeek)) {
            c.set(5, 1);
        } else if ("Mmid".equalsIgnoreCase(dayOfWeek)) {
            c.set(5, 15);
        } else if ("Mend".equalsIgnoreCase(dayOfWeek)) {
            c.set(5, 1);
            c.add(2, 1);
            c.add(5, -1);
        }
        return c.getTime();
    }
}

