/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.id.ID;

public class PlanDataConvergeReduceGroupFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private RowMeta oldRowMeta;
    private Map<Long, String> dateMap;
    private Long userId;
    private Long fid;
    private Date curDate;
    private String[] groupAlias;

    public PlanDataConvergeReduceGroupFunction(RowMeta rowMeta, Map<Long, String> dateMap, Long fid) {
        new PlanDataConvergeReduceGroupFunction(rowMeta, dateMap, new String[]{"fmaterialid"}, fid);
    }

    public PlanDataConvergeReduceGroupFunction(RowMeta rowMeta, Map<Long, String> dateMap, String[] groupAlias, Long fid) {
        this.oldRowMeta = rowMeta;
        this.rowMeta = this.buildResultRowMeta(groupAlias);
        this.dateMap = dateMap;
        this.userId = RequestContext.get().getCurrUserId();
        this.fid = fid;
        this.curDate = new Date();
        this.groupAlias = groupAlias;
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        RowX resultRow = null;
        long seq = 0L;
        for (RowX row : rows) {
            if (resultRow == null) {
                resultRow = this.buildRow();
                resultRow.set(0, (Object)this.fid);
                resultRow.set(1, (Object)ID.genLongId());
                resultRow.set(2, (Object)this.userId);
                resultRow.set(3, (Object)this.curDate);
                resultRow.set(4, (Object)this.curDate);
                resultRow.set(5, (Object)this.userId);
                resultRow.set(6, (Object)seq);
                for (String alias : this.groupAlias) {
                    resultRow.set(this.rowMeta.getFieldIndex(alias), row.get(this.oldRowMeta.getFieldIndex(alias)));
                }
            }
            long fdatenode = row.getDate(this.oldRowMeta.getFieldIndex("fdatenode")).getTime();
            resultRow.set(this.rowMeta.getFieldIndex("f" + this.dateMap.get(fdatenode)), (Object)row.getBigDecimal(this.oldRowMeta.getFieldIndex("ffcqty")));
        }
        out.collect(resultRow);
    }

    private RowX buildRow() {
        RowX row = new RowX(this.rowMeta.getFieldCount());
        for (int i = 1; i <= 150; ++i) {
            row.set(this.rowMeta.getFieldIndex("fqty" + i), (Object)BigDecimal.ZERO);
        }
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowMeta buildResultRowMeta(String[] groupAlias) {
        ArrayList<String> fieldNamesList = new ArrayList<String>(256);
        ArrayList<Object> dataTypesList = new ArrayList<Object>(256);
        fieldNamesList.add("fid");
        fieldNamesList.add("fentryid");
        fieldNamesList.add("fedituser");
        fieldNamesList.add("feditdate");
        fieldNamesList.add("feditcreatedate");
        fieldNamesList.add("fentrymodifier");
        fieldNamesList.add("fseq");
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.DateType);
        dataTypesList.add(DataType.DateType);
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.LongType);
        for (String alias : groupAlias) {
            fieldNamesList.add(alias);
            dataTypesList.add(this.oldRowMeta.getField(alias).getDataType());
        }
        for (int i = 1; i <= 150; ++i) {
            fieldNamesList.add("fqty" + i);
            dataTypesList.add(DataType.BigDecimalType);
        }
        String[] fieldNames = fieldNamesList.toArray(new String[0]);
        DataType[] dataTypes = dataTypesList.toArray(new DataType[0]);
        return new RowMeta(fieldNames, dataTypes);
    }
}

