/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class QuotaMapFunction
extends MapFunction {
    private static final long serialVersionUID = 3691049377965116848L;
    private final RowMeta rowMeta;
    private final int qtyFieldIndex;
    private final int quotaFieldIndex;
    private final int quotaOrgFieldIndex;
    private final int precisionFieldIndex;
    private final int precisionaccountFieldIndex;
    private final Long defaultOrg;

    public QuotaMapFunction(RowMeta rowMeta, String qtyField, String quotaField, String quotaOrgField, String precisionField, String precisionaccountField, Long defaultOrg) {
        this.rowMeta = rowMeta;
        this.qtyFieldIndex = rowMeta.getFieldIndex(qtyField);
        this.quotaFieldIndex = rowMeta.getFieldIndex(quotaField);
        this.quotaOrgFieldIndex = rowMeta.getFieldIndex(quotaOrgField);
        this.precisionFieldIndex = rowMeta.getFieldIndex(precisionField);
        this.precisionaccountFieldIndex = rowMeta.getFieldIndex(precisionaccountField);
        this.defaultOrg = defaultOrg;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        RowX newRow = new RowX(this.rowMeta.getFieldCount());
        BigDecimal qty = row.getBigDecimal(this.qtyFieldIndex);
        BigDecimal quotamod = row.getBigDecimal(this.quotaFieldIndex);
        Long org = row.getLong(this.quotaOrgFieldIndex);
        Integer precision = row.getInteger(this.precisionFieldIndex);
        String precisionaccount = row.getString(this.precisionaccountFieldIndex);
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("2".equals(precisionaccount)) {
            roundingMode = RoundingMode.DOWN;
        } else if ("3".equals(precisionaccount)) {
            roundingMode = RoundingMode.UP;
        }
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        if (quotamod == null) {
            quotamod = BigDecimal.ONE;
        }
        if (precision == null) {
            precision = 0;
        }
        BigDecimal newQty = qty.multiply(quotamod).setScale((int)precision, roundingMode);
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            if (this.qtyFieldIndex == i) {
                newRow.set(i, (Object)newQty);
                continue;
            }
            if (this.quotaOrgFieldIndex == i && org == null) {
                newRow.set(i, (Object)this.defaultOrg);
                continue;
            }
            if (this.quotaFieldIndex == i) {
                newRow.set(i, (Object)quotamod);
                continue;
            }
            newRow.set(i, row.get(i));
        }
        return newRow;
    }
}

