/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class QuotaReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 640177612772637307L;
    private final RowMeta rowMeta;
    private final RowMeta oldRowMeta;
    private final List<String> extAlias;

    public QuotaReduceGroupFunction(RowMeta rowMeta, List<String> extAlias) {
        this.extAlias = extAlias;
        this.oldRowMeta = rowMeta;
        this.rowMeta = this.buildResultRowMeta();
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        int idIndex = this.oldRowMeta.getFieldIndex("id");
        int materialidIndex = this.oldRowMeta.getFieldIndex("fmaterialid");
        int baseunitidIndex = this.oldRowMeta.getFieldIndex("fbaseunitid");
        int datenodeIndex = this.oldRowMeta.getFieldIndex("fdatenode");
        int fcqtyIndex = this.oldRowMeta.getFieldIndex("ffcqty");
        int prodorgIndex = this.oldRowMeta.getFieldIndex("fprodorg");
        int totalQtyIndex = this.oldRowMeta.getFieldIndex("totalQty");
        int quotaIdIndex = this.oldRowMeta.getFieldIndex("quotaId");
        RowX preRow = null;
        Long preFmaterialid = 0L;
        Date preDatenode = null;
        BigDecimal preTotalQty = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        List<Object> rowsCopy = new ArrayList<RowX>(16);
        for (RowX rowX : rows) {
            rowsCopy.add(rowX);
        }
        rowsCopy = rowsCopy.stream().sorted((row, row2) -> row.getBigDecimal(this.oldRowMeta.getFieldIndex("quotamod")).compareTo(row2.getBigDecimal(this.oldRowMeta.getFieldIndex("quotamod")))).collect(Collectors.toList());
        for (RowX rowX : rowsCopy) {
            Long quotaId;
            Long id = rowX.getLong(idIndex);
            Long materialid = rowX.getLong(materialidIndex);
            Long baseunitid = rowX.getLong(baseunitidIndex);
            Date datenode = rowX.getDate(datenodeIndex);
            BigDecimal fcqty = rowX.getBigDecimal(fcqtyIndex);
            if (fcqty == null) {
                fcqty = BigDecimal.ZERO;
            }
            Long prodorg = rowX.getLong(prodorgIndex);
            BigDecimal totalQty = rowX.getBigDecimal(totalQtyIndex);
            if (totalQty == null) {
                totalQty = BigDecimal.ZERO;
            }
            if ((quotaId = rowX.getLong(quotaIdIndex)) == null || quotaId == 0L) {
                RowX resultRow = this.buildRow(id, materialid, baseunitid, datenode, fcqty, prodorg, rowX);
                out.collect(resultRow);
                continue;
            }
            if (preRow != null) {
                if (!Objects.equals(materialid, preFmaterialid) || !Objects.equals(datenode, preDatenode)) {
                    preRow.set(4, (Object)preTotalQty.subtract(qty));
                    qty = BigDecimal.ZERO;
                } else {
                    BigDecimal curQty = qty.add(preRow.getBigDecimal(4));
                    if (curQty.compareTo(preTotalQty) > 0) {
                        preRow.set(4, (Object)preTotalQty.subtract(qty));
                        qty = preTotalQty;
                    } else {
                        qty = curQty;
                    }
                }
                out.collect(preRow);
            }
            preFmaterialid = materialid;
            preDatenode = datenode;
            preTotalQty = totalQty;
            preRow = this.buildRow(id, materialid, baseunitid, datenode, fcqty, prodorg, rowX);
        }
        if (preRow != null) {
            preRow.set(4, (Object)preTotalQty.subtract(qty));
            out.collect(preRow);
        }
    }

    private RowX buildRow(Long id, Long materialid, Long baseunitid, Date datenode, BigDecimal fcqty, Long prodorg, RowX oldRow) {
        RowX row = new RowX(this.rowMeta.getFieldCount());
        row.set(0, (Object)id);
        row.set(1, (Object)materialid);
        row.set(2, (Object)baseunitid);
        row.set(3, (Object)datenode);
        row.set(4, (Object)fcqty);
        row.set(5, (Object)prodorg);
        for (String alias : this.extAlias) {
            row.set(this.rowMeta.getFieldIndex(alias), oldRow.get(this.oldRowMeta.getFieldIndex(alias)));
        }
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private RowMeta buildResultRowMeta() {
        ArrayList<String> fieldNamesList = new ArrayList<String>(16);
        fieldNamesList.add("id");
        fieldNamesList.add("fmaterialid");
        fieldNamesList.add("fbaseunitid");
        fieldNamesList.add("fdatenode");
        fieldNamesList.add("ffcqty");
        fieldNamesList.add("fprodorg");
        ArrayList<Object> dataTypesList = new ArrayList<Object>(16);
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.LongType);
        dataTypesList.add(DataType.DateType);
        dataTypesList.add(DataType.BigDecimalType);
        dataTypesList.add(DataType.LongType);
        for (String alias : this.extAlias) {
            fieldNamesList.add(alias);
            dataTypesList.add(this.oldRowMeta.getField(alias).getDataType());
        }
        return new RowMeta(fieldNamesList.toArray(new String[0]), dataTypesList.toArray(new DataType[0]));
    }
}

