/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;

public class QuotaResolveMapFunction
extends FlatMapFunction {
    private static final long serialVersionUID = 6363660404457029817L;
    private RowMeta rowMeta;
    private int effectdateFieldIndex;
    private int losedateFieldIndex;
    Date outlookDate;

    public QuotaResolveMapFunction(RowMeta rowMeta, String effectdateField, String losedateField, Date outlookDate) {
        this.rowMeta = rowMeta;
        this.effectdateFieldIndex = rowMeta.getFieldIndex(effectdateField);
        this.losedateFieldIndex = rowMeta.getFieldIndex(losedateField);
        this.outlookDate = outlookDate;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void flatMap(RowX row, Collector collector) {
        Date effectdate = row.getDate(this.effectdateFieldIndex);
        Date losedate = row.getDate(this.losedateFieldIndex);
        if (effectdate != null && losedate != null && this.outlookDate != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(effectdate);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(losedate);
            Calendar outlookCalendar = Calendar.getInstance();
            outlookCalendar.setTime(this.outlookDate);
            if (this.comp(c2, outlookCalendar)) {
                c2.setTime(this.outlookDate);
            }
            while (this.comp(c2, c1)) {
                RowX newRow = new RowX(this.rowMeta.getFieldCount());
                for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
                    newRow.set(i, row.get(i));
                }
                newRow.set(this.effectdateFieldIndex, (Object)c1.getTime());
                collector.collect(newRow);
                c1.add(5, 1);
            }
        }
    }

    public boolean comp(Calendar cCal, Calendar nCal) {
        if (cCal.get(1) > nCal.get(1)) {
            return true;
        }
        if (cCal.get(1) < nCal.get(1)) {
            return false;
        }
        if (cCal.get(2) > nCal.get(2)) {
            return true;
        }
        if (cCal.get(2) < nCal.get(2)) {
            return false;
        }
        return cCal.get(5) >= nCal.get(5);
    }
}

