/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;

public class Target4EqHandlerCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 640177612772637306L;
    private RowMeta leftRowMeta;
    private int qtyIndex;
    private int useProbabilityIndex;
    private int useAccountIndex;
    private int accountIndex;
    private int averageQtyIndex;
    private int rightAvgQtyTypeIndex;
    private DynamicObject defaultParams;

    public Target4EqHandlerCoGroupFunction(RowMeta leftRowMeta, RowMeta rightRowMeta, DynamicObject defaultParams) {
        this.leftRowMeta = leftRowMeta;
        this.qtyIndex = this.leftRowMeta.getFieldIndex("qty");
        this.useProbabilityIndex = this.leftRowMeta.getFieldIndex("useprobability");
        this.useAccountIndex = this.leftRowMeta.getFieldIndex("useaccount");
        this.accountIndex = this.leftRowMeta.getFieldIndex("account");
        this.averageQtyIndex = this.leftRowMeta.getFieldIndex("averageqty");
        this.rightAvgQtyTypeIndex = rightRowMeta.getFieldIndex("avgqtytype");
        this.defaultParams = defaultParams;
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector out) {
        String avgQtyType = "1";
        if (this.defaultParams != null) {
            avgQtyType = this.defaultParams.getString("avgqty");
        }
        for (RowX row : iterable1) {
            avgQtyType = row.getString(this.rightAvgQtyTypeIndex);
        }
        for (RowX row : iterable) {
            RowX newRow = this.copyRow(row);
            BigDecimal useaccount = row.getBigDecimal(this.useAccountIndex);
            useaccount = useaccount == null ? BigDecimal.ZERO : useaccount;
            BigDecimal account = row.getBigDecimal(this.accountIndex);
            account = account == null ? BigDecimal.ZERO : account;
            BigDecimal useprobability = BigDecimal.ZERO;
            if (!account.equals(BigDecimal.ZERO)) {
                useprobability = useaccount.divide(account, 10, 4);
            }
            newRow.set(this.useProbabilityIndex, (Object)useprobability);
            BigDecimal qty = newRow.getBigDecimal(this.qtyIndex);
            qty = qty == null ? BigDecimal.ZERO : qty;
            BigDecimal averageqty = BigDecimal.ZERO;
            if (!account.equals(BigDecimal.ZERO)) {
                averageqty = qty.divide(account, 10, 4);
            }
            if ("1".equals(avgQtyType)) {
                averageqty = averageqty.multiply(useprobability);
            }
            newRow.set(this.averageQtyIndex, (Object)averageqty);
            out.collect(newRow);
        }
    }

    private RowX copyRow(RowX row) {
        RowX newRow = new RowX(this.leftRowMeta.getFieldCount());
        for (int i = 0; i < this.leftRowMeta.getFieldCount(); ++i) {
            newRow.set(i, row.get(i));
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

