/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class Target4EqHandlerReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 640177612772637302L;
    private RowMeta rowMeta;
    private Map<String, Integer> nameRelIndex = new HashMap<String, Integer>(16);
    private Calendar curDate = Calendar.getInstance();

    public Target4EqHandlerReduceGroupFunction(RowMeta rowMeta, Date calcTime) {
        Field[] fields;
        this.rowMeta = rowMeta;
        for (Field field : fields = rowMeta.getFields()) {
            this.nameRelIndex.put(field.getName(), rowMeta.getFieldIndex(field.getName()));
        }
        if (calcTime != null) {
            this.curDate.setTime(calcTime);
        }
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        RowX newRow = null;
        for (RowX row : rows) {
            if (newRow == null) {
                newRow = row;
                continue;
            }
            this.sumBigDecimal("qty", newRow, row);
            this.maxBoolean("isgeneral", newRow, row);
            this.maxBoolean("islongcyclemater", newRow, row);
            this.maxBoolean("materialchange", newRow, row);
            this.maxBoolean("shelflife", newRow, row);
            this.minDate("actualintime", newRow, row);
            this.minDate("reqtime", newRow, row);
            this.maxDate("actualleavetime", newRow, row);
            this.groupConcat("atachapterno", newRow, row);
        }
        if (newRow == null) {
            return;
        }
        out.collect(newRow);
    }

    private void groupConcat(String field, RowX newRow, RowX row) {
        HashSet<String> set = new HashSet<String>(16);
        String v1 = newRow.getString(this.nameRelIndex.get(field).intValue());
        String v2 = row.getString(this.nameRelIndex.get(field).intValue());
        if (StringUtils.isNotEmpty((String)v1)) {
            set.addAll(Arrays.asList(v1.split(",")));
        }
        if (StringUtils.isNotEmpty((String)v2)) {
            set.addAll(Arrays.asList(v2.split(",")));
        }
        set.remove("");
        newRow.set(this.nameRelIndex.get(field).intValue(), (Object)String.join((CharSequence)",", set));
    }

    private void maxDate(String field, RowX newRow, RowX row) {
        Date v1 = newRow.getDate(this.nameRelIndex.get(field).intValue());
        Date v2 = row.getDate(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v2);
        } else if (v2 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v1);
        } else {
            Date max = v1.compareTo(v2) > 0 ? v1 : v2;
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)max);
        }
    }

    private void minDate(String field, RowX newRow, RowX row) {
        Date v1 = newRow.getDate(this.nameRelIndex.get(field).intValue());
        Date v2 = row.getDate(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v2);
        } else if (v2 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v1);
        } else {
            Date min = v1.compareTo(v2) < 0 ? v1 : v2;
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)min);
        }
    }

    private void maxBoolean(String field, RowX newRow, RowX row) {
        Boolean v1 = newRow.getBoolean(this.nameRelIndex.get(field).intValue());
        Boolean v2 = row.getBoolean(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            v1 = false;
        }
        if (v2 == null) {
            v2 = false;
        }
        if (v1.booleanValue() || v2.booleanValue()) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)true);
        }
    }

    private void sumBigDecimal(String field, RowX newRow, RowX row) {
        BigDecimal qty = newRow.getBigDecimal(this.nameRelIndex.get(field).intValue());
        BigDecimal qty2 = row.getBigDecimal(this.nameRelIndex.get(field).intValue());
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        if (qty2 != null) {
            qty = qty.add(qty2);
        }
        newRow.set(this.nameRelIndex.get(field).intValue(), (Object)qty);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

