/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class Target4TimeHandlerReduceGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 640177612772637302L;
    private RowMeta rowMeta;
    private Map<Integer, Integer> offSetRelMonthDays = new HashMap<Integer, Integer>(16);
    private Map<String, Integer> nameRelIndex = new HashMap<String, Integer>(16);
    private Calendar curDate = Calendar.getInstance();

    public Target4TimeHandlerReduceGroupFunction(RowMeta rowMeta, Date calcTime) {
        Field[] fields;
        this.rowMeta = rowMeta;
        for (Field field : fields = rowMeta.getFields()) {
            this.nameRelIndex.put(field.getName(), rowMeta.getFieldIndex(field.getName()));
        }
        if (calcTime != null) {
            this.curDate.setTime(calcTime);
        }
        this.initOffSetRelMonthDays();
    }

    private void initOffSetRelMonthDays() {
        Calendar calendar = Calendar.getInstance();
        for (int i = 1; i < 13; ++i) {
            calendar.setTime(this.curDate.getTime());
            calendar.set(5, 1);
            calendar.add(2, -i + 1);
            calendar.add(5, -1);
            this.offSetRelMonthDays.put(i, calendar.get(5));
        }
    }

    public void reduce(Iterable<RowX> rows, Collector out) {
        RowX newRow = null;
        for (RowX row : rows) {
            if (newRow == null) {
                newRow = row;
                continue;
            }
            this.sumBigDecimal("qty", newRow, row);
            this.sumBigDecimal("qty12m", newRow, row);
            this.sumBigDecimal("insupplyqty", newRow, row);
            this.sumBigDecimal("custosupplyqty", newRow, row);
            this.sumInt("ordercountall", newRow, row);
            this.sumInt("ordercount1", newRow, row);
            this.sumInt("ordercount2", newRow, row);
            this.sumInt("ordercount3", newRow, row);
            this.sumInt("ordercount4", newRow, row);
            this.sumInt("ordercount5", newRow, row);
            this.sumInt("ordercount6", newRow, row);
            this.sumInt("ordercount7", newRow, row);
            this.sumInt("ordercount8", newRow, row);
            this.sumInt("ordercount9", newRow, row);
            this.sumInt("ordercount10", newRow, row);
            this.sumInt("ordercount11", newRow, row);
            this.sumInt("ordercount12", newRow, row);
            this.sumBigDecimal("mqty1", newRow, row);
            this.sumBigDecimal("mqty2", newRow, row);
            this.sumBigDecimal("mqty3", newRow, row);
            this.sumBigDecimal("mqty4", newRow, row);
            this.sumBigDecimal("mqty5", newRow, row);
            this.sumBigDecimal("mqty6", newRow, row);
            this.sumBigDecimal("mqty7", newRow, row);
            this.sumBigDecimal("mqty8", newRow, row);
            this.sumBigDecimal("mqty9", newRow, row);
            this.sumBigDecimal("mqty10", newRow, row);
            this.sumBigDecimal("mqty11", newRow, row);
            this.sumBigDecimal("mqty12", newRow, row);
            this.maxBoolean("isgeneral", newRow, row);
            this.maxBoolean("islongcyclemater", newRow, row);
            this.maxBoolean("materialchange", newRow, row);
            this.maxBoolean("shelflife", newRow, row);
            this.maxBoolean("targetflag", newRow, row);
            this.maxBigDecimal("avgdelivery", newRow, row);
            this.maxBigDecimal("longcycle", newRow, row);
            this.minDate("actualintime", newRow, row);
            this.minDate("reqtime", newRow, row);
            this.maxDate("actualleavetime", newRow, row);
            this.groupConcat("atachapterno", newRow, row);
            this.groupConcat("conmtypename", newRow, row);
            this.groupConcat("conmtypenumber", newRow, row);
            this.groupConcat("conmtypeid", newRow, row);
            this.groupConcat("supplyresp", newRow, row);
        }
        if (newRow == null) {
            return;
        }
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>(16);
        ArrayList<BigDecimal> monthstandadevList = new ArrayList<BigDecimal>(16);
        ArrayList<BigDecimal> standadev12mList = new ArrayList<BigDecimal>(16);
        ArrayList<BigDecimal> daystandadevList = new ArrayList<BigDecimal>(16);
        ArrayList<BigDecimal> daystandadev12mList = new ArrayList<BigDecimal>(16);
        for (int i = 1; i < 13; ++i) {
            Integer count = newRow.getInteger(this.nameRelIndex.get("ordercount" + i).intValue());
            if (count != null && count > 0) {
                countMap.put(i, count);
                BigDecimal mqty = newRow.getBigDecimal(this.nameRelIndex.get("mqty" + i).intValue());
                if (mqty == null) {
                    mqty = BigDecimal.ZERO;
                }
                monthstandadevList.add(mqty);
                standadev12mList.add(mqty);
                BigDecimal daystandadevAvg = mqty.divide(new BigDecimal(this.offSetRelMonthDays.getOrDefault(i, 30)), 10, 4);
                daystandadevList.add(daystandadevAvg);
                daystandadev12mList.add(daystandadevAvg);
                continue;
            }
            standadev12mList.add(BigDecimal.ZERO);
            daystandadev12mList.add(BigDecimal.ZERO);
        }
        String quarter1 = countMap.keySet().stream().anyMatch(o -> o >= 1 && o <= 3) ? "1" : "0";
        String quarter2 = countMap.keySet().stream().anyMatch(o -> o >= 4 && o <= 6) ? "1" : "0";
        String quarter3 = countMap.keySet().stream().anyMatch(o -> o >= 7 && o <= 9) ? "1" : "0";
        String quarter4 = countMap.keySet().stream().anyMatch(o -> o >= 10 && o <= 12) ? "1" : "0";
        String qcode = quarter1 + quarter2 + quarter3 + quarter4;
        newRow.set(this.nameRelIndex.get("quarter1").intValue(), (Object)quarter1);
        newRow.set(this.nameRelIndex.get("quarter2").intValue(), (Object)quarter2);
        newRow.set(this.nameRelIndex.get("quarter3").intValue(), (Object)quarter3);
        newRow.set(this.nameRelIndex.get("quarter4").intValue(), (Object)quarter4);
        newRow.set(this.nameRelIndex.get("qcode").intValue(), (Object)qcode);
        int usemonthcount = countMap.size();
        newRow.set(this.nameRelIndex.get("usemonthcount").intValue(), (Object)usemonthcount);
        BigDecimal qty12m = newRow.getBigDecimal(this.nameRelIndex.get("qty12m").intValue());
        if (usemonthcount > 0) {
            newRow.set(this.nameRelIndex.get("averageqty").intValue(), (Object)qty12m.divide(new BigDecimal(usemonthcount), 10, 4));
        }
        newRow.set(this.nameRelIndex.get("averageqty12m").intValue(), (Object)qty12m.divide(new BigDecimal(12), 10, 4));
        if (usemonthcount > 0) {
            newRow.set(this.nameRelIndex.get("averagedayqty").intValue(), (Object)qty12m.divide(new BigDecimal(365).multiply(new BigDecimal(usemonthcount)).divide(new BigDecimal(12), 10, 4), 10, 4));
        }
        newRow.set(this.nameRelIndex.get("averageyearqty").intValue(), (Object)qty12m.divide(new BigDecimal(365), 10, 4));
        BigDecimal monthstandadev = this.variance(monthstandadevList);
        newRow.set(this.nameRelIndex.get("monthstandadev").intValue(), (Object)monthstandadev);
        BigDecimal standadev12m = this.variance(standadev12mList);
        newRow.set(this.nameRelIndex.get("standadev12m").intValue(), (Object)standadev12m);
        BigDecimal daystandadev = this.variance(daystandadevList);
        newRow.set(this.nameRelIndex.get("daystandadev").intValue(), (Object)daystandadev);
        BigDecimal daystandadev12m = this.variance(daystandadev12mList);
        newRow.set(this.nameRelIndex.get("daystandadev12m").intValue(), (Object)daystandadev12m);
        newRow.set(this.nameRelIndex.get("customer").intValue(), null);
        newRow.set(this.nameRelIndex.get("actype").intValue(), null);
        newRow.set(this.nameRelIndex.get("checktype").intValue(), null);
        newRow.set(this.nameRelIndex.get("beforematerialnumber").intValue(), null);
        newRow.set(this.nameRelIndex.get("beforematerialname").intValue(), null);
        newRow.set(this.nameRelIndex.get("beforeunitname").intValue(), null);
        out.collect(newRow);
    }

    private void groupConcat(String field, RowX newRow, RowX row) {
        HashSet<String> set = new HashSet<String>(16);
        String v1 = newRow.getString(this.nameRelIndex.get(field).intValue());
        String v2 = row.getString(this.nameRelIndex.get(field).intValue());
        if (StringUtils.isNotEmpty((String)v1)) {
            set.addAll(Arrays.asList(v1.split(",")));
        }
        if (StringUtils.isNotEmpty((String)v2)) {
            set.addAll(Arrays.asList(v2.split(",")));
        }
        set.remove("");
        newRow.set(this.nameRelIndex.get(field).intValue(), (Object)String.join((CharSequence)",", set));
    }

    private void maxDate(String field, RowX newRow, RowX row) {
        Date v1 = newRow.getDate(this.nameRelIndex.get(field).intValue());
        Date v2 = row.getDate(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v2);
        } else if (v2 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v1);
        } else {
            Date max = v1.compareTo(v2) > 0 ? v1 : v2;
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)max);
        }
    }

    private void minDate(String field, RowX newRow, RowX row) {
        Date v1 = newRow.getDate(this.nameRelIndex.get(field).intValue());
        Date v2 = row.getDate(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v2);
        } else if (v2 == null) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)v1);
        } else {
            Date min = v1.compareTo(v2) < 0 ? v1 : v2;
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)min);
        }
    }

    private void maxBigDecimal(String field, RowX newRow, RowX row) {
        BigDecimal v1 = newRow.getBigDecimal(this.nameRelIndex.get(field).intValue());
        BigDecimal v2 = row.getBigDecimal(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            v1 = BigDecimal.ZERO;
        }
        if (v2 == null) {
            v2 = BigDecimal.ZERO;
        }
        BigDecimal max = v1.compareTo(v2) > 0 ? v1 : v2;
        newRow.set(this.nameRelIndex.get(field).intValue(), (Object)max);
    }

    private void maxBoolean(String field, RowX newRow, RowX row) {
        Boolean v1 = newRow.getBoolean(this.nameRelIndex.get(field).intValue());
        Boolean v2 = row.getBoolean(this.nameRelIndex.get(field).intValue());
        if (v1 == null) {
            v1 = false;
        }
        if (v2 == null) {
            v2 = false;
        }
        if (v1.booleanValue() || v2.booleanValue()) {
            newRow.set(this.nameRelIndex.get(field).intValue(), (Object)true);
        }
    }

    private void sumBigDecimal(String field, RowX newRow, RowX row) {
        BigDecimal qty = newRow.getBigDecimal(this.nameRelIndex.get(field).intValue());
        BigDecimal qty2 = row.getBigDecimal(this.nameRelIndex.get(field).intValue());
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        if (qty2 != null) {
            qty = qty.add(qty2);
        }
        newRow.set(this.nameRelIndex.get(field).intValue(), (Object)qty);
    }

    private void sumInt(String field, RowX newRow, RowX row) {
        Integer qty = newRow.getInteger(this.nameRelIndex.get(field).intValue());
        Integer qty2 = row.getInteger(this.nameRelIndex.get(field).intValue());
        if (qty == null) {
            qty = 0;
        }
        if (qty2 != null) {
            qty = qty + qty2;
        }
        newRow.set(this.nameRelIndex.get(field).intValue(), (Object)qty);
    }

    private int getMonthOffset(Date useDate) {
        int curYear = this.curDate.get(1);
        int curMonth = this.curDate.get(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(useDate);
        int useYear = calendar.get(1);
        int useMonth = calendar.get(2);
        return curMonth - useMonth + 12 * (curYear - useYear);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private BigDecimal variance(List<BigDecimal> values) {
        int m = values.size();
        if (m < 2) {
            return null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            sum = sum.add(value);
        }
        BigDecimal dAve = sum.divide(new BigDecimal(m), 10, 4);
        BigDecimal dVar = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            dVar = dVar.add(value.subtract(dAve).multiply(value.subtract(dAve)));
        }
        BigDecimal resultBig = dVar.divide(new BigDecimal(m - 1), 10, 4);
        double result = resultBig.doubleValue();
        result = Math.sqrt(result);
        return BigDecimal.valueOf(result).setScale(10, 4);
    }
}

